/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.time.Duration;
import java.time.OffsetTime;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.metamodel.model.domain.internal.EmbeddedSqmPathSource;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmToDuration;
import org.hibernate.type.BindableType;
import org.hibernate.type.BindingContext;
import org.hibernate.type.descriptor.java.JavaTypeHelper;

public class SqmExpressionHelper {
    public static <T> SqmExpressible<T> toSqmType(BindableType<T> parameterType, SqmCreationState creationState) {
        return SqmExpressionHelper.toSqmType(parameterType, creationState.getCreationContext());
    }

    public static <T> SqmBindableType<T> toSqmType(BindableType<T> anticipatedType, BindingContext bindingContext) {
        if (anticipatedType == null) {
            return null;
        }
        SqmBindableType<T> sqmExpressible = bindingContext.resolveExpressible(anticipatedType);
        assert (sqmExpressible != null);
        return sqmExpressible;
    }

    public static boolean isCompositeTemporal(SqmExpression<?> expression) {
        SqmPath path;
        return expression instanceof SqmPath && (path = (SqmPath)expression).getReferencedPathSource() instanceof EmbeddedSqmPathSource && JavaTypeHelper.isTemporal(expression.getJavaTypeDescriptor());
    }

    public static SqmExpression<?> getActualExpression(SqmExpression<?> expression) {
        if (SqmExpressionHelper.isCompositeTemporal(expression)) {
            SqmPath path = (SqmPath)expression;
            return expression.getJavaTypeDescriptor().getJavaTypeClass() == OffsetTime.class ? path.get("utcTime") : path.get("instant");
        }
        return expression;
    }

    public static SqmExpression<?> getOffsetAdjustedExpression(SqmExpression<?> expression) {
        if (SqmExpressionHelper.isCompositeTemporal(expression)) {
            SqmPath compositePath = (SqmPath)expression;
            JpaPath temporalPath = expression.getJavaTypeDescriptor().getJavaTypeClass() == OffsetTime.class ? compositePath.get("utcTime") : compositePath.get("instant");
            NodeBuilder nodeBuilder = temporalPath.nodeBuilder();
            return new SqmBinaryArithmetic(BinaryArithmeticOperator.ADD, (SqmExpression<?>)((Object)temporalPath), (SqmExpression<?>)new SqmToDuration<Duration>((SqmExpression<?>)((Object)compositePath.get("zoneOffset")), new SqmDurationUnit<Integer>(TemporalUnit.SECOND, nodeBuilder.getIntegerType(), nodeBuilder), (ReturnableType<Duration>)nodeBuilder.getTypeConfiguration().getBasicTypeForJavaType(Duration.class), nodeBuilder), temporalPath.getNodeType(), nodeBuilder);
        }
        return expression;
    }
}

