/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.client;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.authenticators.client.AbstractClientAuthenticator;
import org.keycloak.authentication.authenticators.client.ClientAuthUtil;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.x509.X509ClientCertificateLookup;

public class X509ClientAuthenticator
extends AbstractClientAuthenticator {
    public static final String PROVIDER_ID = "client-x509";
    public static final String ATTR_PREFIX = "x509";
    public static final String ATTR_SUBJECT_DN = "x509.subjectdn";
    public static final String ATTR_ALLOW_REGEX_PATTERN_COMPARISON = "x509.allow.regex.pattern.comparison";
    private static final Map<String, String> CUSTOM_OIDS = new HashMap<String, String>();
    private static final Map<String, String> CUSTOM_OIDS_REVERSED = new HashMap<String, String>();
    private static final Logger logger;

    public void authenticateClient(ClientAuthenticationFlowContext context) {
        X509ClientCertificateLookup provider = (X509ClientCertificateLookup)context.getSession().getProvider(X509ClientCertificateLookup.class);
        if (provider == null) {
            logger.errorv("\"{0}\" Spi is not available, did you forget to update the configuration?", X509ClientCertificateLookup.class);
            return;
        }
        X509Certificate[] certs = null;
        ClientModel client = null;
        try {
            certs = provider.getCertificateChain(context.getHttpRequest());
            String client_id = null;
            MediaType mediaType = context.getHttpRequest().getHttpHeaders().getMediaType();
            boolean hasFormData = mediaType != null && mediaType.isCompatible(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
            MultivaluedMap formData = hasFormData ? context.getHttpRequest().getDecodedFormParameters() : null;
            MultivaluedMap queryParams = context.getSession().getContext().getUri().getQueryParameters();
            if (formData != null) {
                client_id = (String)formData.getFirst((Object)"client_id");
            }
            if (client_id == null && queryParams != null) {
                client_id = (String)queryParams.getFirst((Object)"client_id");
            }
            if (client_id == null) {
                client_id = (String)context.getSession().getAttribute("client_id", String.class);
            }
            if (client_id == null) {
                Response challengeResponse = ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "Missing client_id parameter");
                context.challenge(challengeResponse);
                return;
            }
            client = context.getRealm().getClientByClientId(client_id);
            if (client == null) {
                context.failure(AuthenticationFlowError.CLIENT_NOT_FOUND, null);
                return;
            }
            context.getEvent().client(client_id);
            context.setClient(client);
            if (!client.isEnabled()) {
                context.failure(AuthenticationFlowError.CLIENT_DISABLED, null);
                return;
            }
        }
        catch (GeneralSecurityException e) {
            logger.errorf("[X509ClientCertificateAuthenticator:authenticate] Exception: %s", (Object)e.getMessage());
            context.attempted();
            return;
        }
        if (certs == null || certs.length == 0) {
            logger.debug((Object)"[X509ClientCertificateAuthenticator:authenticate] x509 client certificate is not available for mutual SSL.");
            context.attempted();
            return;
        }
        OIDCAdvancedConfigWrapper clientCfg = OIDCAdvancedConfigWrapper.fromClientModel(client);
        String subjectDNRegexp = client.getAttribute(ATTR_SUBJECT_DN);
        if (subjectDNRegexp == null || subjectDNRegexp.length() == 0) {
            logger.errorf("[X509ClientCertificateAuthenticator:authenticate] x509.subjectdn is null or empty", new Object[0]);
            context.attempted();
            return;
        }
        X509Certificate certificate = certs[0];
        boolean matchedCertificate = false;
        if (clientCfg.getAllowRegexPatternComparison()) {
            Pattern subjectDNPattern = Pattern.compile(subjectDNRegexp);
            String subjectdn = certificate.getSubjectDN().getName();
            matchedCertificate = subjectDNPattern.matcher(subjectdn).matches();
        } else {
            X500Principal expectedDNPrincipal = new X500Principal(subjectDNRegexp, CUSTOM_OIDS_REVERSED);
            matchedCertificate = expectedDNPrincipal.getName("RFC2253", CUSTOM_OIDS).equals(certificate.getSubjectX500Principal().getName("RFC2253", CUSTOM_OIDS));
        }
        if (!matchedCertificate) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[X509ClientCertificateAuthenticator:authenticate] Couldn't match any certificate for expected Subject DN '" + subjectDNRegexp + "' with allow regex pattern '" + clientCfg.getAllowRegexPatternComparison() + "'."));
                logger.debug((Object)("[X509ClientCertificateAuthenticator:authenticate] Checked Subject DN: " + certificate.getSubjectDN().getName()));
                logger.debug((Object)("[X509ClientCertificateAuthenticator:authenticate] All SubjectDNs from the certificate chain: " + String.valueOf(Arrays.stream(certs).map(cert -> cert.getSubjectDN().getName()).collect(Collectors.toList()))));
            }
            context.attempted();
        } else {
            logger.debug((Object)("[X509ClientCertificateAuthenticator:authenticate] Matched " + certificate.getSubjectDN().getName() + " certificate."));
            context.success();
        }
    }

    public String getDisplayType() {
        return "X509 Certificate";
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public List<ProviderConfigProperty> getConfigPropertiesPerClient() {
        return Collections.emptyList();
    }

    public Map<String, Object> getAdapterConfiguration(ClientModel client) {
        return Collections.emptyMap();
    }

    public Set<String> getProtocolAuthenticatorMethods(String loginProtocol) {
        if (loginProtocol.equals("openid-connect")) {
            HashSet<String> results = new HashSet<String>();
            results.add("tls_client_auth");
            return results;
        }
        return Collections.emptySet();
    }

    public String getHelpText() {
        return "Validates client based on a X509 Certificate";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    static {
        CUSTOM_OIDS.put("2.5.4.5", "serialNumber".toUpperCase());
        CUSTOM_OIDS.put("2.5.4.15", "businessCategory".toUpperCase());
        CUSTOM_OIDS.put("1.3.6.1.4.1.311.60.2.1.3", "jurisdictionCountryName".toUpperCase());
        CUSTOM_OIDS.put("1.2.840.113549.1.9.1", "emailAddress".toUpperCase());
        for (Map.Entry<String, String> entry : CUSTOM_OIDS.entrySet()) {
            CUSTOM_OIDS_REVERSED.put(entry.getValue(), entry.getKey());
        }
        CUSTOM_OIDS_REVERSED.put("E", "1.2.840.113549.1.9.1");
        logger = Logger.getLogger(X509ClientAuthenticator.class);
    }
}

