/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Objects;
import org.apache.kafka.server.common.MetadataVersion;

public final class MetadataVersionChange {
    private final MetadataVersion oldVersion;
    private final MetadataVersion newVersion;

    public MetadataVersionChange(MetadataVersion oldVersion, MetadataVersion newVersion) {
        this.oldVersion = Objects.requireNonNull(oldVersion);
        this.newVersion = Objects.requireNonNull(newVersion);
    }

    public MetadataVersion oldVersion() {
        return this.oldVersion;
    }

    public MetadataVersion newVersion() {
        return this.newVersion;
    }

    public boolean isUpgrade() {
        return this.oldVersion.isLessThan(this.newVersion);
    }

    public boolean isDowngrade() {
        return this.newVersion.isLessThan(this.oldVersion);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        MetadataVersionChange other = (MetadataVersionChange)o;
        return this.oldVersion.equals((Object)other.oldVersion) && this.newVersion.equals((Object)other.newVersion);
    }

    public int hashCode() {
        return Objects.hash(this.oldVersion, this.newVersion);
    }

    public String toString() {
        return "MetadataVersionChange(oldVersion=" + String.valueOf(this.oldVersion) + ", newVersion=" + String.valueOf(this.newVersion) + ")";
    }
}

