# frozen_string_literal: true

# WARNING ABOUT GENERATED CODE
#
# This file is generated. See the contributing guide for more information:
# https://github.com/aws/aws-sdk-ruby/blob/version-3/CONTRIBUTING.md
#
# WARNING ABOUT GENERATED CODE

module Aws::CloudFormation

  class Event

    extend Aws::Deprecations

    # @overload def initialize(id, options = {})
    #   @param [String] id
    #   @option options [Client] :client
    # @overload def initialize(options = {})
    #   @option options [required, String] :id
    #   @option options [Client] :client
    def initialize(*args)
      options = Hash === args.last ? args.pop.dup : {}
      @id = extract_id(args, options)
      @data = options.delete(:data)
      @client = options.delete(:client) || Client.new(options)
      @waiter_block_warned = false
    end

    # @!group Read-Only Attributes

    # @return [String]
    def id
      @id
    end
    alias :event_id :id

    # The unique ID name of the instance of the stack.
    # @return [String]
    def stack_id
      data[:stack_id]
    end

    # The name associated with a stack.
    # @return [String]
    def stack_name
      data[:stack_name]
    end

    # The logical name of the resource specified in the template.
    # @return [String]
    def logical_resource_id
      data[:logical_resource_id]
    end

    # The name or unique identifier associated with the physical instance of
    # the resource.
    # @return [String]
    def physical_resource_id
      data[:physical_resource_id]
    end

    # Type of resource. For more information, see [Amazon Web Services
    # resource and property types reference][1] in the *CloudFormation User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html
    # @return [String]
    def resource_type
      data[:resource_type]
    end

    # Time the status was updated.
    # @return [Time]
    def timestamp
      data[:timestamp]
    end

    # Current status of the resource.
    # @return [String]
    def resource_status
      data[:resource_status]
    end

    # Success/failure message associated with the resource.
    # @return [String]
    def resource_status_reason
      data[:resource_status_reason]
    end

    # BLOB of the properties used to create the resource.
    # @return [String]
    def resource_properties
      data[:resource_properties]
    end

    # The token passed to the operation that generated this event.
    #
    # All events triggered by a given stack operation are assigned the same
    # client request token, which you can use to track operations. For
    # example, if you execute a `CreateStack` operation with the token
    # `token1`, then all the `StackEvents` generated by that operation will
    # have `ClientRequestToken` set as `token1`.
    #
    # In the console, stack operations display the client request token on
    # the Events tab. Stack operations that are initiated from the console
    # use the token format *Console-StackOperation-ID*, which helps you
    # easily identify the stack operation . For example, if you create a
    # stack using the console, each stack event would be assigned the same
    # token in the following format:
    # `Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002`.
    # @return [String]
    def client_request_token
      data[:client_request_token]
    end

    # The name of the hook.
    # @return [String]
    def hook_type
      data[:hook_type]
    end

    # Provides the status of the change set hook.
    # @return [String]
    def hook_status
      data[:hook_status]
    end

    # Provides the reason for the hook status.
    # @return [String]
    def hook_status_reason
      data[:hook_status_reason]
    end

    # Invocation points are points in provisioning logic where Hooks are
    # initiated.
    # @return [String]
    def hook_invocation_point
      data[:hook_invocation_point]
    end

    # Specify the hook failure mode for non-compliant resources in the
    # followings ways.
    #
    # * `FAIL` Stops provisioning resources.
    #
    # * `WARN` Allows provisioning to continue with a warning message.
    # @return [String]
    def hook_failure_mode
      data[:hook_failure_mode]
    end

    # An optional field that contains information about the detailed status
    # of the stack event.
    #
    # * `CONFIGURATION_COMPLETE` - all of the resources in the stack have
    #   reached that event. For more information, see [Understand
    #   CloudFormation stack creation events][1] in the *CloudFormation User
    #   Guide*.
    #
    # ^
    # ^
    #
    # * `VALIDATION_FAILED` - template validation failed because of invalid
    #   properties in the template. The `ResourceStatusReason` field shows
    #   what properties are defined incorrectly.
    #
    # ^
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html
    # @return [String]
    def detailed_status
      data[:detailed_status]
    end

    # @!endgroup

    # @return [Client]
    def client
      @client
    end

    # @raise [NotImplementedError]
    # @api private
    def load
      msg = "#load is not implemented, data only available via enumeration"
      raise NotImplementedError, msg
    end
    alias :reload :load

    # @raise [NotImplementedError] Raises when {#data_loaded?} is `false`.
    # @return [Types::StackEvent]
    #   Returns the data for this {Event}.
    def data
      load unless @data
      @data
    end

    # @return [Boolean]
    #   Returns `true` if this resource is loaded.  Accessing attributes or
    #   {#data} on an unloaded resource will trigger a call to {#load}.
    def data_loaded?
      !!@data
    end

    # @deprecated Use [Aws::CloudFormation::Client] #wait_until instead
    #
    # Waiter polls an API operation until a resource enters a desired
    # state.
    #
    # @note The waiting operation is performed on a copy. The original resource
    #   remains unchanged.
    #
    # ## Basic Usage
    #
    # Waiter will polls until it is successful, it fails by
    # entering a terminal state, or until a maximum number of attempts
    # are made.
    #
    #     # polls in a loop until condition is true
    #     resource.wait_until(options) {|resource| condition}
    #
    # ## Example
    #
    #     instance.wait_until(max_attempts:10, delay:5) do |instance|
    #       instance.state.name == 'running'
    #     end
    #
    # ## Configuration
    #
    # You can configure the maximum number of polling attempts, and the
    # delay (in seconds) between each polling attempt. The waiting condition is
    # set by passing a block to {#wait_until}:
    #
    #     # poll for ~25 seconds
    #     resource.wait_until(max_attempts:5,delay:5) {|resource|...}
    #
    # ## Callbacks
    #
    # You can be notified before each polling attempt and before each
    # delay. If you throw `:success` or `:failure` from these callbacks,
    # it will terminate the waiter.
    #
    #     started_at = Time.now
    #     # poll for 1 hour, instead of a number of attempts
    #     proc = Proc.new do |attempts, response|
    #       throw :failure if Time.now - started_at > 3600
    #     end
    #
    #       # disable max attempts
    #     instance.wait_until(before_wait:proc, max_attempts:nil) {...}
    #
    # ## Handling Errors
    #
    # When a waiter is successful, it returns the Resource. When a waiter
    # fails, it raises an error.
    #
    #     begin
    #       resource.wait_until(...)
    #     rescue Aws::Waiters::Errors::WaiterFailed
    #       # resource did not enter the desired state in time
    #     end
    #
    # @yieldparam [Resource] resource to be used in the waiting condition.
    #
    # @raise [Aws::Waiters::Errors::FailureStateError] Raised when the waiter
    #   terminates because the waiter has entered a state that it will not
    #   transition out of, preventing success.
    #
    #   yet successful.
    #
    # @raise [Aws::Waiters::Errors::UnexpectedError] Raised when an error is
    #   encountered while polling for a resource that is not expected.
    #
    # @raise [NotImplementedError] Raised when the resource does not
    #
    # @option options [Integer] :max_attempts (10) Maximum number of
    # attempts
    # @option options [Integer] :delay (10) Delay between each
    # attempt in seconds
    # @option options [Proc] :before_attempt (nil) Callback
    # invoked before each attempt
    # @option options [Proc] :before_wait (nil) Callback
    # invoked before each wait
    # @return [Resource] if the waiter was successful
    def wait_until(options = {}, &block)
      self_copy = self.dup
      attempts = 0
      options[:max_attempts] = 10 unless options.key?(:max_attempts)
      options[:delay] ||= 10
      options[:poller] = Proc.new do
        attempts += 1
        if block.call(self_copy)
          [:success, self_copy]
        else
          self_copy.reload unless attempts == options[:max_attempts]
          :retry
        end
      end
      Aws::Plugins::UserAgent.metric('RESOURCE_MODEL') do
        Aws::Waiters::Waiter.new(options).wait({})
      end
    end

    # @deprecated
    # @api private
    def identifiers
      { id: @id }
    end
    deprecated(:identifiers)

    private

    def extract_id(args, options)
      value = args[0] || options.delete(:id)
      case value
      when String then value
      when nil then raise ArgumentError, "missing required option :id"
      else
        msg = "expected :id to be a String, got #{value.class}"
        raise ArgumentError, msg
      end
    end

    class Collection < Aws::Resources::Collection; end
  end
end
