/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.ShortKeySet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class RedBlackKeySet
implements ShortKeySet,
Serializable {
    public static final int NODESIZE = 15;
    private transient RBNode root;
    private transient int size;
    private static final byte RED = 0;
    private static final byte BLACK = 1;
    private int maxKey;

    public RedBlackKeySet(short n) {
        this.maxKey = n;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(short key) {
        if (key < 0 || key > this.maxKey) {
            throw new IndexOutOfBoundsException();
        }
        RBNode node = this.root;
        while (node != null) {
            if (key == node.key) {
                return true;
            }
            if (key < node.key) {
                node = node.left;
                continue;
            }
            node = node.right;
        }
        return false;
    }

    @Override
    public short getFirst() {
        if (this.root == null) {
            return -1;
        }
        RBNode node = this.root;
        while (node.left != null) {
            node = node.left;
        }
        return node.key;
    }

    @Override
    public short getLast() {
        if (this.root == null) {
            return -1;
        }
        RBNode node = this.root;
        while (node.right != null) {
            node = node.right;
        }
        return node.key;
    }

    @Override
    public short getNext(short key) {
        if (key < 0 || key > this.maxKey) {
            throw new IndexOutOfBoundsException();
        }
        boolean foundValue = false;
        short bestkey = 0;
        RBNode node = this.root;
        while (node != null) {
            if (key >= node.key) {
                node = node.right;
                continue;
            }
            foundValue = true;
            bestkey = node.key;
            node = node.left;
        }
        if (foundValue) {
            return bestkey;
        }
        return -1;
    }

    @Override
    public short getPrevious(short key) {
        if (key < 0 || key > this.maxKey) {
            throw new IndexOutOfBoundsException();
        }
        boolean foundValue = false;
        short bestkey = 0;
        RBNode node = this.root;
        while (node != null) {
            if (key <= node.key) {
                node = node.left;
                continue;
            }
            foundValue = true;
            bestkey = node.key;
            node = node.right;
        }
        if (foundValue) {
            return bestkey;
        }
        return -1;
    }

    @Override
    public void put(short key) {
        if (key < 0 || key > this.maxKey) {
            throw new IndexOutOfBoundsException();
        }
        if (this.root == null) {
            ++this.size;
            this.root = new RBNode(key, null);
        }
        RBNode node = this.root;
        while (true) {
            if (key == node.key) {
                return;
            }
            if (key < node.key) {
                if (node.left != null) {
                    node = node.left;
                    continue;
                }
                ++this.size;
                node.left = new RBNode(key, node);
                this.fixAfterInsertion(node.left);
                return;
            }
            if (node.right == null) break;
            node = node.right;
        }
        ++this.size;
        node.right = new RBNode(key, node);
        this.fixAfterInsertion(node.right);
    }

    @Override
    public boolean remove(short key) {
        if (key < 0 || key > this.maxKey) {
            throw new IndexOutOfBoundsException();
        }
        RBNode node = this.root;
        while (node != null && key != node.key) {
            if (key < node.key) {
                node = node.left;
                continue;
            }
            node = node.right;
        }
        if (node == null) {
            return false;
        }
        --this.size;
        this.deleteEntry(node);
        return true;
    }

    @Override
    public void removeAll() {
        this.size = 0;
        this.root = null;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private static byte colorOf(RBNode p) {
        return p == null ? (byte)1 : p.color;
    }

    private static RBNode parentOf(RBNode p) {
        return p == null ? null : p.parent;
    }

    private static void setColor(RBNode p, byte c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static RBNode leftOf(RBNode p) {
        return p == null ? null : p.left;
    }

    private static RBNode rightOf(RBNode p) {
        return p == null ? null : p.right;
    }

    private void rotateLeft(RBNode p) {
        RBNode r = p.right;
        p.right = r.left;
        if (r.left != null) {
            r.left.parent = p;
        }
        r.parent = p.parent;
        if (p.parent == null) {
            this.root = r;
        } else if (p.parent.left == p) {
            p.parent.left = r;
        } else {
            p.parent.right = r;
        }
        r.left = p;
        p.parent = r;
    }

    private void rotateRight(RBNode p) {
        RBNode l = p.left;
        p.left = l.right;
        if (l.right != null) {
            l.right.parent = p;
        }
        l.parent = p.parent;
        if (p.parent == null) {
            this.root = l;
        } else if (p.parent.right == p) {
            p.parent.right = l;
        } else {
            p.parent.left = l;
        }
        l.right = p;
        p.parent = l;
    }

    private void fixAfterInsertion(RBNode x) {
        x.color = 0;
        while (x != null && x != this.root && x.parent.color == 0) {
            RBNode y;
            if (RedBlackKeySet.parentOf(x) == RedBlackKeySet.leftOf(RedBlackKeySet.parentOf(RedBlackKeySet.parentOf(x)))) {
                y = RedBlackKeySet.rightOf(RedBlackKeySet.parentOf(RedBlackKeySet.parentOf(x)));
                if (RedBlackKeySet.colorOf(y) == 0) {
                    RedBlackKeySet.setColor(RedBlackKeySet.parentOf(x), (byte)1);
                    RedBlackKeySet.setColor(y, (byte)1);
                    RedBlackKeySet.setColor(RedBlackKeySet.parentOf(RedBlackKeySet.parentOf(x)), (byte)0);
                    x = RedBlackKeySet.parentOf(RedBlackKeySet.parentOf(x));
                    continue;
                }
                if (x == RedBlackKeySet.rightOf(RedBlackKeySet.parentOf(x))) {
                    x = RedBlackKeySet.parentOf(x);
                    this.rotateLeft(x);
                }
                RedBlackKeySet.setColor(RedBlackKeySet.parentOf(x), (byte)1);
                RedBlackKeySet.setColor(RedBlackKeySet.parentOf(RedBlackKeySet.parentOf(x)), (byte)0);
                if (RedBlackKeySet.parentOf(RedBlackKeySet.parentOf(x)) == null) continue;
                this.rotateRight(RedBlackKeySet.parentOf(RedBlackKeySet.parentOf(x)));
                continue;
            }
            y = RedBlackKeySet.leftOf(RedBlackKeySet.parentOf(RedBlackKeySet.parentOf(x)));
            if (RedBlackKeySet.colorOf(y) == 0) {
                RedBlackKeySet.setColor(RedBlackKeySet.parentOf(x), (byte)1);
                RedBlackKeySet.setColor(y, (byte)1);
                RedBlackKeySet.setColor(RedBlackKeySet.parentOf(RedBlackKeySet.parentOf(x)), (byte)0);
                x = RedBlackKeySet.parentOf(RedBlackKeySet.parentOf(x));
                continue;
            }
            if (x == RedBlackKeySet.leftOf(RedBlackKeySet.parentOf(x))) {
                x = RedBlackKeySet.parentOf(x);
                this.rotateRight(x);
            }
            RedBlackKeySet.setColor(RedBlackKeySet.parentOf(x), (byte)1);
            RedBlackKeySet.setColor(RedBlackKeySet.parentOf(RedBlackKeySet.parentOf(x)), (byte)0);
            if (RedBlackKeySet.parentOf(RedBlackKeySet.parentOf(x)) == null) continue;
            this.rotateLeft(RedBlackKeySet.parentOf(RedBlackKeySet.parentOf(x)));
        }
        this.root.color = 1;
    }

    private void deleteEntry(RBNode p) {
        RBNode replacement;
        if (p.left != null && p.right != null) {
            RBNode s = null;
            RBNode node = this.root;
            while (node != null) {
                if (p.key >= node.key) {
                    node = node.right;
                    continue;
                }
                s = node;
                node = node.left;
            }
            this.swapPosition(s, p);
        }
        RBNode rBNode = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color == 1) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color == 1) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
    }

    private void fixAfterDeletion(RBNode x) {
        while (x != this.root && RedBlackKeySet.colorOf(x) == 1) {
            RBNode sib;
            if (x == RedBlackKeySet.leftOf(RedBlackKeySet.parentOf(x))) {
                sib = RedBlackKeySet.rightOf(RedBlackKeySet.parentOf(x));
                if (RedBlackKeySet.colorOf(sib) == 0) {
                    RedBlackKeySet.setColor(sib, (byte)1);
                    RedBlackKeySet.setColor(RedBlackKeySet.parentOf(x), (byte)0);
                    this.rotateLeft(RedBlackKeySet.parentOf(x));
                    sib = RedBlackKeySet.rightOf(RedBlackKeySet.parentOf(x));
                }
                if (RedBlackKeySet.colorOf(RedBlackKeySet.leftOf(sib)) == 1 && RedBlackKeySet.colorOf(RedBlackKeySet.rightOf(sib)) == 1) {
                    RedBlackKeySet.setColor(sib, (byte)0);
                    x = RedBlackKeySet.parentOf(x);
                    continue;
                }
                if (RedBlackKeySet.colorOf(RedBlackKeySet.rightOf(sib)) == 1) {
                    RedBlackKeySet.setColor(RedBlackKeySet.leftOf(sib), (byte)1);
                    RedBlackKeySet.setColor(sib, (byte)0);
                    this.rotateRight(sib);
                    sib = RedBlackKeySet.rightOf(RedBlackKeySet.parentOf(x));
                }
                RedBlackKeySet.setColor(sib, RedBlackKeySet.colorOf(RedBlackKeySet.parentOf(x)));
                RedBlackKeySet.setColor(RedBlackKeySet.parentOf(x), (byte)1);
                RedBlackKeySet.setColor(RedBlackKeySet.rightOf(sib), (byte)1);
                this.rotateLeft(RedBlackKeySet.parentOf(x));
                x = this.root;
                continue;
            }
            sib = RedBlackKeySet.leftOf(RedBlackKeySet.parentOf(x));
            if (RedBlackKeySet.colorOf(sib) == 0) {
                RedBlackKeySet.setColor(sib, (byte)1);
                RedBlackKeySet.setColor(RedBlackKeySet.parentOf(x), (byte)0);
                this.rotateRight(RedBlackKeySet.parentOf(x));
                sib = RedBlackKeySet.leftOf(RedBlackKeySet.parentOf(x));
            }
            if (RedBlackKeySet.colorOf(RedBlackKeySet.rightOf(sib)) == 1 && RedBlackKeySet.colorOf(RedBlackKeySet.leftOf(sib)) == 1) {
                RedBlackKeySet.setColor(sib, (byte)0);
                x = RedBlackKeySet.parentOf(x);
                continue;
            }
            if (RedBlackKeySet.colorOf(RedBlackKeySet.leftOf(sib)) == 1) {
                RedBlackKeySet.setColor(RedBlackKeySet.rightOf(sib), (byte)1);
                RedBlackKeySet.setColor(sib, (byte)0);
                this.rotateLeft(sib);
                sib = RedBlackKeySet.leftOf(RedBlackKeySet.parentOf(x));
            }
            RedBlackKeySet.setColor(sib, RedBlackKeySet.colorOf(RedBlackKeySet.parentOf(x)));
            RedBlackKeySet.setColor(RedBlackKeySet.parentOf(x), (byte)1);
            RedBlackKeySet.setColor(RedBlackKeySet.leftOf(sib), (byte)1);
            this.rotateRight(RedBlackKeySet.parentOf(x));
            x = this.root;
        }
        RedBlackKeySet.setColor(x, (byte)1);
    }

    private void swapPosition(RBNode x, RBNode y) {
        boolean yWasLeftChild;
        RBNode px = x.parent;
        RBNode lx = x.left;
        RBNode rx = x.right;
        RBNode py = y.parent;
        RBNode ly = y.left;
        RBNode ry = y.right;
        boolean xWasLeftChild = px != null && x == px.left;
        boolean bl = yWasLeftChild = py != null && y == py.left;
        if (x == py) {
            x.parent = y;
            if (yWasLeftChild) {
                y.left = x;
                y.right = rx;
            } else {
                y.right = x;
                y.left = lx;
            }
        } else {
            x.parent = py;
            if (py != null) {
                if (yWasLeftChild) {
                    py.left = x;
                } else {
                    py.right = x;
                }
            }
            y.left = lx;
            y.right = rx;
        }
        if (y == px) {
            y.parent = x;
            if (xWasLeftChild) {
                x.left = y;
                x.right = ry;
            } else {
                x.right = y;
                x.left = ly;
            }
        } else {
            y.parent = px;
            if (px != null) {
                if (xWasLeftChild) {
                    px.left = y;
                } else {
                    px.right = y;
                }
            }
            x.left = ly;
            x.right = ry;
        }
        if (x.left != null) {
            x.left.parent = x;
        }
        if (x.right != null) {
            x.right.parent = x;
        }
        if (y.left != null) {
            y.left.parent = y;
        }
        if (y.right != null) {
            y.right.parent = y;
        }
        byte c = x.color;
        x.color = y.color;
        y.color = c;
        if (this.root == x) {
            this.root = y;
        } else if (this.root == y) {
            this.root = x;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        short key = this.getFirst();
        while (key >= 0) {
            s.writeShort(key);
            key = this.getNext(key);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.size = s.readInt();
        this.root = RedBlackKeySet.buildFromSorted(0, 0, this.size - 1, RedBlackKeySet.computeRedLevel(this.size), s);
    }

    private static RBNode buildFromSorted(int level, int lo, int hi, int redLevel, ObjectInputStream str) throws IOException, ClassNotFoundException {
        if (hi < lo) {
            return null;
        }
        int mid = (lo + hi) / 2;
        RBNode left = null;
        if (lo < mid) {
            left = RedBlackKeySet.buildFromSorted(level + 1, lo, mid - 1, redLevel, str);
        }
        short key = str.readShort();
        RBNode middle = new RBNode(key, null);
        if (level == redLevel) {
            middle.color = 0;
        }
        if (left != null) {
            middle.left = left;
            left.parent = middle;
        }
        if (mid < hi) {
            RBNode right;
            middle.right = right = RedBlackKeySet.buildFromSorted(level + 1, mid + 1, hi, redLevel, str);
            right.parent = middle;
        }
        return middle;
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    static class RBNode {
        short key;
        byte color;
        RBNode parent;
        RBNode left;
        RBNode right;

        RBNode(short key, RBNode parent) {
            this.key = key;
            this.parent = parent;
            this.color = 1;
        }
    }
}

