/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.register;

import ghidra.program.database.register.AddressValueRange;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AddressRangeObjectMap<T> {
    private List<AddressValueRange<T>> ranges = new ArrayList<AddressValueRange<T>>();
    AddressValueRange<T> lastRange;

    public AddressRangeIterator getAddressRangeIterator() {
        return new SimpleAddressRangeIterator();
    }

    public AddressRangeIterator getAddressRangeIterator(Address start, Address end) {
        return new RestrictedIndexRangeIterator(start, end);
    }

    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        if (length <= 0L) {
            return;
        }
        AddressRangeObjectMap<T> tmpMap = new AddressRangeObjectMap<T>();
        Address fromEndAddr = fromAddr.add(length - 1L);
        for (AddressRange range : this.getAddressRangeIterator(fromAddr, fromEndAddr)) {
            monitor.checkCancelled();
            Address minAddr = range.getMinAddress();
            T value = this.getObject(minAddr);
            long offset = minAddr.subtract(fromAddr);
            minAddr = toAddr.add(offset);
            Address maxAddr = range.getMaxAddress();
            offset = maxAddr.subtract(fromAddr);
            maxAddr = toAddr.add(offset);
            tmpMap.setObject(minAddr, maxAddr, value);
        }
        this.clearRange(fromAddr, fromEndAddr);
        for (AddressRange range : tmpMap.getAddressRangeIterator()) {
            monitor.checkCancelled();
            T value = tmpMap.getObject(range.getMinAddress());
            this.setObject(range.getMinAddress(), range.getMaxAddress(), value);
        }
    }

    public synchronized void setObject(Address start, Address end, T object) {
        this.lastRange = null;
        AddressValueRange<T> newRange = new AddressValueRange<T>(start, end, object);
        if (this.ranges.isEmpty()) {
            this.ranges.add(newRange);
            return;
        }
        int previousIndex = this.getPositionOfRangeBefore(newRange);
        if (previousIndex >= 0) {
            int oldSize = this.ranges.size();
            newRange = this.adjustPreviousRangeForOverlap(start, end, object, newRange, previousIndex);
            if (oldSize > this.ranges.size()) {
                --previousIndex;
            }
        }
        int insertionIndex = Math.max(0, previousIndex + 1);
        Address newEnd = newRange.getEnd();
        this.removeCompletelyOverlappedRanges(insertionIndex, newEnd);
        newRange = this.adjustRemainingRangeForOverlap(object, newRange, insertionIndex, newEnd);
        this.ranges.add(insertionIndex, newRange);
    }

    private AddressValueRange<T> adjustRemainingRangeForOverlap(T object, AddressValueRange<T> newRange, int insertionIndex, Address newEnd) {
        if (insertionIndex >= this.ranges.size()) {
            return newRange;
        }
        AddressValueRange<T> range = this.ranges.get(insertionIndex);
        if (range.getStart().compareTo(newEnd.next()) > 0) {
            return newRange;
        }
        if (this.valuesEqual(range.getValue(), object)) {
            this.ranges.remove(insertionIndex);
            newRange = new AddressValueRange<T>(newRange.getStart(), range.getEnd(), object);
        } else {
            this.ranges.set(insertionIndex, new AddressValueRange<T>(newEnd.next(), range.getEnd(), range.getValue()));
        }
        return newRange;
    }

    private void removeCompletelyOverlappedRanges(int insertionIndex, Address newEnd) {
        while (insertionIndex < this.ranges.size()) {
            AddressValueRange<T> range = this.ranges.get(insertionIndex);
            if (range.getEnd().compareTo(newEnd) > 0) {
                return;
            }
            this.ranges.remove(insertionIndex);
        }
    }

    private AddressValueRange<T> adjustPreviousRangeForOverlap(Address start, Address end, T object, AddressValueRange<T> newRange, int pos) {
        AddressValueRange<T> previousRange = this.ranges.get(pos);
        if (start.previous() == null || previousRange.getEnd().compareTo(start.previous()) < 0) {
            return newRange;
        }
        Address oldStart = previousRange.getStart();
        Address oldEnd = previousRange.getEnd();
        T oldValue = previousRange.getValue();
        if (this.valuesEqual(previousRange.getValue(), object)) {
            this.ranges.remove(pos);
            newRange = new AddressValueRange<T>(oldStart, this.getMax(oldEnd, end), object);
        } else {
            this.ranges.set(pos, new AddressValueRange<T>(oldStart, start.previous(), oldValue));
            if (previousRange.getEnd().compareTo(end) > 0) {
                this.ranges.add(pos + 1, new AddressValueRange<T>(end.next(), oldEnd, oldValue));
            }
        }
        return newRange;
    }

    public synchronized void clearAll() {
        this.ranges.clear();
        this.lastRange = null;
    }

    public synchronized void clearRange(Address start, Address end) {
        AddressValueRange<T> range;
        this.lastRange = null;
        int pos = this.getPositionOfRangeBefore(new AddressValueRange<Object>(start, end, null));
        if (pos >= 0) {
            range = this.ranges.get(pos);
            if (range.getEnd().compareTo(start) >= 0) {
                this.ranges.set(pos, new AddressValueRange<T>(range.getStart(), start.previous(), range.getValue()));
            }
            if (range.getEnd().compareTo(end) > 0) {
                this.ranges.add(pos + 1, new AddressValueRange<T>(end.next(), range.getEnd(), range.getValue()));
            }
        }
        pos = Math.max(0, pos + 1);
        while (pos < this.ranges.size()) {
            range = this.ranges.get(pos);
            if (range.getEnd().compareTo(end) <= 0) {
                this.ranges.remove(pos);
                continue;
            }
            if (range.getStart().compareTo(end) > 0) break;
            this.ranges.set(pos, new AddressValueRange<T>(end.next(), range.getEnd(), range.getValue()));
        }
    }

    public synchronized boolean contains(Address address) {
        if (this.lastRange != null && this.lastRange.contains(address)) {
            return true;
        }
        int pos = this.getPositionOfRangeAtOrBefore(new AddressValueRange<Object>(address, address, null));
        if (pos < 0) {
            return false;
        }
        this.lastRange = this.ranges.get(pos);
        return this.lastRange.contains(address);
    }

    public synchronized T getObject(Address address) {
        if (address == null) {
            return null;
        }
        if (this.lastRange != null && this.lastRange.contains(address)) {
            return this.lastRange.getValue();
        }
        int pos = this.getPositionOfRangeAtOrBefore(new AddressValueRange<Object>(address, address, null));
        if (pos < 0) {
            return null;
        }
        this.lastRange = this.ranges.get(pos);
        if (this.lastRange.contains(address)) {
            return this.lastRange.getValue();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    int getPositionOfRangeAtOrBefore(AddressValueRange<T> valueRange) {
        int pos = Collections.binarySearch(this.ranges, valueRange);
        if (pos >= 0) {
            return pos;
        }
        if (pos == -1) {
            return -1;
        }
        pos = -pos - 2;
        return Math.min(pos, this.ranges.size());
    }

    int getPositionOfRangeBefore(AddressValueRange<T> valueRange) {
        int pos = Collections.binarySearch(this.ranges, valueRange);
        if (pos >= 0) {
            return pos - 1;
        }
        if (pos == -1) {
            return -1;
        }
        pos = -pos - 2;
        return Math.min(pos, this.ranges.size());
    }

    private boolean valuesEqual(Object value, Object obj) {
        if (value == null) {
            return obj == null;
        }
        return value.equals(obj);
    }

    private Address getMin(Address addr1, Address addr2) {
        if (addr1.compareTo(addr2) <= 0) {
            return addr1;
        }
        return addr2;
    }

    private Address getMax(Address addr1, Address addr2) {
        if (addr1.compareTo(addr2) >= 0) {
            return addr1;
        }
        return addr2;
    }

    public AddressRange getAddressRangeContaining(Address addr) {
        if (this.lastRange != null && this.lastRange.contains(addr)) {
            return new AddressRangeImpl(this.lastRange.getStart(), this.lastRange.getEnd());
        }
        Address min = addr.getAddressSpace().getMinAddress();
        Address max = addr.getAddressSpace().getMaxAddress();
        int pos = this.getPositionOfRangeAtOrBefore(new AddressValueRange<Object>(addr, addr, null));
        if (pos >= 0) {
            this.lastRange = this.ranges.get(pos);
            if (this.lastRange.getEnd().compareTo(addr) >= 0) {
                return new AddressRangeImpl(this.lastRange.getStart(), this.lastRange.getEnd());
            }
            if (min.getAddressSpace().equals(this.lastRange.getEnd().getAddressSpace())) {
                min = this.lastRange.getEnd().next();
            }
        }
        if (++pos < this.ranges.size()) {
            this.lastRange = this.ranges.get(pos);
            if (this.lastRange.getStart().compareTo(addr) == 0) {
                return new AddressRangeImpl(this.lastRange.getStart(), this.lastRange.getEnd());
            }
            if (max.getAddressSpace().equals(this.lastRange.getStart().getAddressSpace())) {
                max = this.lastRange.getStart().previous();
            }
        }
        return new AddressRangeImpl(min, max);
    }

    public void clearCache() {
        this.lastRange = null;
    }

    class SimpleAddressRangeIterator
    implements AddressRangeIterator {
        int pos = 0;

        SimpleAddressRangeIterator() {
        }

        @Override
        public Iterator<AddressRange> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.pos < AddressRangeObjectMap.this.ranges.size();
        }

        @Override
        public AddressRange next() {
            AddressValueRange valueRange = AddressRangeObjectMap.this.ranges.get(this.pos++);
            return new AddressRangeImpl(valueRange.getStart(), valueRange.getEnd());
        }
    }

    class RestrictedIndexRangeIterator
    implements AddressRangeIterator {
        private int pos = 0;
        private Address end;
        private AddressRange nextRange;

        RestrictedIndexRangeIterator(Address start, Address end) {
            AddressValueRange range;
            this.end = end;
            this.pos = AddressRangeObjectMap.this.getPositionOfRangeAtOrBefore(new AddressValueRange<Object>(start, end, null));
            if (this.pos >= 0 && (range = AddressRangeObjectMap.this.ranges.get(this.pos++)).contains(start)) {
                this.nextRange = new AddressRangeImpl(start, AddressRangeObjectMap.this.getMin(range.getEnd(), end));
            }
            if (this.nextRange == null) {
                this.pos = Math.max(0, this.pos);
                this.getNextRange();
            }
        }

        @Override
        public Iterator<AddressRange> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.nextRange != null;
        }

        @Override
        public AddressRange next() {
            AddressRange retRange = this.nextRange;
            if (this.nextRange != null) {
                this.getNextRange();
            }
            return retRange;
        }

        private void getNextRange() {
            AddressValueRange range;
            this.nextRange = null;
            if (this.pos < AddressRangeObjectMap.this.ranges.size() && (range = AddressRangeObjectMap.this.ranges.get(this.pos++)).getStart().compareTo(this.end) <= 0) {
                this.nextRange = new AddressRangeImpl(range.getStart(), AddressRangeObjectMap.this.getMin(range.getEnd(), this.end));
            }
        }
    }
}

