/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.stack;

import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DBTraceStack
implements TraceStack,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private final StackChangeTranslator translator;

    public DBTraceStack(DBTraceObject object) {
        this.object = object;
        this.translator = new StackChangeTranslator(this, object, this);
    }

    @Override
    public TraceThread getThread() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            TraceThread traceThread = this.object.queryCanonicalAncestorsInterface(TraceThread.class).findAny().orElseThrow();
            return traceThread;
        }
    }

    @Override
    public int getDepth(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            int n = this.object.querySuccessorsInterface(Lifespan.at(snap), TraceStackFrame.class, true).map(f -> f.getLevel()).reduce(Integer::max).map(m -> m + 1).orElse(0);
            return n;
        }
    }

    protected TraceStackFrame doAddStackFrame(long snap, int level) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            PathFilter filter = this.object.getSchema().searchFor(TraceStackFrame.class, true);
            KeyPath relPath = filter.applyKeys(KeyPath.makeIndex(level)).getSingletonPath();
            if (relPath == null) {
                throw new IllegalStateException("Could not determine where to create new frame");
            }
            KeyPath path = this.object.getCanonicalPath().extend(relPath);
            TraceStackFrame traceStackFrame = this.object.getManager().addStackFrame(path, snap);
            return traceStackFrame;
        }
    }

    protected void copyFrameAttributes(long snap, TraceStackFrame from, TraceStackFrame to) {
        to.setProgramCounter(Lifespan.nowOn(snap), from.getProgramCounter(snap));
    }

    protected void shiftFrameAttributes(long snap, int from, int to, int count, List<TraceStackFrame> frames) {
        if (from == to) {
            return;
        }
        if (from < to) {
            for (int i = count - 1; i >= 0; --i) {
                this.copyFrameAttributes(snap, frames.get(from + i), frames.get(to + i));
            }
        } else {
            for (int i = 0; i < count; ++i) {
                this.copyFrameAttributes(snap, frames.get(from + i), frames.get(to + i));
            }
        }
    }

    protected void clearFrameAttributes(long snap, int start, int end, List<TraceStackFrame> frames) {
        for (int i = start; i < end; ++i) {
            TraceStackFrame frame = frames.get(i);
            frame.setProgramCounter(Lifespan.nowOn(snap), null);
        }
    }

    @Override
    public void setDepth(long snap, int depth, boolean atInner) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            List frames = this.doGetFrames(snap).collect(Collectors.toCollection(ArrayList::new));
            int curDepth = frames.size();
            if (curDepth == depth) {
                return;
            }
            if (depth < curDepth) {
                if (atInner) {
                    int diff = curDepth - depth;
                    this.shiftFrameAttributes(snap, diff, 0, depth, frames);
                }
                for (int i = depth; i < curDepth; ++i) {
                    ((TraceStackFrame)frames.get(i)).getObject().removeTree(Lifespan.nowOn(snap));
                }
            } else {
                for (int i = curDepth; i < depth; ++i) {
                    frames.add(this.doAddStackFrame(snap, i));
                }
                if (atInner) {
                    int diff = depth - curDepth;
                    this.shiftFrameAttributes(snap, 0, diff, curDepth, frames);
                    this.clearFrameAttributes(snap, 0, diff, frames);
                }
            }
        }
    }

    protected TraceStackFrame doGetFrame(long snap, int level) {
        TraceObjectSchema schema = this.object.getSchema();
        PathFilter filter = schema.searchFor(TraceStackFrame.class, true);
        PathFilter decFilter = filter.applyKeys(KeyPath.makeIndex(level));
        PathFilter hexFilter = filter.applyKeys("0x" + Integer.toHexString(level));
        Lifespan lifespan = Lifespan.at(snap);
        return this.object.getSuccessors(lifespan, decFilter).findAny().map(p -> p.getDestination(this.object).queryInterface(TraceStackFrame.class)).or(() -> this.object.getSuccessors(lifespan, hexFilter).findAny().map(p -> p.getDestination(this.object).queryInterface(TraceStackFrame.class))).orElse(null);
    }

    @Override
    public TraceStackFrame getFrame(long snap, int level, boolean ensureDepth) {
        if (ensureDepth) {
            try (LockHold hold = this.object.getTrace().lockWrite();){
                if (level >= this.getDepth(snap)) {
                    this.setDepth(snap, level + 1, false);
                }
                TraceStackFrame traceStackFrame = this.doGetFrame(snap, level);
                return traceStackFrame;
            }
        }
        try (LockHold hold = this.object.getTrace().lockRead();){
            TraceStackFrame traceStackFrame = this.doGetFrame(snap, level);
            return traceStackFrame;
        }
    }

    protected Stream<TraceStackFrame> doGetFrames(long snap) {
        return this.object.querySuccessorsInterface(Lifespan.at(snap), TraceStackFrame.class, true).sorted(Comparator.comparing(f -> f.getLevel()));
    }

    @Override
    public List<TraceStackFrame> getFrames(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            List<TraceStackFrame> list = this.doGetFrames(snap).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.ALL);
        }
    }

    @Override
    public void remove(long snap) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.nowOn(snap));
        }
    }

    @Override
    public boolean isValid(long snap) {
        return this.object.isAlive(snap);
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return this.translator.translate(rec);
    }

    @Override
    public boolean hasFixedFrames() {
        return false;
    }

    protected class StackChangeTranslator
    extends DBTraceObjectInterface.Translator<TraceStack> {
        protected StackChangeTranslator(DBTraceStack this$0, DBTraceObject object, TraceStack iface) {
            super(null, object, iface);
        }

        @Override
        protected TraceEvent<TraceStack, Void> getAddedType() {
            return TraceEvents.STACK_ADDED;
        }

        @Override
        protected TraceEvent<TraceStack, Lifespan> getLifespanChangedType() {
            return null;
        }

        @Override
        protected TraceEvent<TraceStack, ?> getChangedType() {
            return TraceEvents.STACK_CHANGED;
        }

        @Override
        protected boolean appliesToKey(String key) {
            return false;
        }

        @Override
        protected TraceEvent<TraceStack, Void> getDeletedType() {
            return TraceEvents.STACK_DELETED;
        }
    }
}

