/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.search.trie;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.search.trie.ByteTrieIfc;
import ghidra.util.search.trie.ByteTrieNode;
import ghidra.util.search.trie.ByteTrieNodeIfc;
import ghidra.util.search.trie.Op;
import ghidra.util.search.trie.SearchResult;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class ByteTrie<T>
implements ByteTrieIfc<T> {
    private static final int BUFFER_SIZE = 0x100000;
    private static long GVID = Long.MIN_VALUE;
    private ByteTrieNode<T> root = this.generateNode((byte)0, null, 0);
    private long versionId = ByteTrie.getVersionId();
    private long suffixId = Long.MIN_VALUE;
    private int size = 0;
    private int numberOfNodes = 1;

    private static synchronized long getVersionId() {
        return ++GVID;
    }

    protected ByteTrieNode<T> generateNode(byte id, ByteTrieNode<T> parent, int length) {
        return new ByteTrieNode<T>(id, parent, length);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int numberOfNodes() {
        return this.numberOfNodes;
    }

    @Override
    public boolean add(byte[] value, T item) {
        this.versionId = ByteTrie.getVersionId();
        if (value == null) {
            boolean absent = !this.root.isTerminal();
            this.root.setTerminal(null);
            if (absent) {
                ++this.size;
            }
            return absent;
        }
        ByteTrieNode<T> node = this.root;
        for (int offset = 0; offset < value.length; ++offset) {
            byte c = value[offset];
            ByteTrieNode<T> childNode = node.getChild(c);
            if (childNode == null) {
                childNode = this.generateNode(c, node, node.length() + 1);
                node.addChild(c, childNode);
                ++this.numberOfNodes;
            }
            node = childNode;
        }
        boolean absent = !node.isTerminal();
        node.setTerminal(item);
        if (absent) {
            ++this.size;
        }
        return absent;
    }

    @Override
    public ByteTrieNodeIfc<T> find(byte[] value) {
        if (value == null) {
            return this.root;
        }
        ByteTrieNode<T> node = this.root;
        for (int offset = 0; offset < value.length; ++offset) {
            byte c = value[offset];
            ByteTrieNode<T> childNode = node.getChild(c);
            if (childNode == null) {
                return null;
            }
            node = childNode;
        }
        return node;
    }

    @Override
    public void inorder(TaskMonitor monitor, Op<T> op) throws CancelledException {
        Stack parentStack = new Stack();
        parentStack.push(null);
        ByteTrieNode top = this.root;
        monitor.initialize((long)this.numberOfNodes());
        while (top != null) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            op.op(top);
            if (top.children.length == 0) {
                top = (ByteTrieNode)parentStack.pop();
                continue;
            }
            for (int ii = top.children.length - 1; ii > 0; --ii) {
                parentStack.push(top.children[ii]);
            }
            top = top.children[0];
        }
    }

    @Override
    public List<SearchResult<Integer, T>> search(byte[] text, TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)(this.numberOfNodes() + text.length));
        this.fixupSuffixPointers(monitor);
        ArrayList<SearchResult<Integer, T>> results = new ArrayList<SearchResult<Integer, T>>();
        ByteTrieNode<T> ptr = this.root;
        for (int index = 0; index < text.length; ++index) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            ByteTrieNode<T> trans = null;
            while (trans == null) {
                trans = this.getTransition(ptr, text[index]);
                if (ptr == this.root) break;
                if (trans != null) continue;
                ptr = ptr.suffix;
            }
            if (trans != null) {
                ptr = trans;
            }
            ByteTrieNode<T> tmp = ptr;
            while (tmp != this.root) {
                if (tmp.isTerminal()) {
                    results.add(new SearchResult<Integer, T>(tmp, index - tmp.length() + 1, tmp.getItem()));
                }
                tmp = tmp.suffix;
            }
        }
        return results;
    }

    @Override
    public List<SearchResult<Address, T>> search(Memory memory, AddressSetView view, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        AddressSet initView = memory.getLoadedAndInitializedAddressSet().intersect(view);
        monitor.initialize((long)this.numberOfNodes() + initView.getNumAddresses());
        this.fixupSuffixPointers(monitor);
        ArrayList<SearchResult<Address, T>> results = new ArrayList<SearchResult<Address, T>>();
        byte[] buffer = new byte[0x100000];
        AddressRangeIterator addressRanges = initView.getAddressRanges(true);
        block2: while (addressRanges.hasNext()) {
            AddressRange range = (AddressRange)addressRanges.next();
            BigInteger rangeLength = range.getBigLength();
            int fetchSize = 0x100000;
            if (rangeLength.compareTo(BigInteger.valueOf(0x100000L)) < 0) {
                fetchSize = rangeLength.intValue();
            }
            ByteTrieNode<T> ptr = this.root;
            Address address = range.getMinAddress();
            while (range.contains(address)) {
                monitor.checkCancelled();
                int bytesRead = memory.getBytes(address, buffer, 0, fetchSize);
                monitor.incrementProgress((long)bytesRead);
                for (int index = 0; index < bytesRead; ++index) {
                    ByteTrieNode<T> trans = null;
                    while (trans == null) {
                        trans = this.getTransition(ptr, buffer[index]);
                        if (ptr == this.root) break;
                        if (trans != null) continue;
                        ptr = ptr.suffix;
                    }
                    if (trans != null) {
                        ptr = trans;
                    }
                    ByteTrieNode<T> tmp = ptr;
                    while (tmp != this.root) {
                        if (tmp.isTerminal()) {
                            int offset = index - tmp.length() + 1;
                            Address position = address.add((long)offset);
                            results.add(new SearchResult<Address, T>(tmp, position, tmp.getItem()));
                        }
                        tmp = tmp.suffix;
                    }
                }
                try {
                    address = address.add((long)bytesRead);
                }
                catch (AddressOutOfBoundsException e) {
                    continue block2;
                }
            }
        }
        return results;
    }

    private void fixupSuffixPointers(TaskMonitor monitor) throws CancelledException {
        if (this.versionId > this.suffixId) {
            LinkedList queue = new LinkedList();
            for (int ii = 0; ii < this.root.children.length; ++ii) {
                ByteTrieNode child = this.root.children[ii];
                child.suffix = this.root;
                queue.addLast(child);
            }
            this.root.suffix = this.root;
            while (!queue.isEmpty()) {
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
                ByteTrieNode node = (ByteTrieNode)queue.removeFirst();
                for (int ii = 0; ii < node.children.length; ++ii) {
                    ByteTrieNode tmp = node;
                    byte id = node.children[ii].getId();
                    ByteTrieNode tmpChild = tmp.getChild(id);
                    queue.addLast(tmpChild);
                    tmp = tmp.suffix;
                    while (tmp != this.root && tmp.getChild(id) == null) {
                        tmp = tmp.suffix;
                    }
                    tmpChild.suffix = tmp.getChild(id);
                    if (tmpChild.suffix != null) continue;
                    tmpChild.suffix = this.root;
                }
            }
            this.suffixId = ByteTrie.getVersionId();
        }
    }

    private ByteTrieNode<T> getTransition(ByteTrieNode<T> ptr, byte value) {
        ByteTrieNode<T> child = ptr.getChild(value);
        while (child == null && ptr != this.root) {
            ptr = ptr.suffix;
            child = ptr.getChild(value);
        }
        if (child != null) {
            return child;
        }
        return this.root;
    }
}

