/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.util.viewer.format.FieldHeader;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.util.HelpLocation;
import java.awt.Component;

public class ResetAllFormatsAction
extends DockingAction {
    private FormatManager formatMgr;
    private FieldHeader panel;

    public ResetAllFormatsAction(String owner, FormatManager formatMgr, FieldHeader panel) {
        super("Reset All Formats", owner, false);
        this.panel = panel;
        this.formatMgr = formatMgr;
        this.setPopupMenuData(new MenuData(new String[]{"Reset All Formats"}, null, "format"));
        this.setEnabled(true);
        this.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "Reset All Formats"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        return context.getContextObject() instanceof FieldHeaderLocation;
    }

    public void actionPerformed(ActionContext context) {
        int userChoice = OptionDialog.showOptionDialog((Component)this.panel, (String)"Reset All Formats?", (String)"There is no undo for this action.\nAre you sure you want to reset all formats?", (String)"Continue", (int)2);
        if (userChoice == 0) {
            return;
        }
        this.formatMgr.setDefaultFormats();
        this.panel.getHeaderTab().update();
    }
}

