/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.module;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.cmd.module.RenameCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.services.ProgramTreeService;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import javax.swing.tree.TreePath;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Program Organization", shortDescription="Rename Fragment", description="Rename a fragment in the program tree viewer with either the selected label within the fragment or with the minimum address label in that fragment.", servicesRequired={ProgramTreeService.class})
public class AutoRenamePlugin
extends ProgramPlugin {
    private static final String GROUP_NAME = "delete";
    private static final String[] AUTO_RENAME_MENUPATH = new String[]{"Auto Rename"};
    private AutoRenameAction autoRenameAction;
    private static final String[] AUTO_LBL_RENAME_MENUPATH = new String[]{"Rename Fragment to Label"};
    private DockingAction autoLblRenameAction;
    private ProgramTreeService treeService;

    public AutoRenamePlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    private void createActions() {
        this.autoRenameAction = new AutoRenameAction(this.getName());
        this.autoLblRenameAction = new AutoLableRenameAction(this.getName());
        this.tool.addAction((DockingActionIf)this.autoRenameAction);
        this.tool.addAction((DockingActionIf)this.autoLblRenameAction);
    }

    protected void init() {
        this.treeService = (ProgramTreeService)this.tool.getService(ProgramTreeService.class);
    }

    void autoRenameCallback(ActionContext context) {
        Object obj = context.getContextObject();
        if (obj instanceof ProgramNode) {
            ProgramNode node = (ProgramNode)obj;
            CompoundCmd cmd = new CompoundCmd("Auto Rename Fragment(s)");
            SymbolTable symTable = this.currentProgram.getSymbolTable();
            TreePath[] selectedPaths = node.getTree().getSelectionPaths();
            boolean ignoreDuplicateNames = selectedPaths.length > 1;
            for (int i = 0; i < selectedPaths.length; ++i) {
                Symbol s;
                ProgramFragment f;
                Address a;
                ProgramNode n = (ProgramNode)selectedPaths[i].getLastPathComponent();
                if (!n.isFragment() || (a = (f = n.getFragment()).getMinAddress()) == null || (s = symTable.getPrimarySymbol(a)) == null) continue;
                cmd.add((Command)new RenameCmd(f.getTreeName(), false, f.getName(), s.getName(), ignoreDuplicateNames));
            }
            if (cmd.size() > 0 && !this.tool.execute((Command)cmd, (DomainObject)this.currentProgram)) {
                this.tool.setStatusInfo("Error renaming fragment: " + cmd.getStatusMsg());
            }
        }
    }

    void autoLabelRenameCallback(ListingActionContext context) {
        ProgramLocation location = context.getLocation();
        if (location instanceof LabelFieldLocation && this.currentProgram != null) {
            RenameCmd cmd;
            LabelFieldLocation labelField = (LabelFieldLocation)location;
            String label = labelField.getName();
            String treeName = this.treeService.getViewedTreeName();
            ProgramFragment fragment = this.currentProgram.getListing().getFragment(treeName, labelField.getAddress());
            if (!label.equals(fragment.getName()) && !this.tool.execute((Command)(cmd = new RenameCmd(treeName, false, fragment.getName(), label)), (DomainObject)this.currentProgram)) {
                this.tool.setStatusInfo("Error renaming fragment: " + cmd.getStatusMsg());
            }
        }
    }

    class AutoRenameAction
    extends DockingAction {
        public AutoRenameAction(String owner) {
            super("Rename Fragment from Program Tree View", owner);
            this.setHelpLocation(new HelpLocation("ProgramTreePlugin", "AutoRename"));
            this.setPopupMenuData(new MenuData(AUTO_RENAME_MENUPATH, null, AutoRenamePlugin.GROUP_NAME));
            this.setDescription("Rename a fragment in the program tree viewer with the minimum address label in that fragment.");
            this.setEnabled(true);
        }

        public boolean isEnabledForContext(ActionContext context) {
            ProgramNode node;
            Object activeObj = context.getContextObject();
            if (activeObj != null && activeObj instanceof ProgramNode && (node = (ProgramNode)activeObj).getProgram() != null) {
                TreePath[] selectedPaths = node.getTree().getSelectionPaths();
                for (int i = 0; i < selectedPaths.length; ++i) {
                    ProgramNode n = (ProgramNode)selectedPaths[i].getLastPathComponent();
                    if (!n.isFragment()) continue;
                    return true;
                }
            }
            return false;
        }

        public void actionPerformed(ActionContext context) {
            AutoRenamePlugin.this.autoRenameCallback(context);
        }
    }

    class AutoLableRenameAction
    extends ListingContextAction {
        public AutoLableRenameAction(String owner) {
            super("Rename Fragment from Code Browser", owner);
            this.setPopupMenuData(new MenuData(AUTO_LBL_RENAME_MENUPATH, null, AutoRenamePlugin.GROUP_NAME));
            this.setDescription("Rename a fragment in the program tree viewer with the selected label within the fragment.");
            this.setHelpLocation(new HelpLocation("ProgramTreePlugin", "RenameFragmentToLabel"));
        }

        @Override
        public boolean isEnabledForContext(ListingActionContext context) {
            return context.getLocation() instanceof LabelFieldLocation;
        }

        @Override
        public void actionPerformed(ListingActionContext context) {
            AutoRenamePlugin.this.autoLabelRenameCallback(context);
        }
    }
}

