/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSCounterValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import org.w3c.dom.DOMException;

abstract class AbstractCounterValue
extends TypedValue
implements CSSCounterValue {
    private static final long serialVersionUID = 1L;
    private String identifier;
    private PrimitiveValue listStyle = null;

    protected AbstractCounterValue(CSSValue.Type primitiveType) {
        super(primitiveType);
    }

    protected AbstractCounterValue(AbstractCounterValue copied) {
        super(copied);
        this.identifier = copied.identifier;
        this.listStyle = copied.listStyle;
        if (this.listStyle != null) {
            this.listStyle = this.listStyle.clone();
        }
    }

    @Override
    public String getName() {
        return this.identifier;
    }

    public void setName(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public PrimitiveValue getCounterStyle() {
        return this.listStyle;
    }

    public void setCounterStyle(PrimitiveValue listStyle) {
        this.listStyle = listStyle;
    }

    @Override
    public StyleValue getComponent(int index) {
        if (index == 0) {
            return this.getCounterStyle();
        }
        return null;
    }

    @Override
    public void setComponent(int index, StyleValue component) throws DOMException {
        if (index == 0) {
            if (!(component instanceof PrimitiveValue)) {
                throw new DOMException(17, "Expected a primitive value, got a " + (Object)((Object)component.getCssValueType()));
            }
            this.setCounterStyle((PrimitiveValue)component);
        }
    }

    @Override
    public int getComponentCount() {
        return 1;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.listStyle == null ? this.decimalHashCode() : this.listStyle.hashCode());
        return result;
    }

    private int decimalHashCode() {
        int result = 31 * CSSValue.CssType.TYPED.hashCode() + CSSValue.Type.IDENT.hashCode();
        result = 31 * result + "decimal".hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCounterValue other = (AbstractCounterValue)obj;
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        if (this.listStyle == null) {
            return other.listStyle == null || AbstractCounterValue.isCSSIdentifier(other.listStyle, "decimal");
        }
        if (other.listStyle == null) {
            return AbstractCounterValue.isCSSIdentifier(this.listStyle, "decimal");
        }
        return this.listStyle.equals(other.listStyle);
    }

    static void quoteSeparator(String separator, StringBuilder buf) {
        if (!separator.contains("'")) {
            buf.append('\'').append(separator).append('\'');
        } else {
            buf.append('\"').append(separator).append('\"');
        }
    }
}

