/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.markup.AbstractMarkupFragment;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupParser;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class Markup
extends AbstractMarkupFragment {
    public static final Markup NO_MARKUP = new Markup();
    private List<MarkupElement> markupElements;
    private final MarkupResourceStream markupResourceStream;

    public static Markup of(String markup) {
        return Markup.of(markup, "wicket");
    }

    public static Markup of(String markup, String wicketNamespace) {
        try {
            MarkupParser markupParser = new MarkupParser(markup);
            markupParser.setWicketNamespace(wicketNamespace);
            return markupParser.parse();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (ResourceStreamNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Markup() {
        this.markupResourceStream = null;
    }

    public Markup(MarkupResourceStream markupResourceStream) {
        Args.notNull(markupResourceStream, "markupResourceStream");
        this.markupResourceStream = markupResourceStream;
        this.markupElements = new ArrayList<MarkupElement>();
    }

    @Override
    public final MarkupElement get(int index) {
        return this.markupElements.get(index);
    }

    @Override
    public final MarkupResourceStream getMarkupResourceStream() {
        return this.markupResourceStream;
    }

    public final void replace(int index, MarkupElement elem) {
        Args.notNull(elem, "elem");
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("'index' must be smaller than size(). Index:" + index + "; size:" + this.size());
        }
        this.markupElements.set(index, elem);
    }

    public String locationAsString() {
        return this.markupResourceStream.locationAsString();
    }

    @Override
    public final int size() {
        return this.markupElements.size();
    }

    public final void addMarkupElement(MarkupElement markupElement) {
        this.markupElements.add(markupElement);
    }

    public final void addMarkupElement(int pos, MarkupElement markupElement) {
        this.markupElements.add(pos, markupElement);
    }

    public final void makeImmutable() {
        for (MarkupElement markupElement : this.markupElements) {
            if (!(markupElement instanceof ComponentTag)) continue;
            ((ComponentTag)markupElement).makeImmutable();
        }
        this.markupElements = Collections.unmodifiableList(this.markupElements);
    }

    @Override
    public final IMarkupFragment find(String id) {
        return this.find(id, 0);
    }

    @Override
    public final String toString() {
        return this.toString(false);
    }

    @Override
    public final String toString(boolean markupOnly) {
        AppendingStringBuffer buf = new AppendingStringBuffer(400);
        if (!markupOnly) {
            if (this.markupResourceStream != null) {
                buf.append(this.markupResourceStream.toString());
            } else {
                buf.append("null MarkupResouceStream");
            }
            buf.append("\n");
        }
        if (this.markupElements != null) {
            for (MarkupElement markupElement : this.markupElements) {
                buf.append(markupElement);
            }
        }
        return buf.toString();
    }

    @Override
    public final Iterator<MarkupElement> iterator() {
        return this.markupElements.iterator();
    }

    public final Iterator<MarkupElement> iterator(int startIndex, int size) {
        return this.markupElements.subList(startIndex, startIndex + size).iterator();
    }
}

