/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.realm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.catalina.realm.DataSourceRealm;
import org.apache.naming.ContextBindings;
import org.apache.openejb.config.AutoConfig;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;

public class TomEEDataSourceRealm
extends DataSourceRealm {
    private static final String OPENEJB_RESOURCE_PREFIX = "java:openejb/Resource/";
    private String fullName;

    protected Connection open() {
        try {
            if (this.fullName != null) {
                return ((DataSource)DataSource.class.cast(TomEEDataSourceRealm.openejbContext().lookup(this.fullName))).getConnection();
            }
            Context context = this.localDataSource ? (Context)Context.class.cast(ContextBindings.getClassLoader().lookup("comp/env")) : this.getServer().getGlobalNamingContext();
            return ((DataSource)DataSource.class.cast(context.lookup(this.dataSourceName))).getConnection();
        }
        catch (Exception e) {
            try {
                return this.getConnection(this.dataSourceName);
            }
            catch (Exception e2) {
                try {
                    return this.getConnection(OPENEJB_RESOURCE_PREFIX + this.dataSourceName);
                }
                catch (Exception e3) {
                    List ids = new ConfigurationFactory(true).getResourceIds(DataSource.class.getName(), new Properties());
                    String id = AutoConfig.findResourceId((Collection)ids, (String)this.dataSourceName);
                    if (id != null) {
                        try {
                            return this.getConnection(OPENEJB_RESOURCE_PREFIX + id);
                        }
                        catch (Exception e4) {
                            this.containerLog.error((Object)sm.getString("dataSourceRealm.exception"), (Throwable)e);
                        }
                    } else {
                        this.containerLog.error((Object)sm.getString("dataSourceRealm.exception"), (Throwable)e);
                    }
                    return null;
                }
            }
        }
    }

    private Connection getConnection(String name) throws SQLException, NamingException {
        Connection c = ((DataSource)DataSource.class.cast(TomEEDataSourceRealm.openejbContext().lookup(name))).getConnection();
        this.fullName = name;
        return c;
    }

    private static Context openejbContext() {
        return ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext();
    }
}

