/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openejb.config.Module;
import org.apache.openejb.config.ScanConstants;
import org.apache.openejb.config.ScanUtil;
import org.apache.openejb.core.EmptyResourcesClassLoader;
import org.apache.openejb.loader.SystemInstance;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.archive.ClasspathArchive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.FilterList;
import org.apache.xbean.finder.filter.PackageFilter;

public class ConfigurableClasspathArchive
extends CompositeArchive
implements ScanConstants {
    public ConfigurableClasspathArchive(Module module, URL ... urls) {
        this(module, Arrays.asList(urls));
    }

    public ConfigurableClasspathArchive(Module module, Iterable<URL> urls) {
        this(module, false, urls);
    }

    public ConfigurableClasspathArchive(ClassLoader loader, Iterable<URL> urls) {
        this(loader, false, urls);
    }

    public ConfigurableClasspathArchive(ClassLoader loader, boolean forceDescriptor, Iterable<URL> urls) {
        this((Module)new FakeModule(loader), forceDescriptor, urls);
    }

    public ConfigurableClasspathArchive(ClassLoader loader, URL url) {
        this((Module)new FakeModule(loader), Collections.singletonList(url));
    }

    public ConfigurableClasspathArchive(Module module, boolean forceDescriptor, Iterable<URL> urls) {
        super(ConfigurableClasspathArchive.archive(module, urls, forceDescriptor));
    }

    public static List<Archive> archive(Module module, Iterable<URL> urls, boolean forceDescriptor) {
        ArrayList<Archive> archives = new ArrayList<Archive>();
        for (URL location : urls) {
            try {
                archives.add(ConfigurableClasspathArchive.archive(module, location, forceDescriptor));
            }
            catch (Exception exception) {}
        }
        return archives;
    }

    public static Archive archive(Module module, URL location, boolean forceDescriptor) {
        ClassLoader loader = module.getClassLoader();
        String name = "META-INF/" + ConfigurableClasspathArchive.name();
        try {
            URL scanXml = new URLClassLoader(new URL[]{location}, (ClassLoader)new EmptyResourcesClassLoader()).getResource(name);
            if (scanXml == null && !forceDescriptor) {
                return ClasspathArchive.archive((ClassLoader)loader, (URL)location);
            }
            if (scanXml == null) {
                return new ClassesArchive(new Class[0]);
            }
            ScanUtil.ScanHandler scan = ScanUtil.read(scanXml);
            Archive packageArchive = ConfigurableClasspathArchive.packageArchive(scan.getPackages(), loader, location);
            Archive classesArchive = ConfigurableClasspathArchive.classesArchive(scan.getPackages(), scan.getClasses(), loader);
            if (packageArchive != null && classesArchive != null) {
                return new CompositeArchive(new Archive[]{classesArchive, packageArchive});
            }
            if (packageArchive != null) {
                return packageArchive;
            }
            return classesArchive;
        }
        catch (IOException e) {
            if (forceDescriptor) {
                return new ClassesArchive(new Class[0]);
            }
            return ClasspathArchive.archive((ClassLoader)loader, (URL)location);
        }
    }

    private static String name() {
        return SystemInstance.get().getProperty("openejb.scan.xml.name", "scan.xml");
    }

    public static Archive packageArchive(Set<String> packageNames, ClassLoader loader, URL url) {
        if (!packageNames.isEmpty()) {
            return new FilteredArchive(ClasspathArchive.archive((ClassLoader)loader, (URL)url), ConfigurableClasspathArchive.filters(packageNames));
        }
        return null;
    }

    private static Filter filters(Set<String> packageNames) {
        ArrayList<PackageFilter> filters = new ArrayList<PackageFilter>();
        for (String packageName : packageNames) {
            filters.add(new PackageFilter(packageName));
        }
        return new FilterList(filters);
    }

    public static Archive classesArchive(Set<String> packages, Set<String> classnames, ClassLoader loader) {
        Class[] classes = new Class[classnames.size()];
        int i = 0;
        for (String clazz : classnames) {
            if (packages != null && ConfigurableClasspathArchive.clazzInPackage(packages, clazz)) continue;
            try {
                classes[i++] = loader.loadClass(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (i != classes.length) {
            Class[] updatedClasses = new Class[i];
            System.arraycopy(classes, 0, updatedClasses, 0, i);
            classes = updatedClasses;
        }
        return new ClassesArchive(classes);
    }

    private static boolean clazzInPackage(Collection<String> packagename, String clazz) {
        for (String str : packagename) {
            if (!clazz.startsWith(str)) continue;
            return true;
        }
        return false;
    }

    public static class FakeModule
    extends Module {
        public FakeModule(ClassLoader loader) {
            this(loader, null);
        }

        public FakeModule(ClassLoader loader, Map<String, Object> altDD) {
            this(loader, altDD, ConfigurableClasspathArchive.name());
        }

        public FakeModule(ClassLoader loader, Map<String, Object> altDD, String name) {
            super(false);
            this.setClassLoader(loader);
            URL scanXml = altDD == null ? loader.getResource("META-INF/" + name) : (URL)altDD.get(name);
            if (scanXml != null) {
                this.getAltDDs().put("scan.xml", scanXml);
            }
        }
    }
}

