/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.schema.Table;

public class Schema
implements Comparable<Schema>,
Serializable {
    private static final long serialVersionUID = 1L;
    private DBIdentifier _name = DBIdentifier.NULL;
    private SchemaGroup _group = null;
    private Map<DBIdentifier, Table> _tableMap = null;
    private Map<DBIdentifier, Sequence> _seqMap = null;
    private Table[] _tables = null;
    private Sequence[] _seqs = null;

    public Schema() {
    }

    @Deprecated
    public Schema(String name, SchemaGroup group) {
        this(DBIdentifier.newSchema(name), group);
    }

    public Schema(DBIdentifier name, SchemaGroup group) {
        this.setIdentifier(name);
        this._group = group;
    }

    void remove() {
        Sequence[] seqs;
        Table[] tabs;
        for (Table tab : tabs = this.getTables()) {
            this.removeTable(tab);
        }
        for (Sequence seq : seqs = this.getSequences()) {
            this.removeSequence(seq);
        }
        this._group = null;
    }

    public SchemaGroup getSchemaGroup() {
        return this._group;
    }

    @Deprecated
    public String getName() {
        return this.getIdentifier().getName();
    }

    public DBIdentifier getIdentifier() {
        return this._name;
    }

    @Deprecated
    public void setName(String name) {
        this.setIdentifier(DBIdentifier.trimToNull(DBIdentifier.newSchema(name)));
    }

    public void setIdentifier(DBIdentifier name) {
        if (this.getSchemaGroup() != null) {
            throw new IllegalStateException();
        }
        this._name = DBIdentifier.trimToNull(name);
    }

    public Table[] getTables() {
        if (this._tables == null) {
            this._tables = this._tableMap == null ? new Table[]{} : this._tableMap.values().toArray(new Table[this._tableMap.size()]);
        }
        return this._tables;
    }

    @Deprecated
    public Table getTable(String name) {
        if (name == null || this._tableMap == null) {
            return null;
        }
        return this.getTable(DBIdentifier.newIdentifier(name, DBIdentifier.DBIdentifierType.TABLE, true));
    }

    public Table getTable(DBIdentifier name) {
        if (DBIdentifier.isNull(name) || this._tableMap == null) {
            return null;
        }
        DBIdentifier sName = DBIdentifier.toUpper(name);
        return this._tableMap.get(sName);
    }

    @Deprecated
    public Table addTable(String name) {
        return this.addTable(DBIdentifier.newTable(name));
    }

    public Table addTable(DBIdentifier name) {
        Table tab;
        SchemaGroup group = this.getSchemaGroup();
        name = name.getUnqualifiedName();
        if (group != null) {
            group.addName(name, true);
            tab = group.newTable(name, this);
        } else {
            tab = new Table(name, this);
        }
        if (this._tableMap == null) {
            this._tableMap = new TreeMap<DBIdentifier, Table>();
        }
        DBIdentifier sName = DBIdentifier.toUpper(name);
        this._tableMap.put(sName, tab);
        this._tables = null;
        return tab;
    }

    @Deprecated
    public Table addTable(String name, String validName) {
        return this.addTable(DBIdentifier.newTable(name), DBIdentifier.newTable(validName));
    }

    public Table addTable(DBIdentifier name, DBIdentifier validName) {
        Table tab;
        SchemaGroup group = this.getSchemaGroup();
        if (group != null) {
            group.addName(validName, true);
            tab = group.newTable(validName, this);
        } else {
            tab = new Table(validName, this);
        }
        if (this._tableMap == null) {
            this._tableMap = new TreeMap<DBIdentifier, Table>();
        }
        DBIdentifier sName = DBIdentifier.toUpper(name);
        this._tableMap.put(sName, tab);
        this._tables = null;
        return tab;
    }

    public boolean removeTable(Table tab) {
        if (tab == null || this._tableMap == null) {
            return false;
        }
        DBIdentifier sName = DBIdentifier.toUpper(tab.getIdentifier());
        Table cur = this._tableMap.get(sName);
        if (!cur.equals(tab)) {
            return false;
        }
        this._tableMap.remove(sName);
        this._tables = null;
        SchemaGroup group = this.getSchemaGroup();
        if (group != null) {
            group.removeName(tab.getIdentifier());
        }
        tab.remove();
        return true;
    }

    public Table importTable(Table table) {
        Column[] cols;
        if (table == null) {
            return null;
        }
        Table copy = this.addTable(table.getIdentifier());
        for (Column col : cols = table.getColumns()) {
            copy.importColumn(col);
        }
        copy.importPrimaryKey(table.getPrimaryKey());
        return copy;
    }

    public Sequence[] getSequences() {
        if (this._seqs == null) {
            this._seqs = this._seqMap == null ? new Sequence[]{} : this._seqMap.values().toArray(new Sequence[this._seqMap.size()]);
        }
        return this._seqs;
    }

    @Deprecated
    public Sequence getSequence(String name) {
        if (name == null || this._seqMap == null) {
            return null;
        }
        return this.getSequence(DBIdentifier.newIdentifier(name, DBIdentifier.DBIdentifierType.SEQUENCE, true));
    }

    public Sequence getSequence(DBIdentifier name) {
        if (DBIdentifier.isNull(name) || this._seqMap == null) {
            return null;
        }
        DBIdentifier sName = DBIdentifier.toUpper(name);
        Sequence seq = this._seqMap.get(sName);
        return seq;
    }

    @Deprecated
    public Sequence addSequence(String name) {
        return this.addSequence(DBIdentifier.newIdentifier(name, DBIdentifier.DBIdentifierType.SEQUENCE, true));
    }

    public Sequence addSequence(DBIdentifier name) {
        Sequence seq;
        SchemaGroup group = this.getSchemaGroup();
        if (group != null) {
            group.addName(name, true);
            seq = group.newSequence(name, this);
        } else {
            seq = new Sequence(name, this);
        }
        if (this._seqMap == null) {
            this._seqMap = new TreeMap<DBIdentifier, Sequence>();
        }
        DBIdentifier sName = DBIdentifier.toUpper(name);
        this._seqMap.put(sName, seq);
        this._seqs = null;
        return seq;
    }

    public boolean removeSequence(Sequence seq) {
        if (seq == null || this._seqMap == null) {
            return false;
        }
        DBIdentifier sName = DBIdentifier.toUpper(seq.getIdentifier());
        Sequence cur = this._seqMap.get(sName);
        if (!cur.equals(seq)) {
            return false;
        }
        this._seqMap.remove(sName);
        this._seqs = null;
        SchemaGroup group = this.getSchemaGroup();
        if (group != null) {
            group.removeName(seq.getIdentifier());
        }
        seq.remove();
        return true;
    }

    public Sequence importSequence(Sequence seq) {
        if (seq == null) {
            return null;
        }
        Sequence copy = this.addSequence(seq.getIdentifier());
        copy.setInitialValue(seq.getInitialValue());
        copy.setIncrement(seq.getIncrement());
        copy.setAllocate(seq.getAllocate());
        return copy;
    }

    @Override
    public int compareTo(Schema other) {
        DBIdentifier name = this.getIdentifier();
        DBIdentifier otherName = other.getIdentifier();
        if (DBIdentifier.isNull(name) && DBIdentifier.isNull(otherName)) {
            return 0;
        }
        if (DBIdentifier.isNull(name)) {
            return 1;
        }
        if (DBIdentifier.isNull(otherName)) {
            return -1;
        }
        return name.compareTo(otherName);
    }

    public String toString() {
        return this.getIdentifier().getName();
    }
}

