/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import org.apache.openjpa.datacache.AbstractDataCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.DataCachePCData;
import org.apache.openjpa.event.RemoteCommitListener;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.CacheMap;

public class ConcurrentDataCache
extends AbstractDataCache
implements RemoteCommitListener {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(ConcurrentDataCache.class);
    private CacheMap _cache;
    private int _cacheSize = Integer.MIN_VALUE;
    private int _softRefs = Integer.MIN_VALUE;
    protected boolean _lru = false;

    public CacheMap getCacheMap() {
        return this._cache;
    }

    public void setCacheSize(int size) {
        this._cacheSize = size;
    }

    public int getCacheSize() {
        return this._cache.getCacheSize();
    }

    public void setSoftReferenceSize(int size) {
        this._softRefs = size;
    }

    public int getSoftReferenceSize() {
        return this._cache.getSoftReferenceSize();
    }

    @Override
    public void initialize(DataCacheManager mgr) {
        super.initialize(mgr);
        this.conf.getRemoteCommitEventManager().addInternalListener(this);
        this._cache = this.newCacheMap();
        if (this._cacheSize != Integer.MIN_VALUE) {
            this._cache.setCacheSize(this._cacheSize);
        }
        if (this._softRefs != Integer.MIN_VALUE) {
            this._cache.setSoftReferenceSize(this._softRefs);
        }
    }

    @Override
    public void unpinAll(Class<?> cls, boolean subs) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)_loc.get("cache-class-unpin-all", (Object)this.getName()));
        }
        this.unpinAll(this._cache.getPinnedKeys());
    }

    @Override
    public void writeLock() {
        this._cache.writeLock();
    }

    @Override
    public void writeUnlock() {
        this._cache.writeUnlock();
    }

    protected CacheMap newCacheMap() {
        CacheMap res = new CacheMap(this._lru){

            @Override
            protected void entryRemoved(Object key, Object value, boolean expired) {
                ConcurrentDataCache.this.keyRemoved(key, expired);
            }
        };
        return res;
    }

    @Override
    protected DataCachePCData getInternal(Object key) {
        return (DataCachePCData)this._cache.get(key);
    }

    @Override
    protected DataCachePCData putInternal(Object key, DataCachePCData pc) {
        return (DataCachePCData)this._cache.put(key, pc);
    }

    @Override
    protected DataCachePCData removeInternal(Object key) {
        return (DataCachePCData)this._cache.remove(key);
    }

    @Override
    protected void removeAllInternal(Class<?> cls, boolean subs) {
        this._cache.clear();
    }

    @Override
    protected void clearInternal() {
        this._cache.clear();
    }

    @Override
    protected boolean pinInternal(Object key) {
        return this._cache.pin(key);
    }

    @Override
    protected boolean unpinInternal(Object key) {
        return this._cache.unpin(key);
    }

    @Override
    protected boolean recacheUpdates() {
        return true;
    }

    public void setLru(boolean l) {
        this._lru = l;
    }

    public boolean getLru() {
        return this._lru;
    }
}

