/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.cmd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.PropertyEntity;
import org.flowable.common.engine.impl.persistence.entity.PropertyEntityManager;

public class LockCmd
implements Command<Boolean> {
    protected static final String hostLockDescription;
    protected String lockName;
    protected String engineType;
    protected Duration forceAcquireAfter;

    public LockCmd(String lockName, String engineType) {
        this(lockName, null, engineType);
    }

    public LockCmd(String lockName, Duration forceAcquireAfter, String engineType) {
        this.lockName = lockName;
        this.engineType = engineType;
        this.forceAcquireAfter = forceAcquireAfter;
    }

    @Override
    public Boolean execute(CommandContext commandContext) {
        AbstractEngineConfiguration engineConfiguration = commandContext.getEngineConfigurations().get(this.engineType);
        PropertyEntityManager propertyEntityManager = engineConfiguration.getPropertyEntityManager();
        PropertyEntity property = (PropertyEntity)propertyEntityManager.findById(this.lockName);
        if (property == null) {
            property = (PropertyEntity)propertyEntityManager.create();
            property.setName(this.lockName);
            property.setValue(Instant.now().toString() + hostLockDescription);
            propertyEntityManager.insert(property);
            return true;
        }
        if (property.getValue() == null) {
            property.setValue(Instant.now().toString() + hostLockDescription);
            return true;
        }
        if (this.forceAcquireAfter != null) {
            String value = property.getValue();
            Instant lockAcquireTime = Instant.parse(value.substring(0, value.indexOf(90) + 1));
            if (lockAcquireTime.plus(this.forceAcquireAfter).isBefore(Instant.now())) {
                property.setValue(Instant.now().toString() + hostLockDescription);
                return true;
            }
            return false;
        }
        return false;
    }

    static {
        InetAddress localhost;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            localhost = null;
        }
        StringBuilder sb = new StringBuilder();
        if (localhost != null) {
            sb.append(" - ").append(localhost.getHostName()).append('(').append(localhost.getHostAddress()).append(')');
        } else {
            sb.append(" - ").append("unknown");
        }
        hostLockDescription = sb.substring(0, Math.min(sb.length(), 228));
    }
}

