/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1BitString;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Base64;
import com.unboundid.util.BouncyCastleFIPSHelper;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.OID;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.PasswordReader;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.BooleanValueArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IA5StringArgumentValueValidator;
import com.unboundid.util.args.IPAddressArgumentValueValidator;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.OIDArgumentValueValidator;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.args.SubCommand;
import com.unboundid.util.args.TimestampArgument;
import com.unboundid.util.ssl.JVMDefaultTrustManager;
import com.unboundid.util.ssl.PKCS11KeyManager;
import com.unboundid.util.ssl.cert.AuthorityKeyIdentifierExtension;
import com.unboundid.util.ssl.cert.BasicConstraintsExtension;
import com.unboundid.util.ssl.cert.CRLDistributionPoint;
import com.unboundid.util.ssl.cert.CRLDistributionPointRevocationReason;
import com.unboundid.util.ssl.cert.CRLDistributionPointsExtension;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.DecodedPublicKey;
import com.unboundid.util.ssl.cert.EllipticCurvePublicKey;
import com.unboundid.util.ssl.cert.ExtendedKeyUsageExtension;
import com.unboundid.util.ssl.cert.ExtendedKeyUsageID;
import com.unboundid.util.ssl.cert.GeneralAlternativeNameExtension;
import com.unboundid.util.ssl.cert.GeneralNames;
import com.unboundid.util.ssl.cert.GeneralNamesBuilder;
import com.unboundid.util.ssl.cert.IssuerAlternativeNameExtension;
import com.unboundid.util.ssl.cert.KeyUsageExtension;
import com.unboundid.util.ssl.cert.ManageCertificatesServerCertificateCollector;
import com.unboundid.util.ssl.cert.NamedCurve;
import com.unboundid.util.ssl.cert.PKCS10CertificateSigningRequest;
import com.unboundid.util.ssl.cert.PKCS8EncryptionHandler;
import com.unboundid.util.ssl.cert.PKCS8EncryptionProperties;
import com.unboundid.util.ssl.cert.PKCS8PrivateKey;
import com.unboundid.util.ssl.cert.PublicKeyAlgorithmIdentifier;
import com.unboundid.util.ssl.cert.RSAPublicKey;
import com.unboundid.util.ssl.cert.SignatureAlgorithmIdentifier;
import com.unboundid.util.ssl.cert.SubjectAlternativeNameExtension;
import com.unboundid.util.ssl.cert.SubjectKeyIdentifierExtension;
import com.unboundid.util.ssl.cert.X509Certificate;
import com.unboundid.util.ssl.cert.X509CertificateExtension;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ManageCertificates
extends CommandLineTool {
    @Nullable
    private static final File JVM_DEFAULT_CACERTS_FILE;
    @NotNull
    private static final String BCFKS_KEYSTORE_TYPE = "BCFKS";
    @NotNull
    private static final String BCFKS_KEYSTORE_TYPE_LC;
    @NotNull
    private static final String PROPERTY_DEFAULT_KEYSTORE_TYPE;
    @NotNull
    private static final String DEFAULT_KEYSTORE_TYPE;
    private static final int WRAP_COLUMN;
    @NotNull
    private static final Set<String> ALLOWED_KEYSTORE_TYPE_VALUES;
    @Nullable
    private volatile ArgumentParser globalParser = null;
    @Nullable
    private volatile ArgumentParser subCommandParser = null;
    @NotNull
    private final InputStream in;

    public static void main(String ... args) {
        ResultCode resultCode = ManageCertificates.main(System.in, System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(Math.max(1, Math.min(resultCode.intValue(), 255)));
        }
    }

    @NotNull
    public static ResultCode main(@Nullable InputStream in, @Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        ManageCertificates manageCertificates = new ManageCertificates(in, out, err);
        return manageCertificates.runTool(args);
    }

    public ManageCertificates(@Nullable OutputStream out, @Nullable OutputStream err) {
        this(null, out, err);
    }

    public ManageCertificates(@Nullable InputStream in, @Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
        this.in = in == null ? new ByteArrayInputStream(StaticUtils.NO_BYTES) : in;
    }

    @Override
    @NotNull
    public String getToolName() {
        return "manage-certificates";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return CertMessages.INFO_MANAGE_CERTS_TOOL_DESC.get();
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.10";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return false;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return true;
    }

    /*
     * Opcode count of 13169 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     * WARNING - void declaration
     */
    @Override
    public void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        void displayCSRSubCommand;
        void displayCSRExamples;
        void displayCSRDisplayCommand;
        void displayCSRVerbose;
        void displayCSRParser;
        void displayCSRFile;
        void displayCertSubCommand;
        void displayCertExamples;
        void displayCertDisplayCommand;
        void displayCertVerbose;
        void displayCertParser;
        void displayCertFile;
        void checkUsabilitySubCommand;
        void checkUsabilityExamples;
        void checkUsabilityIgnoreSHA1Signature;
        void checkUsabilityAlias;
        void checkUsabilityKeystoreType;
        void checkUsabilityPromptForKeystorePassword;
        void checkUsabilityKeystorePasswordFile;
        void checkUsabilityKeystorePassword;
        void checkUsabilityParser;
        void checkUsabilityKeystore;
        void trustServerSubCommand;
        void trustServerExamples;
        void trustServerNoPrompt;
        void trustServerVerbose;
        void trustServerEnableSSLDebugging;
        void trustServerIssuersOnly;
        void trustServerAlias;
        void trustServerKeystoreType;
        void trustServerPromptForKeystorePassword;
        void trustServerKeystorePasswordFile;
        void trustServerKeystorePassword;
        void trustServerKeystore;
        void trustServerUseStartTLS;
        void trustServerPort;
        this.globalParser = parser;
        ArgumentParser listCertsParser = new ArgumentParser("list-certificates", CertMessages.INFO_MANAGE_CERTS_SC_LIST_CERTS_DESC.get());
        FileArgument listCertsKeystore = new FileArgument(null, "keystore", JVM_DEFAULT_CACERTS_FILE == null, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_LIST_CERTS_ARG_KS_DESC.get(), true, true, true, false);
        listCertsKeystore.addLongIdentifier("keystore-path", true);
        listCertsKeystore.addLongIdentifier("keystorePath", true);
        listCertsKeystore.addLongIdentifier("keystore-file", true);
        listCertsKeystore.addLongIdentifier("keystoreFile", true);
        listCertsParser.addArgument(listCertsKeystore);
        if (JVM_DEFAULT_CACERTS_FILE != null) {
            BooleanArgument listCertsUseJVMDefault = new BooleanArgument(null, "use-jvm-default-trust-store", 1, CertMessages.INFO_MANAGE_CERTS_SC_LIST_CERTS_ARG_JVM_DEFAULT_DESC.get(JVM_DEFAULT_CACERTS_FILE.getAbsolutePath()));
            listCertsUseJVMDefault.addLongIdentifier("useJVMDefaultTrustStore", true);
            listCertsUseJVMDefault.addLongIdentifier("jvm-default", true);
            listCertsUseJVMDefault.addLongIdentifier("jvmDefault", true);
            listCertsParser.addArgument(listCertsUseJVMDefault);
            listCertsParser.addRequiredArgumentSet(listCertsUseJVMDefault, listCertsKeystore, new Argument[0]);
            listCertsParser.addExclusiveArgumentSet(listCertsUseJVMDefault, listCertsKeystore, new Argument[0]);
        }
        StringArgument listCertsKeystorePassword = new StringArgument(null, "keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_LIST_CERTS_ARG_KS_PW_DESC.get());
        listCertsKeystorePassword.addLongIdentifier("keystorePassword", true);
        listCertsKeystorePassword.addLongIdentifier("keystore-passphrase", true);
        listCertsKeystorePassword.addLongIdentifier("keystorePassphrase", true);
        listCertsKeystorePassword.addLongIdentifier("keystore-pin", true);
        listCertsKeystorePassword.addLongIdentifier("keystorePIN", true);
        listCertsKeystorePassword.addLongIdentifier("storepass", true);
        listCertsKeystorePassword.setSensitive(true);
        listCertsParser.addArgument(listCertsKeystorePassword);
        FileArgument listCertsKeystorePasswordFile = new FileArgument(null, "keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_LIST_CERTS_ARG_KS_PW_FILE_DESC.get(), true, true, true, false);
        listCertsKeystorePasswordFile.addLongIdentifier("keystorePasswordFile", true);
        listCertsKeystorePasswordFile.addLongIdentifier("keystore-passphrase-file", true);
        listCertsKeystorePasswordFile.addLongIdentifier("keystorePassphraseFile", true);
        listCertsKeystorePasswordFile.addLongIdentifier("keystore-pin-file", true);
        listCertsKeystorePasswordFile.addLongIdentifier("keystorePINFile", true);
        listCertsParser.addArgument(listCertsKeystorePasswordFile);
        BooleanArgument listCertsPromptForKeystorePassword = new BooleanArgument(null, "prompt-for-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_LIST_CERTS_ARG_PROMPT_FOR_KS_PW_DESC.get());
        listCertsPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassword", true);
        listCertsPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-passphrase", true);
        listCertsPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassphrase", true);
        listCertsPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-pin", true);
        listCertsPromptForKeystorePassword.addLongIdentifier("promptForKeystorePIN", true);
        listCertsParser.addArgument(listCertsPromptForKeystorePassword);
        StringArgument listCertsKeystoreType = new StringArgument(null, "keystore-type", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TYPE.get(), CertMessages.INFO_MANAGE_CERTS_SC_LIST_CERTS_ARG_KS_TYPE_DESC.get(), ALLOWED_KEYSTORE_TYPE_VALUES);
        listCertsKeystoreType.addLongIdentifier("key-store-type", true);
        listCertsKeystoreType.addLongIdentifier("keystoreType", true);
        listCertsKeystoreType.addLongIdentifier("keystore-format", true);
        listCertsKeystoreType.addLongIdentifier("key-store-format", true);
        listCertsKeystoreType.addLongIdentifier("keystoreFormat", true);
        listCertsKeystoreType.addLongIdentifier("storetype", true);
        listCertsParser.addArgument(listCertsKeystoreType);
        StringArgument listCertsAlias = new StringArgument(null, "alias", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_ALIAS.get(), CertMessages.INFO_MANAGE_CERTS_SC_LIST_CERTS_ARG_ALIAS_DESC.get());
        listCertsAlias.addLongIdentifier("nickname", true);
        listCertsParser.addArgument(listCertsAlias);
        BooleanArgument listCertsDisplayPEM = new BooleanArgument(null, "display-pem-certificate", 1, CertMessages.INFO_MANAGE_CERTS_SC_LIST_CERTS_ARG_DISPLAY_PEM_DESC.get());
        listCertsDisplayPEM.addLongIdentifier("displayPEMCertificate", true);
        listCertsDisplayPEM.addLongIdentifier("display-pem", true);
        listCertsDisplayPEM.addLongIdentifier("displayPEM", true);
        listCertsDisplayPEM.addLongIdentifier("show-pem-certificate", true);
        listCertsDisplayPEM.addLongIdentifier("showPEMCertificate", true);
        listCertsDisplayPEM.addLongIdentifier("show-pem", true);
        listCertsDisplayPEM.addLongIdentifier("showPEM", true);
        listCertsDisplayPEM.addLongIdentifier("pem", true);
        listCertsDisplayPEM.addLongIdentifier("rfc", true);
        listCertsParser.addArgument(listCertsDisplayPEM);
        BooleanArgument listCertsVerbose = new BooleanArgument(null, "verbose", 1, CertMessages.INFO_MANAGE_CERTS_SC_LIST_CERTS_ARG_VERBOSE_DESC.get());
        listCertsParser.addArgument(listCertsVerbose);
        BooleanArgument listCertsDisplayCommand = new BooleanArgument(null, "display-keytool-command", 1, CertMessages.INFO_MANAGE_CERTS_SC_LIST_CERTS_ARG_DISPLAY_COMMAND_DESC.get());
        listCertsDisplayCommand.addLongIdentifier("displayKeytoolCommand", true);
        listCertsDisplayCommand.addLongIdentifier("show-keytool-command", true);
        listCertsDisplayCommand.addLongIdentifier("showKeytoolCommand", true);
        listCertsParser.addArgument(listCertsDisplayCommand);
        listCertsParser.addExclusiveArgumentSet(listCertsKeystorePassword, listCertsKeystorePasswordFile, listCertsPromptForKeystorePassword);
        LinkedHashMap<String[], String> listCertsExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(3));
        listCertsExamples.put(new String[]{"list-certificates", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore")}, CertMessages.INFO_MANAGE_CERTS_SC_LIST_CERTS_EXAMPLE_1.get(ManageCertificates.getPlatformSpecificPath("config", "keystore")));
        listCertsExamples.put(new String[]{"list-certificates", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore.p12"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--alias", "server-cert", "--verbose", "--display-pem-certificate", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_SC_LIST_CERTS_EXAMPLE_2.get(ManageCertificates.getPlatformSpecificPath("config", "keystore.p12"), ManageCertificates.getPlatformSpecificPath("config", "keystore.pin")));
        if (JVM_DEFAULT_CACERTS_FILE != null) {
            listCertsExamples.put(new String[]{"list-certificates", "--use-jvm-default-trust-store"}, CertMessages.INFO_MANAGE_CERTS_SC_LIST_CERTS_EXAMPLE_3.get());
        }
        SubCommand listCertsSubCommand = new SubCommand("list-certificates", CertMessages.INFO_MANAGE_CERTS_SC_LIST_CERTS_DESC.get(), listCertsParser, listCertsExamples);
        listCertsSubCommand.addName("listCertificates", true);
        listCertsSubCommand.addName("list-certs", true);
        listCertsSubCommand.addName("listCerts", true);
        listCertsSubCommand.addName("list", true);
        parser.addSubCommand(listCertsSubCommand);
        ArgumentParser exportCertParser = new ArgumentParser("export-certificate", CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_DESC.get());
        FileArgument exportCertKeystore = new FileArgument(null, "keystore", JVM_DEFAULT_CACERTS_FILE == null, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_ARG_KS_DESC.get(), true, true, true, false);
        exportCertKeystore.addLongIdentifier("keystore-path", true);
        exportCertKeystore.addLongIdentifier("keystorePath", true);
        exportCertKeystore.addLongIdentifier("keystore-file", true);
        exportCertKeystore.addLongIdentifier("keystoreFile", true);
        exportCertParser.addArgument(exportCertKeystore);
        if (JVM_DEFAULT_CACERTS_FILE != null) {
            BooleanArgument exportCertUseJVMDefault = new BooleanArgument(null, "use-jvm-default-trust-store", 1, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERTS_ARG_JVM_DEFAULT_DESC.get(JVM_DEFAULT_CACERTS_FILE.getAbsolutePath()));
            exportCertUseJVMDefault.addLongIdentifier("useJVMDefaultTrustStore", true);
            exportCertUseJVMDefault.addLongIdentifier("jvm-default", true);
            exportCertUseJVMDefault.addLongIdentifier("jvmDefault", true);
            exportCertParser.addArgument(exportCertUseJVMDefault);
            exportCertParser.addRequiredArgumentSet(exportCertUseJVMDefault, exportCertKeystore, new Argument[0]);
            exportCertParser.addExclusiveArgumentSet(exportCertUseJVMDefault, exportCertKeystore, new Argument[0]);
        }
        StringArgument exportCertKeystorePassword = new StringArgument(null, "keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_ARG_KS_PW_DESC.get());
        exportCertKeystorePassword.addLongIdentifier("keystorePassword", true);
        exportCertKeystorePassword.addLongIdentifier("keystore-passphrase", true);
        exportCertKeystorePassword.addLongIdentifier("keystorePassphrase", true);
        exportCertKeystorePassword.addLongIdentifier("keystore-pin", true);
        exportCertKeystorePassword.addLongIdentifier("keystorePIN", true);
        exportCertKeystorePassword.addLongIdentifier("storepass", true);
        exportCertKeystorePassword.setSensitive(true);
        exportCertParser.addArgument(exportCertKeystorePassword);
        FileArgument exportCertKeystorePasswordFile = new FileArgument(null, "keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_ARG_KS_PW_FILE_DESC.get(), true, true, true, false);
        exportCertKeystorePasswordFile.addLongIdentifier("keystorePasswordFile", true);
        exportCertKeystorePasswordFile.addLongIdentifier("keystore-passphrase-file", true);
        exportCertKeystorePasswordFile.addLongIdentifier("keystorePassphraseFile", true);
        exportCertKeystorePasswordFile.addLongIdentifier("keystore-pin-file", true);
        exportCertKeystorePasswordFile.addLongIdentifier("keystorePINFile", true);
        exportCertParser.addArgument(exportCertKeystorePasswordFile);
        BooleanArgument exportCertPromptForKeystorePassword = new BooleanArgument(null, "prompt-for-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_ARG_PROMPT_FOR_KS_PW_DESC.get());
        exportCertPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassword", true);
        exportCertPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-passphrase", true);
        exportCertPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassphrase", true);
        exportCertPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-pin", true);
        exportCertPromptForKeystorePassword.addLongIdentifier("promptForKeystorePIN", true);
        exportCertParser.addArgument(exportCertPromptForKeystorePassword);
        StringArgument exportCertKeystoreType = new StringArgument(null, "keystore-type", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TYPE.get(), CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_ARG_KS_TYPE_DESC.get(), ALLOWED_KEYSTORE_TYPE_VALUES);
        exportCertKeystoreType.addLongIdentifier("key-store-type", true);
        exportCertKeystoreType.addLongIdentifier("keystoreType", true);
        exportCertKeystoreType.addLongIdentifier("keystore-format", true);
        exportCertKeystoreType.addLongIdentifier("key-store-format", true);
        exportCertKeystoreType.addLongIdentifier("keystoreFormat", true);
        exportCertKeystoreType.addLongIdentifier("storetype", true);
        exportCertParser.addArgument(exportCertKeystoreType);
        StringArgument exportCertAlias = new StringArgument(null, "alias", true, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_ALIAS.get(), CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_ARG_ALIAS_DESC.get());
        exportCertAlias.addLongIdentifier("nickname", true);
        exportCertParser.addArgument(exportCertAlias);
        BooleanArgument exportCertChain = new BooleanArgument(null, "export-certificate-chain", 1, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_ARG_CHAIN_DESC.get());
        exportCertChain.addLongIdentifier("exportCertificateChain", true);
        exportCertChain.addLongIdentifier("export-chain", true);
        exportCertChain.addLongIdentifier("exportChain", true);
        exportCertChain.addLongIdentifier("certificate-chain", true);
        exportCertChain.addLongIdentifier("certificateChain", true);
        exportCertChain.addLongIdentifier("chain", true);
        exportCertParser.addArgument(exportCertChain);
        Set<String> exportCertOutputFormatAllowedValues = StaticUtils.setOf("PEM", "text", "txt", "RFC", "DER", "binary", "bin");
        StringArgument exportCertOutputFormat = new StringArgument(null, "output-format", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_FORMAT.get(), CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_ARG_FORMAT_DESC.get(), exportCertOutputFormatAllowedValues, "PEM");
        exportCertOutputFormat.addLongIdentifier("outputFormat", true);
        exportCertParser.addArgument(exportCertOutputFormat);
        FileArgument exportCertOutputFile = new FileArgument(null, "output-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_ARG_FILE_DESC.get(), false, true, true, false);
        exportCertOutputFile.addLongIdentifier("outputFile", true);
        exportCertOutputFile.addLongIdentifier("export-file", true);
        exportCertOutputFile.addLongIdentifier("exportFile", true);
        exportCertOutputFile.addLongIdentifier("certificate-file", true);
        exportCertOutputFile.addLongIdentifier("certificateFile", true);
        exportCertOutputFile.addLongIdentifier("file", true);
        exportCertOutputFile.addLongIdentifier("filename", true);
        exportCertParser.addArgument(exportCertOutputFile);
        BooleanArgument exportCertSeparateFile = new BooleanArgument(null, "separate-file-per-certificate", 1, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_ARG_SEPARATE_FILE_DESC.get());
        exportCertSeparateFile.addLongIdentifier("separateFilePerCertificate", true);
        exportCertSeparateFile.addLongIdentifier("separate-files", true);
        exportCertSeparateFile.addLongIdentifier("separateFiles", true);
        exportCertParser.addArgument(exportCertSeparateFile);
        BooleanArgument exportCertDisplayCommand = new BooleanArgument(null, "display-keytool-command", 1, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_ARG_DISPLAY_COMMAND_DESC.get());
        exportCertDisplayCommand.addLongIdentifier("displayKeytoolCommand", true);
        exportCertDisplayCommand.addLongIdentifier("show-keytool-command", true);
        exportCertDisplayCommand.addLongIdentifier("showKeytoolCommand", true);
        exportCertParser.addArgument(exportCertDisplayCommand);
        exportCertParser.addExclusiveArgumentSet(exportCertKeystorePassword, exportCertKeystorePasswordFile, exportCertPromptForKeystorePassword);
        exportCertParser.addDependentArgumentSet(exportCertSeparateFile, exportCertChain, new Argument[0]);
        exportCertParser.addDependentArgumentSet(exportCertSeparateFile, exportCertOutputFile, new Argument[0]);
        LinkedHashMap<String[], String> exportCertExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(2));
        exportCertExamples.put(new String[]{"export-certificate", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--alias", "server-cert"}, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_EXAMPLE_1.get());
        exportCertExamples.put(new String[]{"export-certificate", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore.p12"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--alias", "server-cert", "--export-certificate-chain", "--output-format", "DER", "--output-file", "certificate-chain.der", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_EXAMPLE_2.get());
        SubCommand exportCertSubCommand = new SubCommand("export-certificate", CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_DESC.get(), exportCertParser, exportCertExamples);
        exportCertSubCommand.addName("exportCertificate", true);
        exportCertSubCommand.addName("export-cert", true);
        exportCertSubCommand.addName("exportCert", true);
        exportCertSubCommand.addName("export", true);
        parser.addSubCommand(exportCertSubCommand);
        ArgumentParser exportKeyParser = new ArgumentParser("export-private-key", CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_DESC.get());
        FileArgument exportKeyKeystore = new FileArgument(null, "keystore", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_ARG_KS_DESC.get(), true, true, true, false);
        exportKeyKeystore.addLongIdentifier("keystore-path", true);
        exportKeyKeystore.addLongIdentifier("keystorePath", true);
        exportKeyKeystore.addLongIdentifier("keystore-file", true);
        exportKeyKeystore.addLongIdentifier("keystoreFile", true);
        exportKeyParser.addArgument(exportKeyKeystore);
        StringArgument exportKeyKeystorePassword = new StringArgument(null, "keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_ARG_KS_PW_DESC.get());
        exportKeyKeystorePassword.addLongIdentifier("keystorePassword", true);
        exportKeyKeystorePassword.addLongIdentifier("keystore-passphrase", true);
        exportKeyKeystorePassword.addLongIdentifier("keystorePassphrase", true);
        exportKeyKeystorePassword.addLongIdentifier("keystore-pin", true);
        exportKeyKeystorePassword.addLongIdentifier("keystorePIN", true);
        exportKeyKeystorePassword.addLongIdentifier("storepass", true);
        exportKeyKeystorePassword.setSensitive(true);
        exportKeyParser.addArgument(exportKeyKeystorePassword);
        FileArgument exportKeyKeystorePasswordFile = new FileArgument(null, "keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_ARG_KS_PW_FILE_DESC.get(), true, true, true, false);
        exportKeyKeystorePasswordFile.addLongIdentifier("keystorePasswordFile", true);
        exportKeyKeystorePasswordFile.addLongIdentifier("keystore-passphrase-file", true);
        exportKeyKeystorePasswordFile.addLongIdentifier("keystorePassphraseFile", true);
        exportKeyKeystorePasswordFile.addLongIdentifier("keystore-pin-file", true);
        exportKeyKeystorePasswordFile.addLongIdentifier("keystorePINFile", true);
        exportKeyParser.addArgument(exportKeyKeystorePasswordFile);
        BooleanArgument exportKeyPromptForKeystorePassword = new BooleanArgument(null, "prompt-for-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_ARG_PROMPT_FOR_KS_PW_DESC.get());
        exportKeyPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassword", true);
        exportKeyPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-passphrase", true);
        exportKeyPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassphrase", true);
        exportKeyPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-pin", true);
        exportKeyPromptForKeystorePassword.addLongIdentifier("promptForKeystorePIN", true);
        exportKeyParser.addArgument(exportKeyPromptForKeystorePassword);
        StringArgument exportKeyPKPassword = new StringArgument(null, "private-key-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_ARG_PK_PW_DESC.get());
        exportKeyPKPassword.addLongIdentifier("privateKeyPassword", true);
        exportKeyPKPassword.addLongIdentifier("private-key-passphrase", true);
        exportKeyPKPassword.addLongIdentifier("privateKeyPassphrase", true);
        exportKeyPKPassword.addLongIdentifier("private-key-pin", true);
        exportKeyPKPassword.addLongIdentifier("privateKeyPIN", true);
        exportKeyPKPassword.addLongIdentifier("key-password", true);
        exportKeyPKPassword.addLongIdentifier("keyPassword", true);
        exportKeyPKPassword.addLongIdentifier("key-passphrase", true);
        exportKeyPKPassword.addLongIdentifier("keyPassphrase", true);
        exportKeyPKPassword.addLongIdentifier("key-pin", true);
        exportKeyPKPassword.addLongIdentifier("keyPIN", true);
        exportKeyPKPassword.addLongIdentifier("keypass", true);
        exportKeyPKPassword.setSensitive(true);
        exportKeyParser.addArgument(exportKeyPKPassword);
        FileArgument exportKeyPKPasswordFile = new FileArgument(null, "private-key-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_ARG_PK_PW_FILE_DESC.get(), true, true, true, false);
        exportKeyPKPasswordFile.addLongIdentifier("privateKeyPasswordFile", true);
        exportKeyPKPasswordFile.addLongIdentifier("private-key-passphrase-file", true);
        exportKeyPKPasswordFile.addLongIdentifier("privateKeyPassphraseFile", true);
        exportKeyPKPasswordFile.addLongIdentifier("private-key-pin-file", true);
        exportKeyPKPasswordFile.addLongIdentifier("privateKeyPINFile", true);
        exportKeyPKPasswordFile.addLongIdentifier("key-password-file", true);
        exportKeyPKPasswordFile.addLongIdentifier("keyPasswordFile", true);
        exportKeyPKPasswordFile.addLongIdentifier("key-passphrase-file", true);
        exportKeyPKPasswordFile.addLongIdentifier("keyPassphraseFile", true);
        exportKeyPKPasswordFile.addLongIdentifier("key-pin-file", true);
        exportKeyPKPasswordFile.addLongIdentifier("keyPINFile", true);
        exportKeyParser.addArgument(exportKeyPKPasswordFile);
        BooleanArgument exportKeyPromptForPKPassword = new BooleanArgument(null, "prompt-for-private-key-password", CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_ARG_PROMPT_FOR_PK_PW_DESC.get());
        exportKeyPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPassword", true);
        exportKeyPromptForPKPassword.addLongIdentifier("prompt-for-private-key-passphrase", true);
        exportKeyPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPassphrase", true);
        exportKeyPromptForPKPassword.addLongIdentifier("prompt-for-private-key-pin", true);
        exportKeyPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPIN", true);
        exportKeyPromptForPKPassword.addLongIdentifier("prompt-for-key-password", true);
        exportKeyPromptForPKPassword.addLongIdentifier("promptForKeyPassword", true);
        exportKeyPromptForPKPassword.addLongIdentifier("prompt-for-key-passphrase", true);
        exportKeyPromptForPKPassword.addLongIdentifier("promptForKeyPassphrase", true);
        exportKeyPromptForPKPassword.addLongIdentifier("prompt-for-key-pin", true);
        exportKeyPromptForPKPassword.addLongIdentifier("promptForKeyPIN", true);
        exportKeyParser.addArgument(exportKeyPromptForPKPassword);
        StringArgument exportKeyKeystoreType = new StringArgument(null, "keystore-type", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TYPE.get(), CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_ARG_KS_TYPE_DESC.get(), ALLOWED_KEYSTORE_TYPE_VALUES);
        exportKeyKeystoreType.addLongIdentifier("key-store-type", true);
        exportKeyKeystoreType.addLongIdentifier("keystoreType", true);
        exportKeyKeystoreType.addLongIdentifier("keystore-format", true);
        exportKeyKeystoreType.addLongIdentifier("key-store-format", true);
        exportKeyKeystoreType.addLongIdentifier("keystoreFormat", true);
        exportKeyKeystoreType.addLongIdentifier("storetype", true);
        exportKeyParser.addArgument(exportKeyKeystoreType);
        StringArgument exportKeyAlias = new StringArgument(null, "alias", true, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_ALIAS.get(), CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_ARG_ALIAS_DESC.get());
        exportKeyAlias.addLongIdentifier("nickname", true);
        exportKeyParser.addArgument(exportKeyAlias);
        Set<String> exportKeyOutputFormatAllowedValues = StaticUtils.setOf("PEM", "text", "txt", "RFC", "DER", "binary", "bin");
        StringArgument exportKeyOutputFormat = new StringArgument(null, "output-format", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_FORMAT.get(), CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_ARG_FORMAT_DESC.get(), exportKeyOutputFormatAllowedValues, "PEM");
        exportKeyOutputFormat.addLongIdentifier("outputFormat", true);
        exportKeyParser.addArgument(exportKeyOutputFormat);
        FileArgument exportKeyOutputFile = new FileArgument(null, "output-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_ARG_FILE_DESC.get(), false, true, true, false);
        exportKeyOutputFile.addLongIdentifier("outputFile", true);
        exportKeyOutputFile.addLongIdentifier("export-file", true);
        exportKeyOutputFile.addLongIdentifier("exportFile", true);
        exportKeyOutputFile.addLongIdentifier("private-key-file", true);
        exportKeyOutputFile.addLongIdentifier("privateKeyFile", true);
        exportKeyOutputFile.addLongIdentifier("key-file", true);
        exportKeyOutputFile.addLongIdentifier("keyFile", true);
        exportKeyOutputFile.addLongIdentifier("file", true);
        exportKeyOutputFile.addLongIdentifier("filename", true);
        exportKeyParser.addArgument(exportKeyOutputFile);
        StringArgument exportKeyEncryptionPassword = new StringArgument(null, "encryption-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_EXPIRT_KEY_ARG_ENC_PW_DESC.get());
        exportKeyEncryptionPassword.addLongIdentifier("encryptionPassword", true);
        exportKeyParser.addArgument(exportKeyEncryptionPassword);
        FileArgument exportKeyEncryptionPasswordFile = new FileArgument(null, "encryption-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_ARG_ENC_PW_FILE_DESC.get(), true, true, true, false);
        exportKeyEncryptionPasswordFile.addLongIdentifier("encryptionPasswordFile", true);
        exportKeyParser.addArgument(exportKeyEncryptionPasswordFile);
        BooleanArgument exportKeyPromptForEncryptionPassword = new BooleanArgument(null, "prompt-for-encryption-password", 1, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_ARG_PROMPT_FOR_ENC_PW.get());
        exportKeyPromptForEncryptionPassword.addLongIdentifier("promptForEncryptionPassword", true);
        exportKeyParser.addArgument(exportKeyPromptForEncryptionPassword);
        exportKeyParser.addRequiredArgumentSet(exportKeyKeystorePassword, exportKeyKeystorePasswordFile, exportKeyPromptForKeystorePassword);
        exportKeyParser.addExclusiveArgumentSet(exportKeyKeystorePassword, exportKeyKeystorePasswordFile, exportKeyPromptForKeystorePassword);
        exportKeyParser.addExclusiveArgumentSet(exportKeyPKPassword, exportKeyPKPasswordFile, exportKeyPromptForPKPassword);
        exportKeyParser.addExclusiveArgumentSet(exportKeyEncryptionPassword, exportKeyEncryptionPasswordFile, exportKeyPromptForEncryptionPassword);
        LinkedHashMap<String[], String> exportKeyExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(2));
        exportKeyExamples.put(new String[]{"export-private-key", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--alias", "server-cert"}, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_EXAMPLE_1.get());
        exportKeyExamples.put(new String[]{"export-private-key", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore.p12"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--private-key-password-file", ManageCertificates.getPlatformSpecificPath("config", "server-cert-key.pin"), "--alias", "server-cert", "--output-format", "DER", "--output-file", "server-cert-key.der"}, CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_KEY_EXAMPLE_2.get());
        SubCommand exportKeySubCommand = new SubCommand("export-private-key", CertMessages.INFO_MANAGE_CERTS_SC_EXPORT_CERT_DESC.get(), exportKeyParser, exportKeyExamples);
        exportKeySubCommand.addName("exportPrivateKey", true);
        exportKeySubCommand.addName("export-key", true);
        exportKeySubCommand.addName("exportKey", true);
        parser.addSubCommand(exportKeySubCommand);
        ArgumentParser importCertParser = new ArgumentParser("import-certificate", CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_DESC.get());
        FileArgument importCertKeystore = new FileArgument(null, "keystore", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_KS_DESC.get(), false, true, true, false);
        importCertKeystore.addLongIdentifier("keystore-path", true);
        importCertKeystore.addLongIdentifier("keystorePath", true);
        importCertKeystore.addLongIdentifier("keystore-file", true);
        importCertKeystore.addLongIdentifier("keystoreFile", true);
        importCertParser.addArgument(importCertKeystore);
        StringArgument importCertKeystorePassword = new StringArgument(null, "keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_KS_PW_DESC.get());
        importCertKeystorePassword.addLongIdentifier("keystorePassword", true);
        importCertKeystorePassword.addLongIdentifier("keystore-passphrase", true);
        importCertKeystorePassword.addLongIdentifier("keystorePassphrase", true);
        importCertKeystorePassword.addLongIdentifier("keystore-pin", true);
        importCertKeystorePassword.addLongIdentifier("keystorePIN", true);
        importCertKeystorePassword.addLongIdentifier("storepass", true);
        importCertKeystorePassword.setSensitive(true);
        importCertParser.addArgument(importCertKeystorePassword);
        FileArgument importCertKeystorePasswordFile = new FileArgument(null, "keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_KS_PW_FILE_DESC.get(), true, true, true, false);
        importCertKeystorePasswordFile.addLongIdentifier("keystorePasswordFile", true);
        importCertKeystorePasswordFile.addLongIdentifier("keystore-passphrase-file", true);
        importCertKeystorePasswordFile.addLongIdentifier("keystorePassphraseFile", true);
        importCertKeystorePasswordFile.addLongIdentifier("keystore-pin-file", true);
        importCertKeystorePasswordFile.addLongIdentifier("keystorePINFile", true);
        importCertParser.addArgument(importCertKeystorePasswordFile);
        BooleanArgument importCertPromptForKeystorePassword = new BooleanArgument(null, "prompt-for-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_PROMPT_FOR_KS_PW_DESC.get());
        importCertPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassword", true);
        importCertPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-passphrase", true);
        importCertPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassphrase", true);
        importCertPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-pin", true);
        importCertPromptForKeystorePassword.addLongIdentifier("promptForKeystorePIN", true);
        importCertParser.addArgument(importCertPromptForKeystorePassword);
        StringArgument importCertKeystoreType = new StringArgument(null, "keystore-type", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TYPE.get(), CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_KS_TYPE_DESC.get(), ALLOWED_KEYSTORE_TYPE_VALUES);
        importCertKeystoreType.addLongIdentifier("key-store-type", true);
        importCertKeystoreType.addLongIdentifier("keystoreType", true);
        importCertKeystoreType.addLongIdentifier("keystore-format", true);
        importCertKeystoreType.addLongIdentifier("key-store-format", true);
        importCertKeystoreType.addLongIdentifier("keystoreFormat", true);
        importCertKeystoreType.addLongIdentifier("storetype", true);
        importCertParser.addArgument(importCertKeystoreType);
        StringArgument importCertAlias = new StringArgument(null, "alias", true, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_ALIAS.get(), CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_ALIAS_DESC.get());
        importCertAlias.addLongIdentifier("nickname", true);
        importCertParser.addArgument(importCertAlias);
        FileArgument importCertCertificateFile = new FileArgument(null, "certificate-file", true, 0, null, CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_CERT_FILE_DESC.get(), true, true, true, false);
        importCertCertificateFile.addLongIdentifier("certificateFile", true);
        importCertCertificateFile.addLongIdentifier("certificate-chain-file", true);
        importCertCertificateFile.addLongIdentifier("certificateChainFile", true);
        importCertCertificateFile.addLongIdentifier("input-file", true);
        importCertCertificateFile.addLongIdentifier("inputFile", true);
        importCertCertificateFile.addLongIdentifier("import-file", true);
        importCertCertificateFile.addLongIdentifier("importFile", true);
        importCertCertificateFile.addLongIdentifier("file", true);
        importCertCertificateFile.addLongIdentifier("filename", true);
        importCertParser.addArgument(importCertCertificateFile);
        FileArgument importCertPKFile = new FileArgument(null, "private-key-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_KEY_FILE_DESC.get(), true, true, true, false);
        importCertPKFile.addLongIdentifier("privateKeyFile", true);
        importCertPKFile.addLongIdentifier("key-file", true);
        importCertPKFile.addLongIdentifier("keyFile", true);
        importCertParser.addArgument(importCertPKFile);
        StringArgument importCertPKPassword = new StringArgument(null, "private-key-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_PK_PW_DESC.get());
        importCertPKPassword.addLongIdentifier("privateKeyPassword", true);
        importCertPKPassword.addLongIdentifier("private-key-passphrase", true);
        importCertPKPassword.addLongIdentifier("privateKeyPassphrase", true);
        importCertPKPassword.addLongIdentifier("private-key-pin", true);
        importCertPKPassword.addLongIdentifier("privateKeyPIN", true);
        importCertPKPassword.addLongIdentifier("key-password", true);
        importCertPKPassword.addLongIdentifier("keyPassword", true);
        importCertPKPassword.addLongIdentifier("key-passphrase", true);
        importCertPKPassword.addLongIdentifier("keyPassphrase", true);
        importCertPKPassword.addLongIdentifier("key-pin", true);
        importCertPKPassword.addLongIdentifier("keyPIN", true);
        importCertPKPassword.addLongIdentifier("keypass", true);
        importCertPKPassword.setSensitive(true);
        importCertParser.addArgument(importCertPKPassword);
        FileArgument importCertPKPasswordFile = new FileArgument(null, "private-key-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_PK_PW_FILE_DESC.get(), true, true, true, false);
        importCertPKPasswordFile.addLongIdentifier("privateKeyPasswordFile", true);
        importCertPKPasswordFile.addLongIdentifier("private-key-passphrase-file", true);
        importCertPKPasswordFile.addLongIdentifier("privateKeyPassphraseFile", true);
        importCertPKPasswordFile.addLongIdentifier("private-key-pin-file", true);
        importCertPKPasswordFile.addLongIdentifier("privateKeyPINFile", true);
        importCertPKPasswordFile.addLongIdentifier("key-password-file", true);
        importCertPKPasswordFile.addLongIdentifier("keyPasswordFile", true);
        importCertPKPasswordFile.addLongIdentifier("key-passphrase-file", true);
        importCertPKPasswordFile.addLongIdentifier("keyPassphraseFile", true);
        importCertPKPasswordFile.addLongIdentifier("key-pin-file", true);
        importCertPKPasswordFile.addLongIdentifier("keyPINFile", true);
        importCertParser.addArgument(importCertPKPasswordFile);
        BooleanArgument importCertPromptForPKPassword = new BooleanArgument(null, "prompt-for-private-key-password", CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_PROMPT_FOR_PK_PW_DESC.get());
        importCertPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPassword", true);
        importCertPromptForPKPassword.addLongIdentifier("prompt-for-private-key-passphrase", true);
        importCertPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPassphrase", true);
        importCertPromptForPKPassword.addLongIdentifier("prompt-for-private-key-pin", true);
        importCertPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPIN", true);
        importCertPromptForPKPassword.addLongIdentifier("prompt-for-key-password", true);
        importCertPromptForPKPassword.addLongIdentifier("promptForKeyPassword", true);
        importCertPromptForPKPassword.addLongIdentifier("prompt-for-key-passphrase", true);
        importCertPromptForPKPassword.addLongIdentifier("promptForKeyPassphrase", true);
        importCertPromptForPKPassword.addLongIdentifier("prompt-for-key-pin", true);
        importCertPromptForPKPassword.addLongIdentifier("promptForKeyPIN", true);
        importCertParser.addArgument(importCertPromptForPKPassword);
        StringArgument importCertEncryptionPassword = new StringArgument(null, "encryption-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_ENC_PW_DESC.get());
        importCertEncryptionPassword.addLongIdentifier("encryptionPassword", true);
        importCertEncryptionPassword.setSensitive(true);
        importCertParser.addArgument(importCertEncryptionPassword);
        FileArgument importCertEncryptionPasswordFile = new FileArgument(null, "encryption-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_ENC_PW_FILE_DESC.get(), true, true, true, false);
        importCertEncryptionPasswordFile.addLongIdentifier("encryptionPasswordFile", true);
        importCertParser.addArgument(importCertEncryptionPasswordFile);
        BooleanArgument importCertPromptForEncryptionPassword = new BooleanArgument(null, "prompt-for-encryption-password", CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_PROMPT_FOR_ENC_PW_DESC.get());
        importCertPromptForEncryptionPassword.addLongIdentifier("promptForEncryptionPassword", true);
        importCertParser.addArgument(importCertPromptForEncryptionPassword);
        BooleanArgument importCertNoPrompt = new BooleanArgument(null, "no-prompt", 1, CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_NO_PROMPT_DESC.get());
        importCertNoPrompt.addLongIdentifier("noPrompt", true);
        importCertParser.addArgument(importCertNoPrompt);
        BooleanArgument importCertDisplayCommand = new BooleanArgument(null, "display-keytool-command", 1, CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_ARG_DISPLAY_COMMAND_DESC.get());
        importCertDisplayCommand.addLongIdentifier("displayKeytoolCommand", true);
        importCertDisplayCommand.addLongIdentifier("show-keytool-command", true);
        importCertDisplayCommand.addLongIdentifier("showKeytoolCommand", true);
        importCertParser.addArgument(importCertDisplayCommand);
        importCertParser.addRequiredArgumentSet(importCertKeystorePassword, importCertKeystorePasswordFile, importCertPromptForKeystorePassword);
        importCertParser.addExclusiveArgumentSet(importCertKeystorePassword, importCertKeystorePasswordFile, importCertPromptForKeystorePassword);
        importCertParser.addExclusiveArgumentSet(importCertPKPassword, importCertPKPasswordFile, importCertPromptForPKPassword);
        importCertParser.addExclusiveArgumentSet(importCertEncryptionPassword, importCertEncryptionPasswordFile, importCertPromptForEncryptionPassword);
        LinkedHashMap<String[], String> importCertExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(2));
        importCertExamples.put(new String[]{"import-certificate", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--alias", "server-cert", "--certificate-file", "server-cert.crt"}, CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_EXAMPLE_1.get("server-cert.crt"));
        importCertExamples.put(new String[]{"import-certificate", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--alias", "server-cert", "--certificate-file", "server-cert.crt", "--certificate-file", "server-cert-issuer.crt", "--private-key-file", "server-cert.key", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_EXAMPLE_2.get());
        SubCommand importCertSubCommand = new SubCommand("import-certificate", CertMessages.INFO_MANAGE_CERTS_SC_IMPORT_CERT_DESC.get(), importCertParser, importCertExamples);
        importCertSubCommand.addName("importCertificate", true);
        importCertSubCommand.addName("import-certificates", true);
        importCertSubCommand.addName("importCertificates", true);
        importCertSubCommand.addName("import-cert", true);
        importCertSubCommand.addName("importCert", true);
        importCertSubCommand.addName("import-certs", true);
        importCertSubCommand.addName("importCerts", true);
        importCertSubCommand.addName("import-certificate-chain", true);
        importCertSubCommand.addName("importCertificateChain", true);
        importCertSubCommand.addName("import-chain", true);
        importCertSubCommand.addName("importChain", true);
        importCertSubCommand.addName("import", true);
        parser.addSubCommand(importCertSubCommand);
        ArgumentParser deleteCertParser = new ArgumentParser("delete-certificate", CertMessages.INFO_MANAGE_CERTS_SC_DELETE_CERT_DESC.get());
        FileArgument deleteCertKeystore = new FileArgument(null, "keystore", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_DELETE_CERT_ARG_KS_DESC.get(), true, true, true, false);
        deleteCertKeystore.addLongIdentifier("keystore-path", true);
        deleteCertKeystore.addLongIdentifier("keystorePath", true);
        deleteCertKeystore.addLongIdentifier("keystore-file", true);
        deleteCertKeystore.addLongIdentifier("keystoreFile", true);
        deleteCertParser.addArgument(deleteCertKeystore);
        StringArgument deleteCertKeystorePassword = new StringArgument(null, "keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_DELETE_CERT_ARG_KS_PW_DESC.get());
        deleteCertKeystorePassword.addLongIdentifier("keystorePassword", true);
        deleteCertKeystorePassword.addLongIdentifier("keystore-passphrase", true);
        deleteCertKeystorePassword.addLongIdentifier("keystorePassphrase", true);
        deleteCertKeystorePassword.addLongIdentifier("keystore-pin", true);
        deleteCertKeystorePassword.addLongIdentifier("keystorePIN", true);
        deleteCertKeystorePassword.addLongIdentifier("storepass", true);
        deleteCertKeystorePassword.setSensitive(true);
        deleteCertParser.addArgument(deleteCertKeystorePassword);
        FileArgument deleteCertKeystorePasswordFile = new FileArgument(null, "keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_DELETE_CERT_ARG_KS_PW_FILE_DESC.get(), true, true, true, false);
        deleteCertKeystorePasswordFile.addLongIdentifier("keystorePasswordFile", true);
        deleteCertKeystorePasswordFile.addLongIdentifier("keystore-passphrase-file", true);
        deleteCertKeystorePasswordFile.addLongIdentifier("keystorePassphraseFile", true);
        deleteCertKeystorePasswordFile.addLongIdentifier("keystore-pin-file", true);
        deleteCertKeystorePasswordFile.addLongIdentifier("keystorePINFile", true);
        deleteCertParser.addArgument(deleteCertKeystorePasswordFile);
        BooleanArgument deleteCertPromptForKeystorePassword = new BooleanArgument(null, "prompt-for-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_DELETE_CERT_ARG_PROMPT_FOR_KS_PW_DESC.get());
        deleteCertPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassword", true);
        deleteCertPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-passphrase", true);
        deleteCertPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassphrase", true);
        deleteCertPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-pin", true);
        deleteCertPromptForKeystorePassword.addLongIdentifier("promptForKeystorePIN", true);
        deleteCertParser.addArgument(deleteCertPromptForKeystorePassword);
        StringArgument deleteCertKeystoreType = new StringArgument(null, "keystore-type", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TYPE.get(), CertMessages.INFO_MANAGE_CERTS_SC_DELETE_CERT_ARG_KS_TYPE_DESC.get(), ALLOWED_KEYSTORE_TYPE_VALUES);
        deleteCertKeystoreType.addLongIdentifier("key-store-type", true);
        deleteCertKeystoreType.addLongIdentifier("keystoreType", true);
        deleteCertKeystoreType.addLongIdentifier("keystore-format", true);
        deleteCertKeystoreType.addLongIdentifier("key-store-format", true);
        deleteCertKeystoreType.addLongIdentifier("keystoreFormat", true);
        deleteCertKeystoreType.addLongIdentifier("storetype", true);
        deleteCertParser.addArgument(deleteCertKeystoreType);
        StringArgument deleteCertAlias = new StringArgument(null, "alias", true, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_ALIAS.get(), CertMessages.INFO_MANAGE_CERTS_SC_DELETE_CERT_ARG_ALIAS_DESC.get());
        deleteCertAlias.addLongIdentifier("nickname", true);
        deleteCertParser.addArgument(deleteCertAlias);
        BooleanArgument deleteCertNoPrompt = new BooleanArgument(null, "no-prompt", 1, CertMessages.INFO_MANAGE_CERTS_SC_DELETE_CERT_ARG_NO_PROMPT_DESC.get());
        deleteCertNoPrompt.addLongIdentifier("noPrompt", true);
        deleteCertParser.addArgument(deleteCertNoPrompt);
        BooleanArgument deleteCertDisplayCommand = new BooleanArgument(null, "display-keytool-command", 1, CertMessages.INFO_MANAGE_CERTS_SC_DELETE_CERT_ARG_DISPLAY_COMMAND_DESC.get());
        deleteCertDisplayCommand.addLongIdentifier("displayKeytoolCommand", true);
        deleteCertDisplayCommand.addLongIdentifier("show-keytool-command", true);
        deleteCertDisplayCommand.addLongIdentifier("showKeytoolCommand", true);
        deleteCertParser.addArgument(deleteCertDisplayCommand);
        deleteCertParser.addExclusiveArgumentSet(deleteCertKeystorePassword, deleteCertKeystorePasswordFile, deleteCertPromptForKeystorePassword);
        deleteCertParser.addRequiredArgumentSet(deleteCertKeystorePassword, deleteCertKeystorePasswordFile, deleteCertPromptForKeystorePassword);
        LinkedHashMap<String[], String> deleteCertExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        deleteCertExamples.put(new String[]{"delete-certificate", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--alias", "server-cert"}, CertMessages.INFO_MANAGE_CERTS_SC_DELETE_CERT_EXAMPLE_1.get(ManageCertificates.getPlatformSpecificPath("config", "keystore")));
        SubCommand deleteCertSubCommand = new SubCommand("delete-certificate", CertMessages.INFO_MANAGE_CERTS_SC_DELETE_CERT_DESC.get(), deleteCertParser, deleteCertExamples);
        deleteCertSubCommand.addName("deleteCertificate", true);
        deleteCertSubCommand.addName("remove-certificate", true);
        deleteCertSubCommand.addName("removeCertificate", true);
        deleteCertSubCommand.addName("delete", true);
        deleteCertSubCommand.addName("remove", true);
        parser.addSubCommand(deleteCertSubCommand);
        ArgumentParser genCertParser = new ArgumentParser("generate-self-signed-certificate", CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_DESC.get());
        FileArgument genCertKeystore = new FileArgument(null, "keystore", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_KS_DESC.get(), false, true, true, false);
        genCertKeystore.addLongIdentifier("keystore-path", true);
        genCertKeystore.addLongIdentifier("keystorePath", true);
        genCertKeystore.addLongIdentifier("keystore-file", true);
        genCertKeystore.addLongIdentifier("keystoreFile", true);
        genCertParser.addArgument(genCertKeystore);
        StringArgument genCertKeystorePassword = new StringArgument(null, "keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_KS_PW_DESC.get());
        genCertKeystorePassword.addLongIdentifier("keystorePassword", true);
        genCertKeystorePassword.addLongIdentifier("keystore-passphrase", true);
        genCertKeystorePassword.addLongIdentifier("keystorePassphrase", true);
        genCertKeystorePassword.addLongIdentifier("keystore-pin", true);
        genCertKeystorePassword.addLongIdentifier("keystorePIN", true);
        genCertKeystorePassword.addLongIdentifier("storepass", true);
        genCertKeystorePassword.setSensitive(true);
        genCertParser.addArgument(genCertKeystorePassword);
        FileArgument genCertKeystorePasswordFile = new FileArgument(null, "keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_KS_PW_FILE_DESC.get(), true, true, true, false);
        genCertKeystorePasswordFile.addLongIdentifier("keystorePasswordFile", true);
        genCertKeystorePasswordFile.addLongIdentifier("keystore-passphrase-file", true);
        genCertKeystorePasswordFile.addLongIdentifier("keystorePassphraseFile", true);
        genCertKeystorePasswordFile.addLongIdentifier("keystore-pin-file", true);
        genCertKeystorePasswordFile.addLongIdentifier("keystorePINFile", true);
        genCertParser.addArgument(genCertKeystorePasswordFile);
        BooleanArgument genCertPromptForKeystorePassword = new BooleanArgument(null, "prompt-for-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_PROMPT_FOR_KS_PW_DESC.get());
        genCertPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassword", true);
        genCertPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-passphrase", true);
        genCertPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassphrase", true);
        genCertPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-pin", true);
        genCertPromptForKeystorePassword.addLongIdentifier("promptForKeystorePIN", true);
        genCertParser.addArgument(genCertPromptForKeystorePassword);
        StringArgument genCertPKPassword = new StringArgument(null, "private-key-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_PK_PW_DESC.get());
        genCertPKPassword.addLongIdentifier("privateKeyPassword", true);
        genCertPKPassword.addLongIdentifier("private-key-passphrase", true);
        genCertPKPassword.addLongIdentifier("privateKeyPassphrase", true);
        genCertPKPassword.addLongIdentifier("private-key-pin", true);
        genCertPKPassword.addLongIdentifier("privateKeyPIN", true);
        genCertPKPassword.addLongIdentifier("key-password", true);
        genCertPKPassword.addLongIdentifier("keyPassword", true);
        genCertPKPassword.addLongIdentifier("key-passphrase", true);
        genCertPKPassword.addLongIdentifier("keyPassphrase", true);
        genCertPKPassword.addLongIdentifier("key-pin", true);
        genCertPKPassword.addLongIdentifier("keyPIN", true);
        genCertPKPassword.addLongIdentifier("keypass", true);
        genCertPKPassword.setSensitive(true);
        genCertParser.addArgument(genCertPKPassword);
        FileArgument genCertPKPasswordFile = new FileArgument(null, "private-key-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_PK_PW_FILE_DESC.get(), true, true, true, false);
        genCertPKPasswordFile.addLongIdentifier("privateKeyPasswordFile", true);
        genCertPKPasswordFile.addLongIdentifier("private-key-passphrase-file", true);
        genCertPKPasswordFile.addLongIdentifier("privateKeyPassphraseFile", true);
        genCertPKPasswordFile.addLongIdentifier("private-key-pin-file", true);
        genCertPKPasswordFile.addLongIdentifier("privateKeyPINFile", true);
        genCertPKPasswordFile.addLongIdentifier("key-password-file", true);
        genCertPKPasswordFile.addLongIdentifier("keyPasswordFile", true);
        genCertPKPasswordFile.addLongIdentifier("key-passphrase-file", true);
        genCertPKPasswordFile.addLongIdentifier("keyPassphraseFile", true);
        genCertPKPasswordFile.addLongIdentifier("key-pin-file", true);
        genCertPKPasswordFile.addLongIdentifier("keyPINFile", true);
        genCertParser.addArgument(genCertPKPasswordFile);
        BooleanArgument genCertPromptForPKPassword = new BooleanArgument(null, "prompt-for-private-key-password", CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_PROMPT_FOR_PK_PW_DESC.get());
        genCertPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPassword", true);
        genCertPromptForPKPassword.addLongIdentifier("prompt-for-private-key-passphrase", true);
        genCertPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPassphrase", true);
        genCertPromptForPKPassword.addLongIdentifier("prompt-for-private-key-pin", true);
        genCertPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPIN", true);
        genCertPromptForPKPassword.addLongIdentifier("prompt-for-key-password", true);
        genCertPromptForPKPassword.addLongIdentifier("promptForKeyPassword", true);
        genCertPromptForPKPassword.addLongIdentifier("prompt-for-key-passphrase", true);
        genCertPromptForPKPassword.addLongIdentifier("promptForKeyPassphrase", true);
        genCertPromptForPKPassword.addLongIdentifier("prompt-for-key-pin", true);
        genCertPromptForPKPassword.addLongIdentifier("promptForKeyPIN", true);
        genCertParser.addArgument(genCertPromptForPKPassword);
        StringArgument genCertKeystoreType = new StringArgument(null, "keystore-type", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TYPE.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_KS_TYPE_DESC.get(), ALLOWED_KEYSTORE_TYPE_VALUES);
        genCertKeystoreType.addLongIdentifier("key-store-type", true);
        genCertKeystoreType.addLongIdentifier("keystoreType", true);
        genCertKeystoreType.addLongIdentifier("keystore-format", true);
        genCertKeystoreType.addLongIdentifier("key-store-format", true);
        genCertKeystoreType.addLongIdentifier("keystoreFormat", true);
        genCertKeystoreType.addLongIdentifier("storetype", true);
        genCertParser.addArgument(genCertKeystoreType);
        StringArgument genCertAlias = new StringArgument(null, "alias", true, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_ALIAS.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_ALIAS_DESC.get());
        genCertAlias.addLongIdentifier("nickname", true);
        genCertParser.addArgument(genCertAlias);
        BooleanArgument genCertUseExistingKeyPair = new BooleanArgument(null, "use-existing-key-pair", 1, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_USE_EXISTING_KP_DESC.get());
        genCertUseExistingKeyPair.addLongIdentifier("use-existing-keypair", true);
        genCertUseExistingKeyPair.addLongIdentifier("useExistingKeypair", true);
        genCertUseExistingKeyPair.addLongIdentifier("replace-existing-certificate", true);
        genCertUseExistingKeyPair.addLongIdentifier("replaceExistingCertificate", true);
        genCertUseExistingKeyPair.addLongIdentifier("replace-certificate", true);
        genCertUseExistingKeyPair.addLongIdentifier("replaceCertificate", true);
        genCertUseExistingKeyPair.addLongIdentifier("replace-existing", true);
        genCertUseExistingKeyPair.addLongIdentifier("replaceExisting", true);
        genCertUseExistingKeyPair.addLongIdentifier("replace", true);
        genCertParser.addArgument(genCertUseExistingKeyPair);
        DNArgument genCertSubjectDN = new DNArgument(null, "subject-dn", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_SUBJECT_DN_DESC.get());
        genCertSubjectDN.addLongIdentifier("subjectDN", true);
        genCertSubjectDN.addLongIdentifier("subject", true);
        genCertSubjectDN.addLongIdentifier("dname", true);
        genCertParser.addArgument(genCertSubjectDN);
        IntegerArgument genCertDaysValid = new IntegerArgument(null, "days-valid", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_DAYS_VALID_DESC.get(), 1, Integer.MAX_VALUE);
        genCertDaysValid.addLongIdentifier("daysValid", true);
        genCertDaysValid.addLongIdentifier("validity", true);
        genCertParser.addArgument(genCertDaysValid);
        TimestampArgument genCertNotBefore = new TimestampArgument(null, "validity-start-time", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TIMESTAMP.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_VALIDITY_START_TIME_DESC.get("20180102123456"));
        genCertNotBefore.addLongIdentifier("validityStartTime", true);
        genCertNotBefore.addLongIdentifier("not-before", true);
        genCertNotBefore.addLongIdentifier("notBefore", true);
        genCertParser.addArgument(genCertNotBefore);
        StringArgument genCertKeyAlgorithm = new StringArgument(null, "key-algorithm", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_KEY_ALGORITHM_DESC.get());
        genCertKeyAlgorithm.addLongIdentifier("keyAlgorithm", true);
        genCertKeyAlgorithm.addLongIdentifier("key-alg", true);
        genCertKeyAlgorithm.addLongIdentifier("keyAlg", true);
        genCertParser.addArgument(genCertKeyAlgorithm);
        IntegerArgument genCertKeySizeBits = new IntegerArgument(null, "key-size-bits", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_BITS.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_KEY_SIZE_BITS_DESC.get(), 1, Integer.MAX_VALUE);
        genCertKeySizeBits.addLongIdentifier("keySizeBits", true);
        genCertKeySizeBits.addLongIdentifier("key-length-bits", true);
        genCertKeySizeBits.addLongIdentifier("keyLengthBits", true);
        genCertKeySizeBits.addLongIdentifier("key-size", true);
        genCertKeySizeBits.addLongIdentifier("keySize", true);
        genCertKeySizeBits.addLongIdentifier("key-length", true);
        genCertKeySizeBits.addLongIdentifier("keyLength", true);
        genCertParser.addArgument(genCertKeySizeBits);
        StringArgument genCertSignatureAlgorithm = new StringArgument(null, "signature-algorithm", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_SIG_ALG_DESC.get());
        genCertSignatureAlgorithm.addLongIdentifier("signatureAlgorithm", true);
        genCertSignatureAlgorithm.addLongIdentifier("signature-alg", true);
        genCertSignatureAlgorithm.addLongIdentifier("signatureAlg", true);
        genCertSignatureAlgorithm.addLongIdentifier("sig-alg", true);
        genCertSignatureAlgorithm.addLongIdentifier("sigAlg", true);
        genCertParser.addArgument(genCertSignatureAlgorithm);
        BooleanArgument genCertInheritExtensions = new BooleanArgument(null, "inherit-extensions", 1, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_INHERIT_EXT_DESC.get());
        genCertInheritExtensions.addLongIdentifier("inheritExtensions", true);
        genCertParser.addArgument(genCertInheritExtensions);
        StringArgument genCertSubjectAltDNS = new StringArgument(null, "subject-alternative-name-dns", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_SAN_DNS_DESC.get());
        genCertSubjectAltDNS.addLongIdentifier("subjectAlternativeNameDNS", true);
        genCertSubjectAltDNS.addLongIdentifier("subject-alt-name-dns", true);
        genCertSubjectAltDNS.addLongIdentifier("subjectAltNameDNS", true);
        genCertSubjectAltDNS.addLongIdentifier("subject-alternative-dns", true);
        genCertSubjectAltDNS.addLongIdentifier("subjectAlternativeDNS", true);
        genCertSubjectAltDNS.addLongIdentifier("subject-alt-dns", true);
        genCertSubjectAltDNS.addLongIdentifier("subjectAltDNS", true);
        genCertSubjectAltDNS.addLongIdentifier("san-dns", true);
        genCertSubjectAltDNS.addLongIdentifier("sanDNS", true);
        genCertSubjectAltDNS.addValueValidator(new IA5StringArgumentValueValidator(false));
        genCertParser.addArgument(genCertSubjectAltDNS);
        StringArgument genCertSubjectAltIP = new StringArgument(null, "subject-alternative-name-ip-address", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_SAN_IP_DESC.get());
        genCertSubjectAltIP.addLongIdentifier("subjectAlternativeNameIPAddress", true);
        genCertSubjectAltIP.addLongIdentifier("subject-alternative-name-ip", true);
        genCertSubjectAltIP.addLongIdentifier("subjectAlternativeNameIP", true);
        genCertSubjectAltIP.addLongIdentifier("subject-alt-name-ip-address", true);
        genCertSubjectAltIP.addLongIdentifier("subjectAltNameIPAddress", true);
        genCertSubjectAltIP.addLongIdentifier("subject-alt-name-ip", true);
        genCertSubjectAltIP.addLongIdentifier("subjectAltNameIP", true);
        genCertSubjectAltIP.addLongIdentifier("subject-alternative-ip-address", true);
        genCertSubjectAltIP.addLongIdentifier("subjectAlternativeIPAddress", true);
        genCertSubjectAltIP.addLongIdentifier("subject-alternative-ip", true);
        genCertSubjectAltIP.addLongIdentifier("subjectAlternativeIP", true);
        genCertSubjectAltIP.addLongIdentifier("subject-alt-ip-address", true);
        genCertSubjectAltIP.addLongIdentifier("subjectAltIPAddress", true);
        genCertSubjectAltIP.addLongIdentifier("subject-alt-ip", true);
        genCertSubjectAltIP.addLongIdentifier("subjectAltIP", true);
        genCertSubjectAltIP.addLongIdentifier("san-ip-address", true);
        genCertSubjectAltIP.addLongIdentifier("sanIPAddress", true);
        genCertSubjectAltIP.addLongIdentifier("san-ip", true);
        genCertSubjectAltIP.addLongIdentifier("sanIP", true);
        genCertSubjectAltIP.addValueValidator(new IPAddressArgumentValueValidator(true, true));
        genCertParser.addArgument(genCertSubjectAltIP);
        StringArgument genCertSubjectAltEmail = new StringArgument(null, "subject-alternative-name-email-address", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_SAN_EMAIL_DESC.get());
        genCertSubjectAltEmail.addLongIdentifier("subjectAlternativeNameEmailAddress", true);
        genCertSubjectAltEmail.addLongIdentifier("subject-alternative-name-email", true);
        genCertSubjectAltEmail.addLongIdentifier("subjectAlternativeNameEmail", true);
        genCertSubjectAltEmail.addLongIdentifier("subject-alt-name-email-address", true);
        genCertSubjectAltEmail.addLongIdentifier("subjectAltNameEmailAddress", true);
        genCertSubjectAltEmail.addLongIdentifier("subject-alt-name-email", true);
        genCertSubjectAltEmail.addLongIdentifier("subjectAltNameEmail", true);
        genCertSubjectAltEmail.addLongIdentifier("subject-alternative-email-address", true);
        genCertSubjectAltEmail.addLongIdentifier("subjectAlternativeEmailAddress", true);
        genCertSubjectAltEmail.addLongIdentifier("subject-alternative-email", true);
        genCertSubjectAltEmail.addLongIdentifier("subjectAlternativeEmail", true);
        genCertSubjectAltEmail.addLongIdentifier("subject-alt-email-address", true);
        genCertSubjectAltEmail.addLongIdentifier("subjectAltEmailAddress", true);
        genCertSubjectAltEmail.addLongIdentifier("subject-alt-email", true);
        genCertSubjectAltEmail.addLongIdentifier("subjectAltEmail", true);
        genCertSubjectAltEmail.addLongIdentifier("san-email-address", true);
        genCertSubjectAltEmail.addLongIdentifier("sanEmailAddress", true);
        genCertSubjectAltEmail.addLongIdentifier("san-email", true);
        genCertSubjectAltEmail.addLongIdentifier("sanEmail", true);
        genCertSubjectAltEmail.addValueValidator(new IA5StringArgumentValueValidator(false));
        genCertParser.addArgument(genCertSubjectAltEmail);
        StringArgument genCertSubjectAltURI = new StringArgument(null, "subject-alternative-name-uri", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_URI.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_SAN_URI_DESC.get());
        genCertSubjectAltURI.addLongIdentifier("subjectAlternativeNameURI", true);
        genCertSubjectAltURI.addLongIdentifier("subject-alt-name-uri", true);
        genCertSubjectAltURI.addLongIdentifier("subjectAltNameURI", true);
        genCertSubjectAltURI.addLongIdentifier("subject-alternative-uri", true);
        genCertSubjectAltURI.addLongIdentifier("subjectAlternativeURI", true);
        genCertSubjectAltURI.addLongIdentifier("subject-alt-uri", true);
        genCertSubjectAltURI.addLongIdentifier("subjectAltURI", true);
        genCertSubjectAltURI.addLongIdentifier("san-uri", true);
        genCertSubjectAltURI.addLongIdentifier("sanURI", true);
        genCertParser.addArgument(genCertSubjectAltURI);
        StringArgument genCertSubjectAltOID = new StringArgument(null, "subject-alternative-name-oid", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_OID.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_SAN_OID_DESC.get());
        genCertSubjectAltOID.addLongIdentifier("subjectAlternativeNameOID", true);
        genCertSubjectAltOID.addLongIdentifier("subject-alt-name-oid", true);
        genCertSubjectAltOID.addLongIdentifier("subjectAltNameOID", true);
        genCertSubjectAltOID.addLongIdentifier("subject-alternative-oid", true);
        genCertSubjectAltOID.addLongIdentifier("subjectAlternativeOID", true);
        genCertSubjectAltOID.addLongIdentifier("subject-alt-oid", true);
        genCertSubjectAltOID.addLongIdentifier("subjectAltOID", true);
        genCertSubjectAltOID.addLongIdentifier("san-oid", true);
        genCertSubjectAltOID.addLongIdentifier("sanOID", true);
        genCertSubjectAltOID.addValueValidator(new OIDArgumentValueValidator(true));
        genCertParser.addArgument(genCertSubjectAltOID);
        BooleanValueArgument genCertBasicConstraintsIsCA = new BooleanValueArgument(null, "basic-constraints-is-ca", false, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_BC_IS_CA_DESC.get());
        genCertBasicConstraintsIsCA.addLongIdentifier("basicConstraintsIsCA", true);
        genCertBasicConstraintsIsCA.addLongIdentifier("bc-is-ca", true);
        genCertBasicConstraintsIsCA.addLongIdentifier("bcIsCA", true);
        genCertParser.addArgument(genCertBasicConstraintsIsCA);
        IntegerArgument genCertBasicConstraintsPathLength = new IntegerArgument(null, "basic-constraints-maximum-path-length", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_BC_PATH_LENGTH_DESC.get(), 0, Integer.MAX_VALUE);
        genCertBasicConstraintsPathLength.addLongIdentifier("basicConstraintsMaximumPathLength", true);
        genCertBasicConstraintsPathLength.addLongIdentifier("basic-constraints-max-path-length", true);
        genCertBasicConstraintsPathLength.addLongIdentifier("basicConstraintsMaxPathLength", true);
        genCertBasicConstraintsPathLength.addLongIdentifier("basic-constraints-path-length", true);
        genCertBasicConstraintsPathLength.addLongIdentifier("basicConstraintsPathLength", true);
        genCertBasicConstraintsPathLength.addLongIdentifier("bc-maximum-path-length", true);
        genCertBasicConstraintsPathLength.addLongIdentifier("bcMaximumPathLength", true);
        genCertBasicConstraintsPathLength.addLongIdentifier("bc-max-path-length", true);
        genCertBasicConstraintsPathLength.addLongIdentifier("bcMaxPathLength", true);
        genCertBasicConstraintsPathLength.addLongIdentifier("bc-path-length", true);
        genCertBasicConstraintsPathLength.addLongIdentifier("bcPathLength", true);
        genCertParser.addArgument(genCertBasicConstraintsPathLength);
        StringArgument genCertKeyUsage = new StringArgument(null, "key-usage", false, 0, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_KU_DESC.get());
        genCertKeyUsage.addLongIdentifier("keyUsage", true);
        genCertParser.addArgument(genCertKeyUsage);
        StringArgument genCertExtendedKeyUsage = new StringArgument(null, "extended-key-usage", false, 0, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_EKU_DESC.get());
        genCertExtendedKeyUsage.addLongIdentifier("extendedKeyUsage", true);
        genCertParser.addArgument(genCertExtendedKeyUsage);
        StringArgument genCertExtension = new StringArgument(null, "extension", false, 0, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_EXT_DESC.get());
        genCertExtension.addLongIdentifier("ext", true);
        genCertParser.addArgument(genCertExtension);
        FileArgument genCertOutputFile = new FileArgument(null, "output-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_OUTPUT_FILE_DESC.get(), false, true, true, false);
        genCertOutputFile.addLongIdentifier("outputFile", true);
        genCertOutputFile.addLongIdentifier("filename", true);
        genCertOutputFile.addLongIdentifier("file", true);
        genCertParser.addArgument(genCertOutputFile);
        Set<String> genCertOutputFormatAllowedValues = StaticUtils.setOf("PEM", "text", "txt", "RFC", "DER", "binary", "bin");
        StringArgument genCertOutputFormat = new StringArgument(null, "output-format", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_FORMAT.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_FORMAT_DESC.get(), genCertOutputFormatAllowedValues, "PEM");
        genCertOutputFormat.addLongIdentifier("outputFormat", true);
        genCertParser.addArgument(genCertOutputFormat);
        BooleanArgument genCertDisplayCommand = new BooleanArgument(null, "display-keytool-command", 1, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_DISPLAY_COMMAND_DESC.get());
        genCertDisplayCommand.addLongIdentifier("displayKeytoolCommand", true);
        genCertDisplayCommand.addLongIdentifier("show-keytool-command", true);
        genCertDisplayCommand.addLongIdentifier("showKeytoolCommand", true);
        genCertParser.addArgument(genCertDisplayCommand);
        genCertParser.addRequiredArgumentSet(genCertKeystorePassword, genCertKeystorePasswordFile, genCertPromptForKeystorePassword);
        genCertParser.addExclusiveArgumentSet(genCertKeystorePassword, genCertKeystorePasswordFile, genCertPromptForKeystorePassword);
        genCertParser.addExclusiveArgumentSet(genCertPKPassword, genCertPKPasswordFile, genCertPromptForPKPassword);
        genCertParser.addExclusiveArgumentSet(genCertUseExistingKeyPair, genCertKeyAlgorithm, new Argument[0]);
        genCertParser.addExclusiveArgumentSet(genCertUseExistingKeyPair, genCertKeySizeBits, new Argument[0]);
        genCertParser.addExclusiveArgumentSet(genCertUseExistingKeyPair, genCertSignatureAlgorithm, new Argument[0]);
        genCertParser.addDependentArgumentSet(genCertBasicConstraintsPathLength, genCertBasicConstraintsIsCA, new Argument[0]);
        genCertParser.addDependentArgumentSet(genCertOutputFormat, genCertOutputFile, new Argument[0]);
        LinkedHashMap<String[], String> genCertExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(4));
        genCertExamples.put(new String[]{"generate-self-signed-certificate", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--alias", "server-cert", "--subject-dn", "CN=ldap.example.com,O=Example Corp,C=US"}, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_EXAMPLE_1.get());
        genCertExamples.put(new String[]{"generate-self-signed-certificate", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--alias", "server-cert", "--use-existing-key-pair", "--inherit-extensions"}, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_EXAMPLE_2.get());
        genCertExamples.put(new String[]{"generate-self-signed-certificate", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--alias", "server-cert", "--subject-dn", "CN=ldap.example.com,O=Example Corp,C=US", "--days-valid", "3650", "--validity-start-time", "20170101000000", "--key-algorithm", "RSA", "--key-size-bits", "4096", "--signature-algorithm", "SHA256withRSA", "--subject-alternative-name-dns", "ldap1.example.com", "--subject-alternative-name-dns", "ldap2.example.com", "--subject-alternative-name-ip-address", "1.2.3.4", "--subject-alternative-name-ip-address", "1.2.3.5", "--extended-key-usage", "server-auth", "--extended-key-usage", "client-auth", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_EXAMPLE_3.get());
        genCertExamples.put(new String[]{"generate-self-signed-certificate", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--alias", "ca-cert", "--subject-dn", "CN=Example Certification Authority,O=Example Corp,C=US", "--days-valid", "7300", "--validity-start-time", "20170101000000", "--key-algorithm", "EC", "--key-size-bits", "256", "--signature-algorithm", "SHA256withECDSA", "--basic-constraints-is-ca", "true", "--key-usage", "key-cert-sign", "--key-usage", "crl-sign", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_EXAMPLE_4.get());
        SubCommand genCertSubCommand = new SubCommand("generate-self-signed-certificate", CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_DESC.get(), genCertParser, genCertExamples);
        genCertSubCommand.addName("generateSelfSignedCertificate", true);
        genCertSubCommand.addName("generate-certificate", true);
        genCertSubCommand.addName("generateCertificate", true);
        genCertSubCommand.addName("self-signed-certificate", true);
        genCertSubCommand.addName("selfSignedCertificate", true);
        genCertSubCommand.addName("selfcert", true);
        parser.addSubCommand(genCertSubCommand);
        ArgumentParser genCSRParser = new ArgumentParser("generate-certificate-signing-request", CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_DESC.get());
        Set<String> genCSROutputFormatAllowedValues = StaticUtils.setOf("PEM", "text", "txt", "RFC", "DER", "binary", "bin");
        StringArgument genCSROutputFormat = new StringArgument(null, "output-format", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_FORMAT.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_FORMAT_DESC.get(), genCSROutputFormatAllowedValues, "PEM");
        genCSROutputFormat.addLongIdentifier("outputFormat", true);
        genCSRParser.addArgument(genCSROutputFormat);
        FileArgument genCSROutputFile = new FileArgument(null, "output-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_OUTPUT_FILE_DESC.get(), false, true, true, false);
        genCSROutputFile.addLongIdentifier("outputFile", true);
        genCSROutputFile.addLongIdentifier("filename", true);
        genCSROutputFile.addLongIdentifier("file", true);
        genCSRParser.addArgument(genCSROutputFile);
        FileArgument genCSRKeystore = new FileArgument(null, "keystore", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_KS_DESC.get(), false, true, true, false);
        genCSRKeystore.addLongIdentifier("keystore-path", true);
        genCSRKeystore.addLongIdentifier("keystorePath", true);
        genCSRKeystore.addLongIdentifier("keystore-file", true);
        genCSRKeystore.addLongIdentifier("keystoreFile", true);
        genCSRParser.addArgument(genCSRKeystore);
        StringArgument genCSRKeystorePassword = new StringArgument(null, "keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_KS_PW_DESC.get());
        genCSRKeystorePassword.addLongIdentifier("keystorePassword", true);
        genCSRKeystorePassword.addLongIdentifier("keystore-passphrase", true);
        genCSRKeystorePassword.addLongIdentifier("keystorePassphrase", true);
        genCSRKeystorePassword.addLongIdentifier("keystore-pin", true);
        genCSRKeystorePassword.addLongIdentifier("keystorePIN", true);
        genCSRKeystorePassword.addLongIdentifier("storepass", true);
        genCSRKeystorePassword.setSensitive(true);
        genCSRParser.addArgument(genCSRKeystorePassword);
        FileArgument genCSRKeystorePasswordFile = new FileArgument(null, "keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_KS_PW_FILE_DESC.get(), true, true, true, false);
        genCSRKeystorePasswordFile.addLongIdentifier("keystorePasswordFile", true);
        genCSRKeystorePasswordFile.addLongIdentifier("keystore-passphrase-file", true);
        genCSRKeystorePasswordFile.addLongIdentifier("keystorePassphraseFile", true);
        genCSRKeystorePasswordFile.addLongIdentifier("keystore-pin-file", true);
        genCSRKeystorePasswordFile.addLongIdentifier("keystorePINFile", true);
        genCSRParser.addArgument(genCSRKeystorePasswordFile);
        BooleanArgument genCSRPromptForKeystorePassword = new BooleanArgument(null, "prompt-for-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_PROMPT_FOR_KS_PW_DESC.get());
        genCSRPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassword", true);
        genCSRPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-passphrase", true);
        genCSRPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassphrase", true);
        genCSRPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-pin", true);
        genCSRPromptForKeystorePassword.addLongIdentifier("promptForKeystorePIN", true);
        genCSRParser.addArgument(genCSRPromptForKeystorePassword);
        StringArgument genCSRPKPassword = new StringArgument(null, "private-key-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_PK_PW_DESC.get());
        genCSRPKPassword.addLongIdentifier("privateKeyPassword", true);
        genCSRPKPassword.addLongIdentifier("private-key-passphrase", true);
        genCSRPKPassword.addLongIdentifier("privateKeyPassphrase", true);
        genCSRPKPassword.addLongIdentifier("private-key-pin", true);
        genCSRPKPassword.addLongIdentifier("privateKeyPIN", true);
        genCSRPKPassword.addLongIdentifier("key-password", true);
        genCSRPKPassword.addLongIdentifier("keyPassword", true);
        genCSRPKPassword.addLongIdentifier("key-passphrase", true);
        genCSRPKPassword.addLongIdentifier("keyPassphrase", true);
        genCSRPKPassword.addLongIdentifier("key-pin", true);
        genCSRPKPassword.addLongIdentifier("keyPIN", true);
        genCSRPKPassword.addLongIdentifier("keypass", true);
        genCSRPKPassword.setSensitive(true);
        genCSRParser.addArgument(genCSRPKPassword);
        FileArgument genCSRPKPasswordFile = new FileArgument(null, "private-key-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_PK_PW_FILE_DESC.get(), true, true, true, false);
        genCSRPKPasswordFile.addLongIdentifier("privateKeyPasswordFile", true);
        genCSRPKPasswordFile.addLongIdentifier("private-key-passphrase-file", true);
        genCSRPKPasswordFile.addLongIdentifier("privateKeyPassphraseFile", true);
        genCSRPKPasswordFile.addLongIdentifier("private-key-pin-file", true);
        genCSRPKPasswordFile.addLongIdentifier("privateKeyPINFile", true);
        genCSRPKPasswordFile.addLongIdentifier("key-password-file", true);
        genCSRPKPasswordFile.addLongIdentifier("keyPasswordFile", true);
        genCSRPKPasswordFile.addLongIdentifier("key-passphrase-file", true);
        genCSRPKPasswordFile.addLongIdentifier("keyPassphraseFile", true);
        genCSRPKPasswordFile.addLongIdentifier("key-pin-file", true);
        genCSRPKPasswordFile.addLongIdentifier("keyPINFile", true);
        genCSRParser.addArgument(genCSRPKPasswordFile);
        BooleanArgument genCSRPromptForPKPassword = new BooleanArgument(null, "prompt-for-private-key-password", CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_PROMPT_FOR_PK_PW_DESC.get());
        genCSRPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPassword", true);
        genCSRPromptForPKPassword.addLongIdentifier("prompt-for-private-key-passphrase", true);
        genCSRPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPassphrase", true);
        genCSRPromptForPKPassword.addLongIdentifier("prompt-for-private-key-pin", true);
        genCSRPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPIN", true);
        genCSRPromptForPKPassword.addLongIdentifier("prompt-for-key-password", true);
        genCSRPromptForPKPassword.addLongIdentifier("promptForKeyPassword", true);
        genCSRPromptForPKPassword.addLongIdentifier("prompt-for-key-passphrase", true);
        genCSRPromptForPKPassword.addLongIdentifier("promptForKeyPassphrase", true);
        genCSRPromptForPKPassword.addLongIdentifier("prompt-for-key-pin", true);
        genCSRPromptForPKPassword.addLongIdentifier("promptForKeyPIN", true);
        genCSRParser.addArgument(genCSRPromptForPKPassword);
        StringArgument genCSRKeystoreType = new StringArgument(null, "keystore-type", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TYPE.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_KS_TYPE_DESC.get(), ALLOWED_KEYSTORE_TYPE_VALUES);
        genCSRKeystoreType.addLongIdentifier("key-store-type", true);
        genCSRKeystoreType.addLongIdentifier("keystoreType", true);
        genCSRKeystoreType.addLongIdentifier("keystore-format", true);
        genCSRKeystoreType.addLongIdentifier("key-store-format", true);
        genCSRKeystoreType.addLongIdentifier("keystoreFormat", true);
        genCSRKeystoreType.addLongIdentifier("storetype", true);
        genCSRParser.addArgument(genCSRKeystoreType);
        StringArgument genCSRAlias = new StringArgument(null, "alias", true, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_ALIAS.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_ALIAS_DESC.get());
        genCSRAlias.addLongIdentifier("nickname", true);
        genCSRParser.addArgument(genCSRAlias);
        BooleanArgument genCSRUseExistingKeyPair = new BooleanArgument(null, "use-existing-key-pair", 1, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_USE_EXISTING_KP_DESC.get());
        genCSRUseExistingKeyPair.addLongIdentifier("use-existing-keypair", true);
        genCSRUseExistingKeyPair.addLongIdentifier("useExistingKeyPair", true);
        genCSRUseExistingKeyPair.addLongIdentifier("replace-existing-certificate", true);
        genCSRUseExistingKeyPair.addLongIdentifier("replaceExistingCertificate", true);
        genCSRUseExistingKeyPair.addLongIdentifier("replace-certificate", true);
        genCSRUseExistingKeyPair.addLongIdentifier("replaceCertificate", true);
        genCSRUseExistingKeyPair.addLongIdentifier("replace-existing", true);
        genCSRUseExistingKeyPair.addLongIdentifier("replaceExisting", true);
        genCSRUseExistingKeyPair.addLongIdentifier("replace", true);
        genCSRParser.addArgument(genCSRUseExistingKeyPair);
        DNArgument genCSRSubjectDN = new DNArgument(null, "subject-dn", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_SUBJECT_DN_DESC.get());
        genCSRSubjectDN.addLongIdentifier("subjectDN", true);
        genCSRSubjectDN.addLongIdentifier("subject", true);
        genCSRSubjectDN.addLongIdentifier("dname", true);
        genCSRParser.addArgument(genCSRSubjectDN);
        StringArgument genCSRKeyAlgorithm = new StringArgument(null, "key-algorithm", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_KEY_ALGORITHM_DESC.get());
        genCSRKeyAlgorithm.addLongIdentifier("keyAlgorithm", true);
        genCSRKeyAlgorithm.addLongIdentifier("key-alg", true);
        genCSRKeyAlgorithm.addLongIdentifier("keyAlg", true);
        genCSRParser.addArgument(genCSRKeyAlgorithm);
        IntegerArgument genCSRKeySizeBits = new IntegerArgument(null, "key-size-bits", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_BITS.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_KEY_SIZE_BITS_DESC.get(), 1, Integer.MAX_VALUE);
        genCSRKeySizeBits.addLongIdentifier("keySizeBits", true);
        genCSRKeySizeBits.addLongIdentifier("key-length-bits", true);
        genCSRKeySizeBits.addLongIdentifier("keyLengthBits", true);
        genCSRKeySizeBits.addLongIdentifier("key-size", true);
        genCSRKeySizeBits.addLongIdentifier("keySize", true);
        genCSRKeySizeBits.addLongIdentifier("key-length", true);
        genCSRKeySizeBits.addLongIdentifier("keyLength", true);
        genCSRParser.addArgument(genCSRKeySizeBits);
        StringArgument genCSRSignatureAlgorithm = new StringArgument(null, "signature-algorithm", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_SIG_ALG_DESC.get());
        genCSRSignatureAlgorithm.addLongIdentifier("signatureAlgorithm", true);
        genCSRSignatureAlgorithm.addLongIdentifier("signature-alg", true);
        genCSRSignatureAlgorithm.addLongIdentifier("signatureAlg", true);
        genCSRSignatureAlgorithm.addLongIdentifier("sig-alg", true);
        genCSRSignatureAlgorithm.addLongIdentifier("sigAlg", true);
        genCSRParser.addArgument(genCSRSignatureAlgorithm);
        BooleanArgument genCSRInheritExtensions = new BooleanArgument(null, "inherit-extensions", 1, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_INHERIT_EXT_DESC.get());
        genCSRInheritExtensions.addLongIdentifier("inheritExtensions", true);
        genCSRParser.addArgument(genCSRInheritExtensions);
        StringArgument genCSRSubjectAltDNS = new StringArgument(null, "subject-alternative-name-dns", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_SAN_DNS_DESC.get());
        genCSRSubjectAltDNS.addLongIdentifier("subjectAlternativeNameDNS", true);
        genCSRSubjectAltDNS.addLongIdentifier("subject-alt-name-dns", true);
        genCSRSubjectAltDNS.addLongIdentifier("subjectAltNameDNS", true);
        genCSRSubjectAltDNS.addLongIdentifier("subject-alternative-dns", true);
        genCSRSubjectAltDNS.addLongIdentifier("subjectAlternativeDNS", true);
        genCSRSubjectAltDNS.addLongIdentifier("subject-alt-dns", true);
        genCSRSubjectAltDNS.addLongIdentifier("subjectAltDNS", true);
        genCSRSubjectAltDNS.addLongIdentifier("san-dns", true);
        genCSRSubjectAltDNS.addLongIdentifier("sanDNS", true);
        genCSRSubjectAltDNS.addValueValidator(new IA5StringArgumentValueValidator(false));
        genCSRParser.addArgument(genCSRSubjectAltDNS);
        StringArgument genCSRSubjectAltIP = new StringArgument(null, "subject-alternative-name-ip-address", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_SAN_IP_DESC.get());
        genCSRSubjectAltIP.addLongIdentifier("subjectAlternativeNameIPAddress", true);
        genCSRSubjectAltIP.addLongIdentifier("subject-alternative-name-ip", true);
        genCSRSubjectAltIP.addLongIdentifier("subjectAlternativeNameIP", true);
        genCSRSubjectAltIP.addLongIdentifier("subject-alt-name-ip-address", true);
        genCSRSubjectAltIP.addLongIdentifier("subjectAltNameIPAddress", true);
        genCSRSubjectAltIP.addLongIdentifier("subject-alt-name-ip", true);
        genCSRSubjectAltIP.addLongIdentifier("subjectAltNameIP", true);
        genCSRSubjectAltIP.addLongIdentifier("subject-alternative-ip-address", true);
        genCSRSubjectAltIP.addLongIdentifier("subjectAlternativeIPAddress", true);
        genCSRSubjectAltIP.addLongIdentifier("subject-alternative-ip", true);
        genCSRSubjectAltIP.addLongIdentifier("subjectAlternativeIP", true);
        genCSRSubjectAltIP.addLongIdentifier("subject-alt-ip-address", true);
        genCSRSubjectAltIP.addLongIdentifier("subjectAltIPAddress", true);
        genCSRSubjectAltIP.addLongIdentifier("subject-alt-ip", true);
        genCSRSubjectAltIP.addLongIdentifier("subjectAltIP", true);
        genCSRSubjectAltIP.addLongIdentifier("san-ip-address", true);
        genCSRSubjectAltIP.addLongIdentifier("sanIPAddress", true);
        genCSRSubjectAltIP.addLongIdentifier("san-ip", true);
        genCSRSubjectAltIP.addLongIdentifier("sanIP", true);
        genCSRSubjectAltIP.addValueValidator(new IPAddressArgumentValueValidator(true, true));
        genCSRParser.addArgument(genCSRSubjectAltIP);
        StringArgument genCSRSubjectAltEmail = new StringArgument(null, "subject-alternative-name-email-address", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_SAN_EMAIL_DESC.get());
        genCSRSubjectAltEmail.addLongIdentifier("subjectAlternativeNameEmailAddress", true);
        genCSRSubjectAltEmail.addLongIdentifier("subject-alternative-name-email", true);
        genCSRSubjectAltEmail.addLongIdentifier("subjectAlternativeNameEmail", true);
        genCSRSubjectAltEmail.addLongIdentifier("subject-alt-name-email-address", true);
        genCSRSubjectAltEmail.addLongIdentifier("subjectAltNameEmailAddress", true);
        genCSRSubjectAltEmail.addLongIdentifier("subject-alt-name-email", true);
        genCSRSubjectAltEmail.addLongIdentifier("subjectAltNameEmail", true);
        genCSRSubjectAltEmail.addLongIdentifier("subject-alternative-email-address", true);
        genCSRSubjectAltEmail.addLongIdentifier("subjectAlternativeEmailAddress", true);
        genCSRSubjectAltEmail.addLongIdentifier("subject-alternative-email", true);
        genCSRSubjectAltEmail.addLongIdentifier("subjectAlternativeEmail", true);
        genCSRSubjectAltEmail.addLongIdentifier("subject-alt-email-address", true);
        genCSRSubjectAltEmail.addLongIdentifier("subjectAltEmailAddress", true);
        genCSRSubjectAltEmail.addLongIdentifier("subject-alt-email", true);
        genCSRSubjectAltEmail.addLongIdentifier("subjectAltEmail", true);
        genCSRSubjectAltEmail.addLongIdentifier("san-email-address", true);
        genCSRSubjectAltEmail.addLongIdentifier("sanEmailAddress", true);
        genCSRSubjectAltEmail.addLongIdentifier("san-email", true);
        genCSRSubjectAltEmail.addLongIdentifier("sanEmail", true);
        genCSRSubjectAltEmail.addValueValidator(new IA5StringArgumentValueValidator(false));
        genCSRParser.addArgument(genCSRSubjectAltEmail);
        StringArgument genCSRSubjectAltURI = new StringArgument(null, "subject-alternative-name-uri", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_URI.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_SAN_URI_DESC.get());
        genCSRSubjectAltURI.addLongIdentifier("subjectAlternativeNameURI", true);
        genCSRSubjectAltURI.addLongIdentifier("subject-alt-name-uri", true);
        genCSRSubjectAltURI.addLongIdentifier("subjectAltNameURI", true);
        genCSRSubjectAltURI.addLongIdentifier("subject-alternative-uri", true);
        genCSRSubjectAltURI.addLongIdentifier("subjectAlternativeURI", true);
        genCSRSubjectAltURI.addLongIdentifier("subject-alt-uri", true);
        genCSRSubjectAltURI.addLongIdentifier("subjectAltURI", true);
        genCSRSubjectAltURI.addLongIdentifier("san-uri", true);
        genCSRSubjectAltURI.addLongIdentifier("sanURI", true);
        genCSRParser.addArgument(genCSRSubjectAltURI);
        StringArgument genCSRSubjectAltOID = new StringArgument(null, "subject-alternative-name-oid", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_OID.get(), CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_SAN_OID_DESC.get());
        genCSRSubjectAltOID.addLongIdentifier("subjectAlternativeNameOID", true);
        genCSRSubjectAltOID.addLongIdentifier("subject-alt-name-oid", true);
        genCSRSubjectAltOID.addLongIdentifier("subjectAltNameOID", true);
        genCSRSubjectAltOID.addLongIdentifier("subject-alternative-oid", true);
        genCSRSubjectAltOID.addLongIdentifier("subjectAlternativeOID", true);
        genCSRSubjectAltOID.addLongIdentifier("subject-alt-oid", true);
        genCSRSubjectAltOID.addLongIdentifier("subjectAltOID", true);
        genCSRSubjectAltOID.addLongIdentifier("san-oid", true);
        genCSRSubjectAltOID.addLongIdentifier("sanOID", true);
        genCSRSubjectAltOID.addValueValidator(new OIDArgumentValueValidator(true));
        genCSRParser.addArgument(genCSRSubjectAltOID);
        BooleanValueArgument genCSRBasicConstraintsIsCA = new BooleanValueArgument(null, "basic-constraints-is-ca", false, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_BC_IS_CA_DESC.get());
        genCSRBasicConstraintsIsCA.addLongIdentifier("basicConstraintsIsCA", true);
        genCSRBasicConstraintsIsCA.addLongIdentifier("bc-is-ca", true);
        genCSRBasicConstraintsIsCA.addLongIdentifier("bcIsCA", true);
        genCSRParser.addArgument(genCSRBasicConstraintsIsCA);
        IntegerArgument genCSRBasicConstraintsPathLength = new IntegerArgument(null, "basic-constraints-maximum-path-length", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_BC_PATH_LENGTH_DESC.get(), 0, Integer.MAX_VALUE);
        genCSRBasicConstraintsPathLength.addLongIdentifier("basicConstraintsMaximumPathLength", true);
        genCSRBasicConstraintsPathLength.addLongIdentifier("basic-constraints-max-path-length", true);
        genCSRBasicConstraintsPathLength.addLongIdentifier("basicConstraintsMaxPathLength", true);
        genCSRBasicConstraintsPathLength.addLongIdentifier("basic-constraints-path-length", true);
        genCSRBasicConstraintsPathLength.addLongIdentifier("basicConstraintsPathLength", true);
        genCSRBasicConstraintsPathLength.addLongIdentifier("bc-maximum-path-length", true);
        genCSRBasicConstraintsPathLength.addLongIdentifier("bcMaximumPathLength", true);
        genCSRBasicConstraintsPathLength.addLongIdentifier("bc-max-path-length", true);
        genCSRBasicConstraintsPathLength.addLongIdentifier("bcMaxPathLength", true);
        genCSRBasicConstraintsPathLength.addLongIdentifier("bc-path-length", true);
        genCSRBasicConstraintsPathLength.addLongIdentifier("bcPathLength", true);
        genCSRParser.addArgument(genCSRBasicConstraintsPathLength);
        StringArgument genCSRKeyUsage = new StringArgument(null, "key-usage", false, 0, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_KU_DESC.get());
        genCSRKeyUsage.addLongIdentifier("keyUsage", true);
        genCSRParser.addArgument(genCSRKeyUsage);
        StringArgument genCSRExtendedKeyUsage = new StringArgument(null, "extended-key-usage", false, 0, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_EKU_DESC.get());
        genCSRExtendedKeyUsage.addLongIdentifier("extendedKeyUsage", true);
        genCSRParser.addArgument(genCSRExtendedKeyUsage);
        StringArgument genCSRExtension = new StringArgument(null, "extension", false, 0, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_EXT_DESC.get());
        genCSRExtension.addLongIdentifier("ext", true);
        genCSRParser.addArgument(genCSRExtension);
        BooleanArgument genCSRDisplayCommand = new BooleanArgument(null, "display-keytool-command", 1, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_ARG_DISPLAY_COMMAND_DESC.get());
        genCSRDisplayCommand.addLongIdentifier("displayKeytoolCommand", true);
        genCSRDisplayCommand.addLongIdentifier("show-keytool-command", true);
        genCSRDisplayCommand.addLongIdentifier("showKeytoolCommand", true);
        genCSRParser.addArgument(genCSRDisplayCommand);
        genCSRParser.addRequiredArgumentSet(genCSRKeystorePassword, genCSRKeystorePasswordFile, genCSRPromptForKeystorePassword);
        genCSRParser.addExclusiveArgumentSet(genCSRKeystorePassword, genCSRKeystorePasswordFile, genCSRPromptForKeystorePassword);
        genCSRParser.addExclusiveArgumentSet(genCSRPKPassword, genCSRPKPasswordFile, genCSRPromptForPKPassword);
        genCSRParser.addExclusiveArgumentSet(genCSRUseExistingKeyPair, genCSRKeyAlgorithm, new Argument[0]);
        genCSRParser.addExclusiveArgumentSet(genCSRUseExistingKeyPair, genCSRKeySizeBits, new Argument[0]);
        genCSRParser.addExclusiveArgumentSet(genCSRUseExistingKeyPair, genCSRSignatureAlgorithm, new Argument[0]);
        genCSRParser.addDependentArgumentSet(genCSRBasicConstraintsPathLength, genCSRBasicConstraintsIsCA, new Argument[0]);
        LinkedHashMap<String[], String> genCSRExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(3));
        genCSRExamples.put(new String[]{"generate-certificate-signing-request", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--alias", "server-cert", "--subject-dn", "CN=ldap.example.com,O=Example Corp,C=US"}, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_EXAMPLE_1.get());
        genCSRExamples.put(new String[]{"generate-certificate-signing-request", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--alias", "server-cert", "--use-existing-key-pair", "--inherit-extensions", "--output-file", "server-cert.csr"}, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_EXAMPLE_2.get());
        genCSRExamples.put(new String[]{"generate-certificate-signing-request", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--alias", "server-cert", "--subject-dn", "CN=ldap.example.com,O=Example Corp,C=US", "--key-algorithm", "EC", "--key-size-bits", "256", "--signature-algorithm", "SHA256withECDSA", "--subject-alternative-name-dns", "ldap1.example.com", "--subject-alternative-name-dns", "ldap2.example.com", "--subject-alternative-name-ip-address", "1.2.3.4", "--subject-alternative-name-ip-address", "1.2.3.5", "--extended-key-usage", "server-auth", "--extended-key-usage", "client-auth", "--output-file", "server-cert.csr", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_EXAMPLE_3.get());
        SubCommand genCSRSubCommand = new SubCommand("generate-certificate-signing-request", CertMessages.INFO_MANAGE_CERTS_SC_GEN_CSR_DESC.get(), genCSRParser, genCSRExamples);
        genCSRSubCommand.addName("generateCertificateSigningRequest", true);
        genCSRSubCommand.addName("generate-certificate-request", true);
        genCSRSubCommand.addName("generateCertificateRequest", true);
        genCSRSubCommand.addName("generate-csr", true);
        genCSRSubCommand.addName("generateCSR", true);
        genCSRSubCommand.addName("certificate-signing-request", true);
        genCSRSubCommand.addName("certificateSigningRequest", true);
        genCSRSubCommand.addName("csr", true);
        genCSRSubCommand.addName("certreq", true);
        parser.addSubCommand(genCSRSubCommand);
        ArgumentParser signCSRParser = new ArgumentParser("sign-certificate-signing-request", CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_DESC.get());
        FileArgument signCSRInputFile = new FileArgument(null, "request-input-file", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_INPUT_FILE_DESC.get(), true, true, true, false);
        signCSRInputFile.addLongIdentifier("requestInputFile", true);
        signCSRInputFile.addLongIdentifier("certificate-signing-request", true);
        signCSRInputFile.addLongIdentifier("certificateSigningRequest", true);
        signCSRInputFile.addLongIdentifier("input-file", false);
        signCSRInputFile.addLongIdentifier("inputFile", true);
        signCSRInputFile.addLongIdentifier("csr", true);
        signCSRParser.addArgument(signCSRInputFile);
        FileArgument signCSROutputFile = new FileArgument(null, "certificate-output-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_OUTPUT_FILE_DESC.get(), false, true, true, false);
        signCSROutputFile.addLongIdentifier("certificateOutputFile", true);
        signCSROutputFile.addLongIdentifier("output-file", false);
        signCSROutputFile.addLongIdentifier("outputFile", true);
        signCSROutputFile.addLongIdentifier("certificate-file", true);
        signCSROutputFile.addLongIdentifier("certificateFile", true);
        signCSRParser.addArgument(signCSROutputFile);
        Set<String> signCSROutputFormatAllowedValues = StaticUtils.setOf("PEM", "text", "txt", "RFC", "DER", "binary", "bin");
        StringArgument signCSROutputFormat = new StringArgument(null, "output-format", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_FORMAT.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_FORMAT_DESC.get(), signCSROutputFormatAllowedValues, "PEM");
        signCSROutputFormat.addLongIdentifier("outputFormat", true);
        signCSRParser.addArgument(signCSROutputFormat);
        FileArgument signCSRKeystore = new FileArgument(null, "keystore", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_KS_DESC.get(), true, true, true, false);
        signCSRKeystore.addLongIdentifier("keystore-path", true);
        signCSRKeystore.addLongIdentifier("keystorePath", true);
        signCSRKeystore.addLongIdentifier("keystore-file", true);
        signCSRKeystore.addLongIdentifier("keystoreFile", true);
        signCSRParser.addArgument(signCSRKeystore);
        StringArgument signCSRKeystorePassword = new StringArgument(null, "keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_KS_PW_DESC.get());
        signCSRKeystorePassword.addLongIdentifier("keystorePassword", true);
        signCSRKeystorePassword.addLongIdentifier("keystore-passphrase", true);
        signCSRKeystorePassword.addLongIdentifier("keystorePassphrase", true);
        signCSRKeystorePassword.addLongIdentifier("keystore-pin", true);
        signCSRKeystorePassword.addLongIdentifier("keystorePIN", true);
        signCSRKeystorePassword.addLongIdentifier("storepass", true);
        signCSRKeystorePassword.setSensitive(true);
        signCSRParser.addArgument(signCSRKeystorePassword);
        FileArgument signCSRKeystorePasswordFile = new FileArgument(null, "keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_KS_PW_FILE_DESC.get(), true, true, true, false);
        signCSRKeystorePasswordFile.addLongIdentifier("keystorePasswordFile", true);
        signCSRKeystorePasswordFile.addLongIdentifier("keystore-passphrase-file", true);
        signCSRKeystorePasswordFile.addLongIdentifier("keystorePassphraseFile", true);
        signCSRKeystorePasswordFile.addLongIdentifier("keystore-pin-file", true);
        signCSRKeystorePasswordFile.addLongIdentifier("keystorePINFile", true);
        signCSRParser.addArgument(signCSRKeystorePasswordFile);
        BooleanArgument signCSRPromptForKeystorePassword = new BooleanArgument(null, "prompt-for-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_PROMPT_FOR_KS_PW_DESC.get());
        signCSRPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassword", true);
        signCSRPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-passphrase", true);
        signCSRPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassphrase", true);
        signCSRPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-pin", true);
        signCSRPromptForKeystorePassword.addLongIdentifier("promptForKeystorePIN", true);
        signCSRParser.addArgument(signCSRPromptForKeystorePassword);
        StringArgument signCSRPKPassword = new StringArgument(null, "private-key-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_PK_PW_DESC.get());
        signCSRPKPassword.addLongIdentifier("privateKeyPassword", true);
        signCSRPKPassword.addLongIdentifier("private-key-passphrase", true);
        signCSRPKPassword.addLongIdentifier("privateKeyPassphrase", true);
        signCSRPKPassword.addLongIdentifier("private-key-pin", true);
        signCSRPKPassword.addLongIdentifier("privateKeyPIN", true);
        signCSRPKPassword.addLongIdentifier("key-password", true);
        signCSRPKPassword.addLongIdentifier("keyPassword", true);
        signCSRPKPassword.addLongIdentifier("key-passphrase", true);
        signCSRPKPassword.addLongIdentifier("keyPassphrase", true);
        signCSRPKPassword.addLongIdentifier("key-pin", true);
        signCSRPKPassword.addLongIdentifier("keyPIN", true);
        signCSRPKPassword.addLongIdentifier("keypass", true);
        signCSRPKPassword.setSensitive(true);
        signCSRParser.addArgument(signCSRPKPassword);
        FileArgument signCSRPKPasswordFile = new FileArgument(null, "private-key-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_PK_PW_FILE_DESC.get(), true, true, true, false);
        signCSRPKPasswordFile.addLongIdentifier("privateKeyPasswordFile", true);
        signCSRPKPasswordFile.addLongIdentifier("private-key-passphrase-file", true);
        signCSRPKPasswordFile.addLongIdentifier("privateKeyPassphraseFile", true);
        signCSRPKPasswordFile.addLongIdentifier("private-key-pin-file", true);
        signCSRPKPasswordFile.addLongIdentifier("privateKeyPINFile", true);
        signCSRPKPasswordFile.addLongIdentifier("key-password-file", true);
        signCSRPKPasswordFile.addLongIdentifier("keyPasswordFile", true);
        signCSRPKPasswordFile.addLongIdentifier("key-passphrase-file", true);
        signCSRPKPasswordFile.addLongIdentifier("keyPassphraseFile", true);
        signCSRPKPasswordFile.addLongIdentifier("key-pin-file", true);
        signCSRPKPasswordFile.addLongIdentifier("keyPINFile", true);
        signCSRParser.addArgument(signCSRPKPasswordFile);
        BooleanArgument signCSRPromptForPKPassword = new BooleanArgument(null, "prompt-for-private-key-password", CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_PROMPT_FOR_PK_PW_DESC.get());
        signCSRPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPassword", true);
        signCSRPromptForPKPassword.addLongIdentifier("prompt-for-private-key-passphrase", true);
        signCSRPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPassphrase", true);
        signCSRPromptForPKPassword.addLongIdentifier("prompt-for-private-key-pin", true);
        signCSRPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPIN", true);
        signCSRPromptForPKPassword.addLongIdentifier("prompt-for-key-password", true);
        signCSRPromptForPKPassword.addLongIdentifier("promptForKeyPassword", true);
        signCSRPromptForPKPassword.addLongIdentifier("prompt-for-key-passphrase", true);
        signCSRPromptForPKPassword.addLongIdentifier("promptForKeyPassphrase", true);
        signCSRPromptForPKPassword.addLongIdentifier("prompt-for-key-pin", true);
        signCSRPromptForPKPassword.addLongIdentifier("promptForKeyPIN", true);
        signCSRParser.addArgument(signCSRPromptForPKPassword);
        StringArgument signCSRKeystoreType = new StringArgument(null, "keystore-type", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TYPE.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_KS_TYPE_DESC.get(), ALLOWED_KEYSTORE_TYPE_VALUES);
        signCSRKeystoreType.addLongIdentifier("key-store-type", true);
        signCSRKeystoreType.addLongIdentifier("keystoreType", true);
        signCSRKeystoreType.addLongIdentifier("keystore-format", true);
        signCSRKeystoreType.addLongIdentifier("key-store-format", true);
        signCSRKeystoreType.addLongIdentifier("keystoreFormat", true);
        signCSRKeystoreType.addLongIdentifier("storetype", true);
        signCSRParser.addArgument(signCSRKeystoreType);
        StringArgument signCSRAlias = new StringArgument(null, "signing-certificate-alias", true, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_ALIAS.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_ALIAS_DESC.get());
        signCSRAlias.addLongIdentifier("signingCertificateAlias", true);
        signCSRAlias.addLongIdentifier("signing-certificate-nickname", true);
        signCSRAlias.addLongIdentifier("signingCertificateNickname", true);
        signCSRAlias.addLongIdentifier("alias", true);
        signCSRAlias.addLongIdentifier("nickname", true);
        signCSRParser.addArgument(signCSRAlias);
        DNArgument signCSRSubjectDN = new DNArgument(null, "subject-dn", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_SUBJECT_DN_DESC.get());
        signCSRSubjectDN.addLongIdentifier("subjectDN", true);
        signCSRSubjectDN.addLongIdentifier("subject", true);
        signCSRSubjectDN.addLongIdentifier("dname", true);
        signCSRParser.addArgument(signCSRSubjectDN);
        IntegerArgument signCSRDaysValid = new IntegerArgument(null, "days-valid", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_DAYS_VALID_DESC.get(), 1, Integer.MAX_VALUE);
        signCSRDaysValid.addLongIdentifier("daysValid", true);
        signCSRDaysValid.addLongIdentifier("validity", true);
        signCSRParser.addArgument(signCSRDaysValid);
        TimestampArgument signCSRNotBefore = new TimestampArgument(null, "validity-start-time", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TIMESTAMP.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_VALIDITY_START_TIME_DESC.get("20180102123456"));
        signCSRNotBefore.addLongIdentifier("validityStartTime", true);
        signCSRNotBefore.addLongIdentifier("not-before", true);
        signCSRNotBefore.addLongIdentifier("notBefore", true);
        signCSRParser.addArgument(signCSRNotBefore);
        StringArgument signCSRSignatureAlgorithm = new StringArgument(null, "signature-algorithm", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_SIG_ALG_DESC.get());
        signCSRSignatureAlgorithm.addLongIdentifier("signatureAlgorithm", true);
        signCSRSignatureAlgorithm.addLongIdentifier("signature-alg", true);
        signCSRSignatureAlgorithm.addLongIdentifier("signatureAlg", true);
        signCSRSignatureAlgorithm.addLongIdentifier("sig-alg", true);
        signCSRSignatureAlgorithm.addLongIdentifier("sigAlg", true);
        signCSRParser.addArgument(signCSRSignatureAlgorithm);
        BooleanArgument signCSRIncludeExtensions = new BooleanArgument(null, "include-requested-extensions", 1, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_INCLUDE_EXT_DESC.get());
        signCSRIncludeExtensions.addLongIdentifier("includeRequestedExtensions", true);
        signCSRParser.addArgument(signCSRIncludeExtensions);
        StringArgument signCSRSubjectAltDNS = new StringArgument(null, "subject-alternative-name-dns", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_SAN_DNS_DESC.get());
        signCSRSubjectAltDNS.addLongIdentifier("subjectAlternativeNameDNS", true);
        signCSRSubjectAltDNS.addLongIdentifier("subject-alt-name-dns", true);
        signCSRSubjectAltDNS.addLongIdentifier("subjectAltNameDNS", true);
        signCSRSubjectAltDNS.addLongIdentifier("subject-alternative-dns", true);
        signCSRSubjectAltDNS.addLongIdentifier("subjectAlternativeDNS", true);
        signCSRSubjectAltDNS.addLongIdentifier("subject-alt-dns", true);
        signCSRSubjectAltDNS.addLongIdentifier("subjectAltDNS", true);
        signCSRSubjectAltDNS.addLongIdentifier("san-dns", true);
        signCSRSubjectAltDNS.addLongIdentifier("sanDNS", true);
        signCSRSubjectAltDNS.addValueValidator(new IA5StringArgumentValueValidator(false));
        signCSRParser.addArgument(signCSRSubjectAltDNS);
        StringArgument signCSRSubjectAltIP = new StringArgument(null, "subject-alternative-name-ip-address", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_SAN_IP_DESC.get());
        signCSRSubjectAltIP.addLongIdentifier("subjectAlternativeNameIPAddress", true);
        signCSRSubjectAltIP.addLongIdentifier("subject-alternative-name-ip", true);
        signCSRSubjectAltIP.addLongIdentifier("subjectAlternativeNameIP", true);
        signCSRSubjectAltIP.addLongIdentifier("subject-alt-name-ip-address", true);
        signCSRSubjectAltIP.addLongIdentifier("subjectAltNameIPAddress", true);
        signCSRSubjectAltIP.addLongIdentifier("subject-alt-name-ip", true);
        signCSRSubjectAltIP.addLongIdentifier("subjectAltNameIP", true);
        signCSRSubjectAltIP.addLongIdentifier("subject-alternative-ip-address", true);
        signCSRSubjectAltIP.addLongIdentifier("subjectAlternativeIPAddress", true);
        signCSRSubjectAltIP.addLongIdentifier("subject-alternative-ip", true);
        signCSRSubjectAltIP.addLongIdentifier("subjectAlternativeIP", true);
        signCSRSubjectAltIP.addLongIdentifier("subject-alt-ip-address", true);
        signCSRSubjectAltIP.addLongIdentifier("subjectAltIPAddress", true);
        signCSRSubjectAltIP.addLongIdentifier("subject-alt-ip", true);
        signCSRSubjectAltIP.addLongIdentifier("subjectAltIP", true);
        signCSRSubjectAltIP.addLongIdentifier("san-ip-address", true);
        signCSRSubjectAltIP.addLongIdentifier("sanIPAddress", true);
        signCSRSubjectAltIP.addLongIdentifier("san-ip", true);
        signCSRSubjectAltIP.addLongIdentifier("sanIP", true);
        signCSRSubjectAltIP.addValueValidator(new IPAddressArgumentValueValidator(true, true));
        signCSRParser.addArgument(signCSRSubjectAltIP);
        StringArgument signCSRSubjectAltEmail = new StringArgument(null, "subject-alternative-name-email-address", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_SAN_EMAIL_DESC.get());
        signCSRSubjectAltEmail.addLongIdentifier("subjectAlternativeNameEmailAddress", true);
        signCSRSubjectAltEmail.addLongIdentifier("subject-alternative-name-email", true);
        signCSRSubjectAltEmail.addLongIdentifier("subjectAlternativeNameEmail", true);
        signCSRSubjectAltEmail.addLongIdentifier("subject-alt-name-email-address", true);
        signCSRSubjectAltEmail.addLongIdentifier("subjectAltNameEmailAddress", true);
        signCSRSubjectAltEmail.addLongIdentifier("subject-alt-name-email", true);
        signCSRSubjectAltEmail.addLongIdentifier("subjectAltNameEmail", true);
        signCSRSubjectAltEmail.addLongIdentifier("subject-alternative-email-address", true);
        signCSRSubjectAltEmail.addLongIdentifier("subjectAlternativeEmailAddress", true);
        signCSRSubjectAltEmail.addLongIdentifier("subject-alternative-email", true);
        signCSRSubjectAltEmail.addLongIdentifier("subjectAlternativeEmail", true);
        signCSRSubjectAltEmail.addLongIdentifier("subject-alt-email-address", true);
        signCSRSubjectAltEmail.addLongIdentifier("subjectAltEmailAddress", true);
        signCSRSubjectAltEmail.addLongIdentifier("subject-alt-email", true);
        signCSRSubjectAltEmail.addLongIdentifier("subjectAltEmail", true);
        signCSRSubjectAltEmail.addLongIdentifier("san-email-address", true);
        signCSRSubjectAltEmail.addLongIdentifier("sanEmailAddress", true);
        signCSRSubjectAltEmail.addLongIdentifier("san-email", true);
        signCSRSubjectAltEmail.addLongIdentifier("sanEmail", true);
        signCSRSubjectAltEmail.addValueValidator(new IA5StringArgumentValueValidator(false));
        signCSRParser.addArgument(signCSRSubjectAltEmail);
        StringArgument signCSRSubjectAltURI = new StringArgument(null, "subject-alternative-name-uri", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_URI.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_SAN_URI_DESC.get());
        signCSRSubjectAltURI.addLongIdentifier("subjectAlternativeNameURI", true);
        signCSRSubjectAltURI.addLongIdentifier("subject-alt-name-uri", true);
        signCSRSubjectAltURI.addLongIdentifier("subjectAltNameURI", true);
        signCSRSubjectAltURI.addLongIdentifier("subject-alternative-uri", true);
        signCSRSubjectAltURI.addLongIdentifier("subjectAlternativeURI", true);
        signCSRSubjectAltURI.addLongIdentifier("subject-alt-uri", true);
        signCSRSubjectAltURI.addLongIdentifier("subjectAltURI", true);
        signCSRSubjectAltURI.addLongIdentifier("san-uri", true);
        signCSRSubjectAltURI.addLongIdentifier("sanURI", true);
        signCSRParser.addArgument(signCSRSubjectAltURI);
        StringArgument signCSRSubjectAltOID = new StringArgument(null, "subject-alternative-name-oid", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_OID.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_SAN_OID_DESC.get());
        signCSRSubjectAltOID.addLongIdentifier("subjectAlternativeNameOID", true);
        signCSRSubjectAltOID.addLongIdentifier("subject-alt-name-oid", true);
        signCSRSubjectAltOID.addLongIdentifier("subjectAltNameOID", true);
        signCSRSubjectAltOID.addLongIdentifier("subject-alternative-oid", true);
        signCSRSubjectAltOID.addLongIdentifier("subjectAlternativeOID", true);
        signCSRSubjectAltOID.addLongIdentifier("subject-alt-oid", true);
        signCSRSubjectAltOID.addLongIdentifier("subjectAltOID", true);
        signCSRSubjectAltOID.addLongIdentifier("san-oid", true);
        signCSRSubjectAltOID.addLongIdentifier("sanOID", true);
        signCSRSubjectAltOID.addValueValidator(new OIDArgumentValueValidator(true));
        signCSRParser.addArgument(signCSRSubjectAltOID);
        StringArgument signCSRIssuerAltDNS = new StringArgument(null, "issuer-alternative-name-dns", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_IAN_DNS_DESC.get());
        signCSRIssuerAltDNS.addLongIdentifier("issuerAlternativeNameDNS", true);
        signCSRIssuerAltDNS.addLongIdentifier("issuer-alt-name-dns", true);
        signCSRIssuerAltDNS.addLongIdentifier("issuerAltNameDNS", true);
        signCSRIssuerAltDNS.addLongIdentifier("issuer-alternative-dns", true);
        signCSRIssuerAltDNS.addLongIdentifier("issuerAlternativeDNS", true);
        signCSRIssuerAltDNS.addLongIdentifier("issuer-alt-dns", true);
        signCSRIssuerAltDNS.addLongIdentifier("issuerAltDNS", true);
        signCSRIssuerAltDNS.addLongIdentifier("ian-dns", true);
        signCSRIssuerAltDNS.addLongIdentifier("ianDNS", true);
        signCSRIssuerAltDNS.addValueValidator(new IA5StringArgumentValueValidator(false));
        signCSRParser.addArgument(signCSRIssuerAltDNS);
        StringArgument signCSRIssuerAltIP = new StringArgument(null, "issuer-alternative-name-ip-address", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_IAN_IP_DESC.get());
        signCSRIssuerAltIP.addLongIdentifier("issuerAlternativeNameIPAddress", true);
        signCSRIssuerAltIP.addLongIdentifier("issuer-alternative-name-ip", true);
        signCSRIssuerAltIP.addLongIdentifier("issuerAlternativeNameIP", true);
        signCSRIssuerAltIP.addLongIdentifier("issuer-alt-name-ip-address", true);
        signCSRIssuerAltIP.addLongIdentifier("issuerAltNameIPAddress", true);
        signCSRIssuerAltIP.addLongIdentifier("issuer-alt-name-ip", true);
        signCSRIssuerAltIP.addLongIdentifier("issuerAltNameIP", true);
        signCSRIssuerAltIP.addLongIdentifier("issuer-alternative-ip-address", true);
        signCSRIssuerAltIP.addLongIdentifier("issuerAlternativeIPAddress", true);
        signCSRIssuerAltIP.addLongIdentifier("issuer-alternative-ip", true);
        signCSRIssuerAltIP.addLongIdentifier("issuerAlternativeIP", true);
        signCSRIssuerAltIP.addLongIdentifier("issuer-alt-ip-address", true);
        signCSRIssuerAltIP.addLongIdentifier("issuerAltIPAddress", true);
        signCSRIssuerAltIP.addLongIdentifier("issuer-alt-ip", true);
        signCSRIssuerAltIP.addLongIdentifier("issuerAltIP", true);
        signCSRIssuerAltIP.addLongIdentifier("ian-ip-address", true);
        signCSRIssuerAltIP.addLongIdentifier("ianIPAddress", true);
        signCSRIssuerAltIP.addLongIdentifier("ian-ip", true);
        signCSRIssuerAltIP.addLongIdentifier("ianIP", true);
        signCSRIssuerAltIP.addValueValidator(new IPAddressArgumentValueValidator(true, true));
        signCSRParser.addArgument(signCSRIssuerAltIP);
        StringArgument signCSRIssuerAltEmail = new StringArgument(null, "issuer-alternative-name-email-address", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_NAME.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_IAN_EMAIL_DESC.get());
        signCSRIssuerAltEmail.addLongIdentifier("issuerAlternativeNameEmailAddress", true);
        signCSRIssuerAltEmail.addLongIdentifier("issuer-alternative-name-email", true);
        signCSRIssuerAltEmail.addLongIdentifier("issuerAlternativeNameEmail", true);
        signCSRIssuerAltEmail.addLongIdentifier("issuer-alt-name-email-address", true);
        signCSRIssuerAltEmail.addLongIdentifier("issuerAltNameEmailAddress", true);
        signCSRIssuerAltEmail.addLongIdentifier("issuer-alt-name-email", true);
        signCSRIssuerAltEmail.addLongIdentifier("issuerAltNameEmail", true);
        signCSRIssuerAltEmail.addLongIdentifier("issuer-alternative-email-address", true);
        signCSRIssuerAltEmail.addLongIdentifier("issuerAlternativeEmailAddress", true);
        signCSRIssuerAltEmail.addLongIdentifier("issuer-alternative-email", true);
        signCSRIssuerAltEmail.addLongIdentifier("issuerAlternativeEmail", true);
        signCSRIssuerAltEmail.addLongIdentifier("issuer-alt-email-address", true);
        signCSRIssuerAltEmail.addLongIdentifier("issuerAltEmailAddress", true);
        signCSRIssuerAltEmail.addLongIdentifier("issuer-alt-email", true);
        signCSRIssuerAltEmail.addLongIdentifier("issuerAltEmail", true);
        signCSRIssuerAltEmail.addLongIdentifier("ian-email-address", true);
        signCSRIssuerAltEmail.addLongIdentifier("ianEmailAddress", true);
        signCSRIssuerAltEmail.addLongIdentifier("ian-email", true);
        signCSRIssuerAltEmail.addLongIdentifier("ianEmail", true);
        signCSRIssuerAltEmail.addValueValidator(new IA5StringArgumentValueValidator(false));
        signCSRParser.addArgument(signCSRIssuerAltEmail);
        StringArgument signCSRIssuerAltURI = new StringArgument(null, "issuer-alternative-name-uri", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_URI.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_IAN_URI_DESC.get());
        signCSRIssuerAltURI.addLongIdentifier("issuerAlternativeNameURI", true);
        signCSRIssuerAltURI.addLongIdentifier("issuer-alt-name-uri", true);
        signCSRIssuerAltURI.addLongIdentifier("issuerAltNameURI", true);
        signCSRIssuerAltURI.addLongIdentifier("issuer-alternative-uri", true);
        signCSRIssuerAltURI.addLongIdentifier("issuerAlternativeURI", true);
        signCSRIssuerAltURI.addLongIdentifier("issuer-alt-uri", true);
        signCSRIssuerAltURI.addLongIdentifier("issuerAltURI", true);
        signCSRIssuerAltURI.addLongIdentifier("ian-uri", true);
        signCSRIssuerAltURI.addLongIdentifier("ianURI", true);
        signCSRParser.addArgument(signCSRIssuerAltURI);
        StringArgument signCSRIssuerAltOID = new StringArgument(null, "issuer-alternative-name-oid", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_OID.get(), CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_IAN_OID_DESC.get());
        signCSRIssuerAltOID.addLongIdentifier("issuerAlternativeNameOID", true);
        signCSRIssuerAltOID.addLongIdentifier("issuer-alt-name-oid", true);
        signCSRIssuerAltOID.addLongIdentifier("issuerAltNameOID", true);
        signCSRIssuerAltOID.addLongIdentifier("issuer-alternative-oid", true);
        signCSRIssuerAltOID.addLongIdentifier("issuerAlternativeOID", true);
        signCSRIssuerAltOID.addLongIdentifier("issuer-alt-oid", true);
        signCSRIssuerAltOID.addLongIdentifier("issuerAltOID", true);
        signCSRIssuerAltOID.addLongIdentifier("ian-oid", true);
        signCSRIssuerAltOID.addLongIdentifier("ianOID", true);
        signCSRIssuerAltOID.addValueValidator(new OIDArgumentValueValidator(true));
        signCSRParser.addArgument(signCSRIssuerAltOID);
        BooleanValueArgument signCSRBasicConstraintsIsCA = new BooleanValueArgument(null, "basic-constraints-is-ca", false, null, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_BC_IS_CA_DESC.get());
        signCSRBasicConstraintsIsCA.addLongIdentifier("basicConstraintsIsCA", true);
        signCSRBasicConstraintsIsCA.addLongIdentifier("bc-is-ca", true);
        signCSRBasicConstraintsIsCA.addLongIdentifier("bcIsCA", true);
        signCSRParser.addArgument(signCSRBasicConstraintsIsCA);
        IntegerArgument signCSRBasicConstraintsPathLength = new IntegerArgument(null, "basic-constraints-maximum-path-length", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_GEN_CERT_ARG_BC_PATH_LENGTH_DESC.get(), 0, Integer.MAX_VALUE);
        signCSRBasicConstraintsPathLength.addLongIdentifier("basicConstraintsMaximumPathLength", true);
        signCSRBasicConstraintsPathLength.addLongIdentifier("basic-constraints-max-path-length", true);
        signCSRBasicConstraintsPathLength.addLongIdentifier("basicConstraintsMaxPathLength", true);
        signCSRBasicConstraintsPathLength.addLongIdentifier("basic-constraints-path-length", true);
        signCSRBasicConstraintsPathLength.addLongIdentifier("basicConstraintsPathLength", true);
        signCSRBasicConstraintsPathLength.addLongIdentifier("bc-maximum-path-length", true);
        signCSRBasicConstraintsPathLength.addLongIdentifier("bcMaximumPathLength", true);
        signCSRBasicConstraintsPathLength.addLongIdentifier("bc-max-path-length", true);
        signCSRBasicConstraintsPathLength.addLongIdentifier("bcMaxPathLength", true);
        signCSRBasicConstraintsPathLength.addLongIdentifier("bc-path-length", true);
        signCSRBasicConstraintsPathLength.addLongIdentifier("bcPathLength", true);
        signCSRParser.addArgument(signCSRBasicConstraintsPathLength);
        StringArgument signCSRKeyUsage = new StringArgument(null, "key-usage", false, 0, null, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_KU_DESC.get());
        signCSRKeyUsage.addLongIdentifier("keyUsage", true);
        signCSRParser.addArgument(signCSRKeyUsage);
        StringArgument signCSRExtendedKeyUsage = new StringArgument(null, "extended-key-usage", false, 0, null, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_EKU_DESC.get());
        signCSRExtendedKeyUsage.addLongIdentifier("extendedKeyUsage", true);
        signCSRParser.addArgument(signCSRExtendedKeyUsage);
        StringArgument signCSRExtension = new StringArgument(null, "extension", false, 0, null, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_EXT_DESC.get());
        signCSRExtension.addLongIdentifier("ext", true);
        signCSRParser.addArgument(signCSRExtension);
        BooleanArgument signCSRNoPrompt = new BooleanArgument(null, "no-prompt", 1, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_NO_PROMPT_DESC.get());
        signCSRNoPrompt.addLongIdentifier("noPrompt", true);
        signCSRParser.addArgument(signCSRNoPrompt);
        BooleanArgument signCSRDisplayCommand = new BooleanArgument(null, "display-keytool-command", 1, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_ARG_DISPLAY_COMMAND_DESC.get());
        signCSRDisplayCommand.addLongIdentifier("displayKeytoolCommand", true);
        signCSRDisplayCommand.addLongIdentifier("show-keytool-command", true);
        signCSRDisplayCommand.addLongIdentifier("showKeytoolCommand", true);
        signCSRParser.addArgument(signCSRDisplayCommand);
        signCSRParser.addRequiredArgumentSet(signCSRKeystorePassword, signCSRKeystorePasswordFile, signCSRPromptForKeystorePassword);
        signCSRParser.addExclusiveArgumentSet(signCSRKeystorePassword, signCSRKeystorePasswordFile, signCSRPromptForKeystorePassword);
        signCSRParser.addExclusiveArgumentSet(signCSRPKPassword, signCSRPKPasswordFile, signCSRPromptForPKPassword);
        signCSRParser.addDependentArgumentSet(signCSRBasicConstraintsPathLength, signCSRBasicConstraintsIsCA, new Argument[0]);
        LinkedHashMap<String[], String> signCSRExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(2));
        signCSRExamples.put(new String[]{"sign-certificate-signing-request", "--request-input-file", "server-cert.csr", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--signing-certificate-alias", "ca-cert", "--include-requested-extensions"}, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_EXAMPLE_1.get(ManageCertificates.getPlatformSpecificPath("config", "keystore")));
        signCSRExamples.put(new String[]{"sign-certificate-signing-request", "--request-input-file", "server-cert.csr", "--certificate-output-file", "server-cert.der", "--output-format", "DER", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--signing-certificate-alias", "ca-cert", "--days-valid", "730", "--validity-start-time", "20170101000000", "--include-requested-extensions", "--issuer-alternative-name-email-address", "ca@example.com"}, CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_EXAMPLE_2.get(ManageCertificates.getPlatformSpecificPath("config", "keystore")));
        SubCommand signCSRSubCommand = new SubCommand("sign-certificate-signing-request", CertMessages.INFO_MANAGE_CERTS_SC_SIGN_CSR_DESC.get(), signCSRParser, signCSRExamples);
        signCSRSubCommand.addName("signCertificateSigningRequest", true);
        signCSRSubCommand.addName("sign-certificate-request", true);
        signCSRSubCommand.addName("signCertificateRequest", true);
        signCSRSubCommand.addName("sign-certificate", true);
        signCSRSubCommand.addName("signCertificate", true);
        signCSRSubCommand.addName("sign-csr", true);
        signCSRSubCommand.addName("signCSR", true);
        signCSRSubCommand.addName("sign", true);
        signCSRSubCommand.addName("gencert", true);
        parser.addSubCommand(signCSRSubCommand);
        ArgumentParser changeAliasParser = new ArgumentParser("change-certificate-alias", CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_ALIAS_DESC.get());
        FileArgument changeAliasKeystore = new FileArgument(null, "keystore", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_ALIAS_ARG_KS_DESC.get(), true, true, true, false);
        changeAliasKeystore.addLongIdentifier("keystore-path", true);
        changeAliasKeystore.addLongIdentifier("keystorePath", true);
        changeAliasKeystore.addLongIdentifier("keystore-file", true);
        changeAliasKeystore.addLongIdentifier("keystoreFile", true);
        changeAliasParser.addArgument(changeAliasKeystore);
        StringArgument changeAliasKeystorePassword = new StringArgument(null, "keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_ALIAS_ARG_KS_PW_DESC.get());
        changeAliasKeystorePassword.addLongIdentifier("keystorePassword", true);
        changeAliasKeystorePassword.addLongIdentifier("keystore-passphrase", true);
        changeAliasKeystorePassword.addLongIdentifier("keystorePassphrase", true);
        changeAliasKeystorePassword.addLongIdentifier("keystore-pin", true);
        changeAliasKeystorePassword.addLongIdentifier("keystorePIN", true);
        changeAliasKeystorePassword.addLongIdentifier("storepass", true);
        changeAliasKeystorePassword.setSensitive(true);
        changeAliasParser.addArgument(changeAliasKeystorePassword);
        FileArgument changeAliasKeystorePasswordFile = new FileArgument(null, "keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_ALIAS_ARG_KS_PW_FILE_DESC.get(), true, true, true, false);
        changeAliasKeystorePasswordFile.addLongIdentifier("keystorePasswordFile", true);
        changeAliasKeystorePasswordFile.addLongIdentifier("keystore-passphrase-file", true);
        changeAliasKeystorePasswordFile.addLongIdentifier("keystorePassphraseFile", true);
        changeAliasKeystorePasswordFile.addLongIdentifier("keystore-pin-file", true);
        changeAliasKeystorePasswordFile.addLongIdentifier("keystorePINFile", true);
        changeAliasParser.addArgument(changeAliasKeystorePasswordFile);
        BooleanArgument changeAliasPromptForKeystorePassword = new BooleanArgument(null, "prompt-for-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_ALIAS_ARG_PROMPT_FOR_KS_PW_DESC.get());
        changeAliasPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassword", true);
        changeAliasPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-passphrase", true);
        changeAliasPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassphrase", true);
        changeAliasPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-pin", true);
        changeAliasPromptForKeystorePassword.addLongIdentifier("promptForKeystorePIN", true);
        changeAliasParser.addArgument(changeAliasPromptForKeystorePassword);
        StringArgument changeAliasPKPassword = new StringArgument(null, "private-key-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_ALIAS_ARG_PK_PW_DESC.get());
        changeAliasPKPassword.addLongIdentifier("privateKeyPassword", true);
        changeAliasPKPassword.addLongIdentifier("private-key-passphrase", true);
        changeAliasPKPassword.addLongIdentifier("privateKeyPassphrase", true);
        changeAliasPKPassword.addLongIdentifier("private-key-pin", true);
        changeAliasPKPassword.addLongIdentifier("privateKeyPIN", true);
        changeAliasPKPassword.addLongIdentifier("key-password", true);
        changeAliasPKPassword.addLongIdentifier("keyPassword", true);
        changeAliasPKPassword.addLongIdentifier("key-passphrase", true);
        changeAliasPKPassword.addLongIdentifier("keyPassphrase", true);
        changeAliasPKPassword.addLongIdentifier("key-pin", true);
        changeAliasPKPassword.addLongIdentifier("keyPIN", true);
        changeAliasPKPassword.addLongIdentifier("keypass", true);
        changeAliasPKPassword.setSensitive(true);
        changeAliasParser.addArgument(changeAliasPKPassword);
        FileArgument changeAliasPKPasswordFile = new FileArgument(null, "private-key-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_ALIAS_ARG_PK_PW_FILE_DESC.get(), true, true, true, false);
        changeAliasPKPasswordFile.addLongIdentifier("privateKeyPasswordFile", true);
        changeAliasPKPasswordFile.addLongIdentifier("private-key-passphrase-file", true);
        changeAliasPKPasswordFile.addLongIdentifier("privateKeyPassphraseFile", true);
        changeAliasPKPasswordFile.addLongIdentifier("private-key-pin-file", true);
        changeAliasPKPasswordFile.addLongIdentifier("privateKeyPINFile", true);
        changeAliasPKPasswordFile.addLongIdentifier("key-password-file", true);
        changeAliasPKPasswordFile.addLongIdentifier("keyPasswordFile", true);
        changeAliasPKPasswordFile.addLongIdentifier("key-passphrase-file", true);
        changeAliasPKPasswordFile.addLongIdentifier("keyPassphraseFile", true);
        changeAliasPKPasswordFile.addLongIdentifier("key-pin-file", true);
        changeAliasPKPasswordFile.addLongIdentifier("keyPINFile", true);
        changeAliasParser.addArgument(changeAliasPKPasswordFile);
        BooleanArgument changeAliasPromptForPKPassword = new BooleanArgument(null, "prompt-for-private-key-password", CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_ALIAS_ARG_PROMPT_FOR_PK_PW_DESC.get());
        changeAliasPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPassword", true);
        changeAliasPromptForPKPassword.addLongIdentifier("prompt-for-private-key-passphrase", true);
        changeAliasPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPassphrase", true);
        changeAliasPromptForPKPassword.addLongIdentifier("prompt-for-private-key-pin", true);
        changeAliasPromptForPKPassword.addLongIdentifier("promptForPrivateKeyPIN", true);
        changeAliasPromptForPKPassword.addLongIdentifier("prompt-for-key-password", true);
        changeAliasPromptForPKPassword.addLongIdentifier("promptForKeyPassword", true);
        changeAliasPromptForPKPassword.addLongIdentifier("prompt-for-key-passphrase", true);
        changeAliasPromptForPKPassword.addLongIdentifier("promptForKeyPassphrase", true);
        changeAliasPromptForPKPassword.addLongIdentifier("prompt-for-key-pin", true);
        changeAliasPromptForPKPassword.addLongIdentifier("promptForKeyPIN", true);
        changeAliasParser.addArgument(changeAliasPromptForPKPassword);
        StringArgument changeAliasKeystoreType = new StringArgument(null, "keystore-type", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TYPE.get(), CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_ALIAS_ARG_KS_TYPE_DESC.get(), ALLOWED_KEYSTORE_TYPE_VALUES);
        changeAliasKeystoreType.addLongIdentifier("key-store-type", true);
        changeAliasKeystoreType.addLongIdentifier("keystoreType", true);
        changeAliasKeystoreType.addLongIdentifier("keystore-format", true);
        changeAliasKeystoreType.addLongIdentifier("key-store-format", true);
        changeAliasKeystoreType.addLongIdentifier("keystoreFormat", true);
        changeAliasKeystoreType.addLongIdentifier("storetype", true);
        changeAliasParser.addArgument(changeAliasKeystoreType);
        StringArgument changeAliasCurrentAlias = new StringArgument(null, "current-alias", true, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_ALIAS.get(), CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_ALIAS_ARG_CURRENT_ALIAS_DESC.get());
        changeAliasCurrentAlias.addLongIdentifier("currentAlias", true);
        changeAliasCurrentAlias.addLongIdentifier("old-alias", true);
        changeAliasCurrentAlias.addLongIdentifier("oldAlias", true);
        changeAliasCurrentAlias.addLongIdentifier("source-alias", true);
        changeAliasCurrentAlias.addLongIdentifier("sourceAlias", true);
        changeAliasCurrentAlias.addLongIdentifier("alias", true);
        changeAliasCurrentAlias.addLongIdentifier("current-nickname", true);
        changeAliasCurrentAlias.addLongIdentifier("currentNickname", true);
        changeAliasCurrentAlias.addLongIdentifier("old-nickname", true);
        changeAliasCurrentAlias.addLongIdentifier("oldNickname", true);
        changeAliasCurrentAlias.addLongIdentifier("source-nickname", true);
        changeAliasCurrentAlias.addLongIdentifier("sourceNickname", true);
        changeAliasCurrentAlias.addLongIdentifier("nickname", true);
        changeAliasCurrentAlias.addLongIdentifier("from", false);
        changeAliasParser.addArgument(changeAliasCurrentAlias);
        StringArgument changeAliasNewAlias = new StringArgument(null, "new-alias", true, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_ALIAS.get(), CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_ALIAS_ARG_NEW_ALIAS_DESC.get());
        changeAliasNewAlias.addLongIdentifier("newAlias", true);
        changeAliasNewAlias.addLongIdentifier("destination-alias", true);
        changeAliasNewAlias.addLongIdentifier("destinationAlias", true);
        changeAliasNewAlias.addLongIdentifier("new-nickname", true);
        changeAliasNewAlias.addLongIdentifier("newNickname", true);
        changeAliasNewAlias.addLongIdentifier("destination-nickname", true);
        changeAliasNewAlias.addLongIdentifier("destinationNickname", true);
        changeAliasNewAlias.addLongIdentifier("to", false);
        changeAliasParser.addArgument(changeAliasNewAlias);
        BooleanArgument changeAliasDisplayCommand = new BooleanArgument(null, "display-keytool-command", 1, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_ALIAS_ARG_DISPLAY_COMMAND_DESC.get());
        changeAliasDisplayCommand.addLongIdentifier("displayKeytoolCommand", true);
        changeAliasDisplayCommand.addLongIdentifier("show-keytool-command", true);
        changeAliasDisplayCommand.addLongIdentifier("showKeytoolCommand", true);
        changeAliasParser.addArgument(changeAliasDisplayCommand);
        changeAliasParser.addRequiredArgumentSet(changeAliasKeystorePassword, changeAliasKeystorePasswordFile, changeAliasPromptForKeystorePassword);
        changeAliasParser.addExclusiveArgumentSet(changeAliasKeystorePassword, changeAliasKeystorePasswordFile, changeAliasPromptForKeystorePassword);
        changeAliasParser.addExclusiveArgumentSet(changeAliasPKPassword, changeAliasPKPasswordFile, changeAliasPromptForPKPassword);
        LinkedHashMap<String[], String> changeAliasExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        changeAliasExamples.put(new String[]{"change-certificate-alias", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--current-alias", "server-cert", "--new-alias", "server-certificate", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_ALIAS_EXAMPLE_1.get());
        SubCommand changeAliasSubCommand = new SubCommand("change-certificate-alias", CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_ALIAS_DESC.get(), changeAliasParser, changeAliasExamples);
        changeAliasSubCommand.addName("changeCertificateAlias", true);
        changeAliasSubCommand.addName("change-alias", true);
        changeAliasSubCommand.addName("changeAlias", true);
        changeAliasSubCommand.addName("rename-certificate", true);
        changeAliasSubCommand.addName("renameCertificate", true);
        changeAliasSubCommand.addName("rename", true);
        parser.addSubCommand(changeAliasSubCommand);
        ArgumentParser changeKSPWParser = new ArgumentParser("change-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_KS_PW_DESC.get());
        FileArgument changeKSPWKeystore = new FileArgument(null, "keystore", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_KS_PW_ARG_KS_DESC.get(), true, true, true, false);
        changeKSPWKeystore.addLongIdentifier("keystore-path", true);
        changeKSPWKeystore.addLongIdentifier("keystorePath", true);
        changeKSPWKeystore.addLongIdentifier("keystore-file", true);
        changeKSPWKeystore.addLongIdentifier("keystoreFile", true);
        changeKSPWParser.addArgument(changeKSPWKeystore);
        StringArgument changeKSPWCurrentPassword = new StringArgument(null, "current-keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_KS_PW_ARG_CURRENT_PW_DESC.get());
        changeKSPWCurrentPassword.addLongIdentifier("currentKeystorePassword", true);
        changeKSPWCurrentPassword.addLongIdentifier("current-keystore-passphrase", true);
        changeKSPWCurrentPassword.addLongIdentifier("currentKeystorePassphrase", true);
        changeKSPWCurrentPassword.addLongIdentifier("current-keystore-pin", true);
        changeKSPWCurrentPassword.addLongIdentifier("currentKeystorePIN", true);
        changeKSPWCurrentPassword.addLongIdentifier("storepass", true);
        changeKSPWCurrentPassword.setSensitive(true);
        changeKSPWParser.addArgument(changeKSPWCurrentPassword);
        FileArgument changeKSPWCurrentPasswordFile = new FileArgument(null, "current-keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_KS_PW_ARG_CURRENT_PW_FILE_DESC.get(), true, true, true, false);
        changeKSPWCurrentPasswordFile.addLongIdentifier("currentKeystorePasswordFile", true);
        changeKSPWCurrentPasswordFile.addLongIdentifier("current-keystore-passphrase-file", true);
        changeKSPWCurrentPasswordFile.addLongIdentifier("currentKeystorePassphraseFile", true);
        changeKSPWCurrentPasswordFile.addLongIdentifier("current-keystore-pin-file", true);
        changeKSPWCurrentPasswordFile.addLongIdentifier("currentKeystorePINFile", true);
        changeKSPWParser.addArgument(changeKSPWCurrentPasswordFile);
        BooleanArgument changeKSPWPromptForCurrentPassword = new BooleanArgument(null, "prompt-for-current-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_KS_PW_ARG_PROMPT_FOR_CURRENT_PW_DESC.get());
        changeKSPWPromptForCurrentPassword.addLongIdentifier("promptForCurrentKeystorePassword", true);
        changeKSPWPromptForCurrentPassword.addLongIdentifier("prompt-for-current-keystore-passphrase", true);
        changeKSPWPromptForCurrentPassword.addLongIdentifier("promptForCurrentKeystorePassphrase", true);
        changeKSPWPromptForCurrentPassword.addLongIdentifier("prompt-for-current-keystore-pin", true);
        changeKSPWPromptForCurrentPassword.addLongIdentifier("promptForCurrentKeystorePIN", true);
        changeKSPWParser.addArgument(changeKSPWPromptForCurrentPassword);
        StringArgument changeKSPWNewPassword = new StringArgument(null, "new-keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_KS_PW_ARG_NEW_PW_DESC.get());
        changeKSPWNewPassword.addLongIdentifier("newKeystorePassword", true);
        changeKSPWNewPassword.addLongIdentifier("new-keystore-passphrase", true);
        changeKSPWNewPassword.addLongIdentifier("newKeystorePassphrase", true);
        changeKSPWNewPassword.addLongIdentifier("new-keystore-pin", true);
        changeKSPWNewPassword.addLongIdentifier("newKeystorePIN", true);
        changeKSPWNewPassword.addLongIdentifier("new", true);
        changeKSPWNewPassword.setSensitive(true);
        changeKSPWParser.addArgument(changeKSPWNewPassword);
        FileArgument changeKSPWNewPasswordFile = new FileArgument(null, "new-keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_KS_PW_ARG_NEW_PW_FILE_DESC.get(), true, true, true, false);
        changeKSPWNewPasswordFile.addLongIdentifier("newKeystorePasswordFile", true);
        changeKSPWNewPasswordFile.addLongIdentifier("new-keystore-passphrase-file", true);
        changeKSPWNewPasswordFile.addLongIdentifier("newKeystorePassphraseFile", true);
        changeKSPWNewPasswordFile.addLongIdentifier("new-keystore-pin-file", true);
        changeKSPWNewPasswordFile.addLongIdentifier("newKeystorePINFile", true);
        changeKSPWParser.addArgument(changeKSPWNewPasswordFile);
        BooleanArgument changeKSPWPromptForNewPassword = new BooleanArgument(null, "prompt-for-new-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_KS_PW_ARG_PROMPT_FOR_NEW_PW_DESC.get());
        changeKSPWPromptForNewPassword.addLongIdentifier("promptForNewKeystorePassword", true);
        changeKSPWPromptForNewPassword.addLongIdentifier("prompt-for-new-keystore-passphrase", true);
        changeKSPWPromptForNewPassword.addLongIdentifier("promptForNewKeystorePassphrase", true);
        changeKSPWPromptForNewPassword.addLongIdentifier("prompt-for-new-keystore-pin", true);
        changeKSPWPromptForNewPassword.addLongIdentifier("promptForNewKeystorePIN", true);
        changeKSPWParser.addArgument(changeKSPWPromptForNewPassword);
        BooleanArgument changeKSPWDisplayCommand = new BooleanArgument(null, "display-keytool-command", 1, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_KS_PW_ARG_DISPLAY_COMMAND_DESC.get());
        changeKSPWDisplayCommand.addLongIdentifier("displayKeytoolCommand", true);
        changeKSPWDisplayCommand.addLongIdentifier("show-keytool-command", true);
        changeKSPWDisplayCommand.addLongIdentifier("showKeytoolCommand", true);
        changeKSPWParser.addArgument(changeKSPWDisplayCommand);
        changeKSPWParser.addRequiredArgumentSet(changeKSPWCurrentPassword, changeKSPWCurrentPasswordFile, changeKSPWPromptForCurrentPassword);
        changeKSPWParser.addExclusiveArgumentSet(changeKSPWCurrentPassword, changeKSPWCurrentPasswordFile, changeKSPWPromptForCurrentPassword);
        changeKSPWParser.addRequiredArgumentSet(changeKSPWNewPassword, changeKSPWNewPasswordFile, changeKSPWPromptForNewPassword);
        changeKSPWParser.addExclusiveArgumentSet(changeKSPWNewPassword, changeKSPWNewPasswordFile, changeKSPWPromptForNewPassword);
        LinkedHashMap<String[], String> changeKSPWExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        changeKSPWExamples.put(new String[]{"change-keystore-password", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--current-keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "current.pin"), "--new-keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "new.pin"), "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_KS_PW_EXAMPLE_1.get(ManageCertificates.getPlatformSpecificPath("config", "keystore"), ManageCertificates.getPlatformSpecificPath("config", "current.pin"), ManageCertificates.getPlatformSpecificPath("config", "new.pin")));
        SubCommand changeKSPWSubCommand = new SubCommand("change-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_KS_PW_DESC.get(), changeKSPWParser, changeKSPWExamples);
        changeKSPWSubCommand.addName("changeKeystorePassword", true);
        changeKSPWSubCommand.addName("change-keystore-passphrase", true);
        changeKSPWSubCommand.addName("changeKeystorePassphrase", true);
        changeKSPWSubCommand.addName("change-keystore-pin", true);
        changeKSPWSubCommand.addName("changeKeystorePIN", true);
        changeKSPWSubCommand.addName("storepasswd", true);
        parser.addSubCommand(changeKSPWSubCommand);
        ArgumentParser changePKPWParser = new ArgumentParser("change-private-key-password", CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_DESC.get());
        FileArgument changePKPWKeystore = new FileArgument(null, "keystore", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_ARG_KS_DESC.get(), true, true, true, false);
        changePKPWKeystore.addLongIdentifier("keystore-path", true);
        changePKPWKeystore.addLongIdentifier("keystorePath", true);
        changePKPWKeystore.addLongIdentifier("keystore-file", true);
        changePKPWKeystore.addLongIdentifier("keystoreFile", true);
        changePKPWParser.addArgument(changePKPWKeystore);
        StringArgument changePKPWKeystorePassword = new StringArgument(null, "keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_ARG_KS_PW_DESC.get());
        changePKPWKeystorePassword.addLongIdentifier("keystorePassword", true);
        changePKPWKeystorePassword.addLongIdentifier("keystore-passphrase", true);
        changePKPWKeystorePassword.addLongIdentifier("keystorePassphrase", true);
        changePKPWKeystorePassword.addLongIdentifier("keystore-pin", true);
        changePKPWKeystorePassword.addLongIdentifier("keystorePIN", true);
        changePKPWKeystorePassword.addLongIdentifier("storepass", true);
        changePKPWKeystorePassword.setSensitive(true);
        changePKPWParser.addArgument(changePKPWKeystorePassword);
        FileArgument changePKPWKeystorePasswordFile = new FileArgument(null, "keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_ARG_KS_PW_FILE_DESC.get(), true, true, true, false);
        changePKPWKeystorePasswordFile.addLongIdentifier("keystorePasswordFile", true);
        changePKPWKeystorePasswordFile.addLongIdentifier("keystore-passphrase-file", true);
        changePKPWKeystorePasswordFile.addLongIdentifier("keystorePassphraseFile", true);
        changePKPWKeystorePasswordFile.addLongIdentifier("keystore-pin-file", true);
        changePKPWKeystorePasswordFile.addLongIdentifier("keystorePINFile", true);
        changePKPWParser.addArgument(changePKPWKeystorePasswordFile);
        BooleanArgument changePKPWPromptForKeystorePassword = new BooleanArgument(null, "prompt-for-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_ARG_PROMPT_FOR_KS_PW_DESC.get());
        changePKPWPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassword", true);
        changePKPWPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-passphrase", true);
        changePKPWPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassphrase", true);
        changePKPWPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-pin", true);
        changePKPWPromptForKeystorePassword.addLongIdentifier("promptForKeystorePIN", true);
        changePKPWParser.addArgument(changePKPWPromptForKeystorePassword);
        StringArgument changePKPWKeystoreType = new StringArgument(null, "keystore-type", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TYPE.get(), CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_ARG_KS_TYPE_DESC.get(), ALLOWED_KEYSTORE_TYPE_VALUES);
        changePKPWKeystoreType.addLongIdentifier("key-store-type", true);
        changePKPWKeystoreType.addLongIdentifier("keystoreType", true);
        changePKPWKeystoreType.addLongIdentifier("keystore-format", true);
        changePKPWKeystoreType.addLongIdentifier("key-store-format", true);
        changePKPWKeystoreType.addLongIdentifier("keystoreFormat", true);
        changePKPWKeystoreType.addLongIdentifier("storetype", true);
        changePKPWParser.addArgument(changePKPWKeystoreType);
        StringArgument changePKPWAlias = new StringArgument(null, "alias", true, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_ALIAS.get(), CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_ARG_ALIAS_DESC.get());
        changePKPWAlias.addLongIdentifier("nickname", true);
        changePKPWParser.addArgument(changePKPWAlias);
        StringArgument changePKPWCurrentPassword = new StringArgument(null, "current-private-key-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_ARG_CURRENT_PW_DESC.get());
        changePKPWCurrentPassword.addLongIdentifier("currentPrivateKeyPassword", true);
        changePKPWCurrentPassword.addLongIdentifier("current-private-key-passphrase", true);
        changePKPWCurrentPassword.addLongIdentifier("currentPrivateKeyPassphrase", true);
        changePKPWCurrentPassword.addLongIdentifier("current-private-key-pin", true);
        changePKPWCurrentPassword.addLongIdentifier("currentPrivateKeyPIN", true);
        changePKPWCurrentPassword.addLongIdentifier("keypass", true);
        changePKPWCurrentPassword.setSensitive(true);
        changePKPWParser.addArgument(changePKPWCurrentPassword);
        FileArgument changePKPWCurrentPasswordFile = new FileArgument(null, "current-private-key-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_ARG_CURRENT_PW_FILE_DESC.get(), true, true, true, false);
        changePKPWCurrentPasswordFile.addLongIdentifier("currentPrivateKeyPasswordFile", true);
        changePKPWCurrentPasswordFile.addLongIdentifier("current-private-key-passphrase-file", true);
        changePKPWCurrentPasswordFile.addLongIdentifier("currentPrivateKeyPassphraseFile", true);
        changePKPWCurrentPasswordFile.addLongIdentifier("current-private-key-pin-file", true);
        changePKPWCurrentPasswordFile.addLongIdentifier("currentPrivateKeyPINFile", true);
        changePKPWParser.addArgument(changePKPWCurrentPasswordFile);
        BooleanArgument changePKPWPromptForCurrentPassword = new BooleanArgument(null, "prompt-for-current-private-key-password", CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_ARG_PROMPT_FOR_CURRENT_PW_DESC.get());
        changePKPWPromptForCurrentPassword.addLongIdentifier("promptForCurrentPrivateKeyPassword", true);
        changePKPWPromptForCurrentPassword.addLongIdentifier("prompt-for-current-private-key-passphrase", true);
        changePKPWPromptForCurrentPassword.addLongIdentifier("promptForCurrentPrivateKeyPassphrase", true);
        changePKPWPromptForCurrentPassword.addLongIdentifier("prompt-for-current-private-key-pin", true);
        changePKPWPromptForCurrentPassword.addLongIdentifier("promptForCurrentPrivateKeyPIN", true);
        changePKPWParser.addArgument(changePKPWPromptForCurrentPassword);
        StringArgument changePKPWNewPassword = new StringArgument(null, "new-private-key-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_ARG_NEW_PW_DESC.get());
        changePKPWNewPassword.addLongIdentifier("newPrivateKeyPassword", true);
        changePKPWNewPassword.addLongIdentifier("new-private-key-passphrase", true);
        changePKPWNewPassword.addLongIdentifier("newPrivateKeyPassphrase", true);
        changePKPWNewPassword.addLongIdentifier("new-private-key-pin", true);
        changePKPWNewPassword.addLongIdentifier("newPrivateKeyPIN", true);
        changePKPWNewPassword.addLongIdentifier("new", true);
        changePKPWNewPassword.setSensitive(true);
        changePKPWParser.addArgument(changePKPWNewPassword);
        FileArgument changePKPWNewPasswordFile = new FileArgument(null, "new-private-key-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_ARG_NEW_PW_FILE_DESC.get(), true, true, true, false);
        changePKPWNewPasswordFile.addLongIdentifier("newPrivateKeyPasswordFile", true);
        changePKPWNewPasswordFile.addLongIdentifier("new-private-key-passphrase-file", true);
        changePKPWNewPasswordFile.addLongIdentifier("newPrivateKeyPassphraseFile", true);
        changePKPWNewPasswordFile.addLongIdentifier("new-private-key-pin-file", true);
        changePKPWNewPasswordFile.addLongIdentifier("newPrivateKeyPINFile", true);
        changePKPWParser.addArgument(changePKPWNewPasswordFile);
        BooleanArgument changePKPWPromptForNewPassword = new BooleanArgument(null, "prompt-for-new-private-key-password", CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_ARG_PROMPT_FOR_NEW_PW_DESC.get());
        changePKPWPromptForNewPassword.addLongIdentifier("promptForNewPrivateKeyPassword", true);
        changePKPWPromptForNewPassword.addLongIdentifier("prompt-for-new-private-key-passphrase", true);
        changePKPWPromptForNewPassword.addLongIdentifier("promptForNewPrivateKeyPassphrase", true);
        changePKPWPromptForNewPassword.addLongIdentifier("prompt-for-new-private-key-pin", true);
        changePKPWPromptForNewPassword.addLongIdentifier("promptForNewPrivateKeyPIN", true);
        changePKPWParser.addArgument(changePKPWPromptForNewPassword);
        BooleanArgument changePKPWDisplayCommand = new BooleanArgument(null, "display-keytool-command", 1, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_ARG_DISPLAY_COMMAND_DESC.get());
        changePKPWDisplayCommand.addLongIdentifier("displayKeytoolCommand", true);
        changePKPWDisplayCommand.addLongIdentifier("show-keytool-command", true);
        changePKPWDisplayCommand.addLongIdentifier("showKeytoolCommand", true);
        changePKPWParser.addArgument(changePKPWDisplayCommand);
        changePKPWParser.addRequiredArgumentSet(changePKPWKeystorePassword, changePKPWKeystorePasswordFile, changePKPWPromptForKeystorePassword);
        changePKPWParser.addExclusiveArgumentSet(changePKPWKeystorePassword, changePKPWKeystorePasswordFile, changePKPWPromptForKeystorePassword);
        changePKPWParser.addRequiredArgumentSet(changePKPWCurrentPassword, changePKPWCurrentPasswordFile, changePKPWPromptForCurrentPassword);
        changePKPWParser.addExclusiveArgumentSet(changePKPWCurrentPassword, changePKPWCurrentPasswordFile, changePKPWPromptForCurrentPassword);
        changePKPWParser.addRequiredArgumentSet(changePKPWNewPassword, changePKPWNewPasswordFile, changePKPWPromptForNewPassword);
        changePKPWParser.addExclusiveArgumentSet(changePKPWNewPassword, changePKPWNewPasswordFile, changePKPWPromptForNewPassword);
        LinkedHashMap<String[], String> changePKPWExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        changePKPWExamples.put(new String[]{"change-private-key-password", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--alias", "server-cert", "--current-private-key-password-file", ManageCertificates.getPlatformSpecificPath("config", "current.pin"), "--new-private-key-password-file", ManageCertificates.getPlatformSpecificPath("config", "new.pin"), "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_EXAMPLE_1.get(ManageCertificates.getPlatformSpecificPath("config", "keystore"), ManageCertificates.getPlatformSpecificPath("config", "current.pin"), ManageCertificates.getPlatformSpecificPath("config", "new.pin")));
        SubCommand changePKPWSubCommand = new SubCommand("change-private-key-password", CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_PK_PW_DESC.get(), changePKPWParser, changePKPWExamples);
        changePKPWSubCommand.addName("changePrivateKeyPassword", true);
        changePKPWSubCommand.addName("change-private-key-passphrase", true);
        changePKPWSubCommand.addName("changePrivateKeyPassphrase", true);
        changePKPWSubCommand.addName("change-private-key-pin", true);
        changePKPWSubCommand.addName("changePrivateKeyPIN", true);
        changePKPWSubCommand.addName("change-key-password", true);
        changePKPWSubCommand.addName("changeKeyPassword", true);
        changePKPWSubCommand.addName("change-key-passphrase", true);
        changePKPWSubCommand.addName("changeKeyPassphrase", true);
        changePKPWSubCommand.addName("change-key-pin", true);
        changePKPWSubCommand.addName("changeKeyPIN", true);
        changePKPWSubCommand.addName("keypasswd", true);
        parser.addSubCommand(changePKPWSubCommand);
        ArgumentParser copyKSParser = new ArgumentParser("copy-keystore", CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_DESC.get());
        FileArgument copyKSSourceKeystore = new FileArgument(null, "source-keystore", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_SRC_KS_DESC.get(), true, true, true, false);
        copyKSSourceKeystore.addLongIdentifier("sourceKeystore", true);
        copyKSSourceKeystore.addLongIdentifier("source-keystore-path", true);
        copyKSSourceKeystore.addLongIdentifier("sourceKeystorePath", true);
        copyKSSourceKeystore.addLongIdentifier("source-keystore-file", true);
        copyKSSourceKeystore.addLongIdentifier("sourceKeystoreFile", true);
        copyKSParser.addArgument(copyKSSourceKeystore);
        StringArgument copyKSSourceKeystorePassword = new StringArgument(null, "source-keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_SRC_KS_PW_DESC.get());
        copyKSSourceKeystorePassword.addLongIdentifier("sourceKeystorePassword", true);
        copyKSSourceKeystorePassword.addLongIdentifier("source-keystore-passphrase", true);
        copyKSSourceKeystorePassword.addLongIdentifier("sourceKeystorePassphrase", true);
        copyKSSourceKeystorePassword.addLongIdentifier("source-keystore-pin", true);
        copyKSSourceKeystorePassword.addLongIdentifier("sourceKeystorePIN", true);
        copyKSParser.addArgument(copyKSSourceKeystorePassword);
        FileArgument copyKSSourceKeystorePasswordFile = new FileArgument(null, "source-keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_SRC_KS_PW_FILE_DESC.get(), true, true, true, false);
        copyKSSourceKeystorePasswordFile.addLongIdentifier("sourceKeystorePasswordFile", true);
        copyKSSourceKeystorePasswordFile.addLongIdentifier("source-keystore-passphrase-file", true);
        copyKSSourceKeystorePasswordFile.addLongIdentifier("sourceKeystorePassphraseFile", true);
        copyKSSourceKeystorePasswordFile.addLongIdentifier("source-keystore-pin-file", true);
        copyKSSourceKeystorePasswordFile.addLongIdentifier("sourceKeystorePINFile", true);
        copyKSParser.addArgument(copyKSSourceKeystorePasswordFile);
        BooleanArgument copyKSPromptForSourceKeystorePassword = new BooleanArgument(null, "prompt-for-source-keystore-password", 1, CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_PROMPT_FOR_SRC_KS_PW.get());
        copyKSPromptForSourceKeystorePassword.addLongIdentifier("promptForSourceKeystorePassword", true);
        copyKSPromptForSourceKeystorePassword.addLongIdentifier("prompt-for-source-keystore-passphrase", true);
        copyKSPromptForSourceKeystorePassword.addLongIdentifier("promptForSourceKeystorePassphrase", true);
        copyKSPromptForSourceKeystorePassword.addLongIdentifier("prompt-for-source-keystore-pin", true);
        copyKSPromptForSourceKeystorePassword.addLongIdentifier("promptForSourceKeystorePIN", true);
        copyKSParser.addArgument(copyKSPromptForSourceKeystorePassword);
        StringArgument copyKSSourcePKPassword = new StringArgument(null, "source-private-key-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_SRC_PK_PW_DESC.get());
        copyKSSourcePKPassword.addLongIdentifier("sourcePrivateKeyPassword", true);
        copyKSSourcePKPassword.addLongIdentifier("source-private-key-passphrase", true);
        copyKSSourcePKPassword.addLongIdentifier("sourcePrivateKeyPassphrase", true);
        copyKSSourcePKPassword.addLongIdentifier("source-private-key-pin", true);
        copyKSSourcePKPassword.addLongIdentifier("sourcePrivateKeyPIN", true);
        copyKSParser.addArgument(copyKSSourcePKPassword);
        FileArgument copyKSSourcePKPasswordFile = new FileArgument(null, "source-private-key-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_SRC_PK_PW_FILE_DESC.get(), true, true, true, false);
        copyKSSourcePKPasswordFile.addLongIdentifier("sourcePrivateKeyPasswordFile", true);
        copyKSSourcePKPasswordFile.addLongIdentifier("source-private-key-passphrase-file", true);
        copyKSSourcePKPasswordFile.addLongIdentifier("sourcePrivateKeyPassphraseFile", true);
        copyKSSourcePKPasswordFile.addLongIdentifier("source-private-key-pin-file", true);
        copyKSSourcePKPasswordFile.addLongIdentifier("sourcePrivateKeyPINFile", true);
        copyKSParser.addArgument(copyKSSourcePKPasswordFile);
        BooleanArgument copyKSPromptForSourcePKPassword = new BooleanArgument(null, "prompt-for-source-private-key-password", 1, CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_PROMPT_FOR_SRC_PK_PW.get());
        copyKSPromptForSourcePKPassword.addLongIdentifier("promptForSourcePrivateKeyPassword", true);
        copyKSPromptForSourcePKPassword.addLongIdentifier("prompt-for-source-private-key-passphrase", true);
        copyKSPromptForSourcePKPassword.addLongIdentifier("promptForSourcePrivateKeyPassphrase", true);
        copyKSPromptForSourcePKPassword.addLongIdentifier("prompt-for-source-private-key-pin", true);
        copyKSPromptForSourcePKPassword.addLongIdentifier("promptForSourcePrivateKeyPIN", true);
        copyKSParser.addArgument(copyKSPromptForSourcePKPassword);
        StringArgument copyKSSourceKeystoreType = new StringArgument(null, "source-keystore-type", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TYPE.get(), CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_SRC_KS_TYPE.get(), ALLOWED_KEYSTORE_TYPE_VALUES);
        copyKSSourceKeystoreType.addLongIdentifier("source-key-store-type", true);
        copyKSSourceKeystoreType.addLongIdentifier("sourceKeystoreType", true);
        copyKSSourceKeystoreType.addLongIdentifier("source-keystore-format", true);
        copyKSSourceKeystoreType.addLongIdentifier("source-key-store-format", true);
        copyKSSourceKeystoreType.addLongIdentifier("sourceKeystoreFormat", true);
        copyKSParser.addArgument(copyKSSourceKeystoreType);
        FileArgument copyKSDestKeystore = new FileArgument(null, "destination-keystore", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_DST_KS_DESC.get(), false, true, true, false);
        copyKSDestKeystore.addLongIdentifier("destinationKeystore", true);
        copyKSDestKeystore.addLongIdentifier("destination-keystore-path", true);
        copyKSDestKeystore.addLongIdentifier("destinationKeystorePath", true);
        copyKSDestKeystore.addLongIdentifier("destination-keystore-file", true);
        copyKSDestKeystore.addLongIdentifier("destinationKeystoreFile", true);
        copyKSDestKeystore.addLongIdentifier("target-keystore", true);
        copyKSDestKeystore.addLongIdentifier("targetKeystore", true);
        copyKSDestKeystore.addLongIdentifier("target-keystore-path", true);
        copyKSDestKeystore.addLongIdentifier("targetKeystorePath", true);
        copyKSDestKeystore.addLongIdentifier("target-keystore-file", true);
        copyKSDestKeystore.addLongIdentifier("targetKeystoreFile", true);
        copyKSParser.addArgument(copyKSDestKeystore);
        StringArgument copyKSDestKeystorePassword = new StringArgument(null, "destination-keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_DST_KS_PW_DESC.get());
        copyKSDestKeystorePassword.addLongIdentifier("destinationKeystorePassword", true);
        copyKSDestKeystorePassword.addLongIdentifier("destination-keystore-passphrase", true);
        copyKSDestKeystorePassword.addLongIdentifier("destinationKeystorePassphrase", true);
        copyKSDestKeystorePassword.addLongIdentifier("destination-keystore-pin", true);
        copyKSDestKeystorePassword.addLongIdentifier("destinationKeystorePIN", true);
        copyKSDestKeystorePassword.addLongIdentifier("target-keystore-password", true);
        copyKSDestKeystorePassword.addLongIdentifier("targetKeystorePassword", true);
        copyKSDestKeystorePassword.addLongIdentifier("target-keystore-passphrase", true);
        copyKSDestKeystorePassword.addLongIdentifier("targetKeystorePassphrase", true);
        copyKSDestKeystorePassword.addLongIdentifier("target-keystore-pin", true);
        copyKSDestKeystorePassword.addLongIdentifier("targetKeystorePIN", true);
        copyKSParser.addArgument(copyKSDestKeystorePassword);
        FileArgument copyKSDestKeystorePasswordFile = new FileArgument(null, "destination-keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_DST_KS_PW_FILE_DESC.get(), true, true, true, false);
        copyKSDestKeystorePasswordFile.addLongIdentifier("destinationKeystorePasswordFile", true);
        copyKSDestKeystorePasswordFile.addLongIdentifier("destination-keystore-passphrase-file", true);
        copyKSDestKeystorePasswordFile.addLongIdentifier("destinationKeystorePassphraseFile", true);
        copyKSDestKeystorePasswordFile.addLongIdentifier("destination-keystore-pin-file", true);
        copyKSDestKeystorePasswordFile.addLongIdentifier("destinationKeystorePINFile", true);
        copyKSDestKeystorePasswordFile.addLongIdentifier("target-keystore-password-file", true);
        copyKSDestKeystorePasswordFile.addLongIdentifier("targetKeystorePasswordFile", true);
        copyKSDestKeystorePasswordFile.addLongIdentifier("target-keystore-passphrase-file", true);
        copyKSDestKeystorePasswordFile.addLongIdentifier("targetKeystorePassphraseFile", true);
        copyKSDestKeystorePasswordFile.addLongIdentifier("target-keystore-pin-file", true);
        copyKSDestKeystorePasswordFile.addLongIdentifier("targetKeystorePINFile", true);
        copyKSParser.addArgument(copyKSDestKeystorePasswordFile);
        BooleanArgument copyKSPromptForDestKeystorePassword = new BooleanArgument(null, "prompt-for-destination-keystore-password", 1, CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_PROMPT_FOR_DST_KS_PW.get());
        copyKSPromptForDestKeystorePassword.addLongIdentifier("promptForDestinationKeystorePassword", true);
        copyKSPromptForDestKeystorePassword.addLongIdentifier("prompt-for-Destination-keystore-passphrase", true);
        copyKSPromptForDestKeystorePassword.addLongIdentifier("promptForDestinationKeystorePassphrase", true);
        copyKSPromptForDestKeystorePassword.addLongIdentifier("prompt-for-Destination-keystore-pin", true);
        copyKSPromptForDestKeystorePassword.addLongIdentifier("promptForDestinationKeystorePIN", true);
        copyKSPromptForDestKeystorePassword.addLongIdentifier("prompt-for-target-keystore-password", true);
        copyKSPromptForDestKeystorePassword.addLongIdentifier("promptForTargetKeystorePassword", true);
        copyKSPromptForDestKeystorePassword.addLongIdentifier("prompt-for-Target-keystore-passphrase", true);
        copyKSPromptForDestKeystorePassword.addLongIdentifier("promptForTargetKeystorePassphrase", true);
        copyKSPromptForDestKeystorePassword.addLongIdentifier("prompt-for-Target-keystore-pin", true);
        copyKSPromptForDestKeystorePassword.addLongIdentifier("promptForTargetKeystorePIN", true);
        copyKSParser.addArgument(copyKSPromptForDestKeystorePassword);
        StringArgument copyKSDestPKPassword = new StringArgument(null, "destination-private-key-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_DST_PK_PW_DESC.get());
        copyKSDestPKPassword.addLongIdentifier("destinationPrivateKeyPassword", true);
        copyKSDestPKPassword.addLongIdentifier("destination-private-key-passphrase", true);
        copyKSDestPKPassword.addLongIdentifier("destinationPrivateKeyPassphrase", true);
        copyKSDestPKPassword.addLongIdentifier("destination-private-key-pin", true);
        copyKSDestPKPassword.addLongIdentifier("destinationPrivateKeyPIN", true);
        copyKSDestPKPassword.addLongIdentifier("target-private-key-password", true);
        copyKSDestPKPassword.addLongIdentifier("targetPrivateKeyPassword", true);
        copyKSDestPKPassword.addLongIdentifier("target-private-key-passphrase", true);
        copyKSDestPKPassword.addLongIdentifier("targetPrivateKeyPassphrase", true);
        copyKSDestPKPassword.addLongIdentifier("target-private-key-pin", true);
        copyKSDestPKPassword.addLongIdentifier("targetPrivateKeyPIN", true);
        copyKSParser.addArgument(copyKSDestPKPassword);
        FileArgument copyKSDestPKPasswordFile = new FileArgument(null, "destination-private-key-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_DST_PK_PW_FILE_DESC.get(), true, true, true, false);
        copyKSDestPKPasswordFile.addLongIdentifier("destinationPrivateKeyPasswordFile", true);
        copyKSDestPKPasswordFile.addLongIdentifier("destination-private-key-passphrase-file", true);
        copyKSDestPKPasswordFile.addLongIdentifier("destinationPrivateKeyPassphraseFile", true);
        copyKSDestPKPasswordFile.addLongIdentifier("destination-private-key-pin-file", true);
        copyKSDestPKPasswordFile.addLongIdentifier("destinationPrivateKeyPINFile", true);
        copyKSDestPKPasswordFile.addLongIdentifier("target-private-key-password-file", true);
        copyKSDestPKPasswordFile.addLongIdentifier("targetPrivateKeyPasswordFile", true);
        copyKSDestPKPasswordFile.addLongIdentifier("target-private-key-passphrase-file", true);
        copyKSDestPKPasswordFile.addLongIdentifier("targetPrivateKeyPassphraseFile", true);
        copyKSDestPKPasswordFile.addLongIdentifier("target-private-key-pin-file", true);
        copyKSDestPKPasswordFile.addLongIdentifier("targetPrivateKeyPINFile", true);
        copyKSParser.addArgument(copyKSDestPKPasswordFile);
        BooleanArgument copyKSPromptForDestPKPassword = new BooleanArgument(null, "prompt-for-destination-private-key-password", 1, CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_PROMPT_FOR_DST_PK_PW.get());
        copyKSPromptForDestPKPassword.addLongIdentifier("promptForDestinationPrivateKeyPassword", true);
        copyKSPromptForDestPKPassword.addLongIdentifier("prompt-for-Destination-private-key-passphrase", true);
        copyKSPromptForDestPKPassword.addLongIdentifier("promptForDestinationPrivateKeyPassphrase", true);
        copyKSPromptForDestPKPassword.addLongIdentifier("prompt-for-Destination-private-key-pin", true);
        copyKSPromptForDestPKPassword.addLongIdentifier("promptForDestinationPrivateKeyPIN", true);
        copyKSPromptForDestPKPassword.addLongIdentifier("prompt-for-target-private-key-password", true);
        copyKSPromptForDestPKPassword.addLongIdentifier("promptForTargetPrivateKeyPassword", true);
        copyKSPromptForDestPKPassword.addLongIdentifier("prompt-for-Target-private-key-passphrase", true);
        copyKSPromptForDestPKPassword.addLongIdentifier("promptForTargetPrivateKeyPassphrase", true);
        copyKSPromptForDestPKPassword.addLongIdentifier("prompt-for-Target-private-key-pin", true);
        copyKSPromptForDestPKPassword.addLongIdentifier("promptForTargetPrivateKeyPIN", true);
        copyKSParser.addArgument(copyKSPromptForDestPKPassword);
        StringArgument copyKSDestKeystoreType = new StringArgument(null, "destination-keystore-type", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TYPE.get(), CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_DST_KS_TYPE.get(), ALLOWED_KEYSTORE_TYPE_VALUES);
        copyKSDestKeystoreType.addLongIdentifier("destination-key-store-type", true);
        copyKSDestKeystoreType.addLongIdentifier("destinationKeystoreType", true);
        copyKSDestKeystoreType.addLongIdentifier("destination-keystore-format", true);
        copyKSDestKeystoreType.addLongIdentifier("destination-key-store-format", true);
        copyKSDestKeystoreType.addLongIdentifier("destinationKeystoreFormat", true);
        copyKSDestKeystoreType.addLongIdentifier("target-key-store-type", true);
        copyKSDestKeystoreType.addLongIdentifier("targetKeystoreType", true);
        copyKSDestKeystoreType.addLongIdentifier("target-keystore-format", true);
        copyKSDestKeystoreType.addLongIdentifier("target-key-store-format", true);
        copyKSDestKeystoreType.addLongIdentifier("targetKeystoreFormat", true);
        copyKSParser.addArgument(copyKSDestKeystoreType);
        StringArgument copyKSAlias = new StringArgument(null, "alias", false, 0, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_ALIAS.get(), CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_ARG_ALIAS.get());
        copyKSAlias.addLongIdentifier("nickname", true);
        copyKSParser.addArgument(copyKSAlias);
        copyKSParser.addRequiredArgumentSet(copyKSSourceKeystorePassword, copyKSSourceKeystorePasswordFile, copyKSPromptForSourceKeystorePassword);
        copyKSParser.addExclusiveArgumentSet(copyKSSourceKeystorePassword, copyKSSourceKeystorePasswordFile, copyKSPromptForSourceKeystorePassword);
        copyKSParser.addExclusiveArgumentSet(copyKSSourcePKPassword, copyKSSourcePKPasswordFile, copyKSPromptForDestPKPassword);
        copyKSParser.addExclusiveArgumentSet(copyKSDestKeystorePassword, copyKSDestKeystorePasswordFile, copyKSPromptForDestKeystorePassword);
        copyKSParser.addExclusiveArgumentSet(copyKSDestPKPassword, copyKSDestPKPasswordFile, copyKSPromptForDestPKPassword);
        LinkedHashMap<String[], String> copyKeyStoreExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        copyKeyStoreExamples.put(new String[]{"copy-keystore", "--source-keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore.jks"), "--source-keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--source-keystore-type", "JKS", "--destination-keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore.p12"), "--destination-keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--destination-keystore-type", "PKCS12"}, CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_EXAMPLE_1.get("keystore.jks", "keystore.p12"));
        SubCommand copyKeyStoreSubCommand = new SubCommand("copy-keystore", CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_DESC.get(), copyKSParser, copyKeyStoreExamples);
        copyKeyStoreSubCommand.addName("copy-key-store", true);
        copyKeyStoreSubCommand.addName("copyKeyStore", true);
        copyKeyStoreSubCommand.addName("import-keystore", true);
        copyKeyStoreSubCommand.addName("import-key-store", true);
        copyKeyStoreSubCommand.addName("importKeyStore", true);
        copyKeyStoreSubCommand.addName("convert-keystore", true);
        copyKeyStoreSubCommand.addName("convert-key-store", true);
        copyKeyStoreSubCommand.addName("convertKeyStore", true);
        parser.addSubCommand(copyKeyStoreSubCommand);
        ArgumentParser retrieveCertParser = new ArgumentParser("retrieve-server-certificate", CertMessages.INFO_MANAGE_CERTS_SC_RETRIEVE_CERT_DESC.get());
        StringArgument retrieveCertHostname = new StringArgument(Character.valueOf('h'), "hostname", true, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_HOST.get(), CertMessages.INFO_MANAGE_CERTS_SC_RETRIEVE_CERT_ARG_HOSTNAME_DESC.get());
        retrieveCertHostname.addLongIdentifier("server-address", true);
        retrieveCertHostname.addLongIdentifier("serverAddress", true);
        retrieveCertHostname.addLongIdentifier("address", true);
        retrieveCertParser.addArgument(retrieveCertHostname);
        IntegerArgument retrieveCertPort = new IntegerArgument(Character.valueOf('p'), "port", true, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PORT.get(), CertMessages.INFO_MANAGE_CERTS_SC_RETRIEVE_CERT_ARG_PORT_DESC.get(), 1, 65535);
        retrieveCertPort.addLongIdentifier("server-port", true);
        retrieveCertPort.addLongIdentifier("serverPort", true);
        retrieveCertParser.addArgument(retrieveCertPort);
        BooleanArgument retrieveCertUseStartTLS = new BooleanArgument(Character.valueOf('q'), "use-ldap-start-tls", 1, CertMessages.INFO_MANAGE_CERTS_SC_RETRIEVE_CERT_ARG_USE_START_TLS_DESC.get());
        retrieveCertUseStartTLS.addLongIdentifier("use-ldap-starttls", true);
        retrieveCertUseStartTLS.addLongIdentifier("useLDAPStartTLS", true);
        retrieveCertUseStartTLS.addLongIdentifier("use-start-tls", true);
        retrieveCertUseStartTLS.addLongIdentifier("use-starttls", true);
        retrieveCertUseStartTLS.addLongIdentifier("useStartTLS", true);
        retrieveCertParser.addArgument(retrieveCertUseStartTLS);
        FileArgument retrieveCertOutputFile = new FileArgument(null, "output-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_RETRIEVE_CERT_ARG_FILE_DESC.get(), false, true, true, false);
        retrieveCertOutputFile.addLongIdentifier("outputFile", true);
        retrieveCertOutputFile.addLongIdentifier("export-file", true);
        retrieveCertOutputFile.addLongIdentifier("exportFile", true);
        retrieveCertOutputFile.addLongIdentifier("certificate-file", true);
        retrieveCertOutputFile.addLongIdentifier("certificateFile", true);
        retrieveCertOutputFile.addLongIdentifier("file", true);
        retrieveCertOutputFile.addLongIdentifier("filename", true);
        retrieveCertParser.addArgument(retrieveCertOutputFile);
        Set<String> retrieveCertOutputFormatAllowedValues = StaticUtils.setOf("PEM", "text", "txt", "RFC", "DER", "binary", "bin");
        StringArgument retrieveCertOutputFormat = new StringArgument(null, "output-format", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_FORMAT.get(), CertMessages.INFO_MANAGE_CERTS_SC_RETRIEVE_CERT_ARG_FORMAT_DESC.get(), retrieveCertOutputFormatAllowedValues, "PEM");
        retrieveCertOutputFormat.addLongIdentifier("outputFormat", true);
        retrieveCertParser.addArgument(retrieveCertOutputFormat);
        BooleanArgument retrieveCertOnlyPeer = new BooleanArgument(null, "only-peer-certificate", 1, CertMessages.INFO_MANAGE_CERTS_SC_RETRIEVE_CERT_ARG_ONLY_PEER_DESC.get());
        retrieveCertOnlyPeer.addLongIdentifier("onlyPeerCertificate", true);
        retrieveCertOnlyPeer.addLongIdentifier("only-peer", true);
        retrieveCertOnlyPeer.addLongIdentifier("onlyPeer", true);
        retrieveCertOnlyPeer.addLongIdentifier("peer-certificate-only", true);
        retrieveCertOnlyPeer.addLongIdentifier("peerCertificateOnly", true);
        retrieveCertOnlyPeer.addLongIdentifier("peer-only", true);
        retrieveCertOnlyPeer.addLongIdentifier("peerOnly", true);
        retrieveCertParser.addArgument(retrieveCertOnlyPeer);
        BooleanArgument retrieveCertEnableSSLDebugging = new BooleanArgument(null, "enableSSLDebugging", 1, CertMessages.INFO_MANAGE_CERTS_SC_RETRIEVE_CERT_ARG_ENABLE_SSL_DEBUGGING_DESC.get());
        retrieveCertEnableSSLDebugging.addLongIdentifier("enableTLSDebugging", true);
        retrieveCertEnableSSLDebugging.addLongIdentifier("enableStartTLSDebugging", true);
        retrieveCertEnableSSLDebugging.addLongIdentifier("enable-ssl-debugging", true);
        retrieveCertEnableSSLDebugging.addLongIdentifier("enable-tls-debugging", true);
        retrieveCertEnableSSLDebugging.addLongIdentifier("enable-starttls-debugging", true);
        retrieveCertEnableSSLDebugging.addLongIdentifier("enable-start-tls-debugging", true);
        retrieveCertParser.addArgument(retrieveCertEnableSSLDebugging);
        this.addEnableSSLDebuggingArgument(retrieveCertEnableSSLDebugging);
        BooleanArgument retrieveCertVerbose = new BooleanArgument(null, "verbose", 1, CertMessages.INFO_MANAGE_CERTS_SC_RETRIEVE_CERT_ARG_VERBOSE_DESC.get());
        retrieveCertParser.addArgument(retrieveCertVerbose);
        retrieveCertParser.addDependentArgumentSet(retrieveCertOutputFormat, retrieveCertOutputFile, new Argument[0]);
        LinkedHashMap<String[], String> retrieveCertExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(2));
        retrieveCertExamples.put(new String[]{"retrieve-server-certificate", "--hostname", "ds.example.com", "--port", "636"}, CertMessages.INFO_MANAGE_CERTS_SC_RETRIEVE_CERT_EXAMPLE_1.get(ManageCertificates.getPlatformSpecificPath("config", "truststore")));
        retrieveCertExamples.put(new String[]{"retrieve-server-certificate", "--hostname", "ds.example.com", "--port", "389", "--use-ldap-start-tls", "--only-peer-certificate", "--output-file", "ds-cert.pem", "--output-format", "PEM", "--verbose"}, CertMessages.INFO_MANAGE_CERTS_SC_RETRIEVE_CERT_EXAMPLE_2.get(ManageCertificates.getPlatformSpecificPath("config", "truststore")));
        SubCommand retrieveCertSubCommand = new SubCommand("retrieve-server-certificate", CertMessages.INFO_MANAGE_CERTS_SC_RETRIEVE_CERT_DESC.get(), retrieveCertParser, retrieveCertExamples);
        retrieveCertSubCommand.addName("retrieveServerCertificate", true);
        retrieveCertSubCommand.addName("retrieve-certificate", true);
        retrieveCertSubCommand.addName("retrieveCertificate", true);
        retrieveCertSubCommand.addName("get-server-certificate", true);
        retrieveCertSubCommand.addName("getServerCertificate", true);
        retrieveCertSubCommand.addName("get-certificate", true);
        retrieveCertSubCommand.addName("getCertificate", true);
        retrieveCertSubCommand.addName("display-server-certificate", true);
        retrieveCertSubCommand.addName("displayServerCertificate", true);
        parser.addSubCommand(retrieveCertSubCommand);
        ArgumentParser trustServerParser = new ArgumentParser("trust-server-certificate", CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_DESC.get());
        StringArgument trustServerHostname = new StringArgument(Character.valueOf('h'), "hostname", true, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_HOST.get(), CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_ARG_HOSTNAME_DESC.get());
        trustServerHostname.addLongIdentifier("server-address", true);
        trustServerHostname.addLongIdentifier("serverAddress", true);
        trustServerHostname.addLongIdentifier("address", true);
        trustServerParser.addArgument(trustServerHostname);
        IntegerArgument integerArgument = new IntegerArgument(Character.valueOf('p'), "port", true, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PORT.get(), CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_ARG_PORT_DESC.get(), 1, 65535);
        trustServerPort.addLongIdentifier("server-port", true);
        trustServerPort.addLongIdentifier("serverPort", true);
        trustServerParser.addArgument((Argument)trustServerPort);
        BooleanArgument booleanArgument = new BooleanArgument(Character.valueOf('q'), "use-ldap-start-tls", 1, CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_ARG_USE_START_TLS_DESC.get());
        trustServerUseStartTLS.addLongIdentifier("use-ldap-starttls", true);
        trustServerUseStartTLS.addLongIdentifier("useLDAPStartTLS", true);
        trustServerUseStartTLS.addLongIdentifier("use-start-tls", true);
        trustServerUseStartTLS.addLongIdentifier("use-starttls", true);
        trustServerUseStartTLS.addLongIdentifier("useStartTLS", true);
        trustServerParser.addArgument((Argument)trustServerUseStartTLS);
        FileArgument fileArgument = new FileArgument(null, "keystore", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_ARG_KS_DESC.get(), false, true, true, false);
        trustServerKeystore.addLongIdentifier("keystore-path", true);
        trustServerKeystore.addLongIdentifier("keystorePath", true);
        trustServerKeystore.addLongIdentifier("keystore-file", true);
        trustServerKeystore.addLongIdentifier("keystoreFile", true);
        trustServerParser.addArgument((Argument)trustServerKeystore);
        StringArgument stringArgument = new StringArgument(null, "keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_ARG_KS_PW_DESC.get());
        trustServerKeystorePassword.addLongIdentifier("keystorePassword", true);
        trustServerKeystorePassword.addLongIdentifier("keystore-passphrase", true);
        trustServerKeystorePassword.addLongIdentifier("keystorePassphrase", true);
        trustServerKeystorePassword.addLongIdentifier("keystore-pin", true);
        trustServerKeystorePassword.addLongIdentifier("keystorePIN", true);
        trustServerKeystorePassword.addLongIdentifier("storepass", true);
        trustServerKeystorePassword.setSensitive(true);
        trustServerParser.addArgument((Argument)trustServerKeystorePassword);
        FileArgument fileArgument2 = new FileArgument(null, "keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_ARG_KS_PW_FILE_DESC.get(), true, true, true, false);
        trustServerKeystorePasswordFile.addLongIdentifier("keystorePasswordFile", true);
        trustServerKeystorePasswordFile.addLongIdentifier("keystore-passphrase-file", true);
        trustServerKeystorePasswordFile.addLongIdentifier("keystorePassphraseFile", true);
        trustServerKeystorePasswordFile.addLongIdentifier("keystore-pin-file", true);
        trustServerKeystorePasswordFile.addLongIdentifier("keystorePINFile", true);
        trustServerParser.addArgument((Argument)trustServerKeystorePasswordFile);
        BooleanArgument booleanArgument2 = new BooleanArgument(null, "prompt-for-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_ARG_PROMPT_FOR_KS_PW_DESC.get());
        trustServerPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassword", true);
        trustServerPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-passphrase", true);
        trustServerPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassphrase", true);
        trustServerPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-pin", true);
        trustServerPromptForKeystorePassword.addLongIdentifier("promptForKeystorePIN", true);
        trustServerParser.addArgument((Argument)trustServerPromptForKeystorePassword);
        StringArgument stringArgument2 = new StringArgument(null, "keystore-type", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TYPE.get(), CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_ARG_KS_TYPE_DESC.get(), ALLOWED_KEYSTORE_TYPE_VALUES);
        trustServerKeystoreType.addLongIdentifier("key-store-type", true);
        trustServerKeystoreType.addLongIdentifier("keystoreType", true);
        trustServerKeystoreType.addLongIdentifier("keystore-format", true);
        trustServerKeystoreType.addLongIdentifier("key-store-format", true);
        trustServerKeystoreType.addLongIdentifier("keystoreFormat", true);
        trustServerKeystoreType.addLongIdentifier("storetype", true);
        trustServerParser.addArgument((Argument)trustServerKeystoreType);
        StringArgument stringArgument3 = new StringArgument(null, "alias", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_ALIAS.get(), CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_ARG_ALIAS_DESC.get());
        trustServerAlias.addLongIdentifier("nickname", true);
        trustServerParser.addArgument((Argument)trustServerAlias);
        BooleanArgument booleanArgument3 = new BooleanArgument(null, "issuers-only", 1, CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_ARG_ISSUERS_ONLY_DESC.get());
        trustServerIssuersOnly.addLongIdentifier("issuersOnly", true);
        trustServerIssuersOnly.addLongIdentifier("issuer-certificates-only", true);
        trustServerIssuersOnly.addLongIdentifier("issuerCertificatesOnly", true);
        trustServerIssuersOnly.addLongIdentifier("only-issuers", true);
        trustServerIssuersOnly.addLongIdentifier("onlyIssuers", true);
        trustServerIssuersOnly.addLongIdentifier("only-issuer-certificates", true);
        trustServerIssuersOnly.addLongIdentifier("onlyIssuerCertificates", true);
        trustServerParser.addArgument((Argument)trustServerIssuersOnly);
        BooleanArgument booleanArgument4 = new BooleanArgument(null, "enableSSLDebugging", 1, CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_ARG_ENABLE_SSL_DEBUGGING_DESC.get());
        trustServerEnableSSLDebugging.addLongIdentifier("enableTLSDebugging", true);
        trustServerEnableSSLDebugging.addLongIdentifier("enableStartTLSDebugging", true);
        trustServerEnableSSLDebugging.addLongIdentifier("enable-ssl-debugging", true);
        trustServerEnableSSLDebugging.addLongIdentifier("enable-tls-debugging", true);
        trustServerEnableSSLDebugging.addLongIdentifier("enable-starttls-debugging", true);
        trustServerEnableSSLDebugging.addLongIdentifier("enable-start-tls-debugging", true);
        trustServerParser.addArgument((Argument)trustServerEnableSSLDebugging);
        this.addEnableSSLDebuggingArgument((BooleanArgument)trustServerEnableSSLDebugging);
        BooleanArgument booleanArgument5 = new BooleanArgument(null, "verbose", 1, CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_ARG_VERBOSE_DESC.get());
        trustServerParser.addArgument((Argument)trustServerVerbose);
        BooleanArgument booleanArgument6 = new BooleanArgument(null, "no-prompt", 1, CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_ARG_NO_PROMPT_DESC.get());
        trustServerNoPrompt.addLongIdentifier("noPrompt", true);
        trustServerParser.addArgument((Argument)trustServerNoPrompt);
        trustServerParser.addRequiredArgumentSet((Argument)trustServerKeystorePassword, (Argument)trustServerKeystorePasswordFile, new Argument[]{trustServerPromptForKeystorePassword});
        trustServerParser.addExclusiveArgumentSet((Argument)trustServerKeystorePassword, (Argument)trustServerKeystorePasswordFile, new Argument[]{trustServerPromptForKeystorePassword});
        LinkedHashMap linkedHashMap = new LinkedHashMap(StaticUtils.computeMapCapacity(2));
        trustServerExamples.put(new String[]{"trust-server-certificate", "--hostname", "ds.example.com", "--port", "636", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "truststore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "truststore.pin"), "--verbose"}, CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_EXAMPLE_1.get(ManageCertificates.getPlatformSpecificPath("config", "truststore")));
        trustServerExamples.put(new String[]{"trust-server-certificate", "--hostname", "ds.example.com", "--port", "389", "--use-ldap-start-tls", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "truststore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "truststore.pin"), "--issuers-only", "--alias", "ds-start-tls-cert", "--no-prompt"}, CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_EXAMPLE_2.get(ManageCertificates.getPlatformSpecificPath("config", "truststore")));
        SubCommand subCommand = new SubCommand("trust-server-certificate", CertMessages.INFO_MANAGE_CERTS_SC_TRUST_SERVER_DESC.get(), trustServerParser, (LinkedHashMap<String[], String>)trustServerExamples);
        trustServerSubCommand.addName("trustServerCertificate", true);
        trustServerSubCommand.addName("trust-server", true);
        trustServerSubCommand.addName("trustServer", true);
        parser.addSubCommand((SubCommand)trustServerSubCommand);
        ArgumentParser argumentParser = new ArgumentParser("check-certificate-usability", CertMessages.INFO_MANAGE_CERTS_SC_CHECK_USABILITY_DESC.get());
        FileArgument fileArgument3 = new FileArgument(null, "keystore", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_CHECK_USABILITY_ARG_KS_DESC.get(), true, true, true, false);
        checkUsabilityKeystore.addLongIdentifier("keystore-path", true);
        checkUsabilityKeystore.addLongIdentifier("keystorePath", true);
        checkUsabilityKeystore.addLongIdentifier("keystore-file", true);
        checkUsabilityKeystore.addLongIdentifier("keystoreFile", true);
        checkUsabilityParser.addArgument((Argument)checkUsabilityKeystore);
        StringArgument stringArgument4 = new StringArgument(null, "keystore-password", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_PASSWORD.get(), CertMessages.INFO_MANAGE_CERTS_SC_CHECK_USABILITY_ARG_KS_PW_DESC.get());
        checkUsabilityKeystorePassword.addLongIdentifier("keystorePassword", true);
        checkUsabilityKeystorePassword.addLongIdentifier("keystore-passphrase", true);
        checkUsabilityKeystorePassword.addLongIdentifier("keystorePassphrase", true);
        checkUsabilityKeystorePassword.addLongIdentifier("keystore-pin", true);
        checkUsabilityKeystorePassword.addLongIdentifier("keystorePIN", true);
        checkUsabilityKeystorePassword.addLongIdentifier("storepass", true);
        checkUsabilityKeystorePassword.setSensitive(true);
        checkUsabilityParser.addArgument((Argument)checkUsabilityKeystorePassword);
        FileArgument fileArgument4 = new FileArgument(null, "keystore-password-file", false, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_CHECK_USABILITY_ARG_KS_PW_FILE_DESC.get(), true, true, true, false);
        checkUsabilityKeystorePasswordFile.addLongIdentifier("keystorePasswordFile", true);
        checkUsabilityKeystorePasswordFile.addLongIdentifier("keystore-passphrase-file", true);
        checkUsabilityKeystorePasswordFile.addLongIdentifier("keystorePassphraseFile", true);
        checkUsabilityKeystorePasswordFile.addLongIdentifier("keystore-pin-file", true);
        checkUsabilityKeystorePasswordFile.addLongIdentifier("keystorePINFile", true);
        checkUsabilityParser.addArgument((Argument)checkUsabilityKeystorePasswordFile);
        BooleanArgument booleanArgument7 = new BooleanArgument(null, "prompt-for-keystore-password", CertMessages.INFO_MANAGE_CERTS_SC_CHECK_USABILITY_ARG_PROMPT_FOR_KS_PW_DESC.get());
        checkUsabilityPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassword", true);
        checkUsabilityPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-passphrase", true);
        checkUsabilityPromptForKeystorePassword.addLongIdentifier("promptForKeystorePassphrase", true);
        checkUsabilityPromptForKeystorePassword.addLongIdentifier("prompt-for-keystore-pin", true);
        checkUsabilityPromptForKeystorePassword.addLongIdentifier("promptForKeystorePIN", true);
        checkUsabilityParser.addArgument((Argument)checkUsabilityPromptForKeystorePassword);
        StringArgument stringArgument5 = new StringArgument(null, "keystore-type", false, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_TYPE.get(), CertMessages.INFO_MANAGE_CERTS_SC_CHECK_USABILITY_ARG_KS_TYPE_DESC.get(), ALLOWED_KEYSTORE_TYPE_VALUES);
        checkUsabilityKeystoreType.addLongIdentifier("key-store-type", true);
        checkUsabilityKeystoreType.addLongIdentifier("keystoreType", true);
        checkUsabilityKeystoreType.addLongIdentifier("keystore-format", true);
        checkUsabilityKeystoreType.addLongIdentifier("key-store-format", true);
        checkUsabilityKeystoreType.addLongIdentifier("keystoreFormat", true);
        checkUsabilityKeystoreType.addLongIdentifier("storetype", true);
        checkUsabilityParser.addArgument((Argument)checkUsabilityKeystoreType);
        StringArgument stringArgument6 = new StringArgument(null, "alias", true, 1, CertMessages.INFO_MANAGE_CERTS_PLACEHOLDER_ALIAS.get(), CertMessages.INFO_MANAGE_CERTS_SC_CHECK_USABILITY_ARG_ALIAS_DESC.get());
        checkUsabilityAlias.addLongIdentifier("nickname", true);
        checkUsabilityParser.addArgument((Argument)checkUsabilityAlias);
        BooleanArgument booleanArgument8 = new BooleanArgument(null, "allow-sha-1-signature-for-issuer-certificates", 1, CertMessages.INFO_MANAGE_CERTS_SC_CHECK_USABILITY_IGNORE_SHA1_WARNING_DESC.get());
        checkUsabilityIgnoreSHA1Signature.addLongIdentifier("allow-sha1-signature-for-issuer-certificates", true);
        checkUsabilityIgnoreSHA1Signature.addLongIdentifier("allowSHA1SignatureForIssuerCertificates", true);
        checkUsabilityParser.addArgument((Argument)checkUsabilityIgnoreSHA1Signature);
        checkUsabilityParser.addRequiredArgumentSet((Argument)checkUsabilityKeystorePassword, (Argument)checkUsabilityKeystorePasswordFile, new Argument[]{checkUsabilityPromptForKeystorePassword});
        checkUsabilityParser.addExclusiveArgumentSet((Argument)checkUsabilityKeystorePassword, (Argument)checkUsabilityKeystorePasswordFile, new Argument[]{checkUsabilityPromptForKeystorePassword});
        LinkedHashMap linkedHashMap2 = new LinkedHashMap(StaticUtils.computeMapCapacity(2));
        checkUsabilityExamples.put(new String[]{"check-certificate-usability", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--alias", "server-cert"}, CertMessages.INFO_MANAGE_CERTS_SC_CHECK_USABILITY_EXAMPLE_1.get(ManageCertificates.getPlatformSpecificPath("config", "keystore")));
        SubCommand subCommand2 = new SubCommand("check-certificate-usability", CertMessages.INFO_MANAGE_CERTS_SC_CHECK_USABILITY_DESC.get(), (ArgumentParser)checkUsabilityParser, (LinkedHashMap<String[], String>)checkUsabilityExamples);
        checkUsabilitySubCommand.addName("checkCertificateUsability", true);
        checkUsabilitySubCommand.addName("check-usability", true);
        checkUsabilitySubCommand.addName("checkUsability", true);
        parser.addSubCommand((SubCommand)checkUsabilitySubCommand);
        ArgumentParser argumentParser2 = new ArgumentParser("display-certificate-file", CertMessages.INFO_MANAGE_CERTS_SC_DISPLAY_CERT_DESC.get());
        FileArgument fileArgument5 = new FileArgument(null, "certificate-file", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_DISPLAY_CERT_ARG_FILE_DESC.get(), true, true, true, false);
        displayCertFile.addLongIdentifier("certificateFile", true);
        displayCertFile.addLongIdentifier("input-file", true);
        displayCertFile.addLongIdentifier("inputFile", true);
        displayCertFile.addLongIdentifier("file", true);
        displayCertFile.addLongIdentifier("filename", true);
        displayCertParser.addArgument((Argument)displayCertFile);
        BooleanArgument booleanArgument9 = new BooleanArgument(null, "verbose", 1, CertMessages.INFO_MANAGE_CERTS_SC_DISPLAY_CERT_ARG_VERBOSE_DESC.get());
        displayCertParser.addArgument((Argument)displayCertVerbose);
        BooleanArgument booleanArgument10 = new BooleanArgument(null, "display-keytool-command", 1, CertMessages.INFO_MANAGE_CERTS_SC_DISPLAY_CERT_ARG_DISPLAY_COMMAND_DESC.get());
        displayCertDisplayCommand.addLongIdentifier("displayKeytoolCommand", true);
        displayCertDisplayCommand.addLongIdentifier("show-keytool-command", true);
        displayCertDisplayCommand.addLongIdentifier("showKeytoolCommand", true);
        displayCertParser.addArgument((Argument)displayCertDisplayCommand);
        LinkedHashMap linkedHashMap3 = new LinkedHashMap(StaticUtils.computeMapCapacity(2));
        displayCertExamples.put(new String[]{"display-certificate-file", "--certificate-file", "certificate.pem"}, CertMessages.INFO_MANAGE_CERTS_SC_DISPLAY_CERT_EXAMPLE_1.get("certificate.pem"));
        displayCertExamples.put(new String[]{"display-certificate-file", "--certificate-file", "certificate.pem", "--verbose", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_SC_DISPLAY_CERT_EXAMPLE_2.get("certificate.pem"));
        SubCommand subCommand3 = new SubCommand("display-certificate-file", CertMessages.INFO_MANAGE_CERTS_SC_DISPLAY_CERT_DESC.get(), (ArgumentParser)displayCertParser, (LinkedHashMap<String[], String>)displayCertExamples);
        displayCertSubCommand.addName("displayCertificateFile", true);
        displayCertSubCommand.addName("display-certificate", true);
        displayCertSubCommand.addName("displayCertificate", true);
        displayCertSubCommand.addName("display-certificates", true);
        displayCertSubCommand.addName("displayCertificates", true);
        displayCertSubCommand.addName("show-certificate", true);
        displayCertSubCommand.addName("showCertificate", true);
        displayCertSubCommand.addName("show-certificate-file", true);
        displayCertSubCommand.addName("showCertificateFile", true);
        displayCertSubCommand.addName("show-certificates", true);
        displayCertSubCommand.addName("showCertificates", true);
        displayCertSubCommand.addName("print-certificate-file", true);
        displayCertSubCommand.addName("printCertificateFile", true);
        displayCertSubCommand.addName("print-certificate", true);
        displayCertSubCommand.addName("printCertificate", true);
        displayCertSubCommand.addName("print-certificates", true);
        displayCertSubCommand.addName("printCertificates", true);
        displayCertSubCommand.addName("printcert", true);
        parser.addSubCommand((SubCommand)displayCertSubCommand);
        ArgumentParser argumentParser3 = new ArgumentParser("display-certificate-signing-request-file", CertMessages.INFO_MANAGE_CERTS_SC_DISPLAY_CSR_DESC.get());
        FileArgument fileArgument6 = new FileArgument(null, "certificate-signing-request-file", true, 1, null, CertMessages.INFO_MANAGE_CERTS_SC_DISPLAY_CSR_ARG_FILE_DESC.get(), true, true, true, false);
        displayCSRFile.addLongIdentifier("certificateSigningRequestFile", true);
        displayCSRFile.addLongIdentifier("request-file", true);
        displayCSRFile.addLongIdentifier("requestFile", true);
        displayCSRFile.addLongIdentifier("input-file", true);
        displayCSRFile.addLongIdentifier("inputFile", true);
        displayCSRFile.addLongIdentifier("file", true);
        displayCSRFile.addLongIdentifier("filename", true);
        displayCSRParser.addArgument((Argument)displayCSRFile);
        BooleanArgument booleanArgument11 = new BooleanArgument(null, "verbose", 1, CertMessages.INFO_MANAGE_CERTS_SC_DISPLAY_CSR_ARG_VERBOSE_DESC.get());
        displayCSRParser.addArgument((Argument)displayCSRVerbose);
        BooleanArgument booleanArgument12 = new BooleanArgument(null, "display-keytool-command", 1, CertMessages.INFO_MANAGE_CERTS_SC_DISPLAY_CSR_ARG_DISPLAY_COMMAND_DESC.get());
        displayCSRDisplayCommand.addLongIdentifier("displayKeytoolCommand", true);
        displayCSRDisplayCommand.addLongIdentifier("show-keytool-command", true);
        displayCSRDisplayCommand.addLongIdentifier("showKeytoolCommand", true);
        displayCSRParser.addArgument((Argument)displayCSRDisplayCommand);
        LinkedHashMap linkedHashMap4 = new LinkedHashMap(StaticUtils.computeMapCapacity(1));
        displayCSRExamples.put(new String[]{"display-certificate-signing-request-file", "--certificate-signing-request-file", "server-cert.csr", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_SC_DISPLAY_CSR_EXAMPLE_1.get("server-cert.csr"));
        SubCommand subCommand4 = new SubCommand("display-certificate-signing-request-file", CertMessages.INFO_MANAGE_CERTS_SC_DISPLAY_CSR_DESC.get(), (ArgumentParser)displayCSRParser, (LinkedHashMap<String[], String>)displayCSRExamples);
        displayCSRSubCommand.addName("displayCertificateSigningRequestFile", true);
        displayCSRSubCommand.addName("display-certificate-signing-request", true);
        displayCSRSubCommand.addName("displayCertificateSigningRequest", true);
        displayCSRSubCommand.addName("display-certificate-request-file", true);
        displayCSRSubCommand.addName("displayCertificateRequestFile", true);
        displayCSRSubCommand.addName("display-certificate-request", true);
        displayCSRSubCommand.addName("displayCertificateRequest", true);
        displayCSRSubCommand.addName("display-csr-file", true);
        displayCSRSubCommand.addName("displayCSRFile", true);
        displayCSRSubCommand.addName("display-csr", true);
        displayCSRSubCommand.addName("displayCSR", true);
        displayCSRSubCommand.addName("show-certificate-signing-request-file", true);
        displayCSRSubCommand.addName("showCertificateSigningRequestFile", true);
        displayCSRSubCommand.addName("show-certificate-signing-request", true);
        displayCSRSubCommand.addName("showCertificateSigningRequest", true);
        displayCSRSubCommand.addName("show-certificate-request-file", true);
        displayCSRSubCommand.addName("showCertificateRequestFile", true);
        displayCSRSubCommand.addName("show-certificate-request", true);
        displayCSRSubCommand.addName("showCertificateRequest", true);
        displayCSRSubCommand.addName("show-csr-file", true);
        displayCSRSubCommand.addName("showCSRFile", true);
        displayCSRSubCommand.addName("show-csr", true);
        displayCSRSubCommand.addName("showCSR", true);
        displayCSRSubCommand.addName("print-certificate-signing-request-file", true);
        displayCSRSubCommand.addName("printCertificateSigningRequestFile", true);
        displayCSRSubCommand.addName("print-certificate-signing-request", true);
        displayCSRSubCommand.addName("printCertificateSigningRequest", true);
        displayCSRSubCommand.addName("print-certificate-request-file", true);
        displayCSRSubCommand.addName("printCertificateRequestFile", true);
        displayCSRSubCommand.addName("print-certificate-request", true);
        displayCSRSubCommand.addName("printCertificateRequest", true);
        displayCSRSubCommand.addName("print-csr-file", true);
        displayCSRSubCommand.addName("printCSRFile", true);
        displayCSRSubCommand.addName("print-csr", true);
        displayCSRSubCommand.addName("printCSR", true);
        displayCSRSubCommand.addName("printcertreq", true);
        parser.addSubCommand((SubCommand)displayCSRSubCommand);
    }

    @NotNull
    private static String getPlatformSpecificPath(String ... pathElements) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < pathElements.length; ++i) {
            if (i > 0) {
                buffer.append(File.separatorChar);
            }
            buffer.append(pathElements[i]);
        }
        return buffer.toString();
    }

    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        SubCommand selectedSubCommand = this.globalParser.getSelectedSubCommand();
        if (selectedSubCommand == null) {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_NO_SUBCOMMAND.get());
            return ResultCode.PARAM_ERROR;
        }
        this.subCommandParser = selectedSubCommand.getArgumentParser();
        if (selectedSubCommand.hasName("list-certificates")) {
            return this.doListCertificates();
        }
        if (selectedSubCommand.hasName("export-certificate")) {
            return this.doExportCertificate();
        }
        if (selectedSubCommand.hasName("export-private-key")) {
            return this.doExportPrivateKey();
        }
        if (selectedSubCommand.hasName("import-certificate")) {
            return this.doImportCertificate();
        }
        if (selectedSubCommand.hasName("delete-certificate")) {
            return this.doDeleteCertificate();
        }
        if (selectedSubCommand.hasName("generate-self-signed-certificate")) {
            return this.doGenerateOrSignCertificateOrCSR();
        }
        if (selectedSubCommand.hasName("generate-certificate-signing-request")) {
            return this.doGenerateOrSignCertificateOrCSR();
        }
        if (selectedSubCommand.hasName("sign-certificate-signing-request")) {
            return this.doGenerateOrSignCertificateOrCSR();
        }
        if (selectedSubCommand.hasName("change-certificate-alias")) {
            return this.doChangeCertificateAlias();
        }
        if (selectedSubCommand.hasName("change-keystore-password")) {
            return this.doChangeKeystorePassword();
        }
        if (selectedSubCommand.hasName("change-private-key-password")) {
            return this.doChangePrivateKeyPassword();
        }
        if (selectedSubCommand.hasName("copy-keystore")) {
            return this.doCopyKeystore();
        }
        if (selectedSubCommand.hasName("retrieve-server-certificate")) {
            return this.doRetrieveServerCertificate();
        }
        if (selectedSubCommand.hasName("trust-server-certificate")) {
            return this.doTrustServerCertificate();
        }
        if (selectedSubCommand.hasName("check-certificate-usability")) {
            return this.doCheckCertificateUsability();
        }
        if (selectedSubCommand.hasName("display-certificate-file")) {
            return this.doDisplayCertificateFile();
        }
        if (selectedSubCommand.hasName("display-certificate-signing-request-file")) {
            return this.doDisplayCertificateSigningRequestFile();
        }
        this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_UNKNOWN_SUBCOMMAND.get(selectedSubCommand.getPrimaryName()));
        return ResultCode.PARAM_ERROR;
    }

    @NotNull
    private ResultCode doListCertificates() {
        Enumeration<String> aliasEnumeration;
        KeyStore keystore;
        char[] keystorePassword;
        String keystoreType;
        Map<String, String> missingAliases;
        Set aliases;
        BooleanArgument displayPEMArgument = this.subCommandParser.getBooleanArgument("display-pem-certificate");
        boolean displayPEM = displayPEMArgument != null && displayPEMArgument.isPresent();
        BooleanArgument verboseArgument = this.subCommandParser.getBooleanArgument("verbose");
        boolean verbose = verboseArgument != null && verboseArgument.isPresent();
        StringArgument aliasArgument = this.subCommandParser.getStringArgument("alias");
        if (aliasArgument == null || !aliasArgument.isPresent()) {
            aliases = Collections.emptySet();
            missingAliases = Collections.emptyMap();
        } else {
            List<String> values = aliasArgument.getValues();
            aliases = new LinkedHashSet(StaticUtils.computeMapCapacity(values.size()));
            missingAliases = new LinkedHashMap(StaticUtils.computeMapCapacity(values.size()));
            for (String alias : values) {
                String lowerAlias = StaticUtils.toLowerCase(alias);
                aliases.add(StaticUtils.toLowerCase(lowerAlias));
                missingAliases.put(lowerAlias, alias);
            }
        }
        File keystorePath = this.getKeystorePath();
        try {
            keystoreType = this.inferKeystoreType(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            keystorePassword = this.getKeystorePassword(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        BooleanArgument displayKeytoolCommandArgument = this.subCommandParser.getBooleanArgument("display-keytool-command");
        if (displayKeytoolCommandArgument != null && displayKeytoolCommandArgument.isPresent()) {
            ArrayList<String> keytoolArgs = new ArrayList<String>(10);
            keytoolArgs.add("-list");
            keytoolArgs.add("-keystore");
            keytoolArgs.add(keystorePath.getAbsolutePath());
            keytoolArgs.add("-storetype");
            keytoolArgs.add(keystoreType);
            if (keystorePassword != null) {
                keytoolArgs.add("-storepass");
                keytoolArgs.add("*****REDACTED*****");
            }
            for (String alias : missingAliases.values()) {
                keytoolArgs.add("-alias");
                keytoolArgs.add(alias);
            }
            if (displayPEM) {
                keytoolArgs.add("-rfc");
            }
            if (verbose) {
                keytoolArgs.add("-v");
            }
            this.displayKeytoolCommand(keytoolArgs);
        }
        try {
            keystore = ManageCertificates.getKeystore(keystoreType, keystorePath, keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_LIST_KEYSTORE_TYPE.get(keystoreType));
        try {
            aliasEnumeration = keystore.aliases();
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.err(new Object[0]);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_LIST_CERTS_CANNOT_GET_ALIASES.get(keystorePath.getAbsolutePath()));
            e.printStackTrace(this.getErr());
            return ResultCode.LOCAL_ERROR;
        }
        int listedCount = 0;
        ResultCode resultCode = ResultCode.SUCCESS;
        while (aliasEnumeration.hasMoreElements()) {
            X509Certificate[] certificateChain;
            String alias = aliasEnumeration.nextElement();
            String lowerAlias = StaticUtils.toLowerCase(alias);
            if (!aliases.isEmpty() && missingAliases.remove(lowerAlias) == null) continue;
            try {
                Certificate[] chain = keystore.getCertificateChain(alias);
                if (chain == null || chain.length == 0) {
                    Certificate cert = keystore.getCertificate(alias);
                    if (cert == null) continue;
                    chain = new Certificate[]{cert};
                }
                certificateChain = new X509Certificate[chain.length];
                for (int i = 0; i < chain.length; ++i) {
                    certificateChain[i] = new X509Certificate(chain[i].getEncoded());
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_LIST_CERTS_ERROR_GETTING_CERT.get(alias, StaticUtils.getExceptionMessage(e)));
                resultCode = ResultCode.LOCAL_ERROR;
                continue;
            }
            ++listedCount;
            for (int i = 0; i < certificateChain.length; ++i) {
                this.out(new Object[0]);
                if (certificateChain.length == 1) {
                    this.out(CertMessages.INFO_MANAGE_CERTS_LIST_CERTS_LABEL_ALIAS_WITHOUT_CHAIN.get(alias));
                } else {
                    this.out(CertMessages.INFO_MANAGE_CERTS_LIST_CERTS_LABEL_ALIAS_WITH_CHAIN.get(alias, i + 1, certificateChain.length));
                }
                this.printCertificate(certificateChain[i], "", verbose);
                if (i == 0) {
                    if (ManageCertificates.hasKeyAlias(keystore, alias)) {
                        this.out(CertMessages.INFO_MANAGE_CERTS_LIST_CERTS_LABEL_HAS_PK_YES.get());
                    } else {
                        this.out(CertMessages.INFO_MANAGE_CERTS_LIST_CERTS_LABEL_HAS_PK_NO.get());
                    }
                }
                CertException signatureVerificationException = null;
                if (certificateChain[i].isSelfSigned()) {
                    try {
                        certificateChain[i].verifySignature(null);
                    }
                    catch (CertException ce) {
                        Debug.debugException(ce);
                        signatureVerificationException = ce;
                    }
                } else {
                    X509Certificate issuerCertificate = null;
                    try {
                        AtomicReference<KeyStore> jvmDefaultTrustStoreRef = new AtomicReference<KeyStore>();
                        AtomicReference<DN> missingIssuerRef = new AtomicReference<DN>();
                        issuerCertificate = ManageCertificates.getIssuerCertificate(certificateChain[i], keystore, jvmDefaultTrustStoreRef, missingIssuerRef);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                    if (issuerCertificate == null) {
                        signatureVerificationException = new CertException(CertMessages.ERR_MANAGE_CERTS_LIST_CERTS_VERIFY_SIGNATURE_NO_ISSUER.get(certificateChain[i].getIssuerDN()));
                    } else {
                        try {
                            certificateChain[i].verifySignature(issuerCertificate);
                        }
                        catch (CertException ce) {
                            Debug.debugException(ce);
                            signatureVerificationException = ce;
                        }
                    }
                }
                if (signatureVerificationException == null) {
                    this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_LIST_CERTS_SIGNATURE_VALID.get());
                } else {
                    this.wrapErr(0, WRAP_COLUMN, signatureVerificationException.getMessage());
                }
                if (!displayPEM) continue;
                this.out(CertMessages.INFO_MANAGE_CERTS_LIST_CERTS_LABEL_PEM.get());
                ManageCertificates.writePEMCertificate(this.getOut(), certificateChain[i].getX509CertificateBytes());
            }
        }
        if (!missingAliases.isEmpty()) {
            this.err(new Object[0]);
            for (String missingAlias : missingAliases.values()) {
                this.wrapErr(0, WRAP_COLUMN, CertMessages.WARN_MANAGE_CERTS_LIST_CERTS_ALIAS_NOT_IN_KS.get(missingAlias, keystorePath.getAbsolutePath()));
                resultCode = ResultCode.PARAM_ERROR;
            }
        } else if (listedCount == 0) {
            this.out(new Object[0]);
            if (keystorePassword == null) {
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_LIST_CERTS_NO_CERTS_OR_KEYS_WITHOUT_PW.get());
            } else {
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_LIST_CERTS_NO_CERTS_OR_KEYS_WITH_PW.get());
            }
        }
        return resultCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ResultCode doExportCertificate() {
        PrintStream printStream;
        X509Certificate[] certificatesToExport;
        KeyStore keystore;
        char[] keystorePassword;
        String keystoreType;
        String format;
        StringArgument aliasArgument = this.subCommandParser.getStringArgument("alias");
        String alias = aliasArgument.getValue();
        BooleanArgument exportChainArgument = this.subCommandParser.getBooleanArgument("export-certificate-chain");
        boolean exportChain = exportChainArgument != null && exportChainArgument.isPresent();
        BooleanArgument separateFilePerCertificateArgument = this.subCommandParser.getBooleanArgument("separate-file-per-certificate");
        boolean separateFilePerCertificate = separateFilePerCertificateArgument != null && separateFilePerCertificateArgument.isPresent();
        boolean exportPEM = true;
        StringArgument outputFormatArgument = this.subCommandParser.getStringArgument("output-format");
        if (outputFormatArgument != null && outputFormatArgument.isPresent() && ((format = outputFormatArgument.getValue().toLowerCase()).equals("der") || format.equals("binary") || format.equals("bin"))) {
            exportPEM = false;
        }
        File outputFile = null;
        FileArgument outputFileArgument = this.subCommandParser.getFileArgument("output-file");
        if (outputFileArgument != null && outputFileArgument.isPresent()) {
            outputFile = outputFileArgument.getValue();
        }
        if (outputFile == null && !exportPEM) {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_EXPORT_CERT_NO_FILE_WITH_DER.get());
            return ResultCode.PARAM_ERROR;
        }
        File keystorePath = this.getKeystorePath();
        try {
            keystoreType = this.inferKeystoreType(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            keystorePassword = this.getKeystorePassword(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        BooleanArgument displayKeytoolCommandArgument = this.subCommandParser.getBooleanArgument("display-keytool-command");
        if (displayKeytoolCommandArgument != null && displayKeytoolCommandArgument.isPresent()) {
            ArrayList<String> keytoolArgs = new ArrayList<String>(10);
            keytoolArgs.add("-list");
            keytoolArgs.add("-keystore");
            keytoolArgs.add(keystorePath.getAbsolutePath());
            keytoolArgs.add("-storetype");
            keytoolArgs.add(keystoreType);
            if (keystorePassword != null) {
                keytoolArgs.add("-storepass");
                keytoolArgs.add("*****REDACTED*****");
            }
            keytoolArgs.add("-alias");
            keytoolArgs.add(alias);
            if (exportPEM) {
                keytoolArgs.add("-rfc");
            }
            if (outputFile != null) {
                keytoolArgs.add("-file");
                keytoolArgs.add(outputFile.getAbsolutePath());
            }
            this.displayKeytoolCommand(keytoolArgs);
        }
        try {
            keystore = ManageCertificates.getKeystore(keystoreType, keystorePath, keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        DN missingIssuerDN = null;
        if (exportChain) {
            try {
                AtomicReference<DN> missingIssuerRef = new AtomicReference<DN>();
                certificatesToExport = ManageCertificates.getCertificateChain(alias, keystore, missingIssuerRef);
                missingIssuerDN = missingIssuerRef.get();
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.wrapErr(0, WRAP_COLUMN, le.getMessage());
                return le.getResultCode();
            }
        }
        try {
            Certificate cert = keystore.getCertificate(alias);
            certificatesToExport = cert == null ? new X509Certificate[]{} : new X509Certificate[]{new X509Certificate(cert.getEncoded())};
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_EXPORT_CERT_ERROR_GETTING_CERT.get(alias, keystorePath.getAbsolutePath()));
            e.printStackTrace(this.getErr());
            return ResultCode.LOCAL_ERROR;
        }
        if (certificatesToExport.length == 0) {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_EXPORT_CERT_NO_CERT_WITH_ALIAS.get(alias, keystorePath.getAbsolutePath()));
            return ResultCode.PARAM_ERROR;
        }
        int fileCounter = 1;
        String filename = null;
        if (outputFile == null) {
            printStream = this.getOut();
        } else {
            try {
                filename = certificatesToExport.length > 1 && separateFilePerCertificate ? outputFile.getAbsolutePath() + '.' + fileCounter : outputFile.getAbsolutePath();
                printStream = new PrintStream(filename);
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_EXPORT_CERT_ERROR_OPENING_OUTPUT.get(outputFile.getAbsolutePath()));
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
        }
        try {
            for (X509Certificate certificate : certificatesToExport) {
                try {
                    if (separateFilePerCertificate && certificatesToExport.length > 1) {
                        if (fileCounter > 1) {
                            printStream.close();
                            filename = outputFile.getAbsolutePath() + '.' + fileCounter;
                            printStream = new PrintStream(filename);
                        }
                        ++fileCounter;
                    }
                    if (exportPEM) {
                        ManageCertificates.writePEMCertificate(printStream, certificate.getX509CertificateBytes());
                    } else {
                        printStream.write(certificate.getX509CertificateBytes());
                    }
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_EXPORT_CERT_ERROR_WRITING_CERT.get(alias, certificate.getSubjectDN()));
                    e.printStackTrace(this.getErr());
                    ResultCode resultCode = ResultCode.LOCAL_ERROR;
                    printStream.flush();
                    if (outputFile != null) {
                        printStream.close();
                    }
                    return resultCode;
                }
                if (outputFile == null) continue;
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_EXPORT_CERT_EXPORT_SUCCESSFUL.get(filename));
                this.printCertificate(certificate, "", false);
            }
        }
        finally {
            printStream.flush();
            if (outputFile != null) {
                printStream.close();
            }
        }
        if (missingIssuerDN != null) {
            this.err(new Object[0]);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.WARN_MANAGE_CERTS_EXPORT_CERT_MISSING_CERT_IN_CHAIN.get(missingIssuerDN, keystorePath.getAbsolutePath()));
            return ResultCode.NO_SUCH_OBJECT;
        }
        return ResultCode.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ResultCode doExportPrivateKey() {
        PrintStream printStream;
        PrivateKey privateKey;
        char[] encryptionPassword;
        char[] privateKeyPassword;
        KeyStore keystore;
        char[] keystorePassword;
        String keystoreType;
        String format;
        StringArgument aliasArgument = this.subCommandParser.getStringArgument("alias");
        String alias = aliasArgument.getValue();
        boolean exportPEM = true;
        StringArgument outputFormatArgument = this.subCommandParser.getStringArgument("output-format");
        if (outputFormatArgument != null && outputFormatArgument.isPresent() && ((format = outputFormatArgument.getValue().toLowerCase()).equals("der") || format.equals("binary") || format.equals("bin"))) {
            exportPEM = false;
        }
        File outputFile = null;
        FileArgument outputFileArgument = this.subCommandParser.getFileArgument("output-file");
        if (outputFileArgument != null && outputFileArgument.isPresent()) {
            outputFile = outputFileArgument.getValue();
        }
        if (outputFile == null && !exportPEM) {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_EXPORT_KEY_NO_FILE_WITH_DER.get());
            return ResultCode.PARAM_ERROR;
        }
        File keystorePath = this.getKeystorePath();
        try {
            keystoreType = this.inferKeystoreType(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            keystorePassword = this.getKeystorePassword(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            keystore = ManageCertificates.getKeystore(keystoreType, keystorePath, keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            privateKeyPassword = this.getPrivateKeyPassword(keystore, alias, keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            encryptionPassword = this.getPrivateKeyEncryptionPassword(false);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            Key key = keystore.getKey(alias, privateKeyPassword);
            if (key == null) {
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_EXPORT_KEY_NO_KEY_WITH_ALIAS.get(alias, keystorePath.getAbsolutePath()));
                return ResultCode.PARAM_ERROR;
            }
            privateKey = (PrivateKey)key;
        }
        catch (UnrecoverableKeyException e) {
            Debug.debugException(e);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_EXPORT_KEY_WRONG_KEY_PW.get(alias, keystorePath.getAbsolutePath()));
            return ResultCode.PARAM_ERROR;
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_EXPORT_KEY_ERROR_GETTING_KEY.get(alias, keystorePath.getAbsolutePath()));
            e.printStackTrace(this.getErr());
            return ResultCode.LOCAL_ERROR;
        }
        if (outputFile == null) {
            printStream = this.getOut();
        } else {
            try {
                printStream = new PrintStream(outputFile);
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_EXPORT_KEY_ERROR_OPENING_OUTPUT.get(outputFile.getAbsolutePath()));
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
        }
        try {
            try {
                if (exportPEM) {
                    ManageCertificates.writePEMPrivateKey(printStream, privateKey.getEncoded(), encryptionPassword);
                } else if (encryptionPassword == null) {
                    printStream.write(privateKey.getEncoded());
                } else {
                    byte[] encryptedPrivateKey = PKCS8EncryptionHandler.encryptPrivateKey(privateKey.getEncoded(), encryptionPassword, new PKCS8EncryptionProperties());
                    printStream.write(encryptedPrivateKey);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_EXPORT_KEY_ERROR_WRITING_KEY.get(alias));
                e.printStackTrace(this.getErr());
                ResultCode resultCode = ResultCode.LOCAL_ERROR;
                printStream.flush();
                if (outputFile != null) {
                    printStream.close();
                }
                return resultCode;
            }
            if (outputFile != null) {
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_EXPORT_KEY_EXPORT_SUCCESSFUL.get());
            }
        }
        finally {
            printStream.flush();
            if (outputFile != null) {
                printStream.close();
            }
        }
        return ResultCode.SUCCESS;
    }

    @NotNull
    private ResultCode doImportCertificate() {
        ArrayList<X509Certificate> chain;
        char[] privateKeyPassword;
        KeyStore keystore;
        PKCS8PrivateKey privateKey;
        char[] encryptionPassword;
        char[] keystorePassword;
        String keystoreType;
        StringArgument aliasArgument = this.subCommandParser.getStringArgument("alias");
        String alias = aliasArgument.getValue();
        FileArgument certificateFileArgument = this.subCommandParser.getFileArgument("certificate-file");
        List<File> certFiles = certificateFileArgument.getValues();
        FileArgument privateKeyFileArgument = this.subCommandParser.getFileArgument("private-key-file");
        File privateKeyFile = privateKeyFileArgument != null && privateKeyFileArgument.isPresent() ? privateKeyFileArgument.getValue() : null;
        BooleanArgument noPromptArgument = this.subCommandParser.getBooleanArgument("no-prompt");
        boolean noPrompt = noPromptArgument != null && noPromptArgument.isPresent();
        File keystorePath = this.getKeystorePath();
        boolean isNewKeystore = !keystorePath.exists();
        try {
            keystoreType = this.inferKeystoreType(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            keystorePassword = this.getKeystorePassword(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(5);
        for (File certFile : certFiles) {
            try {
                List<X509Certificate> certs = ManageCertificates.readCertificatesFromFile(certFile);
                if (certs.isEmpty()) {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_NO_CERTS_IN_FILE.get(certFile.getAbsolutePath()));
                    return ResultCode.PARAM_ERROR;
                }
                certList.addAll(certs);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.wrapErr(0, WRAP_COLUMN, le.getMessage());
                return le.getResultCode();
            }
        }
        try {
            encryptionPassword = this.getPrivateKeyEncryptionPassword(true);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        if (privateKeyFile == null) {
            privateKey = null;
        } else {
            try {
                privateKey = ManageCertificates.readPrivateKeyFromFile(privateKeyFile, encryptionPassword);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.wrapErr(0, WRAP_COLUMN, le.getMessage());
                return le.getResultCode();
            }
        }
        try {
            keystore = ManageCertificates.getKeystore(keystoreType, keystorePath, keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            privateKeyPassword = this.getPrivateKeyPassword(keystore, alias, keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        BooleanArgument displayKeytoolCommandArgument = this.subCommandParser.getBooleanArgument("display-keytool-command");
        if (displayKeytoolCommandArgument != null && displayKeytoolCommandArgument.isPresent()) {
            ArrayList<String> keytoolArgs = new ArrayList<String>(10);
            keytoolArgs.add("-import");
            keytoolArgs.add("-keystore");
            keytoolArgs.add(keystorePath.getAbsolutePath());
            keytoolArgs.add("-storetype");
            keytoolArgs.add(keystoreType);
            keytoolArgs.add("-storepass");
            keytoolArgs.add("*****REDACTED*****");
            keytoolArgs.add("-keypass");
            keytoolArgs.add("*****REDACTED*****");
            keytoolArgs.add("-alias");
            keytoolArgs.add(alias);
            keytoolArgs.add("-file");
            keytoolArgs.add(certFiles.get(0).getAbsolutePath());
            keytoolArgs.add("-trustcacerts");
            this.displayKeytoolCommand(keytoolArgs);
        }
        Iterator certIterator = certList.iterator();
        X509Certificate subjectCert = (X509Certificate)certIterator.next();
        while (true) {
            StringBuilder notIssuerReason;
            if (subjectCert.isSelfSigned() && certIterator.hasNext()) {
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_SELF_SIGNED_NOT_LAST.get(subjectCert.getSubjectDN()));
                return ResultCode.PARAM_ERROR;
            }
            if (!certIterator.hasNext()) break;
            X509Certificate issuerCert = (X509Certificate)certIterator.next();
            if (!issuerCert.isIssuerFor(subjectCert, notIssuerReason = new StringBuilder())) {
                if (Arrays.equals(issuerCert.getX509CertificateBytes(), subjectCert.getX509CertificateBytes())) {
                    certIterator.remove();
                } else {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_NEXT_NOT_ISSUER_OF_PREV.get(notIssuerReason.toString()));
                    return ResultCode.PARAM_ERROR;
                }
            }
            subjectCert = issuerCert;
        }
        if (((X509Certificate)certList.get(certList.size() - 1)).isSelfSigned()) {
            chain = certList;
        } else {
            chain = new ArrayList(certList.size() + 5);
            chain.addAll(certList);
            AtomicReference<KeyStore> jvmDefaultTrustStoreRef = new AtomicReference<KeyStore>();
            AtomicReference<DN> missingIssuerRef = new AtomicReference<DN>();
            X509Certificate c = (X509Certificate)certList.get(certList.size() - 1);
            while (!c.isSelfSigned()) {
                X509Certificate issuer;
                try {
                    issuer = ManageCertificates.getIssuerCertificate(c, keystore, jvmDefaultTrustStoreRef, missingIssuerRef);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_CANNOT_GET_ISSUER.get(c.getIssuerDN()));
                    e.printStackTrace(this.getErr());
                    return ResultCode.LOCAL_ERROR;
                }
                if (issuer == null) {
                    byte[] authorityKeyIdentifier = ManageCertificates.getAuthorityKeyIdentifier(c);
                    if (privateKey != null || ManageCertificates.hasKeyAlias(keystore, alias)) {
                        if (authorityKeyIdentifier == null) {
                            this.err(new Object[0]);
                            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_NO_ISSUER_NO_AKI.get(c.getIssuerDN()));
                        } else {
                            this.err(new Object[0]);
                            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_NO_ISSUER_WITH_AKI.get(c.getIssuerDN(), ManageCertificates.toColonDelimitedHex(authorityKeyIdentifier)));
                        }
                        return ResultCode.PARAM_ERROR;
                    }
                    if (authorityKeyIdentifier == null) {
                        this.err(new Object[0]);
                        this.wrapErr(0, WRAP_COLUMN, CertMessages.WARN_MANAGE_CERTS_IMPORT_CERT_NO_ISSUER_NO_AKI.get(c.getIssuerDN()));
                        break;
                    }
                    this.err(new Object[0]);
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.WARN_MANAGE_CERTS_IMPORT_CERT_NO_ISSUER_WITH_AKI.get(c.getIssuerDN(), ManageCertificates.toColonDelimitedHex(authorityKeyIdentifier)));
                    break;
                }
                chain.add(issuer);
                c = issuer;
            }
        }
        if (privateKey != null) {
            PrivateKey javaPrivateKey;
            if (ManageCertificates.hasKeyAlias(keystore, alias)) {
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_WITH_PK_KEY_ALIAS_CONFLICT.get(alias));
                return ResultCode.PARAM_ERROR;
            }
            if (ManageCertificates.hasCertificateAlias(keystore, alias)) {
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_WITH_PK_CERT_ALIAS_CONFLICT.get(alias));
                return ResultCode.PARAM_ERROR;
            }
            try {
                javaPrivateKey = privateKey.toPrivateKey();
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_ERROR_CONVERTING_KEY.get(privateKeyFile.getAbsolutePath()));
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
            Certificate[] javaCertificateChain = new Certificate[chain.size()];
            for (int i = 0; i < javaCertificateChain.length; ++i) {
                X509Certificate c = (X509Certificate)chain.get(i);
                try {
                    javaCertificateChain[i] = c.toCertificate();
                    continue;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_ERROR_CONVERTING_CERT.get(c.getSubjectDN()));
                    e.printStackTrace(this.getErr());
                    return ResultCode.LOCAL_ERROR;
                }
            }
            if (!noPrompt) {
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_IMPORT_CERT_CONFIRM_IMPORT_CHAIN_NEW_KEY.get(alias));
                for (X509Certificate c : chain) {
                    this.out(new Object[0]);
                    this.printCertificate(c, "", false);
                }
                this.out(new Object[0]);
                try {
                    if (!this.promptForYesNo(CertMessages.INFO_MANAGE_CERTS_IMPORT_CERT_PROMPT_IMPORT_CHAIN.get())) {
                        this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_CANCELED.get());
                        return ResultCode.USER_CANCELED;
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    this.err(new Object[0]);
                    this.wrapErr(0, WRAP_COLUMN, le.getMessage());
                    return le.getResultCode();
                }
            }
            try {
                keystore.setKeyEntry(alias, javaPrivateKey, privateKeyPassword, javaCertificateChain);
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_ERROR_UPDATING_KS_WITH_CHAIN.get(alias));
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
            try {
                ManageCertificates.writeKeystore(keystore, keystorePath, keystorePassword);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.wrapErr(0, WRAP_COLUMN, le.getMessage());
                return le.getResultCode();
            }
            if (isNewKeystore) {
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_IMPORT_CERT_CREATED_KEYSTORE.get(ManageCertificates.getUserFriendlyKeystoreType(keystoreType)));
            }
            this.out(new Object[0]);
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_IMPORT_CERT_IMPORTED_CHAIN_WITH_PK.get());
            return ResultCode.SUCCESS;
        }
        if (ManageCertificates.hasCertificateAlias(keystore, alias)) {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_WITH_CONFLICTING_CERT_ALIAS.get(alias));
            return ResultCode.PARAM_ERROR;
        }
        if (ManageCertificates.hasKeyAlias(keystore, alias)) {
            X509Certificate existingEndCertificate;
            PrivateKey existingPrivateKey;
            try {
                existingPrivateKey = (PrivateKey)keystore.getKey(alias, privateKeyPassword);
                Certificate[] existingChain = keystore.getCertificateChain(alias);
                existingEndCertificate = new X509Certificate(existingChain[0].getEncoded());
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_INTO_KEY_ALIAS_CANNOT_GET_KEY.get(alias));
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
            boolean[] existingPublicKeyBits = existingEndCertificate.getEncodedPublicKey().getBits();
            boolean[] newPublicKeyBits = ((X509Certificate)chain.get(0)).getEncodedPublicKey().getBits();
            if (!Arrays.equals(existingPublicKeyBits, newPublicKeyBits)) {
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_INTO_KEY_ALIAS_KEY_MISMATCH.get(alias));
                return ResultCode.PARAM_ERROR;
            }
            Certificate[] newChain = new Certificate[chain.size()];
            for (int i = 0; i < chain.size(); ++i) {
                X509Certificate c = (X509Certificate)chain.get(i);
                try {
                    newChain[i] = c.toCertificate();
                    continue;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_ERROR_CONVERTING_CERT.get(c.getSubjectDN()));
                    e.printStackTrace(this.getErr());
                    return ResultCode.LOCAL_ERROR;
                }
            }
            if (!noPrompt) {
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_IMPORT_CERT_CONFIRM_IMPORT_CHAIN_EXISTING_KEY.get(alias));
                for (X509Certificate c : chain) {
                    this.out(new Object[0]);
                    this.printCertificate(c, "", false);
                }
                this.out(new Object[0]);
                try {
                    if (!this.promptForYesNo(CertMessages.INFO_MANAGE_CERTS_IMPORT_CERT_PROMPT_IMPORT_CHAIN.get())) {
                        this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_CANCELED.get());
                        return ResultCode.USER_CANCELED;
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    this.err(new Object[0]);
                    this.wrapErr(0, WRAP_COLUMN, le.getMessage());
                    return le.getResultCode();
                }
            }
            try {
                keystore.setKeyEntry(alias, existingPrivateKey, privateKeyPassword, newChain);
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_ERROR_UPDATING_KS_WITH_CHAIN.get(alias));
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
            try {
                ManageCertificates.writeKeystore(keystore, keystorePath, keystorePassword);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.wrapErr(0, WRAP_COLUMN, le.getMessage());
                return le.getResultCode();
            }
            this.out(new Object[0]);
            if (isNewKeystore) {
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_IMPORT_CERT_CREATED_KEYSTORE.get(ManageCertificates.getUserFriendlyKeystoreType(keystoreType)));
            }
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_IMPORT_CERT_IMPORTED_CHAIN_WITHOUT_PK.get());
            return ResultCode.SUCCESS;
        }
        LinkedHashMap<String, X509Certificate> certMap = new LinkedHashMap<String, X509Certificate>(StaticUtils.computeMapCapacity(certList.size()));
        for (int i = 0; i < certList.size(); ++i) {
            Certificate javaCertificate;
            X509Certificate x509Certificate = (X509Certificate)certList.get(i);
            try {
                javaCertificate = x509Certificate.toCertificate();
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_ERROR_CONVERTING_CERT.get(x509Certificate.getSubjectDN()));
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
            String certAlias = i == 0 ? alias : (certList.size() > 2 ? alias + "-issuer-" + i : alias + "-issuer");
            certMap.put(certAlias, x509Certificate);
            if (ManageCertificates.hasKeyAlias(keystore, certAlias) || ManageCertificates.hasCertificateAlias(keystore, certAlias)) {
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_WITH_CONFLICTING_ISSUER_ALIAS.get(x509Certificate.getSubjectDN(), certAlias));
                return ResultCode.PARAM_ERROR;
            }
            try {
                keystore.setCertificateEntry(certAlias, javaCertificate);
                continue;
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_ERROR_UPDATING_KS_WITH_CERT.get(x509Certificate.getSubjectDN(), alias));
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
        }
        if (!noPrompt) {
            this.out(new Object[0]);
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_IMPORT_CERT_CONFIRM_IMPORT_CHAIN_NO_KEY.get(alias));
            for (Map.Entry e : certMap.entrySet()) {
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_IMPORT_CERT_LABEL_ALIAS.get(e.getKey()));
                this.printCertificate((X509Certificate)e.getValue(), "", false);
            }
            this.out(new Object[0]);
            try {
                if (!this.promptForYesNo(CertMessages.INFO_MANAGE_CERTS_IMPORT_CERT_PROMPT_IMPORT_CHAIN.get())) {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_IMPORT_CERT_CANCELED.get());
                    return ResultCode.USER_CANCELED;
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, le.getMessage());
                return le.getResultCode();
            }
        }
        try {
            ManageCertificates.writeKeystore(keystore, keystorePath, keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        this.out(new Object[0]);
        if (isNewKeystore) {
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_IMPORT_CERT_CREATED_KEYSTORE.get(ManageCertificates.getUserFriendlyKeystoreType(keystoreType)));
        }
        this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_IMPORT_CERT_IMPORTED_CHAIN_WITHOUT_PK.get());
        return ResultCode.SUCCESS;
    }

    @NotNull
    private ResultCode doDeleteCertificate() {
        boolean hasPrivateKey;
        KeyStore keystore;
        char[] keystorePassword;
        String keystoreType;
        StringArgument aliasArgument = this.subCommandParser.getStringArgument("alias");
        String alias = aliasArgument.getValue();
        BooleanArgument noPromptArgument = this.subCommandParser.getBooleanArgument("no-prompt");
        boolean noPrompt = noPromptArgument != null && noPromptArgument.isPresent();
        File keystorePath = this.getKeystorePath();
        try {
            keystoreType = this.inferKeystoreType(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            keystorePassword = this.getKeystorePassword(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        BooleanArgument displayKeytoolCommandArgument = this.subCommandParser.getBooleanArgument("display-keytool-command");
        if (displayKeytoolCommandArgument != null && displayKeytoolCommandArgument.isPresent()) {
            ArrayList<String> keytoolArgs = new ArrayList<String>(10);
            keytoolArgs.add("-delete");
            keytoolArgs.add("-keystore");
            keytoolArgs.add(keystorePath.getAbsolutePath());
            keytoolArgs.add("-storetype");
            keytoolArgs.add(keystoreType);
            keytoolArgs.add("-storepass");
            keytoolArgs.add("*****REDACTED*****");
            keytoolArgs.add("-alias");
            keytoolArgs.add(alias);
            this.displayKeytoolCommand(keytoolArgs);
        }
        try {
            keystore = ManageCertificates.getKeystore(keystoreType, keystorePath, keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(5);
        if (ManageCertificates.hasCertificateAlias(keystore, alias)) {
            try {
                hasPrivateKey = false;
                certList.add(new X509Certificate(keystore.getCertificate(alias).getEncoded()));
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_DELETE_CERT_ERROR_GETTING_CERT.get(alias));
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
        } else if (ManageCertificates.hasKeyAlias(keystore, alias)) {
            try {
                hasPrivateKey = true;
                for (Certificate c : keystore.getCertificateChain(alias)) {
                    certList.add(new X509Certificate(c.getEncoded()));
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_DELETE_CERT_ERROR_GETTING_CHAIN.get(alias));
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
        } else {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_DELETE_CERT_ERROR_ALIAS_NOT_CERT_OR_KEY.get(alias));
            return ResultCode.PARAM_ERROR;
        }
        if (!noPrompt) {
            this.out(new Object[0]);
            if (!hasPrivateKey) {
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_DELETE_CERT_CONFIRM_DELETE_CERT.get());
            } else {
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_DELETE_CERT_CONFIRM_DELETE_CHAIN.get());
            }
            for (X509Certificate c : certList) {
                this.out(new Object[0]);
                this.printCertificate(c, "", false);
            }
            this.out(new Object[0]);
            try {
                if (!this.promptForYesNo(CertMessages.INFO_MANAGE_CERTS_DELETE_CERT_PROMPT_DELETE.get())) {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_DELETE_CERT_CANCELED.get());
                    return ResultCode.USER_CANCELED;
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, le.getMessage());
                return le.getResultCode();
            }
        }
        try {
            keystore.deleteEntry(alias);
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_DELETE_CERT_DELETE_ERROR.get(alias));
            e.printStackTrace(this.getErr());
            return ResultCode.LOCAL_ERROR;
        }
        try {
            ManageCertificates.writeKeystore(keystore, keystorePath, keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        if (certList.size() == 1) {
            this.out(new Object[0]);
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_DELETE_CERT_DELETED_CERT.get());
        } else {
            this.out(new Object[0]);
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_DELETE_CERT_DELETED_CHAIN.get());
        }
        return ResultCode.SUCCESS;
    }

    @NotNull
    private ResultCode doGenerateOrSignCertificateOrCSR() {
        X509Certificate signedCertificate;
        PKCS10CertificateSigningRequest csr;
        PrivateKey issuerPrivateKey;
        X509Certificate issuerCertificate;
        ArrayList<String> keytoolArguments;
        Certificate[] chain;
        char[] privateKeyPassword;
        KeyStore keystore;
        char[] keystorePassword;
        String keystoreType;
        StringArgument ianOIDArgument;
        StringArgument ianURIArgument;
        StringArgument ianEmailArgument;
        StringArgument ianIPArgument;
        StringArgument sanOIDArgument;
        StringArgument sanURIArgument;
        StringArgument sanEmailArgument;
        StringArgument sanIPArgument;
        boolean useExistingKeyPair;
        String format;
        boolean isSignCSR;
        boolean isGenerateCSR;
        boolean isGenerateCertificate;
        SubCommand selectedSubCommand = this.globalParser.getSelectedSubCommand();
        if (selectedSubCommand.hasName("generate-self-signed-certificate")) {
            isGenerateCertificate = true;
            isGenerateCSR = false;
            isSignCSR = false;
        } else if (selectedSubCommand.hasName("generate-certificate-signing-request")) {
            isGenerateCertificate = false;
            isGenerateCSR = true;
            isSignCSR = false;
        } else {
            Validator.ensureTrue(selectedSubCommand.hasName("sign-certificate-signing-request"));
            isGenerateCertificate = false;
            isGenerateCSR = false;
            isSignCSR = true;
        }
        StringArgument aliasArgument = this.subCommandParser.getStringArgument("alias");
        String alias = aliasArgument.getValue();
        File keystorePath = this.getKeystorePath();
        boolean isNewKeystore = !keystorePath.exists();
        DN subjectDN = null;
        DNArgument subjectDNArgument = this.subCommandParser.getDNArgument("subject-dn");
        if (subjectDNArgument != null && subjectDNArgument.isPresent()) {
            subjectDN = subjectDNArgument.getValue();
        }
        File inputFile = null;
        FileArgument inputFileArgument = this.subCommandParser.getFileArgument("input-file");
        if (inputFileArgument != null && inputFileArgument.isPresent()) {
            inputFile = inputFileArgument.getValue();
        }
        File outputFile = null;
        FileArgument outputFileArgument = this.subCommandParser.getFileArgument("output-file");
        if (outputFileArgument != null && outputFileArgument.isPresent()) {
            outputFile = outputFileArgument.getValue();
        }
        boolean outputPEM = true;
        StringArgument outputFormatArgument = this.subCommandParser.getStringArgument("output-format");
        if (outputFormatArgument != null && outputFormatArgument.isPresent() && ((format = outputFormatArgument.getValue().toLowerCase()).equals("der") || format.equals("binary") || format.equals("bin"))) {
            outputPEM = false;
        }
        if (!outputPEM && outputFile == null) {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_NO_FILE_WITH_DER.get());
            return ResultCode.PARAM_ERROR;
        }
        BooleanArgument useExistingKeyPairArgument = this.subCommandParser.getBooleanArgument("use-existing-key-pair");
        boolean bl = useExistingKeyPair = useExistingKeyPairArgument != null && useExistingKeyPairArgument.isPresent();
        if (useExistingKeyPair && !keystorePath.exists()) {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_USE_EXISTING_KP_WITHOUT_KS.get());
            return ResultCode.PARAM_ERROR;
        }
        BooleanArgument inheritExtensionsArgument = this.subCommandParser.getBooleanArgument("inherit-extensions");
        boolean inheritExtensions = inheritExtensionsArgument != null && inheritExtensionsArgument.isPresent();
        BooleanArgument includeRequestedExtensionsArgument = this.subCommandParser.getBooleanArgument("include-requested-extensions");
        boolean includeRequestedExtensions = includeRequestedExtensionsArgument != null && includeRequestedExtensionsArgument.isPresent();
        BooleanArgument noPromptArgument = this.subCommandParser.getBooleanArgument("no-prompt");
        boolean noPrompt = noPromptArgument != null && noPromptArgument.isPresent();
        BooleanArgument displayKeytoolCommandArgument = this.subCommandParser.getBooleanArgument("display-keytool-command");
        boolean displayKeytoolCommand = displayKeytoolCommandArgument != null && displayKeytoolCommandArgument.isPresent();
        int daysValid = 365;
        IntegerArgument daysValidArgument = this.subCommandParser.getIntegerArgument("days-valid");
        if (daysValidArgument != null && daysValidArgument.isPresent()) {
            daysValid = daysValidArgument.getValue();
        }
        Date validityStartTime = null;
        TimestampArgument validityStartTimeArgument = this.subCommandParser.getTimestampArgument("validity-start-time");
        if (validityStartTimeArgument != null && validityStartTimeArgument.isPresent()) {
            validityStartTime = validityStartTimeArgument.getValue();
        }
        PublicKeyAlgorithmIdentifier keyAlgorithmIdentifier = null;
        String keyAlgorithmName = null;
        StringArgument keyAlgorithmArgument = this.subCommandParser.getStringArgument("key-algorithm");
        if (keyAlgorithmArgument != null && keyAlgorithmArgument.isPresent()) {
            String name = keyAlgorithmArgument.getValue();
            keyAlgorithmIdentifier = PublicKeyAlgorithmIdentifier.forName(name);
            if (keyAlgorithmIdentifier == null) {
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_UNKNOWN_KEY_ALG.get(name));
                return ResultCode.PARAM_ERROR;
            }
            keyAlgorithmName = keyAlgorithmIdentifier.getName();
        }
        Integer keySizeBits = null;
        IntegerArgument keySizeBitsArgument = this.subCommandParser.getIntegerArgument("key-size-bits");
        if (keySizeBitsArgument != null && keySizeBitsArgument.isPresent()) {
            keySizeBits = keySizeBitsArgument.getValue();
        }
        if (keyAlgorithmIdentifier != null && keyAlgorithmIdentifier != PublicKeyAlgorithmIdentifier.RSA && keySizeBits == null) {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_NO_KEY_SIZE_FOR_NON_RSA_KEY.get());
            return ResultCode.PARAM_ERROR;
        }
        String signatureAlgorithmName = null;
        SignatureAlgorithmIdentifier signatureAlgorithmIdentifier = null;
        StringArgument signatureAlgorithmArgument = this.subCommandParser.getStringArgument("signature-algorithm");
        if (signatureAlgorithmArgument != null && signatureAlgorithmArgument.isPresent()) {
            String name = signatureAlgorithmArgument.getValue();
            signatureAlgorithmIdentifier = SignatureAlgorithmIdentifier.forName(name);
            if (signatureAlgorithmIdentifier == null) {
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_UNKNOWN_SIG_ALG.get(name));
                return ResultCode.PARAM_ERROR;
            }
            signatureAlgorithmName = signatureAlgorithmIdentifier.getJavaName();
        }
        if (keyAlgorithmIdentifier != null && keyAlgorithmIdentifier != PublicKeyAlgorithmIdentifier.RSA && signatureAlgorithmIdentifier == null) {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_NO_SIG_ALG_FOR_NON_RSA_KEY.get());
            return ResultCode.PARAM_ERROR;
        }
        ArrayList<X509CertificateExtension> extensionList = new ArrayList<X509CertificateExtension>(10);
        GeneralNamesBuilder sanBuilder = new GeneralNamesBuilder();
        LinkedHashSet<String> sanValues = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(10));
        StringArgument sanDNSArgument = this.subCommandParser.getStringArgument("subject-alternative-name-dns");
        if (sanDNSArgument != null && sanDNSArgument.isPresent()) {
            for (String value : sanDNSArgument.getValues()) {
                sanBuilder.addDNSName(value);
                sanValues.add("DNS:" + value);
            }
        }
        if ((sanIPArgument = this.subCommandParser.getStringArgument("subject-alternative-name-ip-address")) != null && sanIPArgument.isPresent()) {
            for (String value : sanIPArgument.getValues()) {
                try {
                    sanBuilder.addIPAddress(LDAPConnectionOptions.DEFAULT_NAME_RESOLVER.getByName(value));
                    sanValues.add("IP:" + value);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new RuntimeException(e);
                }
            }
        }
        if ((sanEmailArgument = this.subCommandParser.getStringArgument("subject-alternative-name-email-address")) != null && sanEmailArgument.isPresent()) {
            for (String value : sanEmailArgument.getValues()) {
                sanBuilder.addRFC822Name(value);
                sanValues.add("EMAIL:" + value);
            }
        }
        if ((sanURIArgument = this.subCommandParser.getStringArgument("subject-alternative-name-uri")) != null && sanURIArgument.isPresent()) {
            for (String value : sanURIArgument.getValues()) {
                sanBuilder.addUniformResourceIdentifier(value);
                sanValues.add("URI:" + value);
            }
        }
        if ((sanOIDArgument = this.subCommandParser.getStringArgument("subject-alternative-name-oid")) != null && sanOIDArgument.isPresent()) {
            for (String value : sanOIDArgument.getValues()) {
                sanBuilder.addRegisteredID(new OID(value));
                sanValues.add("OID:" + value);
            }
        }
        if (!sanValues.isEmpty()) {
            try {
                extensionList.add(new SubjectAlternativeNameExtension(false, sanBuilder.build()));
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new RuntimeException(e);
            }
        }
        GeneralNamesBuilder ianBuilder = new GeneralNamesBuilder();
        LinkedHashSet<String> ianValues = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(10));
        StringArgument ianDNSArgument = this.subCommandParser.getStringArgument("issuer-alternative-name-dns");
        if (ianDNSArgument != null && ianDNSArgument.isPresent()) {
            for (String value : ianDNSArgument.getValues()) {
                ianBuilder.addDNSName(value);
                ianValues.add("DNS:" + value);
            }
        }
        if ((ianIPArgument = this.subCommandParser.getStringArgument("issuer-alternative-name-ip-address")) != null && ianIPArgument.isPresent()) {
            for (String value : ianIPArgument.getValues()) {
                try {
                    ianBuilder.addIPAddress(LDAPConnectionOptions.DEFAULT_NAME_RESOLVER.getByName(value));
                    ianValues.add("IP:" + value);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new RuntimeException(e);
                }
            }
        }
        if ((ianEmailArgument = this.subCommandParser.getStringArgument("issuer-alternative-name-email-address")) != null && ianEmailArgument.isPresent()) {
            for (String value : ianEmailArgument.getValues()) {
                ianBuilder.addRFC822Name(value);
                ianValues.add("EMAIL:" + value);
            }
        }
        if ((ianURIArgument = this.subCommandParser.getStringArgument("issuer-alternative-name-uri")) != null && ianURIArgument.isPresent()) {
            for (String value : ianURIArgument.getValues()) {
                ianBuilder.addUniformResourceIdentifier(value);
                ianValues.add("URI:" + value);
            }
        }
        if ((ianOIDArgument = this.subCommandParser.getStringArgument("issuer-alternative-name-oid")) != null && ianOIDArgument.isPresent()) {
            for (String value : ianOIDArgument.getValues()) {
                ianBuilder.addRegisteredID(new OID(value));
                ianValues.add("OID:" + value);
            }
        }
        if (!ianValues.isEmpty()) {
            try {
                extensionList.add(new IssuerAlternativeNameExtension(false, ianBuilder.build()));
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new RuntimeException(e);
            }
        }
        BasicConstraintsExtension basicConstraints = null;
        BooleanValueArgument basicConstraintsIsCAArgument = this.subCommandParser.getBooleanValueArgument("basic-constraints-is-ca");
        if (basicConstraintsIsCAArgument != null && basicConstraintsIsCAArgument.isPresent()) {
            boolean isCA = basicConstraintsIsCAArgument.getValue();
            Integer pathLength = null;
            IntegerArgument pathLengthArgument = this.subCommandParser.getIntegerArgument("basic-constraints-maximum-path-length");
            if (pathLengthArgument != null && pathLengthArgument.isPresent()) {
                if (isCA) {
                    pathLength = pathLengthArgument.getValue();
                } else {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_BC_PATH_LENGTH_WITHOUT_CA.get());
                    return ResultCode.PARAM_ERROR;
                }
            }
            basicConstraints = new BasicConstraintsExtension(false, isCA, pathLength);
            extensionList.add(basicConstraints);
        }
        KeyUsageExtension keyUsage = null;
        StringArgument keyUsageArgument = this.subCommandParser.getStringArgument("key-usage");
        if (keyUsageArgument != null && keyUsageArgument.isPresent()) {
            boolean digitalSignature = false;
            boolean nonRepudiation = false;
            boolean keyEncipherment = false;
            boolean dataEncipherment = false;
            boolean keyAgreement = false;
            boolean keyCertSign = false;
            boolean crlSign = false;
            boolean encipherOnly = false;
            boolean decipherOnly = false;
            for (String value : keyUsageArgument.getValues()) {
                if (value.equalsIgnoreCase("digital-signature") || value.equalsIgnoreCase("digitalSignature")) {
                    digitalSignature = true;
                    continue;
                }
                if (value.equalsIgnoreCase("non-repudiation") || value.equalsIgnoreCase("nonRepudiation") || value.equalsIgnoreCase("content-commitment") || value.equalsIgnoreCase("contentCommitment")) {
                    nonRepudiation = true;
                    continue;
                }
                if (value.equalsIgnoreCase("key-encipherment") || value.equalsIgnoreCase("keyEncipherment")) {
                    keyEncipherment = true;
                    continue;
                }
                if (value.equalsIgnoreCase("data-encipherment") || value.equalsIgnoreCase("dataEncipherment")) {
                    dataEncipherment = true;
                    continue;
                }
                if (value.equalsIgnoreCase("key-agreement") || value.equalsIgnoreCase("keyAgreement")) {
                    keyAgreement = true;
                    continue;
                }
                if (value.equalsIgnoreCase("key-cert-sign") || value.equalsIgnoreCase("keyCertSign")) {
                    keyCertSign = true;
                    continue;
                }
                if (value.equalsIgnoreCase("crl-sign") || value.equalsIgnoreCase("crlSign")) {
                    crlSign = true;
                    continue;
                }
                if (value.equalsIgnoreCase("encipher-only") || value.equalsIgnoreCase("encipherOnly")) {
                    encipherOnly = true;
                    continue;
                }
                if (value.equalsIgnoreCase("decipher-only") || value.equalsIgnoreCase("decipherOnly")) {
                    decipherOnly = true;
                    continue;
                }
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_INVALID_KEY_USAGE.get(value));
                return ResultCode.PARAM_ERROR;
            }
            keyUsage = new KeyUsageExtension(false, digitalSignature, nonRepudiation, keyEncipherment, dataEncipherment, keyAgreement, keyCertSign, crlSign, encipherOnly, decipherOnly);
            extensionList.add(keyUsage);
        }
        ExtendedKeyUsageExtension extendedKeyUsage = null;
        StringArgument extendedKeyUsageArgument = this.subCommandParser.getStringArgument("extended-key-usage");
        if (extendedKeyUsageArgument != null && extendedKeyUsageArgument.isPresent()) {
            List<String> values = extendedKeyUsageArgument.getValues();
            ArrayList<OID> keyPurposeIDs = new ArrayList<OID>(values.size());
            for (String value : values) {
                if (value.equalsIgnoreCase("server-auth") || value.equalsIgnoreCase("serverAuth") || value.equalsIgnoreCase("server-authentication") || value.equalsIgnoreCase("serverAuthentication") || value.equalsIgnoreCase("tls-server-authentication") || value.equalsIgnoreCase("tlsServerAuthentication")) {
                    keyPurposeIDs.add(ExtendedKeyUsageID.TLS_SERVER_AUTHENTICATION.getOID());
                    continue;
                }
                if (value.equalsIgnoreCase("client-auth") || value.equalsIgnoreCase("clientAuth") || value.equalsIgnoreCase("client-authentication") || value.equalsIgnoreCase("clientAuthentication") || value.equalsIgnoreCase("tls-client-authentication") || value.equalsIgnoreCase("tlsClientAuthentication")) {
                    keyPurposeIDs.add(ExtendedKeyUsageID.TLS_CLIENT_AUTHENTICATION.getOID());
                    continue;
                }
                if (value.equalsIgnoreCase("code-signing") || value.equalsIgnoreCase("codeSigning")) {
                    keyPurposeIDs.add(ExtendedKeyUsageID.CODE_SIGNING.getOID());
                    continue;
                }
                if (value.equalsIgnoreCase("email-protection") || value.equalsIgnoreCase("emailProtection")) {
                    keyPurposeIDs.add(ExtendedKeyUsageID.EMAIL_PROTECTION.getOID());
                    continue;
                }
                if (value.equalsIgnoreCase("time-stamping") || value.equalsIgnoreCase("timeStamping")) {
                    keyPurposeIDs.add(ExtendedKeyUsageID.TIME_STAMPING.getOID());
                    continue;
                }
                if (value.equalsIgnoreCase("ocsp-signing") || value.equalsIgnoreCase("ocspSigning")) {
                    keyPurposeIDs.add(ExtendedKeyUsageID.OCSP_SIGNING.getOID());
                    continue;
                }
                if (OID.isStrictlyValidNumericOID(value)) {
                    keyPurposeIDs.add(new OID(value));
                    continue;
                }
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_INVALID_EXTENDED_KEY_USAGE.get(value));
                return ResultCode.PARAM_ERROR;
            }
            try {
                extendedKeyUsage = new ExtendedKeyUsageExtension(false, keyPurposeIDs);
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_EXTENDED_KEY_USAGE_ERROR.get());
                e.printStackTrace(this.getErr());
                return ResultCode.PARAM_ERROR;
            }
            extensionList.add(extendedKeyUsage);
        }
        ArrayList<X509CertificateExtension> genericExtensions = new ArrayList<X509CertificateExtension>(5);
        StringArgument extensionArgument = this.subCommandParser.getStringArgument("extension");
        if (extensionArgument != null && extensionArgument.isPresent()) {
            for (String value : extensionArgument.getValues()) {
                try {
                    byte[] valueBytes;
                    boolean criticality;
                    int firstColonPos = value.indexOf(58);
                    int secondColonPos = value.indexOf(58, firstColonPos + 1);
                    OID oid = new OID(value.substring(0, firstColonPos));
                    if (!oid.isStrictlyValidNumericOID()) {
                        this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_EXT_MALFORMED_OID.get(value, oid.toString()));
                        return ResultCode.PARAM_ERROR;
                    }
                    String criticalityString = value.substring(firstColonPos + 1, secondColonPos);
                    if (criticalityString.equalsIgnoreCase("true") || criticalityString.equalsIgnoreCase("t") || criticalityString.equalsIgnoreCase("yes") || criticalityString.equalsIgnoreCase("y") || criticalityString.equalsIgnoreCase("on") || criticalityString.equalsIgnoreCase("1")) {
                        criticality = true;
                    } else if (criticalityString.equalsIgnoreCase("false") || criticalityString.equalsIgnoreCase("f") || criticalityString.equalsIgnoreCase("no") || criticalityString.equalsIgnoreCase("n") || criticalityString.equalsIgnoreCase("off") || criticalityString.equalsIgnoreCase("0")) {
                        criticality = false;
                    } else {
                        this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_EXT_INVALID_CRITICALITY.get(value, criticalityString));
                        return ResultCode.PARAM_ERROR;
                    }
                    try {
                        valueBytes = StaticUtils.fromHex(value.substring(secondColonPos + 1));
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_EXT_INVALID_VALUE.get(value));
                        return ResultCode.PARAM_ERROR;
                    }
                    X509CertificateExtension extension = new X509CertificateExtension(oid, criticality, valueBytes);
                    genericExtensions.add(extension);
                    extensionList.add(extension);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_EXT_MALFORMED.get(value));
                    return ResultCode.PARAM_ERROR;
                }
            }
        }
        try {
            keystoreType = this.inferKeystoreType(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            keystorePassword = this.getKeystorePassword(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            keystore = ManageCertificates.getKeystore(keystoreType, keystorePath, keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            privateKeyPassword = this.getPrivateKeyPassword(keystore, alias, keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        if (useExistingKeyPair) {
            PKCS10CertificateSigningRequest certificateSigningRequest;
            KeyPair keyPair;
            X509Certificate certToReplace;
            if (!ManageCertificates.hasKeyAlias(keystore, alias)) {
                if (ManageCertificates.hasCertificateAlias(keystore, alias)) {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_USE_EXISTING_KP_ALIAS_IS_CERT.get(alias, keystorePath.getAbsolutePath()));
                    return ResultCode.PARAM_ERROR;
                }
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_USE_EXISTING_KP_NO_SUCH_ALIAS.get(alias, keystorePath.getAbsolutePath()));
                return ResultCode.PARAM_ERROR;
            }
            try {
                chain = keystore.getCertificateChain(alias);
                certToReplace = new X509Certificate(chain[0].getEncoded());
                PublicKey publicKey = chain[0].getPublicKey();
                PrivateKey privateKey = (PrivateKey)keystore.getKey(alias, privateKeyPassword);
                keyPair = new KeyPair(publicKey, privateKey);
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_USE_EXISTING_KP_COULD_NOT_GET_CERT.get(alias));
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
            signatureAlgorithmIdentifier = SignatureAlgorithmIdentifier.forOID(certToReplace.getSignatureAlgorithmOID());
            if (signatureAlgorithmIdentifier == null) {
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_UNKNOWN_SIG_ALG_IN_CERT.get(certToReplace.getSignatureAlgorithmOID()));
                return ResultCode.PARAM_ERROR;
            }
            signatureAlgorithmName = signatureAlgorithmIdentifier.getJavaName();
            if (subjectDN == null) {
                subjectDN = certToReplace.getSubjectDN();
            }
            if (inheritExtensions) {
                for (X509CertificateExtension extension : certToReplace.getExtensions()) {
                    if (extension instanceof AuthorityKeyIdentifierExtension || extension instanceof IssuerAlternativeNameExtension || extension instanceof SubjectKeyIdentifierExtension) continue;
                    if (extension instanceof BasicConstraintsExtension) {
                        if (basicConstraints != null) continue;
                        basicConstraints = (BasicConstraintsExtension)extension;
                        extensionList.add(basicConstraints);
                        continue;
                    }
                    if (extension instanceof ExtendedKeyUsageExtension) {
                        if (extendedKeyUsage != null) continue;
                        extendedKeyUsage = (ExtendedKeyUsageExtension)extension;
                        extensionList.add(extendedKeyUsage);
                        continue;
                    }
                    if (extension instanceof KeyUsageExtension) {
                        if (keyUsage != null) continue;
                        keyUsage = (KeyUsageExtension)extension;
                        extensionList.add(keyUsage);
                        continue;
                    }
                    if (extension instanceof SubjectAlternativeNameExtension) {
                        if (!sanValues.isEmpty()) continue;
                        SubjectAlternativeNameExtension e = (SubjectAlternativeNameExtension)extension;
                        for (String dnsName : e.getDNSNames()) {
                            sanValues.add("DNS:" + dnsName);
                        }
                        for (InetAddress ipAddress : e.getIPAddresses()) {
                            sanValues.add("IP:" + ipAddress.getHostAddress());
                        }
                        for (String emailAddress : e.getRFC822Names()) {
                            sanValues.add("EMAIL:" + emailAddress);
                        }
                        for (String uri : e.getUniformResourceIdentifiers()) {
                            sanValues.add("URI:" + uri);
                        }
                        for (OID oid : e.getRegisteredIDs()) {
                            sanValues.add("OID:" + oid.toString());
                        }
                        extensionList.add(extension);
                        continue;
                    }
                    genericExtensions.add(extension);
                    extensionList.add(extension);
                }
            }
            X509CertificateExtension[] extensions = new X509CertificateExtension[extensionList.size()];
            extensionList.toArray(extensions);
            if (isGenerateCertificate) {
                Certificate[] chain2;
                X509Certificate certificate;
                if (displayKeytoolCommand) {
                    keytoolArguments = new ArrayList(30);
                    keytoolArguments.add("-selfcert");
                    keytoolArguments.add("-keystore");
                    keytoolArguments.add(keystorePath.getAbsolutePath());
                    keytoolArguments.add("-storetype");
                    keytoolArguments.add(keystoreType);
                    keytoolArguments.add("-storepass");
                    keytoolArguments.add("*****REDACTED*****");
                    keytoolArguments.add("-keypass");
                    keytoolArguments.add("*****REDACTED*****");
                    keytoolArguments.add("-alias");
                    keytoolArguments.add(alias);
                    keytoolArguments.add("-dname");
                    keytoolArguments.add(subjectDN.toString());
                    keytoolArguments.add("-sigalg");
                    keytoolArguments.add(signatureAlgorithmName);
                    keytoolArguments.add("-validity");
                    keytoolArguments.add(String.valueOf(daysValid));
                    if (validityStartTime != null) {
                        keytoolArguments.add("-startdate");
                        keytoolArguments.add(ManageCertificates.formatValidityStartTime(validityStartTime));
                    }
                    ManageCertificates.addExtensionArguments(keytoolArguments, basicConstraints, keyUsage, extendedKeyUsage, sanValues, ianValues, genericExtensions);
                    this.displayKeytoolCommand(keytoolArguments);
                }
                long notBefore = validityStartTime == null ? System.currentTimeMillis() : validityStartTime.getTime();
                long notAfter = notBefore + TimeUnit.DAYS.toMillis(daysValid);
                try {
                    certificate = X509Certificate.generateSelfSignedCertificate(signatureAlgorithmIdentifier, keyPair, subjectDN, notBefore, notAfter, extensions);
                    chain2 = new Certificate[]{certificate.toCertificate()};
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_ERROR_GENERATING_CERT.get());
                    e.printStackTrace(this.getErr());
                    return ResultCode.LOCAL_ERROR;
                }
                try {
                    keystore.setKeyEntry(alias, keyPair.getPrivate(), privateKeyPassword, chain2);
                    ManageCertificates.writeKeystore(keystore, keystorePath, keystorePassword);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_ERROR_UPDATING_KEYSTORE.get());
                    e.printStackTrace(this.getErr());
                    return ResultCode.LOCAL_ERROR;
                }
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_GEN_CERT_SUCCESSFULLY_GENERATED_SELF_CERT.get());
                this.printCertificate(certificate, "", false);
                if (outputFile != null) {
                    try (PrintStream ps = new PrintStream(outputFile);){
                        byte[] certBytes = certificate.getX509CertificateBytes();
                        if (outputPEM) {
                            ManageCertificates.writePEMCertificate(ps, certBytes);
                        } else {
                            ps.write(certBytes);
                        }
                        this.out(new Object[0]);
                        this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_GEN_CERT_WROTE_OUTPUT_FILE.get(outputFile.getAbsolutePath()));
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        this.err(new Object[0]);
                        this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_ERROR_WRITING_CERT.get(outputFile.getAbsolutePath()));
                        e.printStackTrace(this.getErr());
                        return ResultCode.LOCAL_ERROR;
                    }
                }
                return ResultCode.SUCCESS;
            }
            Validator.ensureTrue(isGenerateCSR);
            if (displayKeytoolCommand) {
                keytoolArguments = new ArrayList(30);
                keytoolArguments.add("-certreq");
                keytoolArguments.add("-keystore");
                keytoolArguments.add(keystorePath.getAbsolutePath());
                keytoolArguments.add("-storetype");
                keytoolArguments.add(keystoreType);
                keytoolArguments.add("-storepass");
                keytoolArguments.add("*****REDACTED*****");
                keytoolArguments.add("-keypass");
                keytoolArguments.add("*****REDACTED*****");
                keytoolArguments.add("-alias");
                keytoolArguments.add(alias);
                keytoolArguments.add("-dname");
                keytoolArguments.add(subjectDN.toString());
                keytoolArguments.add("-sigalg");
                keytoolArguments.add(signatureAlgorithmName);
                ManageCertificates.addExtensionArguments(keytoolArguments, basicConstraints, keyUsage, extendedKeyUsage, sanValues, ianValues, genericExtensions);
                if (outputFile != null) {
                    keytoolArguments.add("-file");
                    keytoolArguments.add(outputFile.getAbsolutePath());
                }
                this.displayKeytoolCommand(keytoolArguments);
            }
            try {
                certificateSigningRequest = PKCS10CertificateSigningRequest.generateCertificateSigningRequest(signatureAlgorithmIdentifier, keyPair, subjectDN, extensions);
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_ERROR_GENERATING_CSR.get());
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
            try {
                PrintStream ps = outputFile == null ? this.getOut() : new PrintStream(outputFile);
                if (outputPEM) {
                    ManageCertificates.writePEMCertificateSigningRequest(ps, certificateSigningRequest.getPKCS10CertificateSigningRequestBytes());
                } else {
                    ps.write(certificateSigningRequest.getPKCS10CertificateSigningRequestBytes());
                }
                if (outputFile != null) {
                    ps.close();
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_ERROR_WRITING_CSR.get());
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
            if (outputFile != null) {
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_GEN_CERT_SUCCESSFULLY_GENERATED_CSR.get(outputFile.getAbsolutePath()));
            }
            return ResultCode.SUCCESS;
        }
        if (subjectDN == null && !isSignCSR) {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_NO_SUBJECT_DN_WITHOUT_USE_EXISTING_KP.get());
            return ResultCode.PARAM_ERROR;
        }
        if (keyAlgorithmIdentifier == null) {
            keyAlgorithmIdentifier = PublicKeyAlgorithmIdentifier.RSA;
            keyAlgorithmName = keyAlgorithmIdentifier.getName();
        }
        if (keySizeBits == null) {
            keySizeBits = 2048;
        }
        if (signatureAlgorithmIdentifier == null && !isSignCSR) {
            signatureAlgorithmIdentifier = SignatureAlgorithmIdentifier.SHA_256_WITH_RSA;
            signatureAlgorithmName = signatureAlgorithmIdentifier.getJavaName();
        }
        if (isGenerateCertificate || isGenerateCSR) {
            PKCS10CertificateSigningRequest certificateSigningRequest;
            KeyPair keyPair;
            Certificate[] chain3;
            X509Certificate certificate;
            if (ManageCertificates.hasKeyAlias(keystore, alias) || ManageCertificates.hasCertificateAlias(keystore, alias)) {
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_ALIAS_EXISTS_WITHOUT_USE_EXISTING_KP.get(alias));
                return ResultCode.PARAM_ERROR;
            }
            if (displayKeytoolCommand) {
                ArrayList<String> keytoolArguments2 = new ArrayList<String>(30);
                keytoolArguments2.add("-genkeypair");
                keytoolArguments2.add("-keystore");
                keytoolArguments2.add(keystorePath.getAbsolutePath());
                keytoolArguments2.add("-storetype");
                keytoolArguments2.add(keystoreType);
                keytoolArguments2.add("-storepass");
                keytoolArguments2.add("*****REDACTED*****");
                keytoolArguments2.add("-keypass");
                keytoolArguments2.add("*****REDACTED*****");
                keytoolArguments2.add("-alias");
                keytoolArguments2.add(alias);
                keytoolArguments2.add("-dname");
                keytoolArguments2.add(subjectDN.toString());
                keytoolArguments2.add("-keyalg");
                keytoolArguments2.add(keyAlgorithmName);
                keytoolArguments2.add("-keysize");
                keytoolArguments2.add(String.valueOf(keySizeBits));
                keytoolArguments2.add("-sigalg");
                keytoolArguments2.add(signatureAlgorithmName);
                keytoolArguments2.add("-validity");
                keytoolArguments2.add(String.valueOf(daysValid));
                if (validityStartTime != null) {
                    keytoolArguments2.add("-startdate");
                    keytoolArguments2.add(ManageCertificates.formatValidityStartTime(validityStartTime));
                }
                ManageCertificates.addExtensionArguments(keytoolArguments2, basicConstraints, keyUsage, extendedKeyUsage, sanValues, ianValues, genericExtensions);
                this.displayKeytoolCommand(keytoolArguments2);
            }
            long notBefore = validityStartTime == null ? System.currentTimeMillis() : validityStartTime.getTime();
            long notAfter = notBefore + TimeUnit.DAYS.toMillis(daysValid);
            X509CertificateExtension[] extensions = new X509CertificateExtension[extensionList.size()];
            extensionList.toArray(extensions);
            try {
                ObjectPair<X509Certificate, KeyPair> p = X509Certificate.generateSelfSignedCertificate(signatureAlgorithmIdentifier, keyAlgorithmIdentifier, keySizeBits, subjectDN, notBefore, notAfter, extensions);
                certificate = p.getFirst();
                chain3 = new Certificate[]{certificate.toCertificate()};
                keyPair = p.getSecond();
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_ERROR_GENERATING_CERT.get());
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
            try {
                keystore.setKeyEntry(alias, keyPair.getPrivate(), privateKeyPassword, chain3);
                ManageCertificates.writeKeystore(keystore, keystorePath, keystorePassword);
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_ERROR_UPDATING_KEYSTORE.get());
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
            if (isNewKeystore) {
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_GEN_CERT_CERT_CREATED_KEYSTORE.get(ManageCertificates.getUserFriendlyKeystoreType(keystoreType)));
            }
            if (isGenerateCertificate) {
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_GEN_CERT_SUCCESSFULLY_GENERATED_SELF_CERT.get());
                this.printCertificate(certificate, "", false);
                if (outputFile != null) {
                    try (PrintStream ps = new PrintStream(outputFile);){
                        byte[] certBytes = certificate.getX509CertificateBytes();
                        if (outputPEM) {
                            ManageCertificates.writePEMCertificate(ps, certBytes);
                        } else {
                            ps.write(certBytes);
                        }
                        this.out(new Object[0]);
                        this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_GEN_CERT_WROTE_OUTPUT_FILE.get(outputFile.getAbsolutePath()));
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        this.err(new Object[0]);
                        this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_ERROR_WRITING_CERT.get(outputFile.getAbsolutePath()));
                        e.printStackTrace(this.getErr());
                        return ResultCode.LOCAL_ERROR;
                    }
                }
                return ResultCode.SUCCESS;
            }
            Validator.ensureTrue(isGenerateCSR);
            this.out(new Object[0]);
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_GEN_CERT_SUCCESSFULLY_GENERATED_KEYPAIR.get());
            if (displayKeytoolCommand) {
                ArrayList<String> keytoolArguments3 = new ArrayList<String>(30);
                keytoolArguments3.add("-certreq");
                keytoolArguments3.add("-keystore");
                keytoolArguments3.add(keystorePath.getAbsolutePath());
                keytoolArguments3.add("-storetype");
                keytoolArguments3.add(keystoreType);
                keytoolArguments3.add("-storepass");
                keytoolArguments3.add("*****REDACTED*****");
                keytoolArguments3.add("-keypass");
                keytoolArguments3.add("*****REDACTED*****");
                keytoolArguments3.add("-alias");
                keytoolArguments3.add(alias);
                keytoolArguments3.add("-dname");
                keytoolArguments3.add(subjectDN.toString());
                keytoolArguments3.add("-sigalg");
                keytoolArguments3.add(signatureAlgorithmName);
                ManageCertificates.addExtensionArguments(keytoolArguments3, basicConstraints, keyUsage, extendedKeyUsage, sanValues, ianValues, genericExtensions);
                if (outputFile != null) {
                    keytoolArguments3.add("-file");
                    keytoolArguments3.add(outputFile.getAbsolutePath());
                }
                this.displayKeytoolCommand(keytoolArguments3);
            }
            try {
                certificateSigningRequest = PKCS10CertificateSigningRequest.generateCertificateSigningRequest(signatureAlgorithmIdentifier, keyPair, subjectDN, extensions);
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_ERROR_GENERATING_CSR.get());
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
            try {
                PrintStream ps = outputFile == null ? this.getOut() : new PrintStream(outputFile);
                if (outputPEM) {
                    ManageCertificates.writePEMCertificateSigningRequest(ps, certificateSigningRequest.getPKCS10CertificateSigningRequestBytes());
                } else {
                    ps.write(certificateSigningRequest.getPKCS10CertificateSigningRequestBytes());
                }
                if (outputFile != null) {
                    ps.close();
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_ERROR_WRITING_CSR.get());
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
            if (outputFile != null) {
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_GEN_CERT_SUCCESSFULLY_GENERATED_CSR.get(outputFile.getAbsolutePath()));
            }
            return ResultCode.SUCCESS;
        }
        Validator.ensureTrue(isSignCSR);
        if (!ManageCertificates.hasKeyAlias(keystore, alias)) {
            if (ManageCertificates.hasCertificateAlias(keystore, alias)) {
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_SIGN_ALIAS_IS_CERT.get(alias, keystorePath.getAbsolutePath()));
                return ResultCode.PARAM_ERROR;
            }
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_SIGN_NO_SUCH_ALIAS.get(alias, keystorePath.getAbsolutePath()));
            return ResultCode.PARAM_ERROR;
        }
        try {
            chain = keystore.getCertificateChain(alias);
            issuerCertificate = new X509Certificate(chain[0].getEncoded());
            issuerPrivateKey = (PrivateKey)keystore.getKey(alias, privateKeyPassword);
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_SIGN_CANNOT_GET_SIGNING_CERT.get(alias));
            e.printStackTrace(this.getErr());
            return ResultCode.LOCAL_ERROR;
        }
        try {
            csr = ManageCertificates.readCertificateSigningRequestFromFile(inputFile);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            csr.verifySignature();
        }
        catch (CertException ce) {
            Debug.debugException(ce);
            this.wrapErr(0, WRAP_COLUMN, ce.getMessage());
            return ResultCode.PARAM_ERROR;
        }
        if (!noPrompt) {
            this.out(new Object[0]);
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_GEN_CERT_SIGN_CONFIRM.get());
            this.out(new Object[0]);
            this.printCertificateSigningRequest(csr, false, "");
            this.out(new Object[0]);
            try {
                if (!this.promptForYesNo(CertMessages.INFO_MANAGE_CERTS_GEN_CERT_PROMPT_SIGN.get())) {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_SIGN_CANCELED.get());
                    return ResultCode.USER_CANCELED;
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, le.getMessage());
                return le.getResultCode();
            }
        }
        if (subjectDN == null || signatureAlgorithmIdentifier == null || includeRequestedExtensions) {
            if (subjectDN == null) {
                subjectDN = csr.getSubjectDN();
            }
            if (signatureAlgorithmIdentifier == null) {
                signatureAlgorithmIdentifier = SignatureAlgorithmIdentifier.forOID(csr.getSignatureAlgorithmOID());
                if (signatureAlgorithmIdentifier == null) {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_UNKNOWN_SIG_ALG_IN_CSR.get(csr.getSignatureAlgorithmOID()));
                    return ResultCode.PARAM_ERROR;
                }
                signatureAlgorithmName = signatureAlgorithmIdentifier.getJavaName();
            }
            if (includeRequestedExtensions) {
                for (X509CertificateExtension extension : csr.getExtensions()) {
                    if (extension instanceof AuthorityKeyIdentifierExtension || extension instanceof IssuerAlternativeNameExtension || extension instanceof SubjectKeyIdentifierExtension) continue;
                    if (extension instanceof BasicConstraintsExtension) {
                        if (basicConstraints != null) continue;
                        basicConstraints = (BasicConstraintsExtension)extension;
                        extensionList.add(basicConstraints);
                        continue;
                    }
                    if (extension instanceof ExtendedKeyUsageExtension) {
                        if (extendedKeyUsage != null) continue;
                        extendedKeyUsage = (ExtendedKeyUsageExtension)extension;
                        extensionList.add(extendedKeyUsage);
                        continue;
                    }
                    if (extension instanceof KeyUsageExtension) {
                        if (keyUsage != null) continue;
                        keyUsage = (KeyUsageExtension)extension;
                        extensionList.add(keyUsage);
                        continue;
                    }
                    if (extension instanceof SubjectAlternativeNameExtension) {
                        if (!sanValues.isEmpty()) continue;
                        SubjectAlternativeNameExtension e = (SubjectAlternativeNameExtension)extension;
                        for (String dnsName : e.getDNSNames()) {
                            sanBuilder.addDNSName(dnsName);
                            sanValues.add("DNS:" + dnsName);
                        }
                        for (InetAddress ipAddress : e.getIPAddresses()) {
                            sanBuilder.addIPAddress(ipAddress);
                            sanValues.add("IP:" + ipAddress.getHostAddress());
                        }
                        for (String emailAddress : e.getRFC822Names()) {
                            sanBuilder.addRFC822Name(emailAddress);
                            sanValues.add("EMAIL:" + emailAddress);
                        }
                        for (String uri : e.getUniformResourceIdentifiers()) {
                            sanBuilder.addUniformResourceIdentifier(uri);
                            sanValues.add("URI:" + uri);
                        }
                        for (OID oid : e.getRegisteredIDs()) {
                            sanBuilder.addRegisteredID(oid);
                            sanValues.add("OID:" + oid.toString());
                        }
                        try {
                            extensionList.add(new SubjectAlternativeNameExtension(false, sanBuilder.build()));
                            continue;
                        }
                        catch (Exception ex) {
                            Debug.debugException(ex);
                            throw new RuntimeException(ex);
                        }
                    }
                    genericExtensions.add(extension);
                    extensionList.add(extension);
                }
            }
        }
        keytoolArguments = new ArrayList<String>(30);
        keytoolArguments.add("-gencert");
        keytoolArguments.add("-keystore");
        keytoolArguments.add(keystorePath.getAbsolutePath());
        keytoolArguments.add("-storetype");
        keytoolArguments.add(keystoreType);
        keytoolArguments.add("-storepass");
        keytoolArguments.add("*****REDACTED*****");
        keytoolArguments.add("-keypass");
        keytoolArguments.add("*****REDACTED*****");
        keytoolArguments.add("-alias");
        keytoolArguments.add(alias);
        keytoolArguments.add("-dname");
        keytoolArguments.add(subjectDN.toString());
        keytoolArguments.add("-sigalg");
        keytoolArguments.add(signatureAlgorithmName);
        keytoolArguments.add("-validity");
        keytoolArguments.add(String.valueOf(daysValid));
        if (validityStartTime != null) {
            keytoolArguments.add("-startdate");
            keytoolArguments.add(ManageCertificates.formatValidityStartTime(validityStartTime));
        }
        ManageCertificates.addExtensionArguments(keytoolArguments, basicConstraints, keyUsage, extendedKeyUsage, sanValues, ianValues, genericExtensions);
        keytoolArguments.add("-infile");
        keytoolArguments.add(inputFile.getAbsolutePath());
        if (outputFile != null) {
            keytoolArguments.add("-outfile");
            keytoolArguments.add(outputFile.getAbsolutePath());
        }
        if (outputPEM) {
            keytoolArguments.add("-rfc");
        }
        if (displayKeytoolCommand) {
            this.displayKeytoolCommand(keytoolArguments);
        }
        long notBefore = validityStartTime == null ? System.currentTimeMillis() : validityStartTime.getTime();
        long notAfter = notBefore + TimeUnit.DAYS.toMillis(daysValid);
        X509CertificateExtension[] extensions = new X509CertificateExtension[extensionList.size()];
        extensionList.toArray(extensions);
        try {
            signedCertificate = X509Certificate.generateIssuerSignedCertificate(signatureAlgorithmIdentifier, issuerCertificate, issuerPrivateKey, csr.getPublicKeyAlgorithmOID(), csr.getPublicKeyAlgorithmParameters(), csr.getEncodedPublicKey(), csr.getDecodedPublicKey(), subjectDN, notBefore, notAfter, extensions);
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_ERROR_SIGNING_CERT.get());
            e.printStackTrace(this.getErr());
            return ResultCode.LOCAL_ERROR;
        }
        try {
            PrintStream ps = outputFile == null ? this.getOut() : new PrintStream(outputFile);
            if (outputPEM) {
                ManageCertificates.writePEMCertificate(ps, signedCertificate.getX509CertificateBytes());
            } else {
                ps.write(signedCertificate.getX509CertificateBytes());
            }
            if (outputFile != null) {
                ps.close();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GEN_CERT_ERROR_WRITING_SIGNED_CERT.get());
            e.printStackTrace(this.getErr());
            return ResultCode.LOCAL_ERROR;
        }
        if (outputFile != null) {
            this.out(new Object[0]);
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_GEN_CERT_SUCCESSFULLY_SIGNED_CERT.get(outputFile.getAbsolutePath()));
        }
        return ResultCode.SUCCESS;
    }

    @NotNull
    private ResultCode doChangeCertificateAlias() {
        PrivateKey existingPrivateKey;
        Certificate[] existingCertificateChain;
        Certificate existingCertificate;
        char[] privateKeyPassword;
        KeyStore keystore;
        char[] keystorePassword;
        String keystoreType;
        File keystorePath;
        String newAlias;
        String currentAlias;
        block18: {
            StringArgument currentAliasArgument = this.subCommandParser.getStringArgument("current-alias");
            currentAlias = currentAliasArgument.getValue();
            StringArgument newAliasArgument = this.subCommandParser.getStringArgument("new-alias");
            newAlias = newAliasArgument.getValue();
            keystorePath = this.getKeystorePath();
            try {
                keystoreType = this.inferKeystoreType(keystorePath);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.wrapErr(0, WRAP_COLUMN, le.getMessage());
                return le.getResultCode();
            }
            try {
                keystorePassword = this.getKeystorePassword(keystorePath);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.wrapErr(0, WRAP_COLUMN, le.getMessage());
                return le.getResultCode();
            }
            try {
                keystore = ManageCertificates.getKeystore(keystoreType, keystorePath, keystorePassword);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.wrapErr(0, WRAP_COLUMN, le.getMessage());
                return le.getResultCode();
            }
            try {
                privateKeyPassword = this.getPrivateKeyPassword(keystore, currentAlias, keystorePassword);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.wrapErr(0, WRAP_COLUMN, le.getMessage());
                return le.getResultCode();
            }
            try {
                if (ManageCertificates.hasCertificateAlias(keystore, currentAlias)) {
                    existingCertificate = keystore.getCertificate(currentAlias);
                    existingCertificateChain = null;
                    existingPrivateKey = null;
                    break block18;
                }
                if (ManageCertificates.hasKeyAlias(keystore, currentAlias)) {
                    existingCertificateChain = keystore.getCertificateChain(currentAlias);
                    existingPrivateKey = (PrivateKey)keystore.getKey(currentAlias, privateKeyPassword);
                    existingCertificate = null;
                    break block18;
                }
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHANGE_ALIAS_NO_SUCH_ALIAS.get(currentAlias));
                return ResultCode.PARAM_ERROR;
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHANGE_ALIAS_CANNOT_GET_EXISTING_ENTRY.get(currentAlias));
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
        }
        if (ManageCertificates.hasCertificateAlias(keystore, newAlias) || ManageCertificates.hasKeyAlias(keystore, newAlias)) {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHANGE_ALIAS_NEW_ALIAS_IN_USE.get(newAlias));
            return ResultCode.PARAM_ERROR;
        }
        BooleanArgument displayKeytoolCommandArgument = this.subCommandParser.getBooleanArgument("display-keytool-command");
        if (displayKeytoolCommandArgument != null && displayKeytoolCommandArgument.isPresent()) {
            ArrayList<String> keytoolArguments = new ArrayList<String>(30);
            keytoolArguments.add("-changealias");
            keytoolArguments.add("-keystore");
            keytoolArguments.add(keystorePath.getAbsolutePath());
            keytoolArguments.add("-storetype");
            keytoolArguments.add(keystoreType);
            keytoolArguments.add("-storepass");
            keytoolArguments.add("*****REDACTED*****");
            keytoolArguments.add("-keypass");
            keytoolArguments.add("*****REDACTED*****");
            keytoolArguments.add("-alias");
            keytoolArguments.add(currentAlias);
            keytoolArguments.add("-destalias");
            keytoolArguments.add(newAlias);
            this.displayKeytoolCommand(keytoolArguments);
        }
        try {
            keystore.deleteEntry(currentAlias);
            if (existingCertificate != null) {
                keystore.setCertificateEntry(newAlias, existingCertificate);
            } else {
                keystore.setKeyEntry(newAlias, existingPrivateKey, privateKeyPassword, existingCertificateChain);
            }
            ManageCertificates.writeKeystore(keystore, keystorePath, keystorePassword);
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHANGE_ALIAS_CANNOT_UPDATE_KEYSTORE.get());
            e.printStackTrace(this.getErr());
            return ResultCode.LOCAL_ERROR;
        }
        this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHANGE_ALIAS_SUCCESSFUL.get(currentAlias, newAlias));
        return ResultCode.SUCCESS;
    }

    @NotNull
    private ResultCode doChangeKeystorePassword() {
        KeyStore keystore;
        char[] newKeystorePassword;
        char[] currentKeystorePassword;
        String keystoreType;
        File keystorePath = this.getKeystorePath();
        try {
            keystoreType = this.inferKeystoreType(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            currentKeystorePassword = this.getKeystorePassword(keystorePath, "current");
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            newKeystorePassword = this.getKeystorePassword(keystorePath, "new");
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            keystore = ManageCertificates.getKeystore(keystoreType, keystorePath, currentKeystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        BooleanArgument displayKeytoolCommandArgument = this.subCommandParser.getBooleanArgument("display-keytool-command");
        if (displayKeytoolCommandArgument != null && displayKeytoolCommandArgument.isPresent()) {
            ArrayList<String> keytoolArguments = new ArrayList<String>(30);
            keytoolArguments.add("-storepasswd");
            keytoolArguments.add("-keystore");
            keytoolArguments.add(keystorePath.getAbsolutePath());
            keytoolArguments.add("-storetype");
            keytoolArguments.add(keystoreType);
            keytoolArguments.add("-storepass");
            keytoolArguments.add("*****REDACTED*****");
            keytoolArguments.add("-new");
            keytoolArguments.add("*****REDACTED*****");
            this.displayKeytoolCommand(keytoolArguments);
        }
        try {
            ManageCertificates.writeKeystore(keystore, keystorePath, newKeystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHANGE_KS_PW_SUCCESSFUL.get(keystorePath.getAbsolutePath()));
        return ResultCode.SUCCESS;
    }

    @NotNull
    private ResultCode doChangePrivateKeyPassword() {
        PrivateKey privateKey;
        Certificate[] chain;
        char[] newPrivateKeyPassword;
        char[] currentPrivateKeyPassword;
        KeyStore keystore;
        char[] keystorePassword;
        String keystoreType;
        StringArgument aliasArgument = this.subCommandParser.getStringArgument("alias");
        String alias = aliasArgument.getValue();
        File keystorePath = this.getKeystorePath();
        try {
            keystoreType = this.inferKeystoreType(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            keystorePassword = this.getKeystorePassword(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            keystore = ManageCertificates.getKeystore(keystoreType, keystorePath, keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        if (ManageCertificates.hasCertificateAlias(keystore, alias)) {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHANGE_PK_PW_ALIAS_IS_CERT.get(alias));
            return ResultCode.PARAM_ERROR;
        }
        if (!ManageCertificates.hasKeyAlias(keystore, alias)) {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHANGE_PK_PW_NO_SUCH_ALIAS.get(alias));
            return ResultCode.PARAM_ERROR;
        }
        try {
            currentPrivateKeyPassword = this.getPrivateKeyPassword(keystore, alias, "current", keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            newPrivateKeyPassword = this.getPrivateKeyPassword(keystore, alias, "new", keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        BooleanArgument displayKeytoolCommandArgument = this.subCommandParser.getBooleanArgument("display-keytool-command");
        if (displayKeytoolCommandArgument != null && displayKeytoolCommandArgument.isPresent()) {
            ArrayList<String> keytoolArguments = new ArrayList<String>(30);
            keytoolArguments.add("-keypasswd");
            keytoolArguments.add("-keystore");
            keytoolArguments.add(keystorePath.getAbsolutePath());
            keytoolArguments.add("-storetype");
            keytoolArguments.add(keystoreType);
            keytoolArguments.add("-storepass");
            keytoolArguments.add("*****REDACTED*****");
            keytoolArguments.add("-alias");
            keytoolArguments.add(alias);
            keytoolArguments.add("-keypass");
            keytoolArguments.add("*****REDACTED*****");
            keytoolArguments.add("-new");
            keytoolArguments.add("*****REDACTED*****");
            this.displayKeytoolCommand(keytoolArguments);
        }
        try {
            chain = keystore.getCertificateChain(alias);
            privateKey = (PrivateKey)keystore.getKey(alias, currentPrivateKeyPassword);
        }
        catch (UnrecoverableKeyException e) {
            Debug.debugException(e);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHANGE_PK_PW_WRONG_PK_PW.get(alias));
            return ResultCode.PARAM_ERROR;
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHANGE_PK_PW_CANNOT_GET_PK.get(alias));
            e.printStackTrace(this.getErr());
            return ResultCode.LOCAL_ERROR;
        }
        try {
            keystore.deleteEntry(alias);
            keystore.setKeyEntry(alias, privateKey, newPrivateKeyPassword, chain);
            ManageCertificates.writeKeystore(keystore, keystorePath, keystorePassword);
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHANGE_PK_PW_CANNOT_UPDATE_KS.get());
            e.printStackTrace(this.getErr());
            return ResultCode.LOCAL_ERROR;
        }
        this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHANGE_PK_PW_SUCCESSFUL.get(alias));
        return ResultCode.SUCCESS;
    }

    @NotNull
    private ResultCode doCopyKeystore() {
        KeyStore destinationKeyStore;
        char[] destinationKeyStorePassword;
        String destinationKeyStoreType;
        KeyStore sourceKeyStore;
        char[] sourceKeyStorePassword;
        String sourceKeyStoreType;
        File sourceKeyStorePath = this.getKeystorePath("source-keystore");
        try {
            sourceKeyStoreType = this.inferKeystoreType(sourceKeyStorePath, "source");
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            sourceKeyStorePassword = this.getKeystorePassword(sourceKeyStorePath, "source");
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            sourceKeyStore = ManageCertificates.getKeystore(sourceKeyStoreType, sourceKeyStorePath, sourceKeyStorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        File destinationKeyStorePath = this.getKeystorePath("destination-keystore");
        try {
            destinationKeyStoreType = this.inferKeystoreType(destinationKeyStorePath, "destination");
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        boolean destinationExists = destinationKeyStorePath.exists();
        try {
            destinationKeyStorePassword = this.getKeystorePassword(destinationKeyStorePath, "destination");
            if (destinationKeyStorePassword == null) {
                destinationKeyStorePassword = sourceKeyStorePassword;
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            destinationKeyStore = ManageCertificates.getKeystore(destinationKeyStoreType, destinationKeyStorePath, destinationKeyStorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        LinkedHashSet<String> aliases = new LinkedHashSet<String>();
        try {
            StringArgument aliasArg = this.subCommandParser.getStringArgument("alias");
            if (aliasArg != null && aliasArg.isPresent()) {
                for (String alias : aliasArg.getValues()) {
                    aliases.add(alias);
                    if (sourceKeyStore.containsAlias(alias)) continue;
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_COPY_KS_NO_SUCH_SOURCE_ALIAS.get(sourceKeyStorePath.getAbsolutePath(), alias));
                    return ResultCode.PARAM_ERROR;
                }
            } else {
                Enumeration<String> sourceAliases = sourceKeyStore.aliases();
                while (sourceAliases.hasMoreElements()) {
                    aliases.add(sourceAliases.nextElement());
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_COPY_KS_CANNOT_GET_SOURCE_ALIASES.get(sourceKeyStorePath.getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
            return ResultCode.LOCAL_ERROR;
        }
        if (aliases.isEmpty() && destinationExists) {
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_COPY_KS_NO_CERTS_COPIED_EXISTING_KS.get(sourceKeyStorePath.getAbsolutePath(), destinationKeyStorePath.getAbsolutePath()));
            return ResultCode.SUCCESS;
        }
        for (String alias : aliases) {
            try {
                if (!destinationKeyStore.containsAlias(alias)) continue;
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_COPY_KS_CONFLICTING_ALIAS.get(alias, destinationKeyStorePath.getAbsolutePath(), this.subCommandParser.getCommandName()));
                return ResultCode.CONSTRAINT_VIOLATION;
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_COPY_KS_CANNOT_CHECK_DEST_ALIAS.get(alias, destinationKeyStorePath.getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                return ResultCode.LOCAL_ERROR;
            }
        }
        char[] sourcePrivateKeyPassword = null;
        char[] destinationPrivateKeyPassword = null;
        for (String alias : aliases) {
            try {
                if (sourceKeyStore.isCertificateEntry(alias)) {
                    Certificate certificate = sourceKeyStore.getCertificate(alias);
                    destinationKeyStore.setCertificateEntry(alias, certificate);
                    continue;
                }
                if (sourcePrivateKeyPassword == null) {
                    sourcePrivateKeyPassword = this.getPrivateKeyPassword(sourceKeyStore, alias, "source", sourceKeyStorePassword);
                }
                if (destinationPrivateKeyPassword == null) {
                    destinationPrivateKeyPassword = this.getPrivateKeyPassword(destinationKeyStore, alias, "destination", destinationKeyStorePassword);
                }
                Certificate[] chain = sourceKeyStore.getCertificateChain(alias);
                Key key = sourceKeyStore.getKey(alias, sourcePrivateKeyPassword);
                destinationKeyStore.setKeyEntry(alias, key, destinationPrivateKeyPassword, chain);
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_COPY_KS_ERROR_COPYING_ENTRY.get(alias, sourceKeyStorePath.getAbsolutePath(), destinationKeyStorePath.getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                return ResultCode.LOCAL_ERROR;
            }
        }
        try {
            ManageCertificates.writeKeystore(destinationKeyStore, destinationKeyStorePath, destinationKeyStorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        if (aliases.isEmpty()) {
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_COPY_KS_NO_CERTS_COPIED_KS_CREATED.get(sourceKeyStorePath.getAbsolutePath(), destinationKeyStoreType, destinationKeyStorePath.getAbsolutePath()));
        } else {
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_COPY_KS_CERTS_COPIED_HEADER.get(sourceKeyStorePath.getAbsolutePath(), destinationKeyStoreType, destinationKeyStorePath.getAbsolutePath()));
            for (String alias : aliases) {
                this.out("* ", alias);
            }
        }
        return ResultCode.SUCCESS;
    }

    @NotNull
    private ResultCode doRetrieveServerCertificate() {
        X509Certificate[] chain;
        String format;
        StringArgument hostnameArgument = this.subCommandParser.getStringArgument("hostname");
        String hostname = hostnameArgument.getValue();
        IntegerArgument portArgument = this.subCommandParser.getIntegerArgument("port");
        int port = portArgument.getValue();
        BooleanArgument useLDAPStartTLSArgument = this.subCommandParser.getBooleanArgument("use-ldap-start-tls");
        boolean useLDAPStartTLS = useLDAPStartTLSArgument != null && useLDAPStartTLSArgument.isPresent();
        BooleanArgument onlyPeerArgument = this.subCommandParser.getBooleanArgument("only-peer-certificate");
        boolean onlyPeer = onlyPeerArgument != null && onlyPeerArgument.isPresent();
        BooleanArgument verboseArgument = this.subCommandParser.getBooleanArgument("verbose");
        boolean verbose = verboseArgument != null && verboseArgument.isPresent();
        boolean outputPEM = true;
        StringArgument outputFormatArgument = this.subCommandParser.getStringArgument("output-format");
        if (outputFormatArgument != null && outputFormatArgument.isPresent() && ((format = outputFormatArgument.getValue().toLowerCase()).equals("der") || format.equals("binary") || format.equals("bin"))) {
            outputPEM = false;
        }
        File outputFile = null;
        FileArgument outputFileArgument = this.subCommandParser.getFileArgument("output-file");
        if (outputFileArgument != null && outputFileArgument.isPresent()) {
            outputFile = outputFileArgument.getValue();
        }
        LinkedBlockingQueue<Object> responseQueue = new LinkedBlockingQueue<Object>(10);
        ManageCertificatesServerCertificateCollector certificateCollector = new ManageCertificatesServerCertificateCollector(this, hostname, port, useLDAPStartTLS, verbose, responseQueue);
        certificateCollector.start();
        Object responseObject = CertMessages.ERR_MANAGE_CERTS_RETRIEVE_CERT_NO_CERT_CHAIN_RECEIVED.get(hostname + ':' + port);
        try {
            responseObject = responseQueue.poll(90L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        if (responseObject instanceof X509Certificate[]) {
            chain = (X509Certificate[])responseObject;
            if (chain.length == 0) {
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_RETRIEVE_CERT_EMPTY_CHAIN.get());
                return ResultCode.NO_RESULTS_RETURNED;
            }
        } else {
            if (responseObject instanceof CertException) {
                return ResultCode.LOCAL_ERROR;
            }
            this.wrapErr(0, WRAP_COLUMN, String.valueOf(responseObject));
            return ResultCode.LOCAL_ERROR;
        }
        try {
            certificateCollector.join(10000L);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        if (outputFile != null) {
            try (PrintStream s = new PrintStream(outputFile);){
                for (X509Certificate c : chain) {
                    if (outputPEM) {
                        ManageCertificates.writePEMCertificate(s, c.getX509CertificateBytes());
                    } else {
                        s.write(c.getX509CertificateBytes());
                    }
                    if (!onlyPeer) continue;
                    break;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_RETRIEVE_CERT_CANNOT_WRITE_TO_FILE.get(outputFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                return ResultCode.LOCAL_ERROR;
            }
        }
        for (int i = 0; i < chain.length; ++i) {
            if (verbose || i > 0) {
                this.out(new Object[0]);
                this.out(new Object[0]);
            }
            if (!onlyPeer && chain.length > 1) {
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_RETRIEVE_CERT_DISPLAY_HEADER.get(i + 1, chain.length));
                this.out(new Object[0]);
            }
            X509Certificate c = chain[i];
            ManageCertificates.writePEMCertificate(this.getOut(), c.getX509CertificateBytes());
            this.out(new Object[0]);
            this.printCertificate(c, "", verbose);
            if (onlyPeer) break;
        }
        return ResultCode.SUCCESS;
    }

    @NotNull
    private ResultCode doTrustServerCertificate() {
        KeyStore keystore;
        char[] keystorePassword;
        String keystoreType;
        StringArgument hostnameArgument = this.subCommandParser.getStringArgument("hostname");
        String hostname = hostnameArgument.getValue();
        IntegerArgument portArgument = this.subCommandParser.getIntegerArgument("port");
        int port = portArgument.getValue();
        StringArgument aliasArgument = this.subCommandParser.getStringArgument("alias");
        String alias = aliasArgument != null && aliasArgument.isPresent() ? aliasArgument.getValue() : hostname + ':' + port;
        BooleanArgument useLDAPStartTLSArgument = this.subCommandParser.getBooleanArgument("use-ldap-start-tls");
        boolean useLDAPStartTLS = useLDAPStartTLSArgument != null && useLDAPStartTLSArgument.isPresent();
        BooleanArgument issuersOnlyArgument = this.subCommandParser.getBooleanArgument("issuers-only");
        boolean issuersOnly = issuersOnlyArgument != null && issuersOnlyArgument.isPresent();
        BooleanArgument noPromptArgument = this.subCommandParser.getBooleanArgument("no-prompt");
        boolean noPrompt = noPromptArgument != null && noPromptArgument.isPresent();
        BooleanArgument verboseArgument = this.subCommandParser.getBooleanArgument("verbose");
        boolean verbose = verboseArgument != null && verboseArgument.isPresent();
        File keystorePath = this.getKeystorePath();
        boolean isNewKeystore = !keystorePath.exists();
        try {
            keystoreType = this.inferKeystoreType(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            keystorePassword = this.getKeystorePassword(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            keystore = ManageCertificates.getKeystore(keystoreType, keystorePath, keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        if (ManageCertificates.hasCertificateAlias(keystore, alias) || ManageCertificates.hasKeyAlias(keystore, alias)) {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_TRUST_SERVER_ALIAS_IN_USE.get(alias));
            return ResultCode.PARAM_ERROR;
        }
        LinkedBlockingQueue<Object> responseQueue = new LinkedBlockingQueue<Object>(10);
        ManageCertificatesServerCertificateCollector certificateCollector = new ManageCertificatesServerCertificateCollector(this, hostname, port, useLDAPStartTLS, verbose, responseQueue);
        certificateCollector.start();
        Object responseObject = CertMessages.ERR_MANAGE_CERTS_TRUST_SERVER_NO_CERT_CHAIN_RECEIVED.get(hostname + ':' + port);
        try {
            responseObject = responseQueue.poll(90L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        if (!(responseObject instanceof X509Certificate[])) {
            if (responseObject instanceof CertException) {
                return ResultCode.LOCAL_ERROR;
            }
            this.wrapErr(0, WRAP_COLUMN, String.valueOf(responseObject));
            return ResultCode.LOCAL_ERROR;
        }
        X509Certificate[] chain = (X509Certificate[])responseObject;
        try {
            certificateCollector.join(10000L);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        if (!noPrompt) {
            this.out(new Object[0]);
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_TRUST_SERVER_RETRIEVED_CHAIN.get(hostname + ':' + port));
            boolean isFirst = true;
            for (X509Certificate c : chain) {
                this.out(new Object[0]);
                if (isFirst) {
                    isFirst = false;
                    if (issuersOnly && chain.length > 1) {
                        this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_TRUST_SERVER_NOTE_OMITTED.get());
                        this.out(new Object[0]);
                    }
                }
                this.printCertificate(c, "", verbose);
            }
            this.out(new Object[0]);
            try {
                if (!this.promptForYesNo(CertMessages.INFO_MANAGE_CERTS_TRUST_SERVER_PROMPT_TRUST.get())) {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_TRUST_SERVER_CHAIN_REJECTED.get());
                    return ResultCode.USER_CANCELED;
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, le.getMessage());
                return le.getResultCode();
            }
        }
        LinkedHashMap<String, X509Certificate> certsByAlias = new LinkedHashMap<String, X509Certificate>(StaticUtils.computeMapCapacity(chain.length));
        for (int i = 0; i < chain.length; ++i) {
            if (i == 0) {
                if (issuersOnly && chain.length > 1) continue;
                certsByAlias.put(alias, chain[i]);
                continue;
            }
            if (i == 1 && chain.length == 2) {
                certsByAlias.put(alias + "-issuer", chain[i]);
                continue;
            }
            certsByAlias.put(alias + "-issuer-" + i, chain[i]);
        }
        for (Map.Entry e : certsByAlias.entrySet()) {
            String certAlias = (String)e.getKey();
            X509Certificate cert = (X509Certificate)e.getValue();
            try {
                Validator.ensureFalse(ManageCertificates.hasCertificateAlias(keystore, certAlias) || ManageCertificates.hasKeyAlias(keystore, certAlias), "ERROR:  Alias '" + certAlias + "' is already in use in the " + "keystore.");
                keystore.setCertificateEntry(certAlias, cert.toCertificate());
            }
            catch (Exception ex) {
                Debug.debugException(ex);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_TRUST_SERVER_ERROR_ADDING_CERT_TO_KS.get(cert.getSubjectDN()));
                ex.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
        }
        try {
            ManageCertificates.writeKeystore(keystore, keystorePath, keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        if (isNewKeystore) {
            this.out(new Object[0]);
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_TRUST_SERVER_CERT_CREATED_KEYSTORE.get(ManageCertificates.getUserFriendlyKeystoreType(keystoreType)));
        }
        this.out(new Object[0]);
        if (certsByAlias.size() == 1) {
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_TRUST_SERVER_ADDED_CERT_TO_KS.get());
        } else {
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_TRUST_SERVER_ADDED_CERTS_TO_KS.get(certsByAlias.size()));
        }
        return ResultCode.SUCCESS;
    }

    @NotNull
    private ResultCode doCheckCertificateUsability() {
        int i;
        X509Certificate[] chain;
        KeyStore keystore;
        char[] keystorePassword;
        String keystoreType;
        StringArgument aliasArgument = this.subCommandParser.getStringArgument("alias");
        String alias = aliasArgument.getValue();
        File keystorePath = this.getKeystorePath();
        try {
            keystoreType = this.inferKeystoreType(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            keystorePassword = this.getKeystorePassword(keystorePath);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        try {
            keystore = ManageCertificates.getKeystore(keystoreType, keystorePath, keystorePassword);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        if (ManageCertificates.hasKeyAlias(keystore, alias)) {
            try {
                Certificate[] genericChain = keystore.getCertificateChain(alias);
                Validator.ensureTrue(genericChain.length > 0, "ERROR:  The keystore has a private key entry for alias '" + alias + "', but the associated certificate chain is empty.");
                chain = new X509Certificate[genericChain.length];
                for (int i2 = 0; i2 < genericChain.length; ++i2) {
                    chain[i2] = new X509Certificate(genericChain[i2].getEncoded());
                }
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHECK_USABILITY_GOT_CHAIN.get(alias));
                for (X509Certificate c : chain) {
                    this.out(new Object[0]);
                    this.printCertificate(c, "", false);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_CANNOT_GET_CHAIN.get(alias));
                e.printStackTrace(this.getErr());
                return ResultCode.LOCAL_ERROR;
            }
        } else {
            if (ManageCertificates.hasCertificateAlias(keystore, alias)) {
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_NO_PRIVATE_KEY.get(alias));
                return ResultCode.PARAM_ERROR;
            }
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_NO_SUCH_ALIAS.get(alias));
            return ResultCode.PARAM_ERROR;
        }
        int numWarnings = 0;
        int numErrors = 0;
        if (chain[0].isSelfSigned()) {
            this.err(new Object[0]);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.WARN_MANAGE_CERTS_CHECK_USABILITY_CERT_IS_SELF_SIGNED.get(chain[0].getSubjectDN()));
            ++numWarnings;
        } else if (chain.length == 1 || !chain[chain.length - 1].isSelfSigned()) {
            this.err(new Object[0]);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_END_OF_CHAIN_NOT_SELF_SIGNED.get(alias));
            ++numErrors;
        } else {
            boolean chainError = false;
            StringBuilder nonMatchReason = new StringBuilder();
            for (int i3 = 1; i3 < chain.length; ++i3) {
                if (chain[i3].isIssuerFor(chain[i3 - 1], nonMatchReason)) continue;
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_CHAIN_ISSUER_MISMATCH.get(alias, chain[i3].getSubjectDN(), chain[i3 - 1].getSubjectDN(), nonMatchReason));
                ++numErrors;
                chainError = true;
            }
            if (!chainError) {
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHECK_USABILITY_CHAIN_COMPLETE.get());
            }
        }
        if (chain.length > 1 && chain[chain.length - 1].isSelfSigned()) {
            X509Certificate caCert = chain[chain.length - 1];
            try {
                String jvmDefaultTrustStoreType = this.inferKeystoreType(JVM_DEFAULT_CACERTS_FILE);
                KeyStore jvmDefaultTrustStore = CryptoHelper.getKeyStore(jvmDefaultTrustStoreType);
                try (FileInputStream inputStream = new FileInputStream(JVM_DEFAULT_CACERTS_FILE);){
                    jvmDefaultTrustStore.load(inputStream, null);
                }
                boolean found = false;
                Enumeration<String> aliases = jvmDefaultTrustStore.aliases();
                while (aliases.hasMoreElements()) {
                    String jvmDefaultCertAlias = aliases.nextElement();
                    if (!jvmDefaultTrustStore.isCertificateEntry(jvmDefaultCertAlias)) continue;
                    Certificate c = jvmDefaultTrustStore.getCertificate(jvmDefaultCertAlias);
                    X509Certificate xc = new X509Certificate(c.getEncoded());
                    if (!caCert.getSubjectDN().equals(xc.getSubjectDN()) || !Arrays.equals(caCert.getSignatureValue().getBits(), xc.getSignatureValue().getBits())) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.out(new Object[0]);
                    this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHECK_USABILITY_CA_TRUSTED_OK.get(caCert.getSubjectDN()));
                } else {
                    this.out(new Object[0]);
                    this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHECK_USABILITY_CA_NOT_IN_JVM_DEFAULT_TS.get(caCert.getSubjectDN()));
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.WARN_MANAGE_CERTS_CHECK_USABILITY_CHECK_CA_IN_TS_ERROR.get(caCert.getSubjectDN(), StaticUtils.getExceptionMessage(e)));
                ++numWarnings;
            }
        }
        for (int i4 = 0; i4 < chain.length; ++i4) {
            X509Certificate c = chain[i4];
            try {
                if (c.isSelfSigned()) {
                    c.verifySignature(null);
                } else if (i4 + 1 < chain.length) {
                    c.verifySignature(chain[i4 + 1]);
                }
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHECK_USABILITY_CERT_SIGNATURE_VALID.get(c.getSubjectDN()));
                continue;
            }
            catch (CertException ce) {
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, ce.getMessage());
                ++numErrors;
            }
        }
        long currentTime = System.currentTimeMillis();
        long thirtyDaysFromNow = currentTime + 2592000000L;
        for (i = 0; i < chain.length; ++i) {
            X509Certificate c = chain[i];
            if (c.getNotBeforeTime() > currentTime) {
                this.err(new Object[0]);
                if (i == 0) {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_END_CERT_NOT_YET_VALID.get(c.getSubjectDN(), ManageCertificates.formatDateAndTime(c.getNotBeforeDate())));
                } else {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_ISSUER_CERT_NOT_YET_VALID.get(c.getSubjectDN(), ManageCertificates.formatDateAndTime(c.getNotBeforeDate())));
                }
                ++numErrors;
                continue;
            }
            if (c.getNotAfterTime() < currentTime) {
                this.err(new Object[0]);
                if (i == 0) {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_END_CERT_EXPIRED.get(c.getSubjectDN(), ManageCertificates.formatDateAndTime(c.getNotAfterDate())));
                } else {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_ISSUER_CERT_EXPIRED.get(c.getSubjectDN(), ManageCertificates.formatDateAndTime(c.getNotAfterDate())));
                }
                ++numErrors;
                continue;
            }
            if (c.getNotAfterTime() < thirtyDaysFromNow) {
                this.err(new Object[0]);
                if (i == 0) {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.WARN_MANAGE_CERTS_CHECK_USABILITY_END_CERT_NEAR_EXPIRATION.get(c.getSubjectDN(), ManageCertificates.formatDateAndTime(c.getNotAfterDate())));
                } else {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.WARN_MANAGE_CERTS_CHECK_USABILITY_ISSUER_CERT_NEAR_EXPIRATION.get(c.getSubjectDN(), ManageCertificates.formatDateAndTime(c.getNotAfterDate())));
                }
                ++numWarnings;
                continue;
            }
            if (i == 0) {
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHECK_USABILITY_END_CERT_VALIDITY_OK.get(c.getSubjectDN(), ManageCertificates.formatDateAndTime(c.getNotAfterDate())));
                continue;
            }
            this.out(new Object[0]);
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHECK_USABILITY_ISSUER_CERT_VALIDITY_OK.get(c.getSubjectDN(), ManageCertificates.formatDateAndTime(c.getNotAfterDate())));
        }
        for (i = 0; i < chain.length; ++i) {
            boolean basicConstraintsFound = false;
            boolean extendedKeyUsageFound = false;
            boolean keyUsageFound = false;
            X509Certificate c = chain[i];
            for (X509CertificateExtension extension : c.getExtensions()) {
                X509CertificateExtension e;
                if (extension instanceof ExtendedKeyUsageExtension) {
                    extendedKeyUsageFound = true;
                    if (i != 0) continue;
                    e = (ExtendedKeyUsageExtension)extension;
                    if (!((ExtendedKeyUsageExtension)e).getKeyPurposeIDs().contains(ExtendedKeyUsageID.TLS_SERVER_AUTHENTICATION.getOID())) {
                        this.err(new Object[0]);
                        this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_END_CERT_BAD_EKU.get(c.getSubjectDN()));
                        ++numErrors;
                        continue;
                    }
                    this.out(new Object[0]);
                    this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHECK_USABILITY_END_CERT_GOOD_EKU.get(c.getSubjectDN()));
                    continue;
                }
                if (extension instanceof BasicConstraintsExtension) {
                    basicConstraintsFound = true;
                    if (i <= 0) continue;
                    e = (BasicConstraintsExtension)extension;
                    if (!((BasicConstraintsExtension)e).isCA()) {
                        this.err(new Object[0]);
                        this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_ISSUER_CERT_BAD_BC_CA.get(c.getSubjectDN()));
                        ++numErrors;
                        continue;
                    }
                    if (((BasicConstraintsExtension)e).getPathLengthConstraint() != null && i - 1 > ((BasicConstraintsExtension)e).getPathLengthConstraint()) {
                        this.err(new Object[0]);
                        this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_ISSUER_CERT_BAD_BC_LENGTH.get(c.getSubjectDN(), ((BasicConstraintsExtension)e).getPathLengthConstraint(), chain[0].getSubjectDN(), i - 1));
                        ++numErrors;
                        continue;
                    }
                    this.out(new Object[0]);
                    this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHECK_USABILITY_ISSUER_CERT_GOOD_BC.get(c.getSubjectDN()));
                    continue;
                }
                if (!(extension instanceof KeyUsageExtension)) continue;
                keyUsageFound = true;
                if (i <= 0) continue;
                e = (KeyUsageExtension)extension;
                if (!((KeyUsageExtension)e).isKeyCertSignBitSet()) {
                    this.err(new Object[0]);
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_ISSUER_NO_CERT_SIGN_KU.get(c.getSubjectDN()));
                    ++numErrors;
                    continue;
                }
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHECK_USABILITY_ISSUER_GOOD_KU.get(c.getSubjectDN()));
            }
            if (i == 0) {
                if (extendedKeyUsageFound) continue;
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.WARN_MANAGE_CERTS_CHECK_USABILITY_NO_EKU.get(c.getSubjectDN()));
                ++numWarnings;
                continue;
            }
            if (!basicConstraintsFound) {
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.WARN_MANAGE_CERTS_CHECK_USABILITY_NO_BC.get(c.getSubjectDN()));
                ++numWarnings;
            }
            if (keyUsageFound) continue;
            this.err(new Object[0]);
            this.wrapErr(0, WRAP_COLUMN, CertMessages.WARN_MANAGE_CERTS_CHECK_USABILITY_NO_KU.get(c.getSubjectDN()));
            ++numWarnings;
        }
        boolean isIssuer = false;
        BooleanArgument ignoreSHA1WarningArg = this.subCommandParser.getBooleanArgument("allow-sha-1-signature-for-issuer-certificates");
        boolean ignoreSHA1SignatureWarningForIssuerCertificates = ignoreSHA1WarningArg != null && ignoreSHA1WarningArg.isPresent();
        for (X509Certificate c : chain) {
            OID signatureAlgorithmOID = c.getSignatureAlgorithmOID();
            SignatureAlgorithmIdentifier id = SignatureAlgorithmIdentifier.forOID(signatureAlgorithmOID);
            if (id == null) {
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.WARN_MANAGE_CERTS_CHECK_USABILITY_UNKNOWN_SIG_ALG.get(c.getSubjectDN(), signatureAlgorithmOID));
                ++numWarnings;
            } else {
                switch (id) {
                    case MD2_WITH_RSA: 
                    case MD5_WITH_RSA: {
                        this.err(new Object[0]);
                        this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_WEAK_SIG_ALG.get(c.getSubjectDN(), id.getUserFriendlyName()));
                        ++numErrors;
                        break;
                    }
                    case SHA_1_WITH_RSA: 
                    case SHA_1_WITH_DSA: 
                    case SHA_1_WITH_ECDSA: {
                        if (isIssuer && ignoreSHA1SignatureWarningForIssuerCertificates) {
                            this.err(new Object[0]);
                            this.wrapErr(0, WRAP_COLUMN, CertMessages.WARN_MANAGE_CERTS_CHECK_USABILITY_ISSUER_WITH_SHA1_SIG.get(c.getSubjectDN(), id.getUserFriendlyName(), ignoreSHA1WarningArg.getIdentifierString()));
                            break;
                        }
                        this.err(new Object[0]);
                        this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_WEAK_SIG_ALG.get(c.getSubjectDN(), id.getUserFriendlyName()));
                        ++numErrors;
                        break;
                    }
                    case SHA_224_WITH_RSA: 
                    case SHA_224_WITH_DSA: 
                    case SHA_224_WITH_ECDSA: 
                    case SHA_256_WITH_RSA: 
                    case SHA_256_WITH_DSA: 
                    case SHA_256_WITH_ECDSA: 
                    case SHA_384_WITH_RSA: 
                    case SHA_384_WITH_ECDSA: 
                    case SHA_512_WITH_RSA: 
                    case SHA_512_WITH_ECDSA: {
                        this.out(new Object[0]);
                        this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHECK_USABILITY_SIG_ALG_OK.get(c.getSubjectDN(), id.getUserFriendlyName()));
                    }
                }
            }
            isIssuer = true;
        }
        for (X509Certificate c : chain) {
            if (c.getDecodedPublicKey() == null || !(c.getDecodedPublicKey() instanceof RSAPublicKey)) continue;
            RSAPublicKey rsaPublicKey = (RSAPublicKey)c.getDecodedPublicKey();
            byte[] modulusBytes = rsaPublicKey.getModulus().toByteArray();
            int modulusSizeBits = modulusBytes.length * 8;
            if (modulusBytes.length % 2 != 0 && modulusBytes[0] == 0) {
                modulusSizeBits -= 8;
            }
            if (modulusSizeBits < 2048) {
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_WEAK_RSA_MODULUS.get(c.getSubjectDN(), modulusSizeBits));
                ++numErrors;
                continue;
            }
            this.out(new Object[0]);
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHECK_USABILITY_RSA_MODULUS_OK.get(c.getSubjectDN(), modulusSizeBits));
        }
        switch (numErrors) {
            case 0: {
                break;
            }
            case 1: {
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_ONE_ERROR.get());
                return ResultCode.PARAM_ERROR;
            }
            default: {
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_MULTIPLE_ERRORS.get(numErrors));
                return ResultCode.PARAM_ERROR;
            }
        }
        switch (numWarnings) {
            case 0: {
                this.out(new Object[0]);
                this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CHECK_USABILITY_NO_ERRORS_OR_WARNINGS.get());
                return ResultCode.SUCCESS;
            }
            case 1: {
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_ONE_WARNING.get());
                return ResultCode.PARAM_ERROR;
            }
        }
        this.err(new Object[0]);
        this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_CHECK_USABILITY_MULTIPLE_WARNINGS.get(numWarnings));
        return ResultCode.PARAM_ERROR;
    }

    @NotNull
    private ResultCode doDisplayCertificateFile() {
        List<X509Certificate> certificates;
        FileArgument certificateFileArgument = this.subCommandParser.getFileArgument("certificate-file");
        File certificateFile = certificateFileArgument.getValue();
        BooleanArgument verboseArgument = this.subCommandParser.getBooleanArgument("verbose");
        boolean verbose = verboseArgument != null && verboseArgument.isPresent();
        BooleanArgument displayKeytoolCommandArgument = this.subCommandParser.getBooleanArgument("display-keytool-command");
        if (displayKeytoolCommandArgument != null && displayKeytoolCommandArgument.isPresent()) {
            ArrayList<String> keytoolArgs = new ArrayList<String>(10);
            keytoolArgs.add("-printcert");
            keytoolArgs.add("-file");
            keytoolArgs.add(certificateFile.getAbsolutePath());
            if (verbose) {
                keytoolArgs.add("-v");
            }
            this.displayKeytoolCommand(keytoolArgs);
        }
        try {
            certificates = ManageCertificates.readCertificatesFromFile(certificateFile);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        if (certificates.isEmpty()) {
            this.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_DISPLAY_CERT_NO_CERTS.get(certificateFile.getAbsolutePath()));
        } else {
            for (X509Certificate c : certificates) {
                this.out(new Object[0]);
                this.printCertificate(c, "", verbose);
            }
        }
        return ResultCode.SUCCESS;
    }

    @NotNull
    private ResultCode doDisplayCertificateSigningRequestFile() {
        PKCS10CertificateSigningRequest csr;
        FileArgument csrFileArgument = this.subCommandParser.getFileArgument("certificate-signing-request-file");
        File csrFile = csrFileArgument.getValue();
        BooleanArgument verboseArgument = this.subCommandParser.getBooleanArgument("verbose");
        boolean verbose = verboseArgument != null && verboseArgument.isPresent();
        BooleanArgument displayKeytoolCommandArgument = this.subCommandParser.getBooleanArgument("display-keytool-command");
        if (displayKeytoolCommandArgument != null && displayKeytoolCommandArgument.isPresent()) {
            ArrayList<String> keytoolArgs = new ArrayList<String>(10);
            keytoolArgs.add("-printcertreq");
            keytoolArgs.add("-file");
            keytoolArgs.add(csrFile.getAbsolutePath());
            keytoolArgs.add("-v");
            this.displayKeytoolCommand(keytoolArgs);
        }
        try {
            csr = ManageCertificates.readCertificateSigningRequestFromFile(csrFile);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.wrapErr(0, WRAP_COLUMN, le.getMessage());
            return le.getResultCode();
        }
        this.out(new Object[0]);
        this.printCertificateSigningRequest(csr, verbose, "");
        return ResultCode.SUCCESS;
    }

    private void printCertificate(@NotNull X509Certificate certificate, @NotNull String indent, boolean verbose) {
        String pkSummary;
        if (verbose) {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_VERSION.get(certificate.getVersion().getName()));
        }
        this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_SUBJECT_DN.get(certificate.getSubjectDN()));
        this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_ISSUER_DN.get(certificate.getIssuerDN()));
        if (verbose) {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_SERIAL_NUMBER.get(ManageCertificates.toColonDelimitedHex(certificate.getSerialNumber().toByteArray())));
        }
        this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_VALIDITY_START.get(ManageCertificates.formatDateAndTime(certificate.getNotBeforeDate())));
        this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_VALIDITY_END.get(ManageCertificates.formatDateAndTime(certificate.getNotAfterDate())));
        long currentTime = System.currentTimeMillis();
        if (currentTime < certificate.getNotBeforeTime()) {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_VALIDITY_STATE_NOT_YET_VALID.get());
        } else if (currentTime > certificate.getNotAfterTime()) {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_VALIDITY_STATE_EXPIRED.get());
        } else {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_VALIDITY_STATE_VALID.get());
        }
        this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_SIG_ALG.get(certificate.getSignatureAlgorithmNameOrOID()));
        if (verbose) {
            String signatureString;
            try {
                signatureString = ManageCertificates.toColonDelimitedHex(certificate.getSignatureValue().getBytes());
            }
            catch (Exception e) {
                Debug.debugException(e);
                signatureString = certificate.getSignatureValue().toString();
            }
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_SIG_VALUE.get());
            for (String line : StaticUtils.wrapLine(signatureString, 78)) {
                this.out(indent + "     " + line);
            }
        }
        String pkAlg = (pkSummary = ManageCertificates.getPublicKeySummary(certificate.getPublicKeyAlgorithmOID(), certificate.getDecodedPublicKey(), certificate.getPublicKeyAlgorithmParameters())) == null ? certificate.getPublicKeyAlgorithmNameOrOID() : certificate.getPublicKeyAlgorithmNameOrOID() + " (" + pkSummary + ')';
        this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_PK_ALG.get(pkAlg));
        if (verbose) {
            this.printPublicKey(certificate.getEncodedPublicKey(), certificate.getDecodedPublicKey(), certificate.getPublicKeyAlgorithmParameters(), indent);
            if (certificate.getSubjectUniqueID() != null) {
                String subjectUniqueID;
                try {
                    subjectUniqueID = ManageCertificates.toColonDelimitedHex(certificate.getSubjectUniqueID().getBytes());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    subjectUniqueID = certificate.getSubjectUniqueID().toString();
                }
                this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_SUBJECT_UNIQUE_ID.get());
                for (String line : StaticUtils.wrapLine(subjectUniqueID, 78)) {
                    this.out(indent + "     " + line);
                }
            }
            if (certificate.getIssuerUniqueID() != null) {
                String issuerUniqueID;
                try {
                    issuerUniqueID = ManageCertificates.toColonDelimitedHex(certificate.getIssuerUniqueID().getBytes());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    issuerUniqueID = certificate.getIssuerUniqueID().toString();
                }
                this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_ISSUER_UNIQUE_ID.get());
                for (String line : StaticUtils.wrapLine(issuerUniqueID, 78)) {
                    this.out(indent + "     " + line);
                }
            }
            this.printExtensions(certificate.getExtensions(), indent);
        }
        try {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_FINGERPRINT.get("SHA-1", ManageCertificates.toColonDelimitedHex(certificate.getSHA1Fingerprint())));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_FINGERPRINT.get("SHA-256", ManageCertificates.toColonDelimitedHex(certificate.getSHA256Fingerprint())));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    private void printCertificateSigningRequest(@NotNull PKCS10CertificateSigningRequest csr, boolean verbose, @NotNull String indent) {
        String pkSummary;
        this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CSR_LABEL_VERSION.get(csr.getVersion().getName()));
        this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_SUBJECT_DN.get(csr.getSubjectDN()));
        this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_SIG_ALG.get(csr.getSignatureAlgorithmNameOrOID()));
        if (verbose) {
            String signatureString;
            try {
                signatureString = ManageCertificates.toColonDelimitedHex(csr.getSignatureValue().getBytes());
            }
            catch (Exception e) {
                Debug.debugException(e);
                signatureString = csr.getSignatureValue().toString();
            }
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_SIG_VALUE.get());
            for (String line : StaticUtils.wrapLine(signatureString, 78)) {
                this.out(indent + "     " + line);
            }
        }
        String pkAlg = (pkSummary = ManageCertificates.getPublicKeySummary(csr.getPublicKeyAlgorithmOID(), csr.getDecodedPublicKey(), csr.getPublicKeyAlgorithmParameters())) == null ? csr.getPublicKeyAlgorithmNameOrOID() : csr.getPublicKeyAlgorithmNameOrOID() + " (" + pkSummary + ')';
        this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_PK_ALG.get(pkAlg));
        if (verbose) {
            this.printPublicKey(csr.getEncodedPublicKey(), csr.getDecodedPublicKey(), csr.getPublicKeyAlgorithmParameters(), indent);
            this.printExtensions(csr.getExtensions(), indent);
        }
    }

    private void printPublicKey(@NotNull ASN1BitString encodedPublicKey, @Nullable DecodedPublicKey decodedPublicKey, @Nullable ASN1Element parameters, @NotNull String indent) {
        if (decodedPublicKey == null) {
            String pkString;
            try {
                pkString = ManageCertificates.toColonDelimitedHex(encodedPublicKey.getBytes());
            }
            catch (Exception e) {
                Debug.debugException(e);
                pkString = encodedPublicKey.toString();
            }
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_ENCODED_PK.get());
            for (String line : StaticUtils.wrapLine(pkString, 78)) {
                this.out(indent + "     " + line);
            }
            return;
        }
        if (decodedPublicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)decodedPublicKey;
            byte[] modulusBytes = rsaPublicKey.getModulus().toByteArray();
            int modulusSizeBits = modulusBytes.length * 8;
            if (modulusBytes.length % 2 != 0 && modulusBytes[0] == 0) {
                modulusSizeBits -= 8;
            }
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_RSA_MODULUS.get(modulusSizeBits));
            String modulusHex = ManageCertificates.toColonDelimitedHex(modulusBytes);
            for (String line : StaticUtils.wrapLine(modulusHex, 78)) {
                this.out(indent + "     " + line);
            }
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_RSA_EXPONENT.get(ManageCertificates.toColonDelimitedHex(rsaPublicKey.getPublicExponent().toByteArray())));
        } else if (decodedPublicKey instanceof EllipticCurvePublicKey) {
            EllipticCurvePublicKey ecPublicKey = (EllipticCurvePublicKey)decodedPublicKey;
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EC_IS_COMPRESSED.get(String.valueOf(ecPublicKey.usesCompressedForm())));
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EC_X.get(String.valueOf(ecPublicKey.getXCoordinate())));
            if (ecPublicKey.getYCoordinate() == null) {
                this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EC_Y_IS_EVEN.get(String.valueOf(ecPublicKey.yCoordinateIsEven())));
            } else {
                this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EC_Y.get(String.valueOf(ecPublicKey.getYCoordinate())));
            }
        }
    }

    @NotNull
    private static String getPublicKeySummary(@NotNull OID publicKeyAlgorithmOID, @Nullable DecodedPublicKey publicKey, @Nullable ASN1Element parameters) {
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            byte[] modulusBytes = rsaPublicKey.getModulus().toByteArray();
            int modulusSizeBits = modulusBytes.length * 8;
            if (modulusBytes.length % 2 != 0 && modulusBytes[0] == 0) {
                modulusSizeBits -= 8;
            }
            return CertMessages.INFO_MANAGE_CERTS_GET_PK_SUMMARY_RSA_MODULUS_SIZE.get(modulusSizeBits);
        }
        if (parameters != null && publicKeyAlgorithmOID.equals(PublicKeyAlgorithmIdentifier.EC.getOID())) {
            try {
                OID namedCurveOID = parameters.decodeAsObjectIdentifier().getOID();
                return NamedCurve.getNameOrOID(namedCurveOID);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return null;
    }

    void printExtensions(@NotNull List<X509CertificateExtension> extensions, @NotNull String indent) {
        if (extensions.isEmpty()) {
            return;
        }
        this.out(indent + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXTENSIONS.get());
        for (X509CertificateExtension extension : extensions) {
            String idHex;
            X509CertificateExtension e;
            if (extension instanceof AuthorityKeyIdentifierExtension) {
                this.out(indent + "     " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_AUTH_KEY_ID_EXT.get());
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_OID.get(extension.getOID().toString()));
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_IS_CRITICAL.get(String.valueOf(extension.isCritical())));
                e = (AuthorityKeyIdentifierExtension)extension;
                if (((AuthorityKeyIdentifierExtension)e).getKeyIdentifier() != null) {
                    this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_AUTH_KEY_ID_ID.get());
                    idHex = ManageCertificates.toColonDelimitedHex(((AuthorityKeyIdentifierExtension)e).getKeyIdentifier().getValue());
                    for (String line : StaticUtils.wrapLine(idHex, 78)) {
                        this.out(indent + "               " + line);
                    }
                }
                if (((AuthorityKeyIdentifierExtension)e).getAuthorityCertIssuer() != null) {
                    this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_AUTH_KEY_ID_ISSUER.get());
                    this.printGeneralNames(((AuthorityKeyIdentifierExtension)e).getAuthorityCertIssuer(), indent + "               ");
                }
                if (((AuthorityKeyIdentifierExtension)e).getAuthorityCertSerialNumber() == null) continue;
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_AUTH_KEY_ID_SERIAL.get(ManageCertificates.toColonDelimitedHex(((AuthorityKeyIdentifierExtension)e).getAuthorityCertSerialNumber().toByteArray())));
                continue;
            }
            if (extension instanceof BasicConstraintsExtension) {
                this.out(indent + "     " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_BASIC_CONST_EXT.get());
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_OID.get(extension.getOID().toString()));
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_IS_CRITICAL.get(String.valueOf(extension.isCritical())));
                e = (BasicConstraintsExtension)extension;
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_BASIC_CONST_IS_CA.get(String.valueOf(((BasicConstraintsExtension)e).isCA())));
                if (((BasicConstraintsExtension)e).getPathLengthConstraint() == null) continue;
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_BASIC_CONST_LENGTH.get(((BasicConstraintsExtension)e).getPathLengthConstraint()));
                continue;
            }
            if (extension instanceof CRLDistributionPointsExtension) {
                this.out(indent + "     " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_CRL_DP_EXT.get());
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_OID.get(extension.getOID().toString()));
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_IS_CRITICAL.get(String.valueOf(extension.isCritical())));
                CRLDistributionPointsExtension crlDPE = (CRLDistributionPointsExtension)extension;
                for (CRLDistributionPoint dp : crlDPE.getCRLDistributionPoints()) {
                    this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_CRL_DP_HEADER.get());
                    if (dp.getFullName() != null) {
                        this.out(indent + "               " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_CRL_DP_FULL_NAME.get());
                        this.printGeneralNames(dp.getFullName(), indent + "                    ");
                    }
                    if (dp.getNameRelativeToCRLIssuer() != null) {
                        this.out(indent + "               " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_CRL_DP_REL_NAME.get(dp.getNameRelativeToCRLIssuer()));
                    }
                    if (!dp.getPotentialRevocationReasons().isEmpty()) {
                        this.out(indent + "               " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_CRL_DP_REASON.get());
                        for (CRLDistributionPointRevocationReason r : dp.getPotentialRevocationReasons()) {
                            this.out(indent + "                    " + r.getName());
                        }
                    }
                    if (dp.getCRLIssuer() == null) continue;
                    this.out(indent + "              " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_CRL_DP_CRL_ISSUER.get());
                    this.printGeneralNames(dp.getCRLIssuer(), indent + "                    ");
                }
                continue;
            }
            if (extension instanceof ExtendedKeyUsageExtension) {
                this.out(indent + "     " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_EKU_EXT.get());
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_OID.get(extension.getOID().toString()));
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_IS_CRITICAL.get(String.valueOf(extension.isCritical())));
                e = (ExtendedKeyUsageExtension)extension;
                for (OID oid : ((ExtendedKeyUsageExtension)e).getKeyPurposeIDs()) {
                    ExtendedKeyUsageID id = ExtendedKeyUsageID.forOID(oid);
                    if (id == null) {
                        this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_EKU_ID.get(oid));
                        continue;
                    }
                    this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_EKU_ID.get(id.getName()));
                }
                continue;
            }
            if (extension instanceof IssuerAlternativeNameExtension) {
                this.out(indent + "     " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_IAN_EXT.get());
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_OID.get(extension.getOID().toString()));
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_IS_CRITICAL.get(String.valueOf(extension.isCritical())));
                e = (IssuerAlternativeNameExtension)extension;
                this.printGeneralNames(((GeneralAlternativeNameExtension)e).getGeneralNames(), indent + "          ");
                continue;
            }
            if (extension instanceof KeyUsageExtension) {
                this.out(indent + "     " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_KU_EXT.get());
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_OID.get(extension.getOID().toString()));
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_IS_CRITICAL.get(String.valueOf(extension.isCritical())));
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_KU_USAGES.get());
                KeyUsageExtension kue = (KeyUsageExtension)extension;
                if (kue.isDigitalSignatureBitSet()) {
                    this.out(indent + "               " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_KU_DS.get());
                }
                if (kue.isNonRepudiationBitSet()) {
                    this.out(indent + "               " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_KU_NR.get());
                }
                if (kue.isKeyEnciphermentBitSet()) {
                    this.out(indent + "               " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_KU_KE.get());
                }
                if (kue.isDataEnciphermentBitSet()) {
                    this.out(indent + "               " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_KU_DE.get());
                }
                if (kue.isKeyAgreementBitSet()) {
                    this.out(indent + "               " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_KU_KA.get());
                }
                if (kue.isKeyCertSignBitSet()) {
                    this.out(indent + "               " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_KU_KCS.get());
                }
                if (kue.isCRLSignBitSet()) {
                    this.out(indent + "               " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_KU_CRL_SIGN.get());
                }
                if (kue.isEncipherOnlyBitSet()) {
                    this.out(indent + "               " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_KU_EO.get());
                }
                if (!kue.isDecipherOnlyBitSet()) continue;
                this.out(indent + "               " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_KU_DO.get());
                continue;
            }
            if (extension instanceof SubjectAlternativeNameExtension) {
                this.out(indent + "     " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_SAN_EXT.get());
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_OID.get(extension.getOID().toString()));
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_IS_CRITICAL.get(String.valueOf(extension.isCritical())));
                e = (SubjectAlternativeNameExtension)extension;
                this.printGeneralNames(((GeneralAlternativeNameExtension)e).getGeneralNames(), indent + "          ");
                continue;
            }
            if (extension instanceof SubjectKeyIdentifierExtension) {
                this.out(indent + "     " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_SKI_EXT.get());
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_OID.get(extension.getOID().toString()));
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_IS_CRITICAL.get(String.valueOf(extension.isCritical())));
                e = (SubjectKeyIdentifierExtension)extension;
                idHex = ManageCertificates.toColonDelimitedHex(((SubjectKeyIdentifierExtension)e).getKeyIdentifier().getValue());
                this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_SKI_ID.get());
                for (String line : StaticUtils.wrapLine(idHex, 78)) {
                    this.out(indent + "               " + line);
                }
                continue;
            }
            this.out(indent + "     " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_GENERIC.get());
            this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_OID.get(extension.getOID().toString()));
            this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_IS_CRITICAL.get(String.valueOf(extension.isCritical())));
            String valueHex = ManageCertificates.toColonDelimitedHex(extension.getValue());
            this.out(indent + "          " + CertMessages.INFO_MANAGE_CERTS_PRINT_CERT_LABEL_EXT_VALUE.get());
            this.getOut().print(StaticUtils.toHexPlusASCII(extension.getValue(), indent.length() + 15));
        }
    }

    private void printGeneralNames(@NotNull GeneralNames generalNames, @NotNull String indent) {
        for (String dnsName : generalNames.getDNSNames()) {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_GENERAL_NAMES_LABEL_DNS.get(dnsName));
        }
        for (InetAddress ipAddress : generalNames.getIPAddresses()) {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_GENERAL_NAMES_LABEL_IP.get(ipAddress.getHostAddress()));
        }
        for (String name : generalNames.getRFC822Names()) {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_GENERAL_NAMES_LABEL_RFC_822_NAME.get(name));
        }
        for (DN dn : generalNames.getDirectoryNames()) {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_GENERAL_NAMES_LABEL_DIRECTORY_NAME.get(String.valueOf(dn)));
        }
        for (String uri : generalNames.getUniformResourceIdentifiers()) {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_GENERAL_NAMES_LABEL_URI.get(uri));
        }
        for (OID oid : generalNames.getRegisteredIDs()) {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_GENERAL_NAMES_LABEL_REGISTERED_ID.get(oid.toString()));
        }
        if (!generalNames.getOtherNames().isEmpty()) {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_GENERAL_NAMES_LABEL_OTHER_NAME_COUNT.get(generalNames.getOtherNames().size()));
        }
        if (!generalNames.getX400Addresses().isEmpty()) {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_GENERAL_NAMES_LABEL_X400_ADDR_COUNT.get(generalNames.getX400Addresses().size()));
        }
        if (!generalNames.getEDIPartyNames().isEmpty()) {
            this.out(indent + CertMessages.INFO_MANAGE_CERTS_GENERAL_NAMES_LABEL_EDI_PARTY_NAME_COUNT.get(generalNames.getEDIPartyNames().size()));
        }
    }

    private static void writePEMCertificate(@NotNull PrintStream printStream, @NotNull byte[] encodedCertificate) {
        String certBase64 = Base64.encode(encodedCertificate);
        printStream.println("-----BEGIN CERTIFICATE-----");
        for (String line : StaticUtils.wrapLine(certBase64, 64)) {
            printStream.println(line);
        }
        printStream.println("-----END CERTIFICATE-----");
    }

    private static void writePEMCertificateSigningRequest(@NotNull PrintStream printStream, @NotNull byte[] encodedCSR) {
        String certBase64 = Base64.encode(encodedCSR);
        printStream.println("-----BEGIN CERTIFICATE REQUEST-----");
        for (String line : StaticUtils.wrapLine(certBase64, 64)) {
            printStream.println(line);
        }
        printStream.println("-----END CERTIFICATE REQUEST-----");
    }

    private static void writePEMPrivateKey(@NotNull PrintStream printStream, @NotNull byte[] encodedPrivateKey, @Nullable char[] encryptionPassword) throws LDAPException {
        if (encryptionPassword == null) {
            String certBase64 = Base64.encode(encodedPrivateKey);
            printStream.println("-----BEGIN PRIVATE KEY-----");
            for (String line : StaticUtils.wrapLine(certBase64, 64)) {
                printStream.println(line);
            }
            printStream.println("-----END PRIVATE KEY-----");
        } else {
            byte[] encryptedPrivateKey;
            try {
                encryptedPrivateKey = PKCS8EncryptionHandler.encryptPrivateKey(encodedPrivateKey, encryptionPassword, new PKCS8EncryptionProperties());
            }
            catch (CertException e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, e.getMessage(), e);
            }
            String encryptedCertBase64 = Base64.encode(encryptedPrivateKey);
            printStream.println("-----BEGIN ENCRYPTED PRIVATE KEY-----");
            for (String line : StaticUtils.wrapLine(encryptedCertBase64, 64)) {
                printStream.println(line);
            }
            printStream.println("-----END ENCRYPTED PRIVATE KEY-----");
        }
    }

    private void displayKeytoolCommand(@NotNull List<String> keytoolArgs) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("#      keytool");
        boolean lastWasArgName = false;
        for (String arg : keytoolArgs) {
            if (arg.startsWith("-")) {
                buffer.append(' ');
                buffer.append(StaticUtils.getCommandLineContinuationString());
                buffer.append(StaticUtils.EOL);
                buffer.append("#           ");
                buffer.append(arg);
                lastWasArgName = true;
                continue;
            }
            if (lastWasArgName) {
                buffer.append(' ');
                buffer.append(StaticUtils.cleanExampleCommandLineArgument(arg));
                lastWasArgName = false;
                continue;
            }
            buffer.append(' ');
            buffer.append(StaticUtils.getCommandLineContinuationString());
            buffer.append(StaticUtils.EOL);
            buffer.append("#           ");
            buffer.append(arg);
            lastWasArgName = false;
        }
        this.out(new Object[0]);
        this.out(CertMessages.INFO_MANAGE_CERTS_APPROXIMATE_KEYTOOL_COMMAND.get());
        this.out(buffer);
        this.out(new Object[0]);
    }

    @Nullable
    private File getKeystorePath() {
        return this.getKeystorePath("keystore");
    }

    @Nullable
    private File getKeystorePath(@NotNull String keystoreArgumentName) {
        FileArgument keystoreArgument = this.subCommandParser.getFileArgument(keystoreArgumentName);
        if (keystoreArgument != null && keystoreArgument.isPresent()) {
            return keystoreArgument.getValue();
        }
        BooleanArgument useJVMDefaultTrustStoreArgument = this.subCommandParser.getBooleanArgument("useJVMDefaultTrustStore");
        if (useJVMDefaultTrustStoreArgument != null && useJVMDefaultTrustStoreArgument.isPresent()) {
            return JVM_DEFAULT_CACERTS_FILE;
        }
        return null;
    }

    @Nullable
    private char[] getKeystorePassword(@NotNull File keystoreFile) throws LDAPException {
        return this.getKeystorePassword(keystoreFile, null);
    }

    @Nullable
    private char[] getKeystorePassword(@NotNull File keystoreFile, @Nullable String prefix) throws LDAPException {
        String prefixDash = prefix == null ? "" : prefix + '-';
        StringArgument keystorePasswordArgument = this.subCommandParser.getStringArgument(prefixDash + "keystore-password");
        if (keystorePasswordArgument != null && keystorePasswordArgument.isPresent()) {
            char[] keystorePWChars = keystorePasswordArgument.getValue().toCharArray();
            if (!keystoreFile.exists() && keystorePWChars.length < 6) {
                throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_GET_KS_PW_TOO_SHORT.get());
            }
            return keystorePWChars;
        }
        FileArgument keystorePasswordFileArgument = this.subCommandParser.getFileArgument(prefixDash + "keystore-password-file");
        if (keystorePasswordFileArgument != null && keystorePasswordFileArgument.isPresent()) {
            File f = keystorePasswordFileArgument.getValue();
            try {
                char[] passwordChars = this.getPasswordFileReader().readPassword(f);
                if (passwordChars.length < 6) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_GET_KS_PW_TOO_SHORT.get());
                }
                return passwordChars;
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw e;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_GET_KS_PW_ERROR_READING_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
        BooleanArgument promptArgument = this.subCommandParser.getBooleanArgument("prompt-for-" + prefixDash + "keystore-password");
        if (promptArgument != null && promptArgument.isPresent()) {
            this.out(new Object[0]);
            if (keystoreFile.exists() && !"new".equals(prefix)) {
                if (prefix != null && prefix.equals("current")) {
                    return this.promptForPassword(CertMessages.INFO_MANAGE_CERTS_KEY_KS_PW_EXISTING_CURRENT_PROMPT.get(keystoreFile.getAbsolutePath()), false);
                }
                return this.promptForPassword(CertMessages.INFO_MANAGE_CERTS_KEY_KS_PW_EXISTING_PROMPT.get(keystoreFile.getAbsolutePath()), false);
            }
            while (true) {
                String prompt1;
                char[] pwChars;
                if ((pwChars = this.promptForPassword(prompt1 = "new".equals(prefix) ? CertMessages.INFO_MANAGE_CERTS_KEY_KS_PW_EXISTING_NEW_PROMPT.get() : CertMessages.INFO_MANAGE_CERTS_KEY_KS_PW_NEW_PROMPT_1.get(keystoreFile.getAbsolutePath()), false)).length < 6) {
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GET_KS_PW_TOO_SHORT.get());
                    this.err(new Object[0]);
                    continue;
                }
                char[] confirmChars = this.promptForPassword(CertMessages.INFO_MANAGE_CERTS_KEY_KS_PW_NEW_PROMPT_2.get(), true);
                if (Arrays.equals(pwChars, confirmChars)) {
                    Arrays.fill(confirmChars, '\u0000');
                    return pwChars;
                }
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_KEY_KS_PW_PROMPT_MISMATCH.get());
                this.err(new Object[0]);
            }
        }
        return null;
    }

    @Nullable
    private char[] getPrivateKeyEncryptionPassword(boolean forDecrypt) throws LDAPException {
        StringArgument passwordArgument = this.subCommandParser.getStringArgument("encryption-password");
        if (passwordArgument != null && passwordArgument.isPresent()) {
            return passwordArgument.getValue().toCharArray();
        }
        FileArgument passwordFileArgument = this.subCommandParser.getFileArgument("encryption-password-file");
        if (passwordFileArgument != null && passwordFileArgument.isPresent()) {
            File f = passwordFileArgument.getValue();
            try {
                return this.getPasswordFileReader().readPassword(f);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw e;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_GET_PK_ENC_PW_ERROR_READING_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
        BooleanArgument promptArgument = this.subCommandParser.getBooleanArgument("prompt-for-encryption-password");
        if (promptArgument != null && promptArgument.isPresent()) {
            this.out(new Object[0]);
            if (forDecrypt) {
                return this.promptForPassword(CertMessages.INFO_MANAGE_CERTS_GET_PK_ENC_PW_PROMPT_DECRYPT.get(), false);
            }
            while (true) {
                char[] confirmChars;
                char[] pwChars;
                if (Arrays.equals(pwChars = this.promptForPassword(CertMessages.INFO_MANAGE_CERTS_GET_PK_ENC_PW_PROMPT_ENCRYPT_1.get(), false), confirmChars = this.promptForPassword(CertMessages.INFO_MANAGE_CERTS_GET_PK_ENC_PW_PROMPT_ENCRYPT_2.get(), true))) {
                    Arrays.fill(confirmChars, '\u0000');
                    return pwChars;
                }
                this.wrapErr(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_GET_PK_ENC_PW_PROMPT_MISMATCH.get());
                this.err(new Object[0]);
            }
        }
        return null;
    }

    @NotNull
    private char[] promptForPassword(@NotNull String prompt, boolean allowEmpty) throws LDAPException {
        Iterator<String> iterator = StaticUtils.wrapLine(prompt, WRAP_COLUMN).iterator();
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (iterator.hasNext()) {
                this.out(line);
                continue;
            }
            this.getOut().print(line);
        }
        char[] passwordChars = PasswordReader.readPasswordChars();
        if (passwordChars.length == 0 && !allowEmpty) {
            this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_PROMPT_FOR_PW_EMPTY_PW.get());
            this.err(new Object[0]);
            return this.promptForPassword(prompt, allowEmpty);
        }
        return passwordChars;
    }

    private boolean promptForYesNo(@NotNull String prompt) throws LDAPException {
        while (true) {
            List<String> lines = StaticUtils.wrapLine(prompt + ' ', WRAP_COLUMN);
            Iterator<String> lineIterator = lines.iterator();
            while (lineIterator.hasNext()) {
                String line = lineIterator.next();
                if (lineIterator.hasNext()) {
                    this.out(line);
                    continue;
                }
                this.getOut().print(line);
            }
            try {
                String response = this.readLineFromIn();
                if (response.equalsIgnoreCase("yes") || response.equalsIgnoreCase("y")) {
                    return true;
                }
                if (response.equalsIgnoreCase("no") || response.equalsIgnoreCase("n")) {
                    return false;
                }
                this.err(new Object[0]);
                this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_PROMPT_FOR_YES_NO_INVALID_RESPONSE.get());
                this.err(new Object[0]);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_PROMPT_FOR_YES_NO_READ_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
    }

    @NotNull
    private String readLineFromIn() throws IOException {
        ByteStringBuffer buffer = new ByteStringBuffer();
        while (true) {
            int byteRead;
            if ((byteRead = this.in.read()) < 0) {
                if (buffer.isEmpty()) {
                    return null;
                }
                return buffer.toString();
            }
            if (byteRead == 10) {
                return buffer.toString();
            }
            if (byteRead == 13) {
                int nextByteRead = this.in.read();
                Validator.ensureTrue(nextByteRead < 0 || nextByteRead == 10, "ERROR:  Read a carriage return from standard input that was not followed by a new line.");
                return buffer.toString();
            }
            buffer.append((byte)(byteRead & 0xFF));
        }
    }

    @Nullable
    private char[] getPrivateKeyPassword(@NotNull KeyStore keystore, @NotNull String alias, @Nullable char[] keystorePassword) throws LDAPException {
        return this.getPrivateKeyPassword(keystore, alias, null, keystorePassword);
    }

    @Nullable
    private char[] getPrivateKeyPassword(@NotNull KeyStore keystore, @NotNull String alias, @Nullable String prefix, @Nullable char[] keystorePassword) throws LDAPException {
        String prefixDash = prefix == null ? "" : prefix + '-';
        StringArgument privateKeyPasswordArgument = this.subCommandParser.getStringArgument(prefixDash + "private-key-password");
        if (privateKeyPasswordArgument != null && privateKeyPasswordArgument.isPresent()) {
            char[] pkPasswordChars = privateKeyPasswordArgument.getValue().toCharArray();
            if (pkPasswordChars.length < 6 && !ManageCertificates.hasCertificateAlias(keystore, alias) && !ManageCertificates.hasKeyAlias(keystore, alias)) {
                throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_GET_PK_PW_TOO_SHORT.get());
            }
            return pkPasswordChars;
        }
        FileArgument privateKeyPasswordFileArgument = this.subCommandParser.getFileArgument(prefixDash + "private-key-password-file");
        if (privateKeyPasswordFileArgument != null && privateKeyPasswordFileArgument.isPresent()) {
            File f = privateKeyPasswordFileArgument.getValue();
            try {
                char[] passwordChars = this.getPasswordFileReader().readPassword(f);
                if (passwordChars.length < 6) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_GET_PK_PW_EMPTY_FILE.get(f.getAbsolutePath()));
                }
                return passwordChars;
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw e;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_GET_PK_PW_ERROR_READING_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
        BooleanArgument promptArgument = this.subCommandParser.getBooleanArgument("prompt-for-" + prefixDash + "private-key-password");
        if (promptArgument != null && promptArgument.isPresent()) {
            this.out(new Object[0]);
            try {
                if ((ManageCertificates.hasKeyAlias(keystore, alias) || ManageCertificates.hasCertificateAlias(keystore, alias)) && !"new".equals(prefix) && !"destination".equals(prefix)) {
                    String prompt = "current".equals(prefix) ? CertMessages.INFO_MANAGE_CERTS_GET_PK_PW_CURRENT_PROMPT.get(alias) : CertMessages.INFO_MANAGE_CERTS_GET_PK_PW_EXISTING_PROMPT.get(alias);
                    return this.promptForPassword(prompt, false);
                }
                while (true) {
                    String prompt;
                    char[] pwChars;
                    if ((pwChars = this.promptForPassword(prompt = "new".equals(prefix) ? CertMessages.INFO_MANAGE_CERTS_GET_PK_PW_NEW_PROMPT.get() : CertMessages.INFO_MANAGE_CERTS_GET_PK_PW_NEW_PROMPT_1.get(alias), false)).length < 6) {
                        this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GET_PK_PW_TOO_SHORT.get());
                        this.err(new Object[0]);
                        continue;
                    }
                    char[] confirmChars = this.promptForPassword(CertMessages.INFO_MANAGE_CERTS_GET_PK_PW_NEW_PROMPT_2.get(), true);
                    if (Arrays.equals(pwChars, confirmChars)) {
                        Arrays.fill(confirmChars, '\u0000');
                        return pwChars;
                    }
                    this.wrapErr(0, WRAP_COLUMN, CertMessages.ERR_MANAGE_CERTS_GET_PK_PW_PROMPT_MISMATCH.get());
                    this.err(new Object[0]);
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw le;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_GET_PK_PW_PROMPT_ERROR.get(alias, StaticUtils.getExceptionMessage(e)), e);
            }
        }
        return keystorePassword;
    }

    @NotNull
    private String inferKeystoreType(@NotNull File keystorePath) throws LDAPException {
        return this.inferKeystoreType(keystorePath, null);
    }

    @NotNull
    private String inferKeystoreType(@NotNull File keystorePath, @Nullable String prefix) throws LDAPException {
        StringArgument keystoreTypeArgument = prefix == null ? this.subCommandParser.getStringArgument("keystore-type") : this.subCommandParser.getStringArgument(prefix + "-keystore-type");
        if (keystoreTypeArgument != null && keystoreTypeArgument.isPresent()) {
            String ktaValue = keystoreTypeArgument.getValue();
            if (ktaValue.equalsIgnoreCase("PKCS11") || ktaValue.equalsIgnoreCase("PKCS 11") || ktaValue.equalsIgnoreCase("PKCS#11") || ktaValue.equalsIgnoreCase("PKCS #11")) {
                return "PKCS11";
            }
            if (ktaValue.equalsIgnoreCase("PKCS12") || ktaValue.equalsIgnoreCase("PKCS 12") || ktaValue.equalsIgnoreCase("PKCS#12") || ktaValue.equalsIgnoreCase("PKCS #12")) {
                return "PKCS12";
            }
            if (ktaValue.equalsIgnoreCase(BCFKS_KEYSTORE_TYPE)) {
                return BCFKS_KEYSTORE_TYPE;
            }
            return "JKS";
        }
        if (CryptoHelper.usingFIPSMode()) {
            return BCFKS_KEYSTORE_TYPE;
        }
        if (!keystorePath.exists()) {
            return DEFAULT_KEYSTORE_TYPE;
        }
        try {
            return CryptoHelper.inferKeyStoreType(keystorePath);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.PARAM_ERROR, e.getMessage(), e);
        }
    }

    @NotNull
    static String getUserFriendlyKeystoreType(@NotNull String keystoreType) {
        if (keystoreType.equalsIgnoreCase("JKS")) {
            return "JKS";
        }
        if (keystoreType.equalsIgnoreCase("PKCS11") || keystoreType.equalsIgnoreCase("PKCS 11") || keystoreType.equalsIgnoreCase("PKCS#11") || keystoreType.equalsIgnoreCase("PKCS #11")) {
            return "PKCS #11";
        }
        if (keystoreType.equalsIgnoreCase("PKCS12") || keystoreType.equalsIgnoreCase("PKCS 12") || keystoreType.equalsIgnoreCase("PKCS#12") || keystoreType.equalsIgnoreCase("PKCS #12")) {
            return "PKCS #12";
        }
        if (keystoreType.equalsIgnoreCase(BCFKS_KEYSTORE_TYPE)) {
            return BCFKS_KEYSTORE_TYPE;
        }
        return keystoreType;
    }

    @NotNull
    static KeyStore getKeystore(@NotNull String keystoreType, @NotNull File keystorePath, @Nullable char[] keystorePassword) throws LDAPException {
        FileInputStream inputStream;
        KeyStore keystore;
        try {
            if (keystoreType.equals("PKCS11")) {
                Provider pkcs11Provider = PKCS11KeyManager.getProvider(null, keystorePath, keystoreType, true);
                keystore = CryptoHelper.getKeyStore(keystoreType, pkcs11Provider);
            } else {
                keystore = keystoreType.equals(BCFKS_KEYSTORE_TYPE) ? CryptoHelper.getKeyStore(keystoreType, BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider()) : CryptoHelper.getKeyStore(keystoreType);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_CANNOT_INSTANTIATE_KS_TYPE.get(keystoreType, StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            inputStream = keystorePath.exists() && !keystoreType.equals("PKCS11") ? new FileInputStream(keystorePath) : null;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_CANNOT_OPEN_KS_FILE_FOR_READING.get(keystorePath.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            keystore.load(inputStream, keystorePassword);
        }
        catch (Exception e) {
            Debug.debugException(e);
            Throwable cause = e.getCause();
            if (e instanceof IOException && cause != null && cause instanceof UnrecoverableKeyException && keystorePassword != null) {
                throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_CANNOT_LOAD_KS_WRONG_PW.get(keystorePath.getAbsolutePath()), e);
            }
            throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_ERROR_CANNOT_LOAD_KS.get(keystorePath.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return keystore;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<X509Certificate> readCertificatesFromFile(@NotNull File f) throws LDAPException {
        try {
            inputStream = new BufferedInputStream(new FileInputStream(f));
            var2_4 = null;
            try {
                inputStream.mark(1);
                firstByte = inputStream.read();
                if (firstByte < 0) {
                    var4_7 = Collections.emptyList();
                    return var4_7;
                }
                inputStream.reset();
                certList = new ArrayList<X509Certificate>(5);
                if ((firstByte & 255) == 48) ** GOTO lbl41
                reader = new BufferedReader(new InputStreamReader(inputStream));
                var6_15 = null;
                inCert = false;
                buffer = new StringBuilder();
lbl18:
                // 5 sources

                while (true) {
                    line = reader.readLine();
                    if (line != null) ** GOTO lbl67
                    if (inCert) {
                        throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CERTS_FROM_FILE_EOF_WITHOUT_END.get(new Object[]{f.getAbsolutePath()}));
                    }
                    var10_21 = certList;
                    if (reader == null) return var10_21;
                    if (var6_15 == null) ** GOTO lbl65
                    ** GOTO lbl59
                    break;
                }
                {
                    catch (Throwable var7_18) {
                        var6_15 = var7_18;
                        throw var7_18;
                    }
                    catch (Throwable var12_26) {
                        if (reader == null) throw var12_26;
                        if (var6_15 == null) {
                            reader.close();
                            throw var12_26;
                        }
                        try {
                            reader.close();
                            throw var12_26;
                        }
                        catch (Throwable x2) {
                            var6_15.addSuppressed(x2);
                            throw var12_26;
                        }
                    }
lbl41:
                    // 1 sources

                    while (true) {
                        try {
                            certElement = ASN1Element.readFrom(inputStream);
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CERTS_FROM_FILE_DER_NOT_VALID_ASN1.get(new Object[]{f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)}), e);
                        }
                        if (certElement == null) {
                            e = certList;
                            return e;
                        }
                        try {
                            certList.add(new X509Certificate(certElement.encode()));
                        }
                        catch (CertException e) {
                            Debug.debugException(e);
                            throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CERTS_FROM_FILE_DER_NOT_VALID_CERT.get(new Object[]{f.getAbsolutePath(), e.getMessage()}), e);
                        }
                    }
lbl59:
                    // 1 sources

                    try {
                        reader.close();
                        return var10_21;
                    }
                    catch (Throwable x2) {
                        var6_15.addSuppressed(x2);
                        return var10_21;
                    }
lbl65:
                    // 1 sources

                    reader.close();
                    return var10_21;
lbl67:
                    // 1 sources

                    ** try [egrp 12[TRYBLOCK] [16 : 408->760)] { 
lbl-1000:
                    // 1 sources

                    {
                        block49: {
                            block48: {
                                if ((line = line.trim()).isEmpty() || line.startsWith("#")) ** GOTO lbl18
                                if (!line.equals("-----BEGIN CERTIFICATE-----")) break block48;
                                if (inCert) {
                                    throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CERTS_FROM_FILE_MULTIPLE_BEGIN.get(new Object[]{f.getAbsolutePath()}));
                                }
                                inCert = true;
                                ** GOTO lbl18
                            }
                            if (!line.equals("-----END CERTIFICATE-----")) break block49;
                            if (!inCert) {
                                throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CERTS_FROM_FILE_END_WITHOUT_BEGIN.get(new Object[]{f.getAbsolutePath()}));
                            }
                            inCert = false;
                            try {
                                certBytes = Base64.decode(buffer.toString());
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                                throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CERTS_FROM_FILE_PEM_CERT_NOT_BASE64.get(new Object[]{f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)}), e);
                            }
                            try {
                                certList.add(new X509Certificate(certBytes));
                            }
                            catch (CertException e) {
                                Debug.debugException(e);
                                throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CERTS_FROM_FILE_PEM_CERT_NOT_CERT.get(new Object[]{f.getAbsolutePath(), e.getMessage()}), e);
                            }
                            buffer.setLength(0);
                            ** GOTO lbl18
                        }
                        if (!inCert) {
                            throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CERTS_FROM_FILE_DATA_WITHOUT_BEGIN.get(new Object[]{f.getAbsolutePath()}));
                        }
                        buffer.append(line);
                        ** continue;
                    }
                }
            }
lbl100:
            // 2 sources

            catch (Throwable var3_6) {
                var2_4 = var3_6;
                throw var3_6;
            }
            finally {
                if (inputStream != null) {
                    if (var2_4 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable x2) {
                            var2_4.addSuppressed(x2);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CERTS_FROM_FILE_READ_ERROR.get(new Object[]{f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)}), e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    static PKCS8PrivateKey readPrivateKeyFromFile(@NotNull File f, @Nullable char[] encryptionPassword) throws LDAPException {
        try {
            inputStream = new BufferedInputStream(new FileInputStream(f));
            var3_5 = null;
            try {
                inputStream.mark(1);
                firstByte = inputStream.read();
                if (firstByte < 0) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_PK_FROM_FILE_EMPTY_FILE.get(new Object[]{f.getAbsolutePath()}));
                }
                inputStream.reset();
                privateKey = null;
                if ((firstByte & 255) == 48) ** GOTO lbl44
                reader = new BufferedReader(new InputStreamReader(inputStream));
                var7_14 = null;
                inKey = false;
                isRSAKey = false;
                isEncryptedKey = false;
                buffer = new StringBuilder();
lbl19:
                // 7 sources

                while (true) {
                    line = reader.readLine();
                    if (line != null) ** GOTO lbl76
                    if (inKey) {
                        throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_PK_FROM_FILE_EOF_WITHOUT_END.get(new Object[]{f.getAbsolutePath()}));
                    }
                    if (privateKey == null) {
                        throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_PK_FROM_FILE_EMPTY_FILE.get(new Object[]{f.getAbsolutePath()}));
                    }
                    var13_22 = privateKey;
                    if (reader == null) return var13_22;
                    if (var7_14 == null) ** GOTO lbl74
                    ** GOTO lbl68
                    break;
                }
                {
                    catch (Throwable var8_17) {
                        var7_14 = var8_17;
                        throw var8_17;
                    }
                    catch (Throwable var15_27) {
                        if (reader == null) throw var15_27;
                        if (var7_14 == null) {
                            reader.close();
                            throw var15_27;
                        }
                        try {
                            reader.close();
                            throw var15_27;
                        }
                        catch (Throwable x2) {
                            var7_14.addSuppressed(x2);
                            throw var15_27;
                        }
                    }
lbl44:
                    // 1 sources

                    while (true) {
                        try {
                            pkElement = ASN1Element.readFrom(inputStream);
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_PK_FROM_FILE_DER_NOT_VALID_ASN1.get(new Object[]{f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)}), e);
                        }
                        if (pkElement == null) {
                            if (privateKey == null) {
                                throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_PK_FROM_FILE_EMPTY_FILE.get(new Object[]{f.getAbsolutePath()}));
                            }
                            e = privateKey;
                            return e;
                        }
                        if (privateKey != null) {
                            throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_PK_FROM_FILE_MULTIPLE_KEYS.get(new Object[]{f.getAbsolutePath()}));
                        }
                        try {
                            if (encryptionPassword == null) {
                                privateKey = new PKCS8PrivateKey(pkElement.encode());
                                continue;
                            }
                            privateKey = PKCS8EncryptionHandler.decryptPrivateKey(pkElement.encode(), encryptionPassword);
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_PK_FROM_FILE_DER_NOT_VALID_PK.get(new Object[]{f.getAbsolutePath(), e.getMessage()}), e);
                        }
                    }
lbl68:
                    // 1 sources

                    try {
                        reader.close();
                        return var13_22;
                    }
                    catch (Throwable x2) {
                        var7_14.addSuppressed(x2);
                        return var13_22;
                    }
lbl74:
                    // 1 sources

                    reader.close();
                    return var13_22;
lbl76:
                    // 1 sources

                    ** try [egrp 10[TRYBLOCK] [14 : 513->1026)] { 
lbl-1000:
                    // 1 sources

                    {
                        block53: {
                            block51: {
                                block52: {
                                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) ** GOTO lbl19
                                    if (!line.equals("-----BEGIN PRIVATE KEY-----") && !line.equals("-----BEGIN RSA PRIVATE KEY-----") && !line.equals("-----BEGIN ENCRYPTED PRIVATE KEY-----")) break block51;
                                    if (inKey) {
                                        throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_PK_FROM_FILE_MULTIPLE_BEGIN.get(new Object[]{f.getAbsolutePath()}));
                                    }
                                    if (privateKey != null) {
                                        throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_PK_FROM_FILE_MULTIPLE_KEYS.get(new Object[]{f.getAbsolutePath()}));
                                    }
                                    inKey = true;
                                    if (!line.equals("-----BEGIN RSA PRIVATE KEY-----")) break block52;
                                    isRSAKey = true;
                                    ** GOTO lbl19
                                }
                                if (!line.equals("-----BEGIN ENCRYPTED PRIVATE KEY-----")) ** GOTO lbl19
                                isEncryptedKey = true;
                                if (encryptionPassword != null) ** GOTO lbl19
                                throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_PK_FROM_FILE_PK_ENCRYPTED_NO_PW.get(new Object[]{f.getAbsolutePath()}));
                            }
                            if (!line.equals("-----END PRIVATE KEY-----") && !line.equals("-----END RSA PRIVATE KEY-----") && !line.equals("-----END ENCRYPTED PRIVATE KEY-----")) break block53;
                            if (!inKey) {
                                throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_PK_FROM_FILE_END_WITHOUT_BEGIN.get(new Object[]{f.getAbsolutePath()}));
                            }
                            inKey = false;
                            try {
                                pkBytes = Base64.decode(buffer.toString());
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                                throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_PK_FROM_FILE_PEM_PK_NOT_BASE64.get(new Object[]{f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)}), e);
                            }
                            if (isRSAKey) {
                                pkBytes = PKCS8PrivateKey.wrapRSAPrivateKey(pkBytes);
                            }
                            try {
                                privateKey = isEncryptedKey ? PKCS8EncryptionHandler.decryptPrivateKey(pkBytes, encryptionPassword) : new PKCS8PrivateKey(pkBytes);
                            }
                            catch (CertException e) {
                                Debug.debugException(e);
                                throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_PK_FROM_FILE_PEM_PK_NOT_PK.get(new Object[]{f.getAbsolutePath(), e.getMessage()}), e);
                            }
                            buffer.setLength(0);
                            ** GOTO lbl19
                        }
                        if (!inKey) {
                            throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_PK_FROM_FILE_DATA_WITHOUT_BEGIN.get(new Object[]{f.getAbsolutePath()}));
                        }
                        buffer.append(line);
                        ** continue;
                    }
                }
            }
lbl119:
            // 2 sources

            catch (Throwable var4_7) {
                var3_5 = var4_7;
                throw var4_7;
            }
            finally {
                if (inputStream != null) {
                    if (var3_5 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable x2) {
                            var3_5.addSuppressed(x2);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_PK_FROM_FILE_READ_ERROR.get(new Object[]{f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)}), e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static PKCS10CertificateSigningRequest readCertificateSigningRequestFromFile(@NotNull File f) throws LDAPException {
        try {
            inputStream = new BufferedInputStream(new FileInputStream(f));
            var2_4 = null;
            try {
                inputStream.mark(1);
                firstByte = inputStream.read();
                if (firstByte < 0) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CSR_FROM_FILE_EMPTY_FILE.get(new Object[]{f.getAbsolutePath()}));
                }
                inputStream.reset();
                csr = null;
                if ((firstByte & 255) == 48) ** GOTO lbl42
                reader = new BufferedReader(new InputStreamReader(inputStream));
                var6_13 = null;
                inCSR = false;
                buffer = new StringBuilder();
lbl17:
                // 5 sources

                while (true) {
                    line = reader.readLine();
                    if (line != null) ** GOTO lbl71
                    if (inCSR) {
                        throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CSR_FROM_FILE_EOF_WITHOUT_END.get(new Object[]{f.getAbsolutePath()}));
                    }
                    if (csr == null) {
                        throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CSR_FROM_FILE_EMPTY_FILE.get(new Object[]{f.getAbsolutePath()}));
                    }
                    var10_19 = csr;
                    if (reader == null) return var10_19;
                    if (var6_13 == null) ** GOTO lbl69
                    ** GOTO lbl63
                    break;
                }
                {
                    catch (Throwable var7_16) {
                        var6_13 = var7_16;
                        throw var7_16;
                    }
                    catch (Throwable var12_24) {
                        if (reader == null) throw var12_24;
                        if (var6_13 == null) {
                            reader.close();
                            throw var12_24;
                        }
                        try {
                            reader.close();
                            throw var12_24;
                        }
                        catch (Throwable x2) {
                            var6_13.addSuppressed(x2);
                            throw var12_24;
                        }
                    }
lbl42:
                    // 1 sources

                    while (true) {
                        try {
                            csrElement = ASN1Element.readFrom(inputStream);
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CSR_FROM_FILE_DER_NOT_VALID_ASN1.get(new Object[]{f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)}), e);
                        }
                        if (csrElement == null) {
                            if (csr == null) {
                                throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CSR_FROM_FILE_EMPTY_FILE.get(new Object[]{f.getAbsolutePath()}));
                            }
                            e = csr;
                            return e;
                        }
                        if (csr != null) {
                            throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CSR_FROM_FILE_MULTIPLE_CSRS.get(new Object[]{f.getAbsolutePath()}));
                        }
                        try {
                            csr = new PKCS10CertificateSigningRequest(csrElement.encode());
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CSR_FROM_FILE_DER_NOT_VALID_CSR.get(new Object[]{f.getAbsolutePath(), e.getMessage()}), e);
                        }
                    }
lbl63:
                    // 1 sources

                    try {
                        reader.close();
                        return var10_19;
                    }
                    catch (Throwable x2) {
                        var6_13.addSuppressed(x2);
                        return var10_19;
                    }
lbl69:
                    // 1 sources

                    reader.close();
                    return var10_19;
lbl71:
                    // 1 sources

                    ** try [egrp 10[TRYBLOCK] [14 : 486->889)] { 
lbl-1000:
                    // 1 sources

                    {
                        block50: {
                            block49: {
                                if ((line = line.trim()).isEmpty() || line.startsWith("#")) ** GOTO lbl17
                                if (!line.equals("-----BEGIN CERTIFICATE REQUEST-----") && !line.equals("-----BEGIN NEW CERTIFICATE REQUEST-----")) break block49;
                                if (inCSR) {
                                    throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CSR_FROM_FILE_MULTIPLE_BEGIN.get(new Object[]{f.getAbsolutePath()}));
                                }
                                if (csr != null) {
                                    throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CSR_FROM_FILE_MULTIPLE_CSRS.get(new Object[]{f.getAbsolutePath()}));
                                }
                                inCSR = true;
                                ** GOTO lbl17
                            }
                            if (!line.equals("-----END CERTIFICATE REQUEST-----") && !line.equals("-----END NEW CERTIFICATE REQUEST-----")) break block50;
                            if (!inCSR) {
                                throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CSR_FROM_FILE_END_WITHOUT_BEGIN.get(new Object[]{f.getAbsolutePath()}));
                            }
                            inCSR = false;
                            try {
                                csrBytes = Base64.decode(buffer.toString());
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                                throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CSR_FROM_FILE_PEM_CSR_NOT_BASE64.get(new Object[]{f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)}), e);
                            }
                            try {
                                csr = new PKCS10CertificateSigningRequest(csrBytes);
                            }
                            catch (CertException e) {
                                Debug.debugException(e);
                                throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CSR_FROM_FILE_PEM_CSR_NOT_CSR.get(new Object[]{f.getAbsolutePath(), e.getMessage()}), e);
                            }
                            buffer.setLength(0);
                            ** GOTO lbl17
                        }
                        if (!inCSR) {
                            throw new LDAPException(ResultCode.PARAM_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CSR_FROM_FILE_DATA_WITHOUT_BEGIN.get(new Object[]{f.getAbsolutePath()}));
                        }
                        buffer.append(line);
                        ** continue;
                    }
                }
            }
lbl105:
            // 2 sources

            catch (Throwable var3_6) {
                var2_4 = var3_6;
                throw var3_6;
            }
            finally {
                if (inputStream != null) {
                    if (var2_4 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable x2) {
                            var2_4.addSuppressed(x2);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_READ_CSR_FROM_FILE_READ_ERROR.get(new Object[]{f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)}), e);
        }
    }

    @NotNull
    private static String toColonDelimitedHex(byte ... bytes) {
        StringBuilder buffer = new StringBuilder(bytes.length * 3);
        StaticUtils.toHex(bytes, ":", buffer);
        return buffer.toString();
    }

    @NotNull
    private static String formatDateAndTime(@NotNull Date d) {
        long currentTime;
        String dateFormatString = "EEEE, MMMM d, yyyy";
        String formattedDate = new SimpleDateFormat("EEEE, MMMM d, yyyy").format(d);
        String timeFormatString = "hh:mm:ss aa z";
        String formattedTime = new SimpleDateFormat("hh:mm:ss aa z").format(d);
        long providedTime = d.getTime();
        if (providedTime > (currentTime = System.currentTimeMillis())) {
            long secondsInFuture = (providedTime - currentTime) / 1000L;
            String durationInFuture = StaticUtils.secondsToHumanReadableDuration(secondsInFuture);
            return CertMessages.INFO_MANAGE_CERTS_FORMAT_DATE_AND_TIME_IN_FUTURE.get(formattedDate, formattedTime, durationInFuture);
        }
        long secondsInPast = (currentTime - providedTime) / 1000L;
        String durationInPast = StaticUtils.secondsToHumanReadableDuration(secondsInPast);
        return CertMessages.INFO_MANAGE_CERTS_FORMAT_DATE_AND_TIME_IN_PAST.get(formattedDate, formattedTime, durationInPast);
    }

    @NotNull
    private static String formatValidityStartTime(@NotNull Date d) {
        String dateFormatString = "yyyy'/'MM'/'dd HH':'mm':'ss";
        return new SimpleDateFormat("yyyy'/'MM'/'dd HH':'mm':'ss").format(d);
    }

    @NotNull
    private static X509Certificate[] getCertificateChain(@NotNull String alias, @NotNull KeyStore keystore, @NotNull AtomicReference<DN> missingIssuerRef) throws LDAPException {
        try {
            X509Certificate issuerCertificate;
            Certificate[] chain = keystore.getCertificateChain(alias);
            if (chain != null && chain.length > 0) {
                X509Certificate[] x509Chain = new X509Certificate[chain.length];
                for (int i = 0; i < chain.length; ++i) {
                    x509Chain[i] = new X509Certificate(chain[i].getEncoded());
                }
                return x509Chain;
            }
            Certificate endCert = keystore.getCertificate(alias);
            if (endCert == null) {
                return new X509Certificate[0];
            }
            ArrayList<X509Certificate> chainList = new ArrayList<X509Certificate>(5);
            X509Certificate certificate = new X509Certificate(endCert.getEncoded());
            chainList.add(certificate);
            AtomicReference<KeyStore> jvmDefaultTrustStoreRef = new AtomicReference<KeyStore>();
            while ((issuerCertificate = ManageCertificates.getIssuerCertificate(certificate, keystore, jvmDefaultTrustStoreRef, missingIssuerRef)) != null) {
                chainList.add(issuerCertificate);
                certificate = issuerCertificate;
            }
            X509Certificate[] x509Chain = new X509Certificate[chainList.size()];
            return chainList.toArray(x509Chain);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_GET_CHAIN_ERROR.get(alias, StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Nullable
    private static X509Certificate getIssuerCertificate(@NotNull X509Certificate certificate, @NotNull KeyStore keystore, @NotNull AtomicReference<KeyStore> jvmDefaultTrustStoreRef, @NotNull AtomicReference<DN> missingIssuerRef) throws Exception {
        DN issuerDN;
        DN subjectDN = certificate.getSubjectDN();
        if (subjectDN.equals(issuerDN = certificate.getIssuerDN())) {
            return null;
        }
        X509Certificate issuerCertificate = ManageCertificates.getIssuerCertificate(certificate, keystore);
        if (issuerCertificate != null) {
            return issuerCertificate;
        }
        KeyStore jvmDefaultTrustStore = jvmDefaultTrustStoreRef.get();
        if (jvmDefaultTrustStore == null) {
            String[] keystoreTypes;
            if (JVM_DEFAULT_CACERTS_FILE == null) {
                missingIssuerRef.set(issuerDN);
                return null;
            }
            for (String keystoreType : keystoreTypes = new String[]{"JKS", "PKCS12", BCFKS_KEYSTORE_TYPE}) {
                KeyStore ks = CryptoHelper.getKeyStore(keystoreType);
                try (FileInputStream inputStream = new FileInputStream(JVM_DEFAULT_CACERTS_FILE);){
                    ks.load(inputStream, null);
                    jvmDefaultTrustStore = ks;
                    jvmDefaultTrustStoreRef.set(jvmDefaultTrustStore);
                    break;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        if (jvmDefaultTrustStore != null) {
            issuerCertificate = ManageCertificates.getIssuerCertificate(certificate, jvmDefaultTrustStore);
        }
        if (issuerCertificate == null) {
            missingIssuerRef.set(issuerDN);
        }
        return issuerCertificate;
    }

    @Nullable
    private static X509Certificate getIssuerCertificate(@NotNull X509Certificate certificate, @NotNull KeyStore keystore) throws Exception {
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate[] certs = null;
            if (ManageCertificates.hasCertificateAlias(keystore, alias)) {
                Certificate c = keystore.getCertificate(alias);
                if (c == null) continue;
                certs = new Certificate[]{c};
            } else if (ManageCertificates.hasKeyAlias(keystore, alias)) {
                certs = keystore.getCertificateChain(alias);
            }
            if (certs == null) continue;
            for (Certificate c : certs) {
                X509Certificate xc = new X509Certificate(c.getEncoded());
                if (!xc.isIssuerFor(certificate)) continue;
                return xc;
            }
        }
        return null;
    }

    @Nullable
    private static byte[] getAuthorityKeyIdentifier(@NotNull X509Certificate c) {
        for (X509CertificateExtension extension : c.getExtensions()) {
            AuthorityKeyIdentifierExtension e;
            if (!(extension instanceof AuthorityKeyIdentifierExtension) || (e = (AuthorityKeyIdentifierExtension)extension).getKeyIdentifier() == null) continue;
            return e.getKeyIdentifier().getValue();
        }
        return null;
    }

    static void writeKeystore(@NotNull KeyStore keystore, @NotNull File keystorePath, @Nullable char[] keystorePassword) throws LDAPException {
        if (keystore.getType().equals("PKCS11")) {
            try {
                keystore.store(null);
                return;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_PKCS11_WRITE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        File copyOfExistingKeystore = null;
        String timestamp = StaticUtils.encodeGeneralizedTime(System.currentTimeMillis());
        if (keystorePath.exists()) {
            copyOfExistingKeystore = new File(keystorePath.getAbsolutePath() + ".backup-" + timestamp);
            try {
                Files.copy(keystorePath.toPath(), copyOfExistingKeystore.toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_WRITE_KS_ERROR_COPYING_EXISTING_KS.get(keystorePath.getAbsolutePath(), copyOfExistingKeystore.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
        try (FileOutputStream outputStream = new FileOutputStream(keystorePath);){
            keystore.store(outputStream, keystorePassword);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (copyOfExistingKeystore == null) {
                throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_WRITE_KS_ERROR_WRITING_NEW_KS.get(keystorePath.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_WRITE_KS_ERROR_OVERWRITING_KS.get(keystorePath.getAbsolutePath(), StaticUtils.getExceptionMessage(e), copyOfExistingKeystore.getAbsolutePath()), e);
        }
        if (copyOfExistingKeystore != null) {
            try {
                Files.delete(copyOfExistingKeystore.toPath());
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, CertMessages.ERR_MANAGE_CERTS_WRITE_KS_ERROR_DELETING_KS_BACKUP.get(copyOfExistingKeystore.getAbsolutePath(), keystorePath.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
    }

    private static boolean hasCertificateAlias(@NotNull KeyStore keystore, @NotNull String alias) {
        try {
            return keystore.isCertificateEntry(alias);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
    }

    private static boolean hasKeyAlias(@NotNull KeyStore keystore, @NotNull String alias) {
        try {
            return keystore.isKeyEntry(alias);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
    }

    private static void addExtensionArguments(@NotNull List<String> keytoolArguments, @Nullable BasicConstraintsExtension basicConstraints, @Nullable KeyUsageExtension keyUsage, @Nullable ExtendedKeyUsageExtension extendedKeyUsage, @NotNull Set<String> sanValues, @NotNull Set<String> ianValues, @NotNull List<X509CertificateExtension> genericExtensions) {
        if (basicConstraints != null) {
            StringBuilder basicConstraintsValue = new StringBuilder();
            basicConstraintsValue.append("ca:");
            basicConstraintsValue.append(basicConstraints.isCA());
            if (basicConstraints.getPathLengthConstraint() != null) {
                basicConstraintsValue.append(",pathlen:");
                basicConstraintsValue.append(basicConstraints.getPathLengthConstraint());
            }
            keytoolArguments.add("-ext");
            keytoolArguments.add("BasicConstraints=" + basicConstraintsValue);
        }
        if (keyUsage != null) {
            StringBuilder keyUsageValue = new StringBuilder();
            if (keyUsage.isDigitalSignatureBitSet()) {
                ManageCertificates.commaAppend(keyUsageValue, "digitalSignature");
            }
            if (keyUsage.isNonRepudiationBitSet()) {
                ManageCertificates.commaAppend(keyUsageValue, "nonRepudiation");
            }
            if (keyUsage.isKeyEnciphermentBitSet()) {
                ManageCertificates.commaAppend(keyUsageValue, "keyEncipherment");
            }
            if (keyUsage.isDataEnciphermentBitSet()) {
                ManageCertificates.commaAppend(keyUsageValue, "dataEncipherment");
            }
            if (keyUsage.isKeyAgreementBitSet()) {
                ManageCertificates.commaAppend(keyUsageValue, "keyAgreement");
            }
            if (keyUsage.isKeyCertSignBitSet()) {
                ManageCertificates.commaAppend(keyUsageValue, "keyCertSign");
            }
            if (keyUsage.isCRLSignBitSet()) {
                ManageCertificates.commaAppend(keyUsageValue, "cRLSign");
            }
            if (keyUsage.isEncipherOnlyBitSet()) {
                ManageCertificates.commaAppend(keyUsageValue, "encipherOnly");
            }
            if (keyUsage.isEncipherOnlyBitSet()) {
                ManageCertificates.commaAppend(keyUsageValue, "decipherOnly");
            }
            keytoolArguments.add("-ext");
            keytoolArguments.add("KeyUsage=" + keyUsageValue);
        }
        if (extendedKeyUsage != null) {
            StringBuilder extendedKeyUsageValue = new StringBuilder();
            block8: for (OID oid : extendedKeyUsage.getKeyPurposeIDs()) {
                ExtendedKeyUsageID id = ExtendedKeyUsageID.forOID(oid);
                if (id == null) {
                    ManageCertificates.commaAppend(extendedKeyUsageValue, oid.toString());
                    continue;
                }
                switch (id) {
                    case TLS_SERVER_AUTHENTICATION: {
                        ManageCertificates.commaAppend(extendedKeyUsageValue, "serverAuth");
                        continue block8;
                    }
                    case TLS_CLIENT_AUTHENTICATION: {
                        ManageCertificates.commaAppend(extendedKeyUsageValue, "clientAuth");
                        continue block8;
                    }
                    case CODE_SIGNING: {
                        ManageCertificates.commaAppend(extendedKeyUsageValue, "codeSigning");
                        continue block8;
                    }
                    case EMAIL_PROTECTION: {
                        ManageCertificates.commaAppend(extendedKeyUsageValue, "emailProtection");
                        continue block8;
                    }
                    case TIME_STAMPING: {
                        ManageCertificates.commaAppend(extendedKeyUsageValue, "timeStamping");
                        continue block8;
                    }
                    case OCSP_SIGNING: {
                        ManageCertificates.commaAppend(extendedKeyUsageValue, "OCSPSigning");
                        continue block8;
                    }
                }
                ManageCertificates.commaAppend(extendedKeyUsageValue, id.getOID().toString());
            }
            keytoolArguments.add("-ext");
            keytoolArguments.add("ExtendedKeyUsage=" + extendedKeyUsageValue);
        }
        if (!sanValues.isEmpty()) {
            StringBuilder subjectAltNameValue = new StringBuilder();
            for (String sanValue : sanValues) {
                ManageCertificates.commaAppend(subjectAltNameValue, sanValue);
            }
            keytoolArguments.add("-ext");
            keytoolArguments.add("SAN=" + subjectAltNameValue);
        }
        if (!ianValues.isEmpty()) {
            StringBuilder issuerAltNameValue = new StringBuilder();
            for (String ianValue : ianValues) {
                ManageCertificates.commaAppend(issuerAltNameValue, ianValue);
            }
            keytoolArguments.add("-ext");
            keytoolArguments.add("IAN=" + issuerAltNameValue);
        }
        for (X509CertificateExtension e : genericExtensions) {
            keytoolArguments.add("-ext");
            if (e.isCritical()) {
                keytoolArguments.add(e.getOID().toString() + ":critical=" + ManageCertificates.toColonDelimitedHex(e.getValue()));
                continue;
            }
            keytoolArguments.add(e.getOID().toString() + '=' + ManageCertificates.toColonDelimitedHex(e.getValue()));
        }
    }

    private static void commaAppend(@NotNull StringBuilder buffer, @NotNull String value) {
        if (buffer.length() > 0) {
            buffer.append(',');
        }
        buffer.append(value);
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        String keystorePath = ManageCertificates.getPlatformSpecificPath("config", "keystore");
        String keystorePWPath = ManageCertificates.getPlatformSpecificPath("config", "keystore.pin");
        String privateKeyPWPath = ManageCertificates.getPlatformSpecificPath("config", "server-cert-private-key.pin");
        String exportCertOutputFile = ManageCertificates.getPlatformSpecificPath("server-cert.crt");
        String exportKeyOutputFile = ManageCertificates.getPlatformSpecificPath("server-cert.private-key");
        String genCSROutputFile = ManageCertificates.getPlatformSpecificPath("server-cert.csr");
        String truststorePath = ManageCertificates.getPlatformSpecificPath("config", "truststore");
        String truststorePWPath = ManageCertificates.getPlatformSpecificPath("config", "truststore.pin");
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(20));
        examples.put(new String[]{"list-certificates", "--keystore", keystorePath, "--keystore-password-file", keystorePWPath, "--verbose", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_EXAMPLE_LIST_1.get(keystorePath));
        examples.put(new String[]{"export-certificate", "--keystore", keystorePath, "--keystore-password-file", keystorePWPath, "--alias", "server-cert", "--output-file", exportCertOutputFile, "--output-format", "PEM", "--verbose", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_EXAMPLE_EXPORT_CERT_1.get(keystorePath, exportCertOutputFile));
        examples.put(new String[]{"export-private-key", "--keystore", keystorePath, "--keystore-password-file", keystorePWPath, "--private-key-password-file", privateKeyPWPath, "--alias", "server-cert", "--output-file", exportKeyOutputFile, "--output-format", "PEM", "--verbose", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_EXAMPLE_EXPORT_KEY_1.get(keystorePath, exportKeyOutputFile));
        examples.put(new String[]{"import-certificate", "--keystore", keystorePath, "--keystore-type", "JKS", "--keystore-password-file", keystorePWPath, "--alias", "server-cert", "--certificate-file", exportCertOutputFile, "--private-key-file", exportKeyOutputFile, "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_EXAMPLE_IMPORT_1.get(exportCertOutputFile, exportKeyOutputFile, keystorePath));
        examples.put(new String[]{"delete-certificate", "--keystore", keystorePath, "--keystore-password-file", keystorePWPath, "--alias", "server-cert"}, CertMessages.INFO_MANAGE_CERTS_EXAMPLE_DELETE_1.get(keystorePath));
        examples.put(new String[]{"generate-self-signed-certificate", "--keystore", keystorePath, "--keystore-type", "PKCS12", "--keystore-password-file", keystorePWPath, "--alias", "ca-cert", "--subject-dn", "CN=Example Authority,O=Example Corporation,C=US", "--days-valid", "7300", "--validity-start-time", "20170101000000", "--key-algorithm", "RSA", "--key-size-bits", "4096", "--signature-algorithm", "SHA256withRSA", "--basic-constraints-is-ca", "true", "--key-usage", "key-cert-sign", "--key-usage", "crl-sign", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_EXAMPLE_GEN_CERT_1.get(keystorePath));
        examples.put(new String[]{"generate-certificate-signing-request", "--keystore", keystorePath, "--keystore-type", "PKCS12", "--keystore-password-file", keystorePWPath, "--output-file", genCSROutputFile, "--alias", "server-cert", "--subject-dn", "CN=ldap.example.com,O=Example Corporation,C=US", "--key-algorithm", "EC", "--key-size-bits", "256", "--signature-algorithm", "SHA256withECDSA", "--subject-alternative-name-dns", "ldap1.example.com", "--subject-alternative-name-dns", "ldap2.example.com", "--extended-key-usage", "server-auth", "--extended-key-usage", "client-auth", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_EXAMPLE_GEN_CSR_1.get(keystorePath, genCSROutputFile));
        examples.put(new String[]{"generate-certificate-signing-request", "--keystore", keystorePath, "--keystore-password-file", keystorePWPath, "--alias", "server-cert", "--use-existing-key-pair", "--inherit-extensions", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_EXAMPLE_GEN_CSR_2.get(keystorePath));
        examples.put(new String[]{"sign-certificate-signing-request", "--keystore", keystorePath, "--keystore-password-file", keystorePWPath, "--request-input-file", genCSROutputFile, "--certificate-output-file", exportCertOutputFile, "--alias", "ca-cert", "--days-valid", "730", "--include-requested-extensions", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_EXAMPLE_SIGN_CERT_1.get(keystorePath, genCSROutputFile, exportCertOutputFile));
        examples.put(new String[]{"change-certificate-alias", "--keystore", keystorePath, "--keystore-password-file", keystorePWPath, "--current-alias", "server-cert", "--new-alias", "server-certificate", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_EXAMPLE_CHANGE_ALIAS_1.get(keystorePath, genCSROutputFile, exportCertOutputFile));
        examples.put(new String[]{"change-keystore-password", "--keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore"), "--current-keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "current.pin"), "--new-keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "new.pin"), "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_SC_CHANGE_KS_PW_EXAMPLE_1.get(ManageCertificates.getPlatformSpecificPath("config", "keystore"), ManageCertificates.getPlatformSpecificPath("config", "current.pin"), ManageCertificates.getPlatformSpecificPath("config", "new.pin")));
        examples.put(new String[]{"retrieve-server-certificate", "--hostname", "ds.example.com", "--port", "636"}, CertMessages.INFO_MANAGE_CERTS_SC_RETRIEVE_CERT_EXAMPLE_1.get(ManageCertificates.getPlatformSpecificPath("config", "truststore")));
        examples.put(new String[]{"copy-keystore", "--source-keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore.jks"), "--source-keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--source-keystore-type", "JKS", "--destination-keystore", ManageCertificates.getPlatformSpecificPath("config", "keystore.p12"), "--destination-keystore-password-file", ManageCertificates.getPlatformSpecificPath("config", "keystore.pin"), "--destination-keystore-type", "PKCS12"}, CertMessages.INFO_MANAGE_CERTS_SC_COPY_KS_EXAMPLE_1.get("keystore.jks", "keystore.p12"));
        examples.put(new String[]{"trust-server-certificate", "--hostname", "ldap.example.com", "--port", "636", "--keystore", truststorePath, "--keystore-password-file", truststorePWPath, "--alias", "ldap.example.com:636"}, CertMessages.INFO_MANAGE_CERTS_EXAMPLE_TRUST_SERVER_1.get(truststorePath));
        examples.put(new String[]{"check-certificate-usability", "--keystore", keystorePath, "--keystore-password-file", keystorePWPath, "--alias", "server-cert"}, CertMessages.INFO_MANAGE_CERTS_EXAMPLE_CHECK_USABILITY_1.get(keystorePath));
        examples.put(new String[]{"display-certificate-file", "--certificate-file", exportCertOutputFile, "--verbose", "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_EXAMPLE_DISPLAY_CERT_1.get(keystorePath));
        examples.put(new String[]{"display-certificate-signing-request-file", "--certificate-signing-request-file", genCSROutputFile, "--display-keytool-command"}, CertMessages.INFO_MANAGE_CERTS_EXAMPLE_DISPLAY_CSR_1.get(keystorePath));
        examples.put(new String[]{"--help-subcommands"}, CertMessages.INFO_MANAGE_CERTS_EXAMPLE_HELP_SUBCOMMANDS_1.get(keystorePath));
        return examples;
    }

    static {
        File caCertsFile;
        try {
            caCertsFile = JVMDefaultTrustManager.getInstance().getCACertsFile();
        }
        catch (Exception e) {
            Debug.debugException(e);
            caCertsFile = null;
        }
        JVM_DEFAULT_CACERTS_FILE = caCertsFile;
        BCFKS_KEYSTORE_TYPE_LC = BCFKS_KEYSTORE_TYPE.toLowerCase();
        PROPERTY_DEFAULT_KEYSTORE_TYPE = ManageCertificates.class.getName() + ".defaultKeystoreType";
        String propertyValue = StaticUtils.getSystemProperty(PROPERTY_DEFAULT_KEYSTORE_TYPE);
        DEFAULT_KEYSTORE_TYPE = CryptoHelper.usingFIPSMode() || propertyValue != null && propertyValue.equalsIgnoreCase(BCFKS_KEYSTORE_TYPE) ? BCFKS_KEYSTORE_TYPE : (propertyValue != null && (propertyValue.equalsIgnoreCase("PKCS12") || propertyValue.equalsIgnoreCase("PKCS#12") || propertyValue.equalsIgnoreCase("PKCS #12") || propertyValue.equalsIgnoreCase("PKCS 12")) ? "PKCS12" : "JKS");
        WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
        ALLOWED_KEYSTORE_TYPE_VALUES = StaticUtils.setOf("jks", "pkcs11", "pkcs 11", "pkcs#11", "pkcs #11", "pkcs12", "pkcs 12", "pkcs#12", "pkcs #12", BCFKS_KEYSTORE_TYPE_LC);
    }
}

