/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.ArrayList;
import java.util.List;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public class StartEventValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List startEvents = process.findFlowElementsOfType(StartEvent.class, false);
        this.validateEventDefinitionTypes(startEvents, process, errors);
        this.validateMultipleStartEvents(startEvents, process, errors);
    }

    protected void validateEventDefinitionTypes(List<StartEvent> startEvents, Process process, List<ValidationError> errors) {
        for (StartEvent startEvent : startEvents) {
            EventDefinition eventDefinition;
            if (startEvent.getEventDefinitions() == null || startEvent.getEventDefinitions().isEmpty() || (eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof MessageEventDefinition || eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof SignalEventDefinition) continue;
            this.addError(errors, "flowable-start-event-invalid-event-definition", process, (FlowElement)startEvent, (BaseElement)eventDefinition, "Unsupported event definition on start event");
        }
    }

    protected void validateMultipleStartEvents(List<StartEvent> startEvents, Process process, List<ValidationError> errors) {
        ArrayList<StartEvent> noneStartEvents = new ArrayList<StartEvent>();
        for (StartEvent startEvent : startEvents) {
            if (startEvent.getEventDefinitions() != null && !startEvent.getEventDefinitions().isEmpty() || startEvent.getExtensionElements().get("eventType") != null && ((List)startEvent.getExtensionElements().get("eventType")).size() != 0) continue;
            noneStartEvents.add(startEvent);
        }
        if (noneStartEvents.size() > 1) {
            for (StartEvent startEvent : noneStartEvents) {
                this.addError(errors, "flowable-start-event-multiple-found", process, (BaseElement)startEvent, "Multiple none start events are not supported");
            }
        }
    }
}

