/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategyConfigurer;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuth20AuthenticationServiceSelectionStrategy;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.OAuth)
@AutoConfiguration
public class CasOAuth20AuthenticationServiceSelectionStrategyConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"oauth20AuthenticationRequestServiceSelectionStrategy"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationServiceSelectionStrategy oauth20AuthenticationRequestServiceSelectionStrategy(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) {
        return new OAuth20AuthenticationServiceSelectionStrategy(servicesManager, webApplicationServiceFactory, OAuth20Utils.casOAuthCallbackUrl((String)casProperties.getServer().getPrefix()), oauthRequestParameterResolver);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationServiceSelectionStrategyConfigurer oauth20AuthenticationServiceSelectionStrategyConfigurer(@Qualifier(value="oauth20AuthenticationRequestServiceSelectionStrategy") AuthenticationServiceSelectionStrategy oauth20AuthenticationRequestServiceSelectionStrategy) {
        return plan -> plan.registerStrategy(oauth20AuthenticationRequestServiceSelectionStrategy);
    }
}

