/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.db;

import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.EventRegistryEngines;

public class DbSchemaDrop {
    public static void main(String[] args) {
        try {
            EventRegistryEngine eventRegistryEngine = EventRegistryEngines.getDefaultEventRegistryEngine();
            EventRegistryEngineConfiguration eventRegistryEngineConfiguration = eventRegistryEngine.getEventRegistryEngineConfiguration();
            DataSource dataSource = eventRegistryEngineConfiguration.getDataSource();
            JdbcConnection connection = new JdbcConnection(dataSource.getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName("FLW_EV_" + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName("FLW_EV_" + database.getDatabaseChangeLogLockTableName());
            if (StringUtils.isNotEmpty((CharSequence)eventRegistryEngineConfiguration.getDatabaseSchema())) {
                database.setDefaultSchemaName(eventRegistryEngineConfiguration.getDatabaseSchema());
                database.setLiquibaseSchemaName(eventRegistryEngineConfiguration.getDatabaseSchema());
            }
            if (StringUtils.isNotEmpty((CharSequence)eventRegistryEngineConfiguration.getDatabaseCatalog())) {
                database.setDefaultCatalogName(eventRegistryEngineConfiguration.getDatabaseCatalog());
                database.setLiquibaseCatalogName(eventRegistryEngineConfiguration.getDatabaseCatalog());
            }
            Liquibase liquibase = new Liquibase("org/flowable/eventregistry/db/liquibase/flowable-eventregistry-db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.dropAll();
            liquibase.getDatabase().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

