/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl;

import java.io.Serializable;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.query.AbstractQuery;
import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.api.EventDeploymentQuery;
import org.flowable.eventregistry.impl.DeploymentQueryProperty;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class EventDeploymentQueryImpl
extends AbstractQuery<EventDeploymentQuery, EventDeployment>
implements EventDeploymentQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String name;
    protected String nameLike;
    protected String category;
    protected String categoryNotEquals;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String parentDeploymentId;
    protected String parentDeploymentIdLike;
    protected String eventDefinitionKey;
    protected String eventDefinitionKeyLike;
    protected String channelDefinitionKey;
    protected String channelDefinitionKeyLike;

    public EventDeploymentQueryImpl() {
    }

    public EventDeploymentQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public EventDeploymentQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public EventDeploymentQueryImpl deploymentId(String deploymentId) {
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("Deployment id is null");
        }
        this.deploymentId = deploymentId;
        return this;
    }

    public EventDeploymentQueryImpl deploymentName(String deploymentName) {
        if (deploymentName == null) {
            throw new FlowableIllegalArgumentException("deploymentName is null");
        }
        this.name = deploymentName;
        return this;
    }

    public EventDeploymentQueryImpl deploymentNameLike(String nameLike) {
        if (nameLike == null) {
            throw new FlowableIllegalArgumentException("deploymentNameLike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    public EventDeploymentQueryImpl deploymentCategory(String deploymentCategory) {
        if (deploymentCategory == null) {
            throw new FlowableIllegalArgumentException("deploymentCategory is null");
        }
        this.category = deploymentCategory;
        return this;
    }

    public EventDeploymentQueryImpl deploymentCategoryNotEquals(String deploymentCategoryNotEquals) {
        if (deploymentCategoryNotEquals == null) {
            throw new FlowableIllegalArgumentException("deploymentCategoryExclude is null");
        }
        this.categoryNotEquals = deploymentCategoryNotEquals;
        return this;
    }

    public EventDeploymentQueryImpl parentDeploymentId(String parentDeploymentId) {
        if (parentDeploymentId == null) {
            throw new FlowableIllegalArgumentException("parentDeploymentId is null");
        }
        this.parentDeploymentId = parentDeploymentId;
        return this;
    }

    public EventDeploymentQueryImpl parentDeploymentIdLike(String parentDeploymentIdLike) {
        if (parentDeploymentIdLike == null) {
            throw new FlowableIllegalArgumentException("parentDeploymentIdLike is null");
        }
        this.parentDeploymentIdLike = parentDeploymentIdLike;
        return this;
    }

    public EventDeploymentQueryImpl deploymentWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public EventDeploymentQueryImpl deploymentTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("deploymentTenantId is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public EventDeploymentQueryImpl deploymentTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("deploymentTenantIdLike is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public EventDeploymentQueryImpl eventDefinitionKey(String key) {
        if (key == null) {
            throw new FlowableIllegalArgumentException("key is null");
        }
        this.eventDefinitionKey = key;
        return this;
    }

    public EventDeploymentQueryImpl eventDefinitionKeyLike(String keyLike) {
        if (keyLike == null) {
            throw new FlowableIllegalArgumentException("keyLike is null");
        }
        this.eventDefinitionKeyLike = keyLike;
        return this;
    }

    public EventDeploymentQueryImpl channelDefinitionKey(String key) {
        if (key == null) {
            throw new FlowableIllegalArgumentException("key is null");
        }
        this.channelDefinitionKey = key;
        return this;
    }

    public EventDeploymentQueryImpl channelDefinitionKeyLike(String keyLike) {
        if (keyLike == null) {
            throw new FlowableIllegalArgumentException("keyLike is null");
        }
        this.channelDefinitionKeyLike = keyLike;
        return this;
    }

    public EventDeploymentQuery orderByDeploymentId() {
        return (EventDeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOYMENT_ID);
    }

    public EventDeploymentQuery orderByDeploymentTime() {
        return (EventDeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOY_TIME);
    }

    public EventDeploymentQuery orderByDeploymentName() {
        return (EventDeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOYMENT_NAME);
    }

    public EventDeploymentQuery orderByTenantId() {
        return (EventDeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOYMENT_TENANT_ID);
    }

    public long executeCount(CommandContext commandContext) {
        return CommandContextUtil.getDeploymentEntityManager(commandContext).findDeploymentCountByQueryCriteria(this);
    }

    public List<EventDeployment> executeList(CommandContext commandContext) {
        return CommandContextUtil.getDeploymentEntityManager(commandContext).findDeploymentsByQueryCriteria(this);
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryNotEquals() {
        return this.categoryNotEquals;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getEventDefinitionKey() {
        return this.eventDefinitionKey;
    }

    public String getEventDefinitionKeyLike() {
        return this.eventDefinitionKeyLike;
    }

    public String getParentDeploymentId() {
        return this.parentDeploymentId;
    }

    public String getParentDeploymentIdLike() {
        return this.parentDeploymentIdLike;
    }

    public String getChannelDefinitionKey() {
        return this.channelDefinitionKey;
    }

    public String getChannelDefinitionKeyLike() {
        return this.channelDefinitionKeyLike;
    }
}

