/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.config;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;
import org.springframework.util.StringUtils;
import org.springmodules.cache.config.AbstractCacheProviderFacadeParser;
import org.w3c.dom.Element;

public abstract class AbstractCacheManagerAndProviderFacadeParser
extends AbstractCacheProviderFacadeParser {
    protected final void doParse(String cacheProviderFacadeId, Element element, BeanDefinitionRegistry registry) {
        String id = "cacheManager";
        Class clazz = this.getCacheManagerClass();
        RootBeanDefinition cacheManager = new RootBeanDefinition(clazz);
        MutablePropertyValues cacheManagerProperties = new MutablePropertyValues();
        cacheManager.setPropertyValues(cacheManagerProperties);
        PropertyValue configLocation = this.parseConfigLocationProperty(element);
        cacheManagerProperties.addPropertyValue(configLocation);
        registry.registerBeanDefinition(id, (BeanDefinition)cacheManager);
        BeanDefinition cacheProviderFacade = registry.getBeanDefinition(cacheProviderFacadeId);
        cacheProviderFacade.getPropertyValues().addPropertyValue("cacheManager", (Object)new RuntimeBeanReference(id));
    }

    protected abstract Class getCacheManagerClass();

    private PropertyValue parseConfigLocationProperty(Element element) {
        Resource resource = null;
        String configLocation = element.getAttribute("configLocation");
        if (StringUtils.hasText((String)configLocation)) {
            ResourceEditor resourceEditor = new ResourceEditor();
            resourceEditor.setAsText(configLocation);
            resource = (Resource)resourceEditor.getValue();
        }
        return new PropertyValue("configLocation", resource);
    }
}

