/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client.rest;

import org.pac4j.cas.client.rest.AbstractCasRestClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.credentials.authenticator.CasRestAuthenticator;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.util.CommonHelper;

public class CasRestBasicAuthClient
extends AbstractCasRestClient {
    private String headerName = "Authorization";
    private String prefixHeader = "Basic ";

    public CasRestBasicAuthClient() {
    }

    public CasRestBasicAuthClient(CasConfiguration configuration, String headerName, String prefixHeader) {
        this.configuration = configuration;
        this.headerName = headerName;
        this.prefixHeader = prefixHeader;
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"headerName", (String)this.headerName);
        CommonHelper.assertNotNull((String)"prefixHeader", (Object)this.prefixHeader);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.defaultCredentialsExtractor((CredentialsExtractor)new BasicAuthExtractor(this.headerName, this.prefixHeader));
        this.defaultAuthenticator(new CasRestAuthenticator(this.configuration));
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getPrefixHeader() {
        return this.prefixHeader;
    }

    public void setPrefixHeader(String prefixHeader) {
        this.prefixHeader = prefixHeader;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "authorizationGenerators", this.getAuthorizationGenerators(), "configuration", this.configuration, "headerName", this.headerName, "prefixHeader", this.prefixHeader});
    }
}

