/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.okta.sdk.impl.ds.DefaultDiscriminatorRegistry;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscriminatorConfig {
    private static final Logger logger = LoggerFactory.getLogger(DiscriminatorConfig.class);
    private Map<String, ClassConfig> config = Collections.emptyMap();

    public Map<String, ClassConfig> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, ClassConfig> config) {
        this.config = config;
    }

    static DiscriminatorConfig loadConfig() {
        String configFile = "/com/okta/sdk/resource/discrimination.json";
        URL configJson = DefaultDiscriminatorRegistry.class.getResource(configFile);
        if (configJson != null) {
            try {
                return (DiscriminatorConfig)new ObjectMapper().readValue(configJson, DiscriminatorConfig.class);
            }
            catch (IOException e) {
                logger.warn("Failed to load config file: {}", (Object)configFile, (Object)e);
            }
        } else {
            logger.warn("Could not find config file on the classpath: {}", (Object)configFile);
        }
        return new DiscriminatorConfig();
    }

    public static class ClassConfig {
        private String fieldName;
        private Map<String, String> values;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public Map<String, String> getValues() {
            return this.values;
        }

        public void setValues(Map<String, String> values) {
            this.values = values;
        }
    }
}

