/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.SAML2SPClientAppDAO;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.am.SAML2SPClientApp;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.jpa.dao.AbstractClientAppDAO;
import org.apache.syncope.core.persistence.jpa.entity.am.JPASAML2SPClientApp;
import org.springframework.transaction.annotation.Transactional;

public class JPASAML2SPClientAppDAO
extends AbstractClientAppDAO<SAML2SPClientApp>
implements SAML2SPClientAppDAO {
    public SAML2SPClientApp find(String key) {
        return (SAML2SPClientApp)this.entityManager().find(JPASAML2SPClientApp.class, (Object)key);
    }

    private SAML2SPClientApp find(String column, Object value) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPASAML2SPClientApp.class.getSimpleName() + " e WHERE e." + column + "=:value", SAML2SPClientApp.class);
        query.setParameter("value", value);
        SAML2SPClientApp result = null;
        try {
            result = (SAML2SPClientApp)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("No SAML2SP found with " + column + " {}", value, (Object)e);
        }
        return result;
    }

    public SAML2SPClientApp findByClientAppId(Long clientAppId) {
        return this.find("clientAppId", clientAppId);
    }

    public SAML2SPClientApp findByName(String name) {
        return this.find("name", name);
    }

    public SAML2SPClientApp findByEntityId(String entityId) {
        return this.find("entityId", entityId);
    }

    public List<SAML2SPClientApp> findByPolicy(Policy policy) {
        return this.findByPolicy(policy, SAML2SPClientApp.class, JPASAML2SPClientApp.class);
    }

    public List<SAML2SPClientApp> findByRealm(Realm realm) {
        return this.findByRealm(realm, SAML2SPClientApp.class, JPASAML2SPClientApp.class);
    }

    @Transactional(readOnly=true)
    public List<SAML2SPClientApp> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPASAML2SPClientApp.class.getSimpleName() + " e", SAML2SPClientApp.class);
        return query.getResultList();
    }

    public SAML2SPClientApp save(SAML2SPClientApp clientApp) {
        ((JPASAML2SPClientApp)clientApp).list2json();
        return (SAML2SPClientApp)this.entityManager().merge((Object)clientApp);
    }

    public void delete(String key) {
        SAML2SPClientApp policy = this.find(key);
        if (policy == null) {
            return;
        }
        this.delete(policy);
    }

    public void deleteByEntityId(String entityId) {
        SAML2SPClientApp app = this.findByEntityId(entityId);
        if (app == null) {
            return;
        }
        this.delete(app);
    }

    public void delete(SAML2SPClientApp clientApp) {
        this.entityManager().remove((Object)clientApp);
    }
}

