/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractAction
implements Action,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public EventFactorySupport getEventFactorySupport() {
        return new EventFactorySupport();
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.initAction();
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Initialization of this Action failed: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected void initAction() throws Exception {
    }

    protected Event success() {
        return this.getEventFactorySupport().success(this);
    }

    protected Event success(Object result) {
        return this.getEventFactorySupport().success(this, result);
    }

    protected Event error() {
        return this.getEventFactorySupport().error(this);
    }

    protected Event error(Exception e) {
        return this.getEventFactorySupport().error(this, e);
    }

    protected Event yes() {
        return this.getEventFactorySupport().yes(this);
    }

    protected Event no() {
        return this.getEventFactorySupport().no(this);
    }

    protected Event result(boolean booleanResult) {
        return this.getEventFactorySupport().event((Object)this, booleanResult);
    }

    protected Event result(String eventId) {
        return this.getEventFactorySupport().event((Object)this, eventId);
    }

    protected Event result(String eventId, AttributeMap<Object> resultAttributes) {
        return this.getEventFactorySupport().event(this, eventId, resultAttributes);
    }

    protected Event result(String eventId, String resultAttributeName, Object resultAttributeValue) {
        return this.getEventFactorySupport().event(this, eventId, resultAttributeName, resultAttributeValue);
    }

    @Override
    public final Event execute(RequestContext context) throws Exception {
        Event result = this.doPreExecute(context);
        if (result == null) {
            result = this.doExecute(context);
            this.doPostExecute(context);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Action execution disallowed; pre-execution result is '" + result.getId() + "'"));
        }
        return result;
    }

    protected String getActionNameForLogging() {
        return ClassUtils.getShortName(this.getClass());
    }

    protected Event doPreExecute(RequestContext context) throws Exception {
        return null;
    }

    protected abstract Event doExecute(RequestContext var1) throws Exception;

    protected void doPostExecute(RequestContext context) throws Exception {
    }
}

