/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.ImplementationInfoProvider;
import org.apache.syncope.client.console.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.common.lib.policy.AccountRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.common.lib.report.ReportConf;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class IdRepoImplementationInfoProvider
implements ImplementationInfoProvider {
    private static final long serialVersionUID = -6620368595630782392L;
    protected final ClassPathScanImplementationLookup lookup;
    protected final ImplementationRestClient implementationRestClient;

    public IdRepoImplementationInfoProvider(ClassPathScanImplementationLookup lookup, ImplementationRestClient implementationRestClient) {
        this.lookup = lookup;
        this.implementationRestClient = implementationRestClient;
    }

    @Override
    public ImplementationInfoProvider.ViewMode getViewMode(ImplementationTO implementation) {
        return implementation.getEngine() == ImplementationEngine.GROOVY ? ImplementationInfoProvider.ViewMode.GROOVY_BODY : ("REPORT_DELEGATE".equals(implementation.getType()) || "ACCOUNT_RULE".equals(implementation.getType()) || "PASSWORD_RULE".equals(implementation.getType()) ? ImplementationInfoProvider.ViewMode.JSON_BODY : ImplementationInfoProvider.ViewMode.JAVA_CLASS);
    }

    @Override
    public List<String> getClasses(ImplementationTO implementation, ImplementationInfoProvider.ViewMode viewMode) {
        List classes = List.of();
        if (viewMode == ImplementationInfoProvider.ViewMode.JAVA_CLASS) {
            classes = SyncopeConsoleSession.get().getPlatformInfo().getJavaImplInfo(implementation.getType()).map(javaImplInfo -> new ArrayList(javaImplInfo.getClasses())).orElseGet(ArrayList::new);
        } else if (viewMode == ImplementationInfoProvider.ViewMode.JSON_BODY) {
            switch (implementation.getType()) {
                case "REPORT_DELEGATE": {
                    classes = this.lookup.getClasses(ReportConf.class).stream().map(Class::getName).collect(Collectors.toList());
                    break;
                }
                case "ACCOUNT_RULE": {
                    classes = this.lookup.getClasses(AccountRuleConf.class).stream().map(Class::getName).collect(Collectors.toList());
                    break;
                }
                case "PASSWORD_RULE": {
                    classes = this.lookup.getClasses(PasswordRuleConf.class).stream().map(Class::getName).collect(Collectors.toList());
                    break;
                }
            }
        }
        if (!classes.isEmpty()) {
            Collections.sort(classes);
        }
        return classes;
    }

    @Override
    public String getGroovyTemplateClassName(String implementationType) {
        String templateClassName = null;
        switch (implementationType) {
            case "ACCOUNT_RULE": {
                templateClassName = "MyAccountRule";
                break;
            }
            case "PASSWORD_RULE": {
                templateClassName = "MyPasswordRule";
                break;
            }
            case "TASKJOB_DELEGATE": {
                templateClassName = "MySchedTaskJobDelegate";
                break;
            }
            case "REPORT_DELEGATE": {
                templateClassName = "MyReportJobDelegate";
                break;
            }
            case "LOGIC_ACTIONS": {
                templateClassName = "MyLogicActions";
                break;
            }
            case "MACRO_ACTIONS": {
                templateClassName = "MyMacroActions";
                break;
            }
            case "ATTR_VALUE_VALIDATOR": {
                templateClassName = "MyAttrValueValidator";
                break;
            }
            case "RECIPIENTS_PROVIDER": {
                templateClassName = "MyRecipientsProvider";
                break;
            }
            case "ITEM_TRANSFORMER": {
                templateClassName = "MyItemTransformer";
                break;
            }
            case "COMMAND": {
                templateClassName = "MyCommand";
                break;
            }
        }
        return templateClassName;
    }

    @Override
    public Class<?> getClass(String implementationType, String name) {
        Class clazz = null;
        switch (implementationType) {
            case "REPORT_DELEGATE": {
                clazz = this.lookup.getClasses(ReportConf.class).stream().filter(c -> c.getName().equals(name)).findFirst().orElse(null);
                break;
            }
            case "ACCOUNT_RULE": {
                clazz = this.lookup.getClasses(AccountRuleConf.class).stream().filter(c -> c.getName().equals(name)).findFirst().orElse(null);
                break;
            }
            case "PASSWORD_RULE": {
                clazz = this.lookup.getClasses(PasswordRuleConf.class).stream().filter(c -> c.getName().equals(name)).findFirst().orElse(null);
                break;
            }
        }
        return clazz;
    }

    @Override
    public IModel<List<String>> getTaskJobDelegates() {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return IdRepoImplementationInfoProvider.this.implementationRestClient.list("TASKJOB_DELEGATE").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };
    }

    @Override
    public IModel<List<String>> getReportJobDelegates() {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return IdRepoImplementationInfoProvider.this.implementationRestClient.list("REPORT_DELEGATE").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };
    }

    @Override
    public IModel<List<String>> getReconFilterBuilders() {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return List.of();
            }
        };
    }

    @Override
    public IModel<List<String>> getMacroActions() {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return IdRepoImplementationInfoProvider.this.implementationRestClient.list("MACRO_ACTIONS").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };
    }

    @Override
    public IModel<List<String>> getPullActions() {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return List.of();
            }
        };
    }

    @Override
    public IModel<List<String>> getPushActions() {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return List.of();
            }
        };
    }
}

