/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.init;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.init.InitProjectUtil;
import com.datical.liquibase.ext.init.InitProjectUtil$FileCreationResultEnum;
import com.datical.liquibase.ext.init.InteractivePromptingValueProvider;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.configuration.core.DefaultsFileValueProvider;
import liquibase.exception.CommandExecutionException;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;

public class InitProjectCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"init", "project"};
    public static final CommandArgumentDefinition<String> INIT_PROJECT_DIR_ARG;
    public static final CommandArgumentDefinition<String> INIT_FORMAT_ARG;
    public static final CommandArgumentDefinition<String> INIT_CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> INIT_DEFAULTS_FILE_ARG;
    public static final CommandArgumentDefinition<String> INIT_PROJECT_GUIDE_ARG;
    public static final CommandArgumentDefinition<String> URL_ARG;
    public static final CommandArgumentDefinition<String> USERNAME_ARG;
    public static final CommandArgumentDefinition<String> PASSWORD_ARG;
    public static final String SHOULD_BACKUP_DEFAULTS_FILE_ARG = "shouldBackupDefaultsFile";
    public static final String USED_H2_KEY = "usedH2";

    private boolean isProjectGuideOn(String string) {
        return string.equalsIgnoreCase("on");
    }

    private void doPrompt(ConfiguredValue<String> configuredValue, CommandArgumentDefinition<String> commandArgumentDefinition, CommandScope commandScope, DynamicRuleParameterEnum dynamicRuleParameterEnum, InteractivePromptingValueProvider interactivePromptingValueProvider) {
        this.doPrompt(configuredValue, commandArgumentDefinition, commandScope, dynamicRuleParameterEnum, interactivePromptingValueProvider, null);
    }

    private void doPrompt(ConfiguredValue<String> configuredValue, CommandArgumentDefinition<String> commandArgumentDefinition, CommandScope commandScope, DynamicRuleParameterEnum dynamicRuleParameterEnum, InteractivePromptingValueProvider interactivePromptingValueProvider, Object object) {
        if (configuredValue.wasDefaultValueUsed()) {
            dynamicRuleParameterEnum = dynamicRuleParameterEnum.interactiveCommandLineValueGetter.prompt(new RuleParameter(dynamicRuleParameterEnum), null, object);
            if (!configuredValue.getValue().equals((Object)dynamicRuleParameterEnum)) {
                interactivePromptingValueProvider.addValue(commandScope.getCompleteConfigPrefix() + "." + commandArgumentDefinition.getName(), (Object)dynamicRuleParameterEnum);
            }
        }
    }

    @Override
    public final void run(CommandResultsBuilder commandResultsBuilder) {
        Object object = commandResultsBuilder.getCommandScope().getConfiguredValue(INIT_PROJECT_GUIDE_ARG);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (!((ConfiguredValue)object).wasDefaultValueUsed() && this.isProjectGuideOn((String)(object = ((ConfiguredValue)object).getValue()))) {
            hashMap.put(GlobalConfiguration.HEADLESS.getKey(), Boolean.FALSE);
        }
        try {
            object = Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
            Optional<ConfigurationValueProvider> optional = ((LiquibaseConfiguration)object).getProviders().stream().filter(configurationValueProvider -> configurationValueProvider instanceof DefaultsFileValueProvider).findFirst();
            optional.ifPresent(((LiquibaseConfiguration)object)::unregisterProvider);
            Scope.child(hashMap, () -> this.internalRun(commandResultsBuilder));
            optional.ifPresent(((LiquibaseConfiguration)object)::registerProvider);
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void internalRun(CommandResultsBuilder commandResultsBuilder) {
        String string2;
        Object object2;
        Object object3;
        Object object4 = commandResultsBuilder.getCommandScope();
        ConfiguredValue<String> configuredValue = ((CommandScope)object4).getConfiguredValue(INIT_DEFAULTS_FILE_ARG);
        Object object5 = ((CommandScope)object4).getConfiguredValue(INIT_FORMAT_ARG);
        ConfiguredValue<String> configuredValue2 = ((CommandScope)object4).getConfiguredValue(INIT_CHANGELOG_FILE_ARG);
        ConfiguredValue<String> configuredValue3 = ((CommandScope)object4).getConfiguredValue(INIT_PROJECT_DIR_ARG);
        ConfiguredValue<String> configuredValue4 = ((CommandScope)object4).getConfiguredValue(URL_ARG);
        ConfiguredValue<String> configuredValue5 = ((CommandScope)object4).getConfiguredValue(USERNAME_ARG);
        ConfiguredValue<String> configuredValue6 = ((CommandScope)object4).getConfiguredValue(PASSWORD_ARG);
        String string3 = ((CommandScope)object4).getConfiguredValue(INIT_PROJECT_GUIDE_ARG).getValue();
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.isProjectGuideOn(string3) && (configuredValue3.wasDefaultValueUsed() || configuredValue2.wasDefaultValueUsed() || ((ConfiguredValue)object5).wasDefaultValueUsed() || configuredValue.wasDefaultValueUsed() || configuredValue4.wasDefaultValueUsed() || configuredValue5.wasDefaultValueUsed() || configuredValue6.wasDefaultValueUsed())) {
            string3 = Scope.getCurrentScope().getUI().prompt("Setup new liquibase.properties and sample changelog? Enter (Y)es with defaults, yes with (C)ustomization, or (N)o.", "Y", (string, object) -> {
                object = Arrays.asList("y", "yes", "n", "no", "c", "custom", "customize");
                if (string == null || object.stream().noneMatch(string2 -> string2.equalsIgnoreCase(string))) {
                    throw new IllegalArgumentException();
                }
                return string;
            }, String.class);
            if (string3.toLowerCase().startsWith("c")) {
                object3 = new InteractivePromptingValueProvider();
                Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class).registerProvider((ConfigurationValueProvider)object3);
                this.doPrompt(configuredValue3, INIT_PROJECT_DIR_ARG, (CommandScope)object4, DynamicRuleParameterEnum.PROJECT_DIR, (InteractivePromptingValueProvider)object3);
                configuredValue3 = ((CommandScope)object4).getConfiguredValue(INIT_PROJECT_DIR_ARG);
                object2 = this.findLatestChangelogFilename(configuredValue3);
                this.doPrompt(configuredValue2, INIT_CHANGELOG_FILE_ARG, (CommandScope)object4, DynamicRuleParameterEnum.SAMPLE_CHANGELOG_NAME, (InteractivePromptingValueProvider)object3, object2);
                configuredValue2 = ((CommandScope)object4).getConfiguredValue(INIT_CHANGELOG_FILE_ARG);
                bl2 = this.isSkipped(configuredValue2);
                if (bl2) {
                    string2 = "No changelog file will be created. Specify a valid changelog file on the CLI, via Environment variable, or in your defaults file. ";
                    Scope.getCurrentScope().getUI().sendMessage(InitProjectCommandStep.addGettingStarted(string2));
                } else if (InitProjectUtil.determineFormatType(configuredValue2.getValue(), null) == null) {
                    this.doPrompt((ConfiguredValue<String>)object5, INIT_FORMAT_ARG, (CommandScope)object4, DynamicRuleParameterEnum.FILETYPE, (InteractivePromptingValueProvider)object3);
                }
                this.doPrompt(configuredValue, INIT_DEFAULTS_FILE_ARG, (CommandScope)object4, DynamicRuleParameterEnum.DEFAULTS_FILENAME, (InteractivePromptingValueProvider)object3);
                configuredValue = ((CommandScope)object4).getConfiguredValue(INIT_DEFAULTS_FILE_ARG);
                bl3 = this.isSkipped(configuredValue);
                if (bl3) {
                    string2 = "No defaults file will be created. Specify a valid defaults file on the CLI, via Environment variable, or pass all required properties on the CLI, via Environment variables. ";
                    Scope.getCurrentScope().getUI().sendMessage(InitProjectCommandStep.addGettingStarted(string2));
                } else {
                    this.doPrompt(configuredValue4, URL_ARG, (CommandScope)object4, DynamicRuleParameterEnum.JDBC_URL, (InteractivePromptingValueProvider)object3);
                    this.doPrompt(configuredValue5, USERNAME_ARG, (CommandScope)object4, DynamicRuleParameterEnum.USERNAME, (InteractivePromptingValueProvider)object3);
                    this.doPrompt(configuredValue6, PASSWORD_ARG, (CommandScope)object4, DynamicRuleParameterEnum.PASSWORD, (InteractivePromptingValueProvider)object3);
                }
                object5 = ((CommandScope)object4).getConfiguredValue(INIT_FORMAT_ARG);
                configuredValue4 = ((CommandScope)object4).getConfiguredValue(URL_ARG);
                configuredValue5 = ((CommandScope)object4).getConfiguredValue(USERNAME_ARG);
                configuredValue6 = ((CommandScope)object4).getConfiguredValue(PASSWORD_ARG);
                if (!bl2 || !bl3) {
                    string2 = String.format("Setting up new Liquibase project in '%s'...", new File(configuredValue3.getValue()).getAbsolutePath());
                    Scope.getCurrentScope().getLog(this.getClass()).info(string2);
                    Scope.getCurrentScope().getUI().sendMessage(string2);
                }
            } else if (string3.toLowerCase().startsWith("y")) {
                object3 = String.format("Setting up new Liquibase project in '%s'...", new File(configuredValue3.getValue()).getAbsolutePath());
                Scope.getCurrentScope().getLog(this.getClass()).info((String)object3);
                Scope.getCurrentScope().getUI().sendMessage((String)object3);
            } else if (string3.toLowerCase().startsWith("n")) {
                String string4 = "No files created. Set 'liquibase.command.init.project.projectGuide=off' in your defaults file or set LIQUIBASE_COMMAND_INIT_PROJECT_PROJECT_GUIDE=off as an environment variable to not be asked again. Getting Started and project setup available anytime, run \"liquibase init project --help\" for information.";
                Scope.getCurrentScope().getLog(this.getClass()).info(string4);
                Scope.getCurrentScope().getUI().sendMessage(string4);
                return;
            }
        }
        string3 = configuredValue3.getValue();
        object3 = new File(string3);
        InitProjectUtil.validateProjectDirectory((File)object3);
        InitProjectUtil.createProjectDirectory((File)object3);
        if (!bl2 || !bl3) {
            object2 = InitProjectUtil$FileCreationResultEnum.skipped_changelog_step;
            string2 = null;
            if (!bl2) {
                String string5 = configuredValue2.getValue();
                InitProjectUtil.validateChangelogFilePath(string5);
                if (((ConfiguredValue)object5).wasDefaultValueUsed() && (string2 = InitProjectUtil.determineFormatType(string5, ((ConfiguredValue)object5).getValue())) == null) {
                    object4 = "Unable to determine format for the changelog file '" + string5 + "'";
                    throw new CommandExecutionException((String)object4);
                }
                if (string2 == null) {
                    string2 = ((CommandScope)object4).getConfiguredValue(INIT_FORMAT_ARG).getValue();
                }
                if (!string5.contains(".".concat(String.valueOf(string2)))) {
                    string5 = string5 + "." + string2;
                }
                object2 = InitProjectUtil.copyExampleChangelog(string2, (File)object3, string5, configuredValue2);
                commandResultsBuilder.addResult(INIT_CHANGELOG_FILE_ARG.getName(), Paths.get(string3, string5).toString());
            }
            boolean bl4 = false;
            if (!bl3) {
                boolean bl5 = false;
                object5 = new File((File)object3, configuredValue.getValue());
                if (!((File)object5).exists()) {
                    if (object2 == InitProjectUtil$FileCreationResultEnum.skipped_changelog_step || object2 == InitProjectUtil$FileCreationResultEnum.already_existed) {
                        Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator());
                    }
                    object5 = InitProjectUtil.copyExampleProperties(string2, string3, configuredValue.getValue());
                    bl5 = true;
                }
                Boolean bl6 = (Boolean)((Object)Scope.getCurrentScope().get(SHOULD_BACKUP_DEFAULTS_FILE_ARG, Boolean.class));
                InitProjectUtil.updateDefaultsFile((File)object5, bl5, string2, configuredValue2, configuredValue4, configuredValue5, configuredValue6, object2, bl6, commandResultsBuilder);
                commandResultsBuilder.addResult(INIT_DEFAULTS_FILE_ARG.getName(), object5);
                bl4 = InitProjectUtil.wasH2Used(configuredValue4, configuredValue5, configuredValue6);
            }
            commandResultsBuilder.addResult(USED_H2_KEY, (Object)bl4);
            InitProjectCommandStep.outputEndInstructions(configuredValue3.wasDefaultValueUsed(), configuredValue, string3, bl4);
        } else {
            object2 = InitProjectCommandStep.addGettingStarted(" ");
            Scope.getCurrentScope().getLog(InitProjectCommandStep.class).info((String)object2);
            Scope.getCurrentScope().getUI().sendMessage((String)object2);
        }
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    public static void outputEndInstructions(boolean bl2, ConfiguredValue<String> configuredValue, String string, boolean bl3) {
        String string2 = "To use the new project files";
        if (!bl2) {
            string2 = string2 + String.format(", please cd into '%s',", string);
        }
        string2 = string2 + " make sure your database is active and accessible";
        String string3 = "liquibase update" + (configuredValue.wasDefaultValueUsed() || configuredValue.getValue().equals(INIT_DEFAULTS_FILE_ARG.getDefaultValue()) ? "" : " --defaults-file=" + configuredValue.getValue());
        string2 = bl3 ? string2 + " by opening a new terminal window to run \"liquibase init start-h2\", and then return to this terminal window to run \"" + string3 + "\" command." : string2 + " and run \"" + string3 + "\".";
        string2 = InitProjectCommandStep.addGettingStarted(string2);
        Scope.getCurrentScope().getLog(InitProjectCommandStep.class).info(string2);
        Scope.getCurrentScope().getUI().sendMessage(string2);
    }

    private static String addGettingStarted(String string) {
        return string + "\nFor more details, visit the Getting Started Guide at https://www.liquibase.org/get-started/quickstart.";
    }

    private boolean isSkipped(ConfiguredValue<String> configuredValue) {
        return configuredValue.getValue().equalsIgnoreCase("s");
    }

    private String findLatestChangelogFilename(ConfiguredValue<String> fileArray) {
        try {
            fileArray = InitProjectUtil.findChangeLogsInProjectDir(new File(fileArray.getValue()));
            if (fileArray != null && fileArray.length > 0) {
                Arrays.sort(fileArray, (file, file2) -> Long.compare(file2.lastModified(), file.lastModified()));
                return fileArray[0].getName();
            }
        }
        catch (Exception exception) {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Failed to find an existing changelog file in the specified project directory, using default instead", exception);
        }
        return null;
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Creates the directory and files needed to run Liquibase commands. Run without any flags on the CLI, or set via Environment variable, etc. will launch an interactive guide to walk users through setting up the necessary project's default and changelog files. This guide can be turned off by setting the 'liquibase.command.init.project.projectGuide=off'");
        commandDefinition.setGroupShortDescription(new String[]{"init"}, "Init commands");
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        INIT_PROJECT_DIR_ARG = commandBuilder.argument("projectDir", String.class).description("Relative or fully qualified path to the directory where the project files will be created").defaultValue((String)DynamicRuleParameterEnum.PROJECT_DIR.defaultValue).build();
        INIT_FORMAT_ARG = commandBuilder.argument("format", String.class).description("Format of the project changelog sql|xml|json|yaml|yml").defaultValue(DynamicRuleParameterEnum.FILETYPE.defaultValue.toString()).build();
        INIT_DEFAULTS_FILE_ARG = commandBuilder.argument("projectDefaultsFile", String.class).description(LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getDescription()).defaultValue(LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getDefaultValue()).build();
        INIT_PROJECT_GUIDE_ARG = commandBuilder.argument("projectGuide", String.class).description("Allow interactive prompts for init project").defaultValue("on").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (!((String)(object = String.valueOf(object))).equalsIgnoreCase("on") && !((String)object).equalsIgnoreCase("off")) {
                object = "\nWARNING: The projectGuide parameter must be set to either 'on' or 'off'.  (Blank defaults to 'on')";
                throw new IllegalArgumentException((String)object);
            }
            return object;
        }).build();
        INIT_CHANGELOG_FILE_ARG = commandBuilder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).description("Relative or fully qualified path to the changelog file").defaultValue((String)DynamicRuleParameterEnum.SAMPLE_CHANGELOG_NAME.defaultValue).build();
        URL_ARG = commandBuilder.argument(CommonArgumentNames.URL, String.class).description("The JDBC database connection URL").defaultValue((String)DynamicRuleParameterEnum.JDBC_URL.defaultValue).build();
        USERNAME_ARG = commandBuilder.argument(CommonArgumentNames.USERNAME, String.class).description("Username to use to connect to the database").defaultValue((String)DynamicRuleParameterEnum.USERNAME.defaultValue).build();
        PASSWORD_ARG = commandBuilder.argument(CommonArgumentNames.PASSWORD, String.class).description("Password to use to connect to the database").defaultValue((String)DynamicRuleParameterEnum.PASSWORD.defaultValue).setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
    }
}

