/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccount;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.device.MultifactorAuthenticationRegisteredDevice;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationDeviceProviderAction;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DuoSecurityMultifactorAuthenticationDeviceProviderAction
extends BaseCasWebflowAction
implements MultifactorAuthenticationDeviceProviderAction {
    private final ApplicationContext applicationContext;

    protected Event doExecute(RequestContext requestContext) {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = authentication.getPrincipal();
        Collection providers = this.applicationContext.getBeansOfType(DuoSecurityMultifactorAuthenticationProvider.class).values();
        List accounts = providers.stream().filter(Objects::nonNull).map(DuoSecurityMultifactorAuthenticationProvider.class::cast).map(provider -> provider.getDuoAuthenticationService().getAdminApiService()).filter(Optional::isPresent).map(Optional::get).map(Unchecked.function(service -> service.getDuoSecurityUserAccount(principal.getId()))).filter(Optional::isPresent).map(Optional::get).map(this::mapDuoSecurityDevice).flatMap(Collection::stream).collect(Collectors.toList());
        WebUtils.putMultifactorAuthenticationRegisteredDevices((RequestContext)requestContext, accounts);
        return null;
    }

    protected List<MultifactorAuthenticationRegisteredDevice> mapDuoSecurityDevice(DuoSecurityUserAccount acct) {
        return acct.getDevices().stream().map(device -> {
            String model = String.format("%s %s", StringUtils.defaultString((String)device.getModel()), StringUtils.defaultString((String)device.getPlatform())).trim();
            return MultifactorAuthenticationRegisteredDevice.builder().id(device.getId()).type(device.getType()).model(model).number(device.getNumber()).name((String)StringUtils.defaultIfBlank((CharSequence)device.getName(), (CharSequence)model)).payload(device.toJson()).lastUsedDateTime(device.getLastSeen()).source("Duo Security").build();
        }).collect(Collectors.toList());
    }

    @Generated
    public DuoSecurityMultifactorAuthenticationDeviceProviderAction(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

