/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.WrappingProxyCloseable;
import org.apache.flink.util.AbstractCloseableRegistry;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.WrappingProxyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class SafetyNetCloseableRegistry
extends AbstractCloseableRegistry<WrappingProxyCloseable<? extends Closeable>, PhantomDelegatingCloseableRef> {
    private static final Logger LOG = LoggerFactory.getLogger(SafetyNetCloseableRegistry.class);
    private static final Object REAPER_THREAD_LOCK = new Object();
    private static CloseableReaperThread REAPER_THREAD = null;
    private static int GLOBAL_SAFETY_NET_REGISTRY_COUNT = 0;

    SafetyNetCloseableRegistry() {
        this(() -> new CloseableReaperThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    SafetyNetCloseableRegistry(Supplier<CloseableReaperThread> reaperThreadSupplier) {
        super(new IdentityHashMap());
        Object object = REAPER_THREAD_LOCK;
        synchronized (object) {
            if (0 == GLOBAL_SAFETY_NET_REGISTRY_COUNT) {
                Preconditions.checkState(null == REAPER_THREAD);
                try {
                    REAPER_THREAD = reaperThreadSupplier.get();
                    REAPER_THREAD.start();
                }
                catch (Throwable throwable) {
                    REAPER_THREAD = null;
                    throw throwable;
                }
            }
            ++GLOBAL_SAFETY_NET_REGISTRY_COUNT;
        }
    }

    @Override
    protected void doRegister(@Nonnull WrappingProxyCloseable<? extends Closeable> wrappingProxyCloseable, @Nonnull Map<Closeable, PhantomDelegatingCloseableRef> closeableMap) {
        assert (Thread.holdsLock(this.getSynchronizationLock()));
        Closeable innerCloseable = WrappingProxyUtil.stripProxy(wrappingProxyCloseable);
        if (null == innerCloseable) {
            return;
        }
        PhantomDelegatingCloseableRef phantomRef = new PhantomDelegatingCloseableRef(wrappingProxyCloseable, this, REAPER_THREAD.referenceQueue);
        closeableMap.put(innerCloseable, phantomRef);
    }

    @Override
    protected boolean doUnRegister(@Nonnull WrappingProxyCloseable<? extends Closeable> closeable, @Nonnull Map<Closeable, PhantomDelegatingCloseableRef> closeableMap) {
        assert (Thread.holdsLock(this.getSynchronizationLock()));
        Closeable innerCloseable = WrappingProxyUtil.stripProxy(closeable);
        return null != innerCloseable && closeableMap.remove(innerCloseable) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            Object object = REAPER_THREAD_LOCK;
            synchronized (object) {
                if (0 == --GLOBAL_SAFETY_NET_REGISTRY_COUNT) {
                    REAPER_THREAD.interrupt();
                    REAPER_THREAD = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static boolean isReaperThreadRunning() {
        Object object = REAPER_THREAD_LOCK;
        synchronized (object) {
            return null != REAPER_THREAD && REAPER_THREAD.isAlive();
        }
    }

    static class CloseableReaperThread
    extends Thread {
        private final ReferenceQueue<WrappingProxyCloseable<? extends Closeable>> referenceQueue;
        private volatile boolean running;

        protected CloseableReaperThread() {
            super("CloseableReaperThread");
            this.setDaemon(true);
            this.referenceQueue = new ReferenceQueue();
            this.running = true;
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (this.running) {
                        PhantomDelegatingCloseableRef toClose = (PhantomDelegatingCloseableRef)this.referenceQueue.remove();
                        if (toClose == null) continue;
                        try {
                            toClose.close();
                            continue block4;
                        }
                        catch (Throwable t) {
                            LOG.debug("Error while closing resource via safety-net", t);
                        }
                    }
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
        }

        @Override
        public void interrupt() {
            this.running = false;
            super.interrupt();
        }
    }

    static final class PhantomDelegatingCloseableRef
    extends PhantomReference<WrappingProxyCloseable<? extends Closeable>>
    implements Closeable {
        private final Closeable innerCloseable;
        private final SafetyNetCloseableRegistry closeableRegistry;
        private final String debugString;

        PhantomDelegatingCloseableRef(WrappingProxyCloseable<? extends Closeable> referent, SafetyNetCloseableRegistry closeableRegistry, ReferenceQueue<? super WrappingProxyCloseable<? extends Closeable>> q) {
            super(referent, q);
            this.innerCloseable = Preconditions.checkNotNull(WrappingProxyUtil.stripProxy(referent));
            this.closeableRegistry = Preconditions.checkNotNull(closeableRegistry);
            this.debugString = referent.toString();
        }

        String getDebugString() {
            return this.debugString;
        }

        @Override
        public void close() throws IOException {
            if (this.closeableRegistry.removeCloseableInternal(this.innerCloseable)) {
                LOG.warn("Closing unclosed resource via safety-net: {}", (Object)this.getDebugString());
                this.innerCloseable.close();
            }
        }
    }
}

