/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.StringUtils;

@Public
public class Path
implements IOReadableWritable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    public static final String CUR_DIR = ".";
    private static final Pattern WINDOWS_ROOT_DIR_REGEX = Pattern.compile("/\\p{Alpha}+:/");
    private URI uri;

    public Path() {
    }

    public Path(URI uri) {
        this.uri = uri;
    }

    public Path(String parent, String child) {
        this(new Path(parent), new Path(child));
    }

    public Path(Path parent, String child) {
        this(parent, new Path(child));
    }

    public Path(String parent, Path child) {
        this(new Path(parent), child);
    }

    public Path(Path parent, Path child) {
        URI parentUri = parent.uri;
        String parentPath = parentUri.getPath();
        if (!parentPath.equals(SEPARATOR) && !parentPath.equals("")) {
            try {
                parentUri = new URI(parentUri.getScheme(), parentUri.getAuthority(), parentUri.getPath() + SEPARATOR, null, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (child.uri.getPath().startsWith(SEPARATOR)) {
            child = new Path(child.uri.getScheme(), child.uri.getAuthority(), child.uri.getPath().substring(1));
        }
        URI resolved = parentUri.resolve(child.uri);
        this.initialize(resolved.getScheme(), resolved.getAuthority(), resolved.getPath());
    }

    private String checkPathArg(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Can not create a Path from a null string");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Can not create a Path from an empty string");
        }
        return path;
    }

    public Path(String pathString) {
        pathString = this.checkPathArg(pathString);
        if (this.hasWindowsDrive(pathString, false)) {
            pathString = SEPARATOR + pathString;
        }
        String scheme = null;
        String authority = null;
        int start = 0;
        int colon = pathString.indexOf(58);
        int slash = pathString.indexOf(47);
        if (colon != -1 && (slash == -1 || colon < slash)) {
            scheme = pathString.substring(0, colon);
            start = colon + 1;
        }
        if (pathString.startsWith("//", start) && pathString.length() - start > 2) {
            int nextSlash = pathString.indexOf(47, start + 2);
            int authEnd = nextSlash > 0 ? nextSlash : pathString.length();
            authority = pathString.substring(start + 2, authEnd);
            start = authEnd;
        }
        String path = pathString.substring(start, pathString.length());
        this.initialize(scheme, authority, path);
    }

    public Path(String scheme, String authority, String path) {
        path = this.checkPathArg(path);
        this.initialize(scheme, authority, path);
    }

    private void initialize(String scheme, String authority, String path) {
        try {
            this.uri = new URI(scheme, authority, this.normalizePath(path), null, null).normalize();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String normalizePath(String path) {
        path = path.replace("\\", SEPARATOR);
        if ((path = path.replaceAll("/+", SEPARATOR)).endsWith(SEPARATOR) && !path.equals(SEPARATOR) && !WINDOWS_ROOT_DIR_REGEX.matcher(path).matches()) {
            path = path.substring(0, path.length() - SEPARATOR.length());
        }
        return path;
    }

    public URI toUri() {
        return this.uri;
    }

    public FileSystem getFileSystem() throws IOException {
        return FileSystem.get(this.toUri());
    }

    public boolean isAbsolute() {
        int start = this.hasWindowsDrive(this.uri.getPath(), true) ? 3 : 0;
        return this.uri.getPath().startsWith(SEPARATOR, start);
    }

    public String getName() {
        String path = this.uri.getPath();
        int slash = path.lastIndexOf(SEPARATOR);
        return path.substring(slash + 1);
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public Path getParent() {
        String parent;
        int start;
        String path = this.uri.getPath();
        int lastSlash = path.lastIndexOf(47);
        int n = start = this.hasWindowsDrive(path, true) ? 3 : 0;
        if (path.length() == start || lastSlash == start && path.length() == start + 1) {
            return null;
        }
        if (lastSlash == -1) {
            parent = CUR_DIR;
        } else {
            int end = this.hasWindowsDrive(path, true) ? 3 : 0;
            parent = path.substring(0, lastSlash == end ? end + 1 : lastSlash);
        }
        return new Path(this.uri.getScheme(), this.uri.getAuthority(), parent);
    }

    public Path suffix(String suffix) {
        return new Path(this.getParent(), this.getName() + suffix);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.uri.getScheme() != null) {
            buffer.append(this.uri.getScheme());
            buffer.append(":");
        }
        if (this.uri.getAuthority() != null) {
            buffer.append("//");
            buffer.append(this.uri.getAuthority());
        }
        if (this.uri.getPath() != null) {
            String path = this.uri.getPath();
            if (path.indexOf(47) == 0 && this.hasWindowsDrive(path, true) && this.uri.getScheme() == null && this.uri.getAuthority() == null) {
                path = path.substring(1);
            }
            buffer.append(path);
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Path)) {
            return false;
        }
        Path that = (Path)o;
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public int compareTo(Object o) {
        Path that = (Path)o;
        return this.uri.compareTo(that.uri);
    }

    public int depth() {
        int slash;
        String path = this.uri.getPath();
        int depth = 0;
        int n = slash = path.length() == 1 && path.charAt(0) == '/' ? -1 : 0;
        while (slash != -1) {
            ++depth;
            slash = path.indexOf(SEPARATOR, slash + 1);
        }
        return depth;
    }

    public Path makeQualified(FileSystem fs) {
        Path path = this;
        if (!this.isAbsolute()) {
            path = new Path(fs.getWorkingDirectory(), this);
        }
        URI pathUri = path.toUri();
        URI fsUri = fs.getUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        if (scheme != null && (authority != null || fsUri.getAuthority() == null)) {
            return path;
        }
        if (scheme == null) {
            scheme = fsUri.getScheme();
        }
        if (authority == null && (authority = fsUri.getAuthority()) == null) {
            authority = "";
        }
        return new Path(scheme + "://" + authority + pathUri.getPath());
    }

    @Override
    public void read(DataInputView in) throws IOException {
        boolean isNotNull = in.readBoolean();
        if (isNotNull) {
            String scheme = StringUtils.readNullableString(in);
            String userInfo = StringUtils.readNullableString(in);
            String host = StringUtils.readNullableString(in);
            int port = in.readInt();
            String path = StringUtils.readNullableString(in);
            String query = StringUtils.readNullableString(in);
            String fragment = StringUtils.readNullableString(in);
            try {
                this.uri = new URI(scheme, userInfo, host, port, path, query, fragment);
            }
            catch (URISyntaxException e) {
                throw new IOException("Error reconstructing URI", e);
            }
        }
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        if (this.uri == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            StringUtils.writeNullableString(this.uri.getScheme(), out);
            StringUtils.writeNullableString(this.uri.getUserInfo(), out);
            StringUtils.writeNullableString(this.uri.getHost(), out);
            out.writeInt(this.uri.getPort());
            StringUtils.writeNullableString(this.uri.getPath(), out);
            StringUtils.writeNullableString(this.uri.getQuery(), out);
            StringUtils.writeNullableString(this.uri.getFragment(), out);
        }
    }

    public boolean hasWindowsDrive() {
        return this.hasWindowsDrive(this.uri.getPath(), true);
    }

    private boolean hasWindowsDrive(String path, boolean slashed) {
        int start = slashed ? 1 : 0;
        return path.length() >= start + 2 && (!slashed || path.charAt(0) == '/') && path.charAt(start + 1) == ':' && (path.charAt(start) >= 'A' && path.charAt(start) <= 'Z' || path.charAt(start) >= 'a' && path.charAt(start) <= 'z');
    }

    public static Path fromLocalFile(File file) {
        return new Path(file.toURI());
    }
}

