/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams;

import java.util.List;
import java.util.Map;
import org.apache.storm.shade.com.google.common.collect.Multimap;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;
import org.apache.storm.streams.Edge;
import org.apache.storm.streams.Node;
import org.apache.storm.streams.ProcessorBoltDelegate;
import org.apache.storm.streams.ProcessorNode;
import org.apache.storm.streams.StreamBolt;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichBolt;
import org.apache.storm.tuple.Tuple;

class ProcessorBolt
extends BaseRichBolt
implements StreamBolt {
    private final ProcessorBoltDelegate delegate;

    ProcessorBolt(String id, DirectedGraph<Node, Edge> graph, List<ProcessorNode> nodes) {
        this.delegate = new ProcessorBoltDelegate(id, graph, nodes);
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        this.delegate.prepare(topoConf, context, collector);
    }

    @Override
    public void execute(Tuple input) {
        this.delegate.processAndAck(input);
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.delegate.declareOutputFields(declarer);
    }

    @Override
    public void setTimestampField(String fieldName) {
        this.delegate.setTimestampField(fieldName);
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    void setStreamToInitialProcessors(Multimap<String, ProcessorNode> streamToInitialProcessors) {
        this.delegate.setStreamToInitialProcessors(streamToInitialProcessors);
    }
}

