/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpHeaders;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StandardHttpHeaders
implements HttpHeaders {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String EXPECT = "Expect";
    public static final String EXPECT_CONTINUE = "100-continue";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    private final Map<String, List<String>> headers;

    public StandardHttpHeaders() {
        this(new LinkedHashMap<String, List<String>>());
    }

    public StandardHttpHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    @Override
    public List<String> headers(String key) {
        ArrayList values = new ArrayList();
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(key)) continue;
            values.addAll(entry.getValue());
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.headers);
    }
}

