/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.lapack;

import dev.ludovic.netlib.lapack.F2jLAPACK;
import dev.ludovic.netlib.lapack.JNILAPACK;
import dev.ludovic.netlib.lapack.JavaLAPACK;
import dev.ludovic.netlib.lapack.LAPACK;
import dev.ludovic.netlib.lapack.NativeLAPACK;
import java.util.logging.Logger;

final class InstanceBuilder {
    private static final Logger log = Logger.getLogger(InstanceBuilder.class.getName());
    private static final LAPACK lapack;
    private static final NativeLAPACK nativeLapack;
    private static final JavaLAPACK javaLapack;

    InstanceBuilder() {
    }

    public static LAPACK lapack() {
        return lapack;
    }

    private static NativeLAPACK initializeNative() {
        try {
            return JNILAPACK.getInstance();
        }
        catch (Throwable t) {
            log.warning("Failed to load implementation from:" + JNILAPACK.class.getName());
            return null;
        }
    }

    public static NativeLAPACK nativeLapack() {
        if (nativeLapack == null) {
            throw new RuntimeException("Unable to load native implementation");
        }
        return nativeLapack;
    }

    private static JavaLAPACK initializeJava() {
        return F2jLAPACK.getInstance();
    }

    public static JavaLAPACK javaLapack() {
        return javaLapack;
    }

    static {
        nativeLapack = InstanceBuilder.initializeNative();
        javaLapack = InstanceBuilder.initializeJava();
        lapack = nativeLapack != null ? nativeLapack : javaLapack;
    }
}

