/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(QueryState queryState, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        HiveOperation opType = commandType.get(tree.getType());
        queryState.setCommandType(opType);
        switch (tree.getType()) {
            case 751: {
                return new ExplainSemanticAnalyzer(queryState);
            }
            case 752: {
                return new ExplainSQRewriteSemanticAnalyzer(queryState);
            }
            case 811: {
                return new LoadSemanticAnalyzer(queryState);
            }
            case 754: {
                return new ExportSemanticAnalyzer(queryState);
            }
            case 778: {
                return new ImportSemanticAnalyzer(queryState);
            }
            case 883: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 884: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 885: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 656: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 657: 
                    case 658: 
                    case 659: 
                    case 660: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 668: 
                    case 672: 
                    case 673: 
                    case 674: 
                    case 675: 
                    case 677: 
                    case 680: 
                    case 682: 
                    case 683: {
                        queryState.setCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                opType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                queryState.setCommandType(opType);
                return new DDLSemanticAnalyzer(queryState);
            }
            case 686: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 687: 
                    case 688: 
                    case 689: 
                    case 690: 
                    case 691: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                assert (child.getType() == 876);
                queryState.setCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(queryState);
            }
            case 648: 
            case 652: 
            case 653: 
            case 654: 
            case 655: 
            case 663: 
            case 699: 
            case 707: 
            case 709: 
            case 712: 
            case 731: 
            case 732: 
            case 733: 
            case 740: 
            case 742: 
            case 744: 
            case 745: 
            case 746: 
            case 747: 
            case 766: 
            case 768: 
            case 812: 
            case 813: 
            case 818: 
            case 890: 
            case 891: 
            case 909: 
            case 910: 
            case 911: 
            case 912: 
            case 913: 
            case 914: 
            case 915: 
            case 916: 
            case 917: 
            case 918: 
            case 919: 
            case 920: 
            case 921: 
            case 922: 
            case 923: 
            case 924: 
            case 925: 
            case 926: 
            case 927: 
            case 928: 
            case 929: 
            case 947: 
            case 990: 
            case 998: 
            case 999: {
                return new DDLSemanticAnalyzer(queryState);
            }
            case 708: 
            case 741: 
            case 880: {
                return new FunctionSemanticAnalyzer(queryState);
            }
            case 692: {
                return new ColumnStatsSemanticAnalyzer(queryState);
            }
            case 711: 
            case 743: {
                return new MacroSemanticAnalyzer(queryState);
            }
            case 730: 
            case 816: 
            case 1001: {
                return new UpdateDeleteSemanticAnalyzer(queryState);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar((Configuration)queryState.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(queryState) : new SemanticAnalyzer(queryState);
        return semAnalyzer;
    }

    private SemanticAnalyzerFactory() {
    }

    static HiveOperation getOperation(int hiveParserToken) {
        return commandType.get(hiveParserToken);
    }

    static {
        commandType.put(751, HiveOperation.EXPLAIN);
        commandType.put(811, HiveOperation.LOAD);
        commandType.put(754, HiveOperation.EXPORT);
        commandType.put(778, HiveOperation.IMPORT);
        commandType.put(707, HiveOperation.CREATEDATABASE);
        commandType.put(740, HiveOperation.DROPDATABASE);
        commandType.put(947, HiveOperation.SWITCHDATABASE);
        commandType.put(713, HiveOperation.CREATETABLE);
        commandType.put(990, HiveOperation.TRUNCATETABLE);
        commandType.put(745, HiveOperation.DROPTABLE);
        commandType.put(733, HiveOperation.DESCTABLE);
        commandType.put(732, HiveOperation.DESCFUNCTION);
        commandType.put(818, HiveOperation.MSCK);
        commandType.put(657, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(677, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(675, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(674, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(666, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(659, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(682, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(660, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(683, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(673, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(667, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(668, HiveOperation.ALTERTABLE_EXCHANGEPARTITION);
        commandType.put(665, HiveOperation.ALTERTABLE_DROPCONSTRAINT);
        commandType.put(658, HiveOperation.ALTERTABLE_ADDCONSTRAINT);
        commandType.put(911, HiveOperation.SHOWDATABASES);
        commandType.put(917, HiveOperation.SHOWTABLES);
        commandType.put(909, HiveOperation.SHOWCOLUMNS);
        commandType.put(927, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(928, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(920, HiveOperation.SHOW_CREATEDATABASE);
        commandType.put(921, HiveOperation.SHOW_CREATETABLE);
        commandType.put(913, HiveOperation.SHOWFUNCTIONS);
        commandType.put(914, HiveOperation.SHOWINDEXES);
        commandType.put(916, HiveOperation.SHOWPARTITIONS);
        commandType.put(915, HiveOperation.SHOWLOCKS);
        commandType.put(912, HiveOperation.SHOWLOCKS);
        commandType.put(910, HiveOperation.SHOWCONF);
        commandType.put(918, HiveOperation.SHOWVIEWS);
        commandType.put(708, HiveOperation.CREATEFUNCTION);
        commandType.put(741, HiveOperation.DROPFUNCTION);
        commandType.put(880, HiveOperation.RELOADFUNCTION);
        commandType.put(711, HiveOperation.CREATEMACRO);
        commandType.put(743, HiveOperation.DROPMACRO);
        commandType.put(714, HiveOperation.CREATEVIEW);
        commandType.put(715, HiveOperation.CREATE_MATERIALIZED_VIEW);
        commandType.put(746, HiveOperation.DROPVIEW);
        commandType.put(747, HiveOperation.DROP_MATERIALIZED_VIEW);
        commandType.put(709, HiveOperation.CREATEINDEX);
        commandType.put(742, HiveOperation.DROPINDEX);
        commandType.put(655, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(654, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(690, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(689, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(687, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(688, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(691, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(686, HiveOperation.ALTERVIEW_AS);
        commandType.put(876, HiveOperation.QUERY);
        commandType.put(813, HiveOperation.LOCKTABLE);
        commandType.put(999, HiveOperation.UNLOCKTABLE);
        commandType.put(812, HiveOperation.LOCKDB);
        commandType.put(998, HiveOperation.UNLOCKDB);
        commandType.put(712, HiveOperation.CREATEROLE);
        commandType.put(744, HiveOperation.DROPROLE);
        commandType.put(766, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(890, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(922, HiveOperation.SHOW_GRANT);
        commandType.put(768, HiveOperation.GRANT_ROLE);
        commandType.put(891, HiveOperation.REVOKE_ROLE);
        commandType.put(923, HiveOperation.SHOW_ROLES);
        commandType.put(926, HiveOperation.SHOW_ROLES);
        commandType.put(925, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(924, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(653, HiveOperation.ALTERDATABASE);
        commandType.put(652, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(731, HiveOperation.DESCDATABASE);
        commandType.put(680, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(692, HiveOperation.ANALYZE_TABLE);
        commandType.put(699, HiveOperation.CACHE_METADATA);
        commandType.put(672, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(919, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(929, HiveOperation.SHOW_TRANSACTIONS);
        commandType.put(648, HiveOperation.ABORT_TRANSACTIONS);
        commandType.put(935, HiveOperation.START_TRANSACTION);
        commandType.put(706, HiveOperation.COMMIT);
        commandType.put(896, HiveOperation.ROLLBACK);
        commandType.put(907, HiveOperation.SET_AUTOCOMMIT);
        commandType.put(883, HiveOperation.EXPORT);
        commandType.put(884, HiveOperation.IMPORT);
        commandType.put(885, HiveOperation.SHOW_TBLPROPERTIES);
        tablePartitionCommandType.put(669, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(670, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(671, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(679, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(678, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(676, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(664, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(681, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(661, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(663, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(684, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
        tablePartitionCommandType.put(685, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

