/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public abstract class MathFuncLongToLong
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected int colNum;
    private int outputColumn;

    protected abstract long func(long var1);

    public MathFuncLongToLong(int colNum, int outputColumn) {
        this.colNum = colNum;
        this.outputColumn = outputColumn;
    }

    public MathFuncLongToLong() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            this.evaluateChildren(batch);
        }
        LongColumnVector inputColVector = (LongColumnVector)batch.cols[this.colNum];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector.noNulls;
        int n = batch.size;
        long[] vector = inputColVector.vector;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector.isRepeating) {
            outputVector[0] = this.func(vector[0]);
            outputIsNull[0] = inputIsNull[0];
            outputColVector.isRepeating = true;
        } else if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = this.func(vector[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.func(vector[i]);
                }
            }
            outputColVector.isRepeating = false;
        } else {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = this.func(vector[i]);
                    outputIsNull[i] = inputIsNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.func(vector[i]);
                }
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
            }
            outputColVector.isRepeating = false;
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    @Override
    public String getOutputType() {
        return "long";
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum;
    }
}

