/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ThetaIntersection$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ThetaSketchUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(first, second) - Intersects two binary representations of\n    Datasketches ThetaSketch objects from two input columns using a\n    ThetaSketch Intersect object. ", examples="\n    Examples:\n      > SELECT theta_sketch_estimate(_FUNC_(theta_sketch_agg(col1), theta_sketch_agg(col2))) FROM VALUES (5, 4), (1, 4), (2, 5), (2, 5), (3, 1) tab(col1, col2);\n       2\n  ", group="misc_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001B\u0010!\u00016B\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015y\u0006\u0001\"\u0011O\u0011\u0015\u0001\u0007\u0001\"\u0011O\u0011\u0015\t\u0007\u0001\"\u0015c\u0011\u00159\u0007\u0001\"\u0011i\u0011\u0015\t\b\u0001\"\u0011s\u0011\u0015a\b\u0001\"\u0011~\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bA\u0011\"!\u0006\u0001\u0003\u0003%\t!a\u0006\t\u0013\u0005u\u0001!%A\u0005\u0002\u0005}\u0001\"CA\u001b\u0001E\u0005I\u0011AA\u0010\u0011%\t9\u0004AA\u0001\n\u0003\nI\u0004C\u0005\u0002J\u0001\t\t\u0011\"\u0001\u0002L!I\u00111\u000b\u0001\u0002\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u00037\u0002\u0011\u0011!C!\u0003;B\u0011\"a\u001b\u0001\u0003\u0003%\t!!\u001c\t\u0013\u0005E\u0004!!A\u0005B\u0005M\u0004\"CA<\u0001\u0005\u0005I\u0011IA=\u000f%\ti\nIA\u0001\u0012\u0003\tyJ\u0002\u0005 A\u0005\u0005\t\u0012AAQ\u0011\u0019)\u0016\u0004\"\u0001\u0002:\"I\u00111X\r\u0002\u0002\u0013\u0015\u0013Q\u0018\u0005\n\u0003\u007fK\u0012\u0011!CA\u0003\u0003D\u0011\"a2\u001a\u0003\u0003%\t)!3\t\u0013\u0005m\u0017$!A\u0005\n\u0005u'!\u0005+iKR\f\u0017J\u001c;feN,7\r^5p]*\u0011\u0011EI\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002$I\u0005A1-\u0019;bYf\u001cHO\u0003\u0002&M\u0005\u00191/\u001d7\u000b\u0005\u001dB\u0013!B:qCJ\\'BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001]IB4(\u0011\t\u0003_Aj\u0011\u0001I\u0005\u0003c\u0001\u0012\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U\u0002\u0013aB2pI\u0016<WM\\\u0005\u0003oQ\u0012qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003_eJ!A\u000f\u0011\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UHA\u0004Qe>$Wo\u0019;\u0011\u0005\tSeBA\"I\u001d\t!u)D\u0001F\u0015\t1E&\u0001\u0004=e>|GOP\u0005\u0002}%\u0011\u0011*P\u0001\ba\u0006\u001c7.Y4f\u0013\tYEJ\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002J{\u0005)a-\u001b:tiV\tq\n\u0005\u00020!&\u0011\u0011\u000b\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017A\u00024jeN$\b%\u0001\u0004tK\u000e|g\u000eZ\u0001\bg\u0016\u001cwN\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0019q\u000bW-\u0011\u0005=\u0002\u0001\"B'\u0006\u0001\u0004y\u0005\"B*\u0006\u0001\u0004y\u0015A\u00048vY2Le\u000e^8mKJ\fg\u000e^\u000b\u00029B\u0011A(X\u0005\u0003=v\u0012qAQ8pY\u0016\fg.\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\r96-\u001a\u0005\u0006I&\u0001\raT\u0001\t]\u0016<h)\u001b:ti\")a-\u0003a\u0001\u001f\u0006Ia.Z<TK\u000e|g\u000eZ\u0001\u000baJ,G\u000f^=OC6,W#A5\u0011\u0005)tgBA6m!\t!U(\u0003\u0002n{\u00051\u0001K]3eK\u001aL!a\u001c9\u0003\rM#(/\u001b8h\u0015\tiW(\u0001\u0006j]B,H\u000fV=qKN,\u0012a\u001d\t\u0004\u0005R4\u0018BA;M\u0005\r\u0019V-\u001d\t\u0003ojl\u0011\u0001\u001f\u0006\u0003s\u0012\nQ\u0001^=qKNL!a\u001f=\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003y\u0004\"a^@\n\u0007\u0005\u0005\u0001P\u0001\u0005ECR\fG+\u001f9f\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0019\t9!!\u0004\u0002\u0012A\u0019A(!\u0003\n\u0007\u0005-QHA\u0002B]fDq!a\u0004\u000e\u0001\u0004\t9!\u0001\u0004wC2,X-\r\u0005\b\u0003'i\u0001\u0019AA\u0004\u0003\u00191\u0018\r\\;fe\u0005!1m\u001c9z)\u00159\u0016\u0011DA\u000e\u0011\u001die\u0002%AA\u0002=Cqa\u0015\b\u0011\u0002\u0003\u0007q*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005\"fA(\u0002$-\u0012\u0011Q\u0005\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003%)hn\u00195fG.,GMC\u0002\u00020u\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019$!\u000b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0004\u0005\u0003\u0002>\u0005\u001dSBAA \u0015\u0011\t\t%a\u0011\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000b\nAA[1wC&\u0019q.a\u0010\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u00055\u0003c\u0001\u001f\u0002P%\u0019\u0011\u0011K\u001f\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d\u0011q\u000b\u0005\n\u00033\u001a\u0012\u0011!a\u0001\u0003\u001b\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA0!\u0019\t\t'a\u001a\u0002\b5\u0011\u00111\r\u0006\u0004\u0003Kj\u0014AC2pY2,7\r^5p]&!\u0011\u0011NA2\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007q\u000by\u0007C\u0005\u0002ZU\t\t\u00111\u0001\u0002\b\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tY$!\u001e\t\u0013\u0005ec#!AA\u0002\u00055\u0013AB3rk\u0006d7\u000fF\u0002]\u0003wB\u0011\"!\u0017\u0018\u0003\u0003\u0005\r!a\u0002)'\u0001\ty(!\"\u0002\b\u0006-\u0015QRAI\u0003'\u000b9*!'\u0011\u0007=\n\t)C\u0002\u0002\u0004\u0002\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\n\u0006\tIF\u0003\u0011!A\u0001zf)\u0016(D?\"2\u0017N]:uY\u0001\u001aXmY8oI&\u0002S\u0006I%oi\u0016\u00148/Z2ug\u0002\"xo\u001c\u0011cS:\f'/\u001f\u0011sKB\u0014Xm]3oi\u0006$\u0018n\u001c8tA=4'\u0002\t\u0011!A\u0011\u000bG/Y:lKR\u001c\u0007.Z:!)\",G/Y*lKR\u001c\u0007\u000eI8cU\u0016\u001cGo\u001d\u0011ge>l\u0007\u0005^<pA%t\u0007/\u001e;!G>dW/\u001c8tAU\u001c\u0018N\\4!C*\u0001\u0003\u0005\t\u0011UQ\u0016$\u0018mU6fi\u000eD\u0007%\u00138uKJ\u001cXm\u0019;!_\nTWm\u0019;/A\u0005AQ\r_1na2,7/\t\u0002\u0002\u0010\u0006\t9H\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011uQ\u0016$\u0018mX:lKR\u001c\u0007nX3ti&l\u0017\r^3)?\u001a+fjQ0)i\",G/Y0tW\u0016$8\r[0bO\u001eD3m\u001c72S1\u0002C\u000f[3uC~\u001b8.\u001a;dQ~\u000bwm\u001a\u0015d_2\u0014\u0014&K\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u00156Y\u0001\"\u0014\u0006\f\u0011)c1\u0002C'\u000b\u0017!QIb\u0003%N\u0015-A!\u0012D\u0006I\u001b*Y\u0001B3\u0007\f\u00112S\u0001\"\u0018M\u0019\u0015d_2\fD\u0006I2pYJJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a\u000bA\u0001\nQa\u001a:pkB\f#!!&\u0002\u00155L7oY0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002\u001c\u0006)AGL\u0019/a\u0005\tB\u000b[3uC&sG/\u001a:tK\u000e$\u0018n\u001c8\u0011\u0005=J2#B\r\u0002$\u0006=\u0006cBAS\u0003W{ujV\u0007\u0003\u0003OS1!!+>\u0003\u001d\u0011XO\u001c;j[\u0016LA!!,\u0002(\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gSA!!.\u0002D\u0005\u0011\u0011n\\\u0005\u0004\u0017\u0006MFCAAP\u0003!!xn\u0015;sS:<GCAA\u001e\u0003\u0015\t\u0007\u000f\u001d7z)\u00159\u00161YAc\u0011\u0015iE\u00041\u0001P\u0011\u0015\u0019F\u00041\u0001P\u0003\u001d)h.\u00199qYf$B!a3\u0002XB)A(!4\u0002R&\u0019\u0011qZ\u001f\u0003\r=\u0003H/[8o!\u0015a\u00141[(P\u0013\r\t).\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005eW$!AA\u0002]\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ty\u000e\u0005\u0003\u0002>\u0005\u0005\u0018\u0002BAr\u0003\u007f\u0011aa\u00142kK\u000e$\b")
public class ThetaIntersection
extends BinaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression first;
    private final Expression second;

    public static Option<Tuple2<Expression, Expression>> unapply(ThetaIntersection x$0) {
        return ThetaIntersection$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ThetaIntersection> tupled() {
        return ThetaIntersection$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ThetaIntersection>> curried() {
        return ThetaIntersection$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    public Expression first() {
        return this.first;
    }

    public Expression second() {
        return this.second;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression left() {
        return this.first();
    }

    @Override
    public Expression right() {
        return this.second();
    }

    @Override
    public ThetaIntersection withNewChildrenInternal(Expression newFirst, Expression newSecond) {
        return this.copy(newFirst, newSecond);
    }

    @Override
    public String prettyName() {
        return "theta_intersection";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object value1, Object value2) {
        byte[] sketch1Bytes = (byte[])value1;
        CompactSketch sketch1 = ThetaSketchUtils$.MODULE$.wrapCompactSketch(sketch1Bytes, this.prettyName());
        byte[] sketch2Bytes = (byte[])value2;
        CompactSketch sketch2 = ThetaSketchUtils$.MODULE$.wrapCompactSketch(sketch2Bytes, this.prettyName());
        CompactSketch intersection = SetOperation.builder().buildIntersection().intersect((Sketch)sketch1, (Sketch)sketch2);
        return intersection.toByteArrayCompressed();
    }

    public ThetaIntersection copy(Expression first, Expression second) {
        return new ThetaIntersection(first, second);
    }

    public Expression copy$default$1() {
        return this.first();
    }

    public Expression copy$default$2() {
        return this.second();
    }

    @Override
    public String productPrefix() {
        return "ThetaIntersection";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.first();
            }
            case 1: {
                return this.second();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ThetaIntersection;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "first";
            }
            case 1: {
                return "second";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ThetaIntersection)) return false;
        boolean bl = true;
        if (!bl) return false;
        ThetaIntersection thetaIntersection = (ThetaIntersection)x$1;
        Expression expression = this.first();
        Expression expression2 = thetaIntersection.first();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.second();
        Expression expression4 = thetaIntersection.second();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!thetaIntersection.canEqual(this)) return false;
        return true;
    }

    public ThetaIntersection(Expression first, Expression second) {
        this.first = first;
        this.second = second;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

