/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Substring$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, pos[, len]) - Returns the substring of `str` that starts at `pos` and is of length `len`, or the slice of byte array that starts at `pos` and is of length `len`.\n\n    _FUNC_(str FROM pos[ FOR len]]) - Returns the substring of `str` that starts at `pos` and is of length `len`, or the slice of byte array that starts at `pos` and is of length `len`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL', 5);\n       k SQL\n      > SELECT _FUNC_('Spark SQL', -3);\n       SQL\n      > SELECT _FUNC_('Spark SQL', 5, 1);\n       k\n      > SELECT _FUNC_('Spark SQL' FROM 5);\n       k SQL\n      > SELECT _FUNC_('Spark SQL' FROM -3);\n       SQL\n      > SELECT _FUNC_('Spark SQL' FROM 5 FOR 1);\n       k\n      > SELECT _FUNC_(encode('Spark SQL', 'utf-8'), 5);\n       k SQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t-a\u0001B\u0013'\u0001NB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011!)\u0006A!f\u0001\n\u0003q\u0005\u0002\u0003,\u0001\u0005#\u0005\u000b\u0011B(\t\u000b]\u0003A\u0011\u0001-\t\u000bu\u0003A\u0011\t0\t\u000b]\u0003A\u0011\u00012\t\u000b\u0015\u0004A\u0011\t4\t\u000b5\u0004A\u0011\t8\t\u000bU\u0004A\u0011\t0\t\u000bY\u0004A\u0011\t(\t\u000b]\u0004A\u0011\t(\t\u000ba\u0004A\u0011\t(\t\u000be\u0004A\u0011\t>\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u00111\u0005\u0001\u0005R\u0005\u0015\u0002\"CA\u001a\u0001\u0005\u0005I\u0011AA\u001b\u0011%\ti\u0004AI\u0001\n\u0003\ty\u0004C\u0005\u0002V\u0001\t\n\u0011\"\u0001\u0002@!I\u0011q\u000b\u0001\u0012\u0002\u0013\u0005\u0011q\b\u0005\n\u00033\u0002\u0011\u0011!C!\u00037B\u0011\"!\u001c\u0001\u0003\u0003%\t!a\u001c\t\u0013\u0005]\u0004!!A\u0005\u0002\u0005e\u0004\"CA@\u0001\u0005\u0005I\u0011IAA\u0011%\ty\tAA\u0001\n\u0003\t\t\nC\u0005\u0002\u0016\u0002\t\t\u0011\"\u0011\u0002\u0018\"I\u00111\u0014\u0001\u0002\u0002\u0013\u0005\u0013QT\u0004\n\u0003\u00034\u0013\u0011!E\u0001\u0003\u00074\u0001\"\n\u0014\u0002\u0002#\u0005\u0011Q\u0019\u0005\u0007/~!\t!!8\t\u0013\u0005}w$!A\u0005F\u0005\u0005\b\"CAr?\u0005\u0005I\u0011QAs\u0011%\tioHA\u0001\n\u0003\u000by\u000fC\u0005\u0003\u0002}\t\t\u0011\"\u0003\u0003\u0004\tI1+\u001e2tiJLgn\u001a\u0006\u0003O!\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0011FK\u0001\tG\u0006$\u0018\r\\=ti*\u00111\u0006L\u0001\u0004gFd'BA\u0017/\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0003'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002c\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u000e\u001d<\u0003B\u0011QGN\u0007\u0002M%\u0011qG\n\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u001b:\u0013\tQdE\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0011&\u000f\u0005\rCeB\u0001#H\u001b\u0005)%B\u0001$3\u0003\u0019a$o\\8u}%\ta(\u0003\u0002J{\u00059\u0001/Y2lC\u001e,\u0017BA&M\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tIU(A\u0002tiJ,\u0012a\u0014\t\u0003kAK!!\u0015\u0014\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0003tiJ\u0004\u0013a\u00019pg\u0006!\u0001o\\:!\u0003\raWM\\\u0001\u0005Y\u0016t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u00053j[F\f\u0005\u00026\u0001!)Qj\u0002a\u0001\u001f\")1k\u0002a\u0001\u001f\")Qk\u0002a\u0001\u001f\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$X#A0\u0011\u0005q\u0002\u0017BA1>\u0005\u001d\u0011un\u001c7fC:$2!W2e\u0011\u0015i\u0015\u00021\u0001P\u0011\u0015\u0019\u0016\u00021\u0001P\u0003!!\u0017\r^1UsB,W#A4\u0011\u0005!\\W\"A5\u000b\u0005)T\u0013!\u0002;za\u0016\u001c\u0018B\u00017j\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\tq\u000eE\u0002CaJL!!\u001d'\u0003\u0007M+\u0017\u000f\u0005\u0002ig&\u0011A/\u001b\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f!dY8oi\u0016DH/\u00138eKB,g\u000eZ3oi\u001a{G\u000eZ1cY\u0016\fQAZ5sgR\faa]3d_:$\u0017!\u0002;iSJ$\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCB>\u007f\u0003\u0003\t\u0019\u0001\u0005\u0002=y&\u0011Q0\u0010\u0002\u0004\u0003:L\b\"B@\u0011\u0001\u0004Y\u0018AB:ue&tw\rC\u0003T!\u0001\u00071\u0010C\u0003V!\u0001\u000710A\u0005e_\u001e+gnQ8eKR1\u0011\u0011BA\u000b\u0003?\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f1\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003'\tiA\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t9\"\u0005a\u0001\u00033\t1a\u0019;y!\u0011\tY!a\u0007\n\t\u0005u\u0011Q\u0002\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t\t#\u0005a\u0001\u0003\u0013\t!!\u001a<\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcB-\u0002(\u0005-\u0012q\u0006\u0005\u0007\u0003S\u0011\u0002\u0019A(\u0002\u00119,wOR5sgRDa!!\f\u0013\u0001\u0004y\u0015!\u00038foN+7m\u001c8e\u0011\u0019\t\tD\u0005a\u0001\u001f\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLHcB-\u00028\u0005e\u00121\b\u0005\b\u001bN\u0001\n\u00111\u0001P\u0011\u001d\u00196\u0003%AA\u0002=Cq!V\n\u0011\u0002\u0003\u0007q*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005#fA(\u0002D-\u0012\u0011Q\t\t\u0005\u0003\u000f\n\t&\u0004\u0002\u0002J)!\u00111JA'\u0003%)hn\u00195fG.,GMC\u0002\u0002Pu\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019&!\u0013\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0018\u0011\t\u0005}\u0013\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005!A.\u00198h\u0015\t\t9'\u0001\u0003kCZ\f\u0017\u0002BA6\u0003C\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA9!\ra\u00141O\u0005\u0004\u0003kj$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA>\u0002|!I\u0011QP\r\u0002\u0002\u0003\u0007\u0011\u0011O\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0005#BAC\u0003\u0017[XBAAD\u0015\r\tI)P\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAG\u0003\u000f\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019q,a%\t\u0011\u0005u4$!AA\u0002m\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QLAM\u0011%\ti\bHA\u0001\u0002\u0004\t\t(\u0001\u0004fcV\fGn\u001d\u000b\u0004?\u0006}\u0005\u0002CA?;\u0005\u0005\t\u0019A>)'\u0001\t\u0019+!+\u0002,\u0006=\u0016\u0011WA[\u0003o\u000bY,!0\u0011\u0007U\n)+C\u0002\u0002(\u001a\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002.\u0006\u0011\tO\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aHO\u001d\u0017!a>\u001c8\f\f\u0011mK:l\u0016\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI:vEN$(/\u001b8hA=4\u0007\u0005Y:ue\u0002\u0004C\u000f[1uAM$\u0018M\u001d;tA\u0005$\b\u0005\u00199pg\u0002\u0004\u0013M\u001c3!SN\u0004sN\u001a\u0011mK:<G\u000f\u001b\u0011aY\u0016t\u0007\r\f\u0011pe\u0002\"\b.\u001a\u0011tY&\u001cW\rI8gA\tLH/\u001a\u0011beJ\f\u0017\u0010\t;iCR\u00043\u000f^1siN\u0004\u0013\r\u001e\u0011aa>\u001c\b\rI1oI\u0002J7\u000fI8gA1,gn\u001a;iA\u0001dWM\u001c1/\u0015)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJ\u0004cIU(NAA|7o\u0017\u0011G\u001fJ\u0003C.\u001a8^;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043/\u001e2tiJLgn\u001a\u0011pM\u0002\u00027\u000f\u001e:aAQD\u0017\r\u001e\u0011ti\u0006\u0014Ho\u001d\u0011bi\u0002\u0002\u0007o\\:aA\u0005tG\rI5tA=4\u0007\u0005\\3oORD\u0007\u0005\u00197f]\u0002d\u0003e\u001c:!i\",\u0007e\u001d7jG\u0016\u0004sN\u001a\u0011csR,\u0007%\u0019:sCf\u0004C\u000f[1uAM$\u0018M\u001d;tA\u0005$\b\u0005\u00199pg\u0002\u0004\u0013M\u001c3!SN\u0004sN\u001a\u0011mK:<G\u000f\u001b\u0011aY\u0016t\u0007M\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u00024\u0006\u0019\u0019D\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B\f'o\u001b\u0011T#2;C\u0006I\u001b*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0007eU)M\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3\u000b]1sW\u0002\u001a\u0016\u000bT\u0014-A5\u001a\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011T#2S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\\u0007eU)MO1\u0002S\u0007\f\u00112SmR\u0001\u0005\t\u0011!A\u0001\u00023N\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B\f'o\u001b\u0011T#2;\u0003E\u0012*P\u001b\u0002*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011lAM\u000bFJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B\f'o\u001b\u0011T#2;\u0003E\u0012*P\u001b\u0002j3'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!'Fc%\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148\u000eI*R\u0019\u001e\u0002cIU(NAU\u0002ci\u0014*!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001b\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)K:\u001cw\u000eZ3)OM\u0003\u0018M]6!'Fcu\u0005\f\u0011(kR4W\u0006O\u0014*Y\u0001*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011lAM\u000bFJ\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tI,A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u0002@\u0006a1\u000f\u001e:j]\u001e|f-\u001e8dg\u0006I1+\u001e2tiJLgn\u001a\t\u0003k}\u0019RaHAd\u0003'\u0004\u0002\"!3\u0002P>{u*W\u0007\u0003\u0003\u0017T1!!4>\u0003\u001d\u0011XO\u001c;j[\u0016LA!!5\u0002L\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u0005U\u00171\\\u0007\u0003\u0003/TA!!7\u0002f\u0005\u0011\u0011n\\\u0005\u0004\u0017\u0006]GCAAb\u0003!!xn\u0015;sS:<GCAA/\u0003\u0015\t\u0007\u000f\u001d7z)\u001dI\u0016q]Au\u0003WDQ!\u0014\u0012A\u0002=CQa\u0015\u0012A\u0002=CQ!\u0016\u0012A\u0002=\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002r\u0006u\b#\u0002\u001f\u0002t\u0006]\u0018bAA{{\t1q\n\u001d;j_:\u0004b\u0001PA}\u001f>{\u0015bAA~{\t1A+\u001e9mKNB\u0001\"a@$\u0003\u0003\u0005\r!W\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u0003!\u0011\tyFa\u0002\n\t\t%\u0011\u0011\r\u0002\u0007\u001f\nTWm\u0019;")
public class Substring
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression str;
    private final Expression pos;
    private final Expression len;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Substring x$0) {
        return Substring$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Substring> tupled() {
        return Substring$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Substring>>> curried() {
        return Substring$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression pos() {
        return this.pos;
    }

    public Expression len() {
        return this.len;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.str().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), BinaryType$.MODULE$})), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.children().forall((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)x$27.contextIndependentFoldable()));
    }

    @Override
    public Expression first() {
        return this.str();
    }

    @Override
    public Expression second() {
        return this.pos();
    }

    @Override
    public Expression third() {
        return this.len();
    }

    @Override
    public Object nullSafeEval(Object string, Object pos, Object len) {
        DataType dataType = this.str().dataType();
        if (dataType instanceof StringType) {
            return ((UTF8String)string).substringSQL(BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)len));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return ByteArray.subStringSQL((byte[])((byte[])string), (int)BoxesRunTime.unboxToInt((Object)pos), (int)BoxesRunTime.unboxToInt((Object)len));
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(string, pos, len) -> {
            DataType dataType = this.str().dataType();
            if (dataType instanceof StringType) {
                return string + ".substringSQL(" + pos + ", " + len + ")";
            }
            if (BinaryType$.MODULE$.equals(dataType)) {
                return ByteArray.class.getName() + ".subStringSQL(" + string + ", " + pos + ", " + len + ")";
            }
            throw new MatchError((Object)dataType);
        });
    }

    @Override
    public Substring withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public Substring copy(Expression str, Expression pos, Expression len) {
        return new Substring(str, pos, len);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.pos();
    }

    public Expression copy$default$3() {
        return this.len();
    }

    @Override
    public String productPrefix() {
        return "Substring";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.pos();
            }
            case 2: {
                return this.len();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Substring;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "str";
            }
            case 1: {
                return "pos";
            }
            case 2: {
                return "len";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Substring)) return false;
        boolean bl = true;
        if (!bl) return false;
        Substring substring = (Substring)x$1;
        Expression expression = this.str();
        Expression expression2 = substring.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pos();
        Expression expression4 = substring.pos();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.len();
        Expression expression6 = substring.len();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substring.canEqual(this)) return false;
        return true;
    }

    public Substring(Expression str, Expression pos, Expression len) {
        this.str = str;
        this.pos = pos;
        this.len = len;
        ExpectsInputTypes.$init$(this);
    }

    public Substring(Expression str, Expression pos) {
        this(str, pos, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)));
    }
}

