/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Slice$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(x, start, length) - Subsets array x starting from index start (array indices start at 1, or starting from the end if start is negative) with the specified length.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, 4), 2, 2);\n       [2,3]\n      > SELECT _FUNC_(array(1, 2, 3, 4), -2, 2);\n       [3,4]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\t]b\u0001\u0002\u0014(\u0001RB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005V\u0001\tE\t\u0015!\u0003Q\u0011!1\u0006A!f\u0001\n\u0003y\u0005\u0002C,\u0001\u0005#\u0005\u000b\u0011\u0002)\t\u000ba\u0003A\u0011A-\t\u000by\u0003A\u0011I0\t\u000b\r\u0004A\u0011\t3\t\u000b-\u0004A\u0011B0\t\u000b1\u0004A\u0011I7\t\u000bQ\u0004A\u0011I(\t\u000bU\u0004A\u0011I(\t\u000bY\u0004A\u0011I(\t\u0011]\u0004\u0001R1A\u0005\n\u0011DQ\u0001 \u0001\u0005BuDq!a\u0004\u0001\t\u0003\n\t\u0002C\u0004\u0002.\u0001!\t!a\f\t\u000f\u0005E\u0003\u0001\"\u0015\u0002T!I\u0011\u0011\r\u0001\u0002\u0002\u0013\u0005\u00111\r\u0005\n\u0003W\u0002\u0011\u0013!C\u0001\u0003[B\u0011\"a!\u0001#\u0003%\t!!\u001c\t\u0013\u0005\u0015\u0005!%A\u0005\u0002\u00055\u0004\"CAD\u0001\u0005\u0005I\u0011IAE\u0011%\tI\nAA\u0001\n\u0003\tY\nC\u0005\u0002$\u0002\t\t\u0011\"\u0001\u0002&\"I\u00111\u0016\u0001\u0002\u0002\u0013\u0005\u0013Q\u0016\u0005\n\u0003w\u0003\u0011\u0011!C\u0001\u0003{C\u0011\"!1\u0001\u0003\u0003%\t%a1\t\u0013\u0005\u001d\u0007!!A\u0005B\u0005%w!CAwO\u0005\u0005\t\u0012AAx\r!1s%!A\t\u0002\u0005E\bB\u0002-!\t\u0003\u0011I\u0001C\u0005\u0003\f\u0001\n\t\u0011\"\u0012\u0003\u000e!I!q\u0002\u0011\u0002\u0002\u0013\u0005%\u0011\u0003\u0005\n\u00053\u0001\u0013\u0011!CA\u00057A\u0011B!\f!\u0003\u0003%IAa\f\u0003\u000bMc\u0017nY3\u000b\u0005!J\u0013aC3yaJ,7o]5p]NT!AK\u0016\u0002\u0011\r\fG/\u00197zgRT!\u0001L\u0017\u0002\u0007M\fHN\u0003\u0002/_\u0005)1\u000f]1sW*\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u001b:y\t\u0003\"AN\u001c\u000e\u0003\u001dJ!\u0001O\u0014\u0003#Q+'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00027u%\u00111h\n\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011Q\bQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t9\u0001K]8ek\u000e$\bCA\"L\u001d\t!\u0015J\u0004\u0002F\u00116\taI\u0003\u0002Hg\u00051AH]8pizJ\u0011aP\u0005\u0003\u0015z\nq\u0001]1dW\u0006<W-\u0003\u0002M\u001b\na1+\u001a:jC2L'0\u00192mK*\u0011!JP\u0001\u0002qV\t\u0001\u000b\u0005\u00027#&\u0011!k\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017A\u0001=!\u0003\u0015\u0019H/\u0019:u\u0003\u0019\u0019H/\u0019:uA\u00051A.\u001a8hi\"\fq\u0001\\3oORD\u0007%\u0001\u0004=S:LGO\u0010\u000b\u00055ncV\f\u0005\u00027\u0001!)aj\u0002a\u0001!\")Ak\u0002a\u0001!\")ak\u0002a\u0001!\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$X#\u00011\u0011\u0005u\n\u0017B\u00012?\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002KB\u0011a-[\u0007\u0002O*\u0011\u0001nK\u0001\u0006if\u0004Xm]\u0005\u0003U\u001e\u0014\u0001\u0002R1uCRK\b/Z\u0001\u001be\u0016\u001cX\u000f\u001c;BeJ\f\u00170\u00127f[\u0016tGOT;mY\u0006\u0014G.Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u00018\u0011\u0007\r{\u0017/\u0003\u0002q\u001b\n\u00191+Z9\u0011\u0005\u0019\u0014\u0018BA:h\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-A\u0003gSJ\u001cH/\u0001\u0004tK\u000e|g\u000eZ\u0001\u0006i\"L'\u000fZ\u0001\fK2,W.\u001a8u)f\u0004X\r\u000b\u0002\u0010sB\u0011QH_\u0005\u0003wz\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u000fy\f\u0019!a\u0002\u0002\fA\u0011Qh`\u0005\u0004\u0003\u0003q$aA!os\"1\u0011Q\u0001\tA\u0002y\fA\u0001\u001f,bY\"1\u0011\u0011\u0002\tA\u0002y\f\u0001b\u001d;beR4\u0016\r\u001c\u0005\u0007\u0003\u001b\u0001\u0002\u0019\u0001@\u0002\u00131,gn\u001a;i-\u0006d\u0017!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t\u0019\"a\b\u0002*A!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a\u001d\nqaY8eK\u001e,g.\u0003\u0003\u0002\u001e\u0005]!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\u0005\u0012\u00031\u0001\u0002$\u0005\u00191\r\u001e=\u0011\t\u0005U\u0011QE\u0005\u0005\u0003O\t9B\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005-\u0012\u00031\u0001\u0002\u0014\u0005\u0011QM^\u0001\u0011O\u0016t7i\u001c3f\r>\u0014(+Z:vYR$B\"!\r\u0002B\u0005\r\u0013QIA%\u0003\u001b\u0002B!a\r\u0002<9!\u0011QGA\u001c!\t)e(C\u0002\u0002:y\na\u0001\u0015:fI\u00164\u0017\u0002BA\u001f\u0003\u007f\u0011aa\u0015;sS:<'bAA\u001d}!9\u0011\u0011\u0005\nA\u0002\u0005\r\u0002bBA\u0016%\u0001\u0007\u00111\u0003\u0005\b\u0003\u000f\u0012\u0002\u0019AA\u0019\u0003)Ig\u000e];u\u0003J\u0014\u0018-\u001f\u0005\b\u0003\u0017\u0012\u0002\u0019AA\u0019\u0003!\u0019H/\u0019:u\u0013\u0012D\bbBA(%\u0001\u0007\u0011\u0011G\u0001\ne\u0016\u001cH*\u001a8hi\"\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000fi\u000b)&!\u0017\u0002^!1\u0011qK\nA\u0002A\u000b\u0001B\\3x\r&\u00148\u000f\u001e\u0005\u0007\u00037\u001a\u0002\u0019\u0001)\u0002\u00139,woU3d_:$\u0007BBA0'\u0001\u0007\u0001+\u0001\u0005oK^$\u0006.\u001b:e\u0003\u0011\u0019w\u000e]=\u0015\u000fi\u000b)'a\u001a\u0002j!9a\n\u0006I\u0001\u0002\u0004\u0001\u0006b\u0002+\u0015!\u0003\u0005\r\u0001\u0015\u0005\b-R\u0001\n\u00111\u0001Q\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u001c+\u0007A\u000b\th\u000b\u0002\u0002tA!\u0011QOA@\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014!C;oG\",7m[3e\u0015\r\tiHP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAA\u0003o\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0017\u0003B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*\u0001\u0003mC:<'BAAK\u0003\u0011Q\u0017M^1\n\t\u0005u\u0012qR\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003;\u00032!PAP\u0013\r\t\tK\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004}\u0006\u001d\u0006\"CAU5\u0005\u0005\t\u0019AAO\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0016\t\u0006\u0003c\u000b9L`\u0007\u0003\u0003gS1!!.?\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003s\u000b\u0019L\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00011\u0002@\"A\u0011\u0011\u0016\u000f\u0002\u0002\u0003\u0007a0\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAF\u0003\u000bD\u0011\"!+\u001e\u0003\u0003\u0005\r!!(\u0002\r\u0015\fX/\u00197t)\r\u0001\u00171\u001a\u0005\t\u0003Ss\u0012\u0011!a\u0001}\"\u001a\u0002!a4\u0002V\u0006]\u00171\\Ao\u0003C\f\u0019/a:\u0002jB\u0019a'!5\n\u0007\u0005MwEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005e\u0017!a\u0015`\rVs5i\u0018\u0015yY\u0001\u001aH/\u0019:uY\u0001bWM\\4uQ&\u0002S\u0006I*vEN,Go\u001d\u0011beJ\f\u0017\u0010\t=!gR\f'\u000f^5oO\u00022'o\\7!S:$W\r\u001f\u0011ti\u0006\u0014H\u000f\t\u0015beJ\f\u0017\u0010I5oI&\u001cWm\u001d\u0011ti\u0006\u0014H\u000fI1uAEb\u0003e\u001c:!gR\f'\u000f^5oO\u00022'o\\7!i\",\u0007%\u001a8eA%4\u0007e\u001d;beR\u0004\u0013n\u001d\u0011oK\u001e\fG/\u001b<fS\u0001:\u0018\u000e\u001e5!i\",\u0007e\u001d9fG&4\u0017.\u001a3!Y\u0016tw\r\u001e5/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAp\u0003\u0005e!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\r\u0017!e1\u00023\u0007\f\u00115S1\u0002#\u0007\f\u00113SmR\u0001\u0005\t\u0011!A\u0001\u00023L\r\u00174;*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\nD\u0006\t\u001a-AMb\u0003\u0005N\u0015-A5\u0012D\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6\u0007\f\u001b^\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAs\u0003-\t'O]1z?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005-\u0018!\u0002\u001a/i9\u0002\u0014!B*mS\u000e,\u0007C\u0001\u001c!'\u0015\u0001\u00131_A\u0000!!\t)0a?Q!BSVBAA|\u0015\r\tIPP\u0001\beVtG/[7f\u0013\u0011\ti0a>\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0003\u0002\t\u001dQB\u0001B\u0002\u0015\u0011\u0011)!a%\u0002\u0005%|\u0017b\u0001'\u0003\u0004Q\u0011\u0011q^\u0001\ti>\u001cFO]5oOR\u0011\u00111R\u0001\u0006CB\u0004H.\u001f\u000b\b5\nM!Q\u0003B\f\u0011\u0015q5\u00051\u0001Q\u0011\u0015!6\u00051\u0001Q\u0011\u001516\u00051\u0001Q\u0003\u001d)h.\u00199qYf$BA!\b\u0003*A)QHa\b\u0003$%\u0019!\u0011\u0005 \u0003\r=\u0003H/[8o!\u0019i$Q\u0005)Q!&\u0019!q\u0005 \u0003\rQ+\b\u000f\\34\u0011!\u0011Y\u0003JA\u0001\u0002\u0004Q\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u0007\t\u0005\u0003\u001b\u0013\u0019$\u0003\u0003\u00036\u0005=%AB(cU\u0016\u001cG\u000f")
public class Slice
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private transient DataType elementType;
    private final Expression x;
    private final Expression start;
    private final Expression length;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Slice x$0) {
        return Slice$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Slice> tupled() {
        return Slice$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Slice>>> curried() {
        return Slice$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression x() {
        return this.x;
    }

    public Expression start() {
        return this.start;
    }

    public Expression length() {
        return this.length;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.x().dataType();
    }

    private boolean resultArrayElementNullable() {
        return ((ArrayType)this.dataType()).containsNull();
    }

    @Override
    public scala.collection.immutable.Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)ArrayType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.x();
    }

    @Override
    public Expression second() {
        return this.start();
    }

    @Override
    public Expression third() {
        return this.length();
    }

    private DataType elementType$lzycompute() {
        Slice slice = this;
        synchronized (slice) {
            if (!this.bitmap$trans$0) {
                this.elementType = ((ArrayType)this.x().dataType()).elementType();
                this.bitmap$trans$0 = true;
            }
        }
        return this.elementType;
    }

    private DataType elementType() {
        if (!this.bitmap$trans$0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public Object nullSafeEval(Object xVal, Object startVal, Object lengthVal) {
        int startIndex;
        int startInt = BoxesRunTime.unboxToInt((Object)startVal);
        int lengthInt = BoxesRunTime.unboxToInt((Object)lengthVal);
        ArrayData arr = (ArrayData)xVal;
        if (startInt == 0) {
            throw QueryExecutionErrors$.MODULE$.unexpectedValueForStartInFunctionError(this.prettyName());
        }
        int n = startIndex = startInt < 0 ? startInt + arr.numElements() : startInt - 1;
        if (lengthInt < 0) {
            throw QueryExecutionErrors$.MODULE$.unexpectedValueForLengthInFunctionError(this.prettyName(), lengthInt);
        }
        if (startIndex < 0 || startIndex >= arr.numElements()) {
            return new GenericArrayData(Array$.MODULE$.empty(ClassTag$.MODULE$.AnyRef()));
        }
        IndexedSeq data = arr.toSeq(this.elementType());
        return new GenericArrayData((Seq<Object>)((Seq)data.slice(startIndex, startIndex + lengthInt)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(x, start, length) -> {
            String startIdx = ctx.freshName("startIdx");
            String resLength = ctx.freshName("resLength");
            String defaultIntValue = CodeGenerator$.MODULE$.defaultValue("int", false);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |int " + startIdx + " = " + defaultIntValue + ";\n         |int " + resLength + " = " + defaultIntValue + ";\n         |if (" + start + " == 0) {\n         |  throw QueryExecutionErrors.unexpectedValueForStartInFunctionError(\"" + this.prettyName() + "\");\n         |} else if (" + start + " < 0) {\n         |  " + startIdx + " = " + start + " + " + x + ".numElements();\n         |} else {\n         |  // arrays in SQL are 1-based instead of 0-based\n         |  " + startIdx + " = " + start + " - 1;\n         |}\n         |if (" + length + " < 0) {\n         |  throw QueryExecutionErrors.unexpectedValueForLengthInFunctionError(\n         |    \"" + this.prettyName() + "\", " + length + ");\n         |} else if (" + length + " > " + x + ".numElements() - " + startIdx + ") {\n         |  " + resLength + " = " + x + ".numElements() - " + startIdx + ";\n         |} else {\n         |  " + resLength + " = " + length + ";\n         |}\n         |" + this.genCodeForResult(ctx, ev, (String)x, startIdx, resLength) + "\n       "));
        });
    }

    public String genCodeForResult(CodegenContext ctx, ExprCode ev, String inputArray, String startIdx, String resLength) {
        String values = ctx.freshName("values");
        String i = ctx.freshName("i");
        String genericArrayData = GenericArrayData.class.getName();
        String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), resLength, " " + this.prettyName() + " failed.");
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), inputArray, i, i + " + " + startIdx, this.resultArrayElementNullable());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |if (" + startIdx + " < 0 || " + startIdx + " >= " + inputArray + ".numElements()) {\n       |  " + ev.value() + " = new " + genericArrayData + "(new Object[0]);\n       |} else {\n       |  " + allocation + "\n       |  for (int " + i + " = 0; " + i + " < " + resLength + "; " + i + " ++) {\n       |    " + assignment + "\n       |  }\n       |  " + ev.value() + " = " + values + ";\n       |}\n     "));
    }

    @Override
    public Slice withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public Slice copy(Expression x, Expression start, Expression length) {
        return new Slice(x, start, length);
    }

    public Expression copy$default$1() {
        return this.x();
    }

    public Expression copy$default$2() {
        return this.start();
    }

    public Expression copy$default$3() {
        return this.length();
    }

    @Override
    public String productPrefix() {
        return "Slice";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.x();
            }
            case 1: {
                return this.start();
            }
            case 2: {
                return this.length();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Slice;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "x";
            }
            case 1: {
                return "start";
            }
            case 2: {
                return "length";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Slice)) return false;
        boolean bl = true;
        if (!bl) return false;
        Slice slice = (Slice)x$1;
        Expression expression = this.x();
        Expression expression2 = slice.x();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.start();
        Expression expression4 = slice.start();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.length();
        Expression expression6 = slice.length();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!slice.canEqual(this)) return false;
        return true;
    }

    public Slice(Expression x, Expression start, Expression length) {
        this.x = x;
        this.start = start;
        this.length = length;
        ExpectsInputTypes.$init$(this);
    }
}

