/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LPadExpressionBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="\n    _FUNC_(str, len[, pad]) - Returns `str`, left-padded with `pad` to a length of `len`.\n      If `str` is longer than `len`, the return value is shortened to `len` characters or bytes.\n      If `pad` is not specified, `str` will be padded to the left with space characters if it is\n      a character string, and with zeros if it is a byte sequence.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('hi', 5, '??');\n       ???hi\n      > SELECT _FUNC_('hi', 1, '??');\n       h\n      > SELECT _FUNC_('hi', 5);\n          hi\n      > SELECT hex(_FUNC_(unhex('aabb'), 5));\n       000000AABB\n      > SELECT hex(_FUNC_(unhex('aabb'), 5, unhex('1122')));\n       112211AABB\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005u:Q\u0001B\u0003\t\u0002I1Q\u0001F\u0003\t\u0002UAQaH\u0001\u0005\u0002\u0001BQ!I\u0001\u0005B\t\nQ\u0003\u0014)bI\u0016C\bO]3tg&|gNQ;jY\u0012,'O\u0003\u0002\u0007\u000f\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tA\u0011\"\u0001\u0005dCR\fG._:u\u0015\tQ1\"A\u0002tc2T!\u0001D\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001!\t\u0019\u0012!D\u0001\u0006\u0005Ua\u0005+\u00193FqB\u0014Xm]:j_:\u0014U/\u001b7eKJ\u001c2!\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u00111#H\u0005\u0003=\u0015\u0011\u0001\u0004U1e\u000bb\u0004(/Z:tS>t')^5mI\u0016\u0014()Y:f\u0003\u0019a\u0014N\\5u}Q\t!#A\bde\u0016\fG/Z*ue&tw\rU1e)\u0011\u0019c\u0005\u000b\u0016\u0011\u0005M!\u0013BA\u0013\u0006\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006O\r\u0001\raI\u0001\u0004gR\u0014\b\"B\u0015\u0004\u0001\u0004\u0019\u0013a\u00017f]\")1f\u0001a\u0001G\u0005\u0019\u0001/\u00193)\u0015\u0005i\u0003'M\u001a5m]J$\b\u0005\u0002\u0014]%\u0011q&\u0002\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\u0005\u0011\u0014A!2\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;sY\u0001bWM\\.-AA\fG-X\u0015![\u0001\u0012V\r^;s]N\u0004\u0003m\u001d;sA2\u0002C.\u001a4u[A\fG\rZ3eA]LG\u000f\u001b\u0011aa\u0006$\u0007\r\t;pA\u0005\u0004C.\u001a8hi\"\u0004sN\u001a\u0011aY\u0016t\u0007M\f\u0006!A\u0001\u0002\u0003\u0005I%gA\u0001\u001cHO\u001d1!SN\u0004Cn\u001c8hKJ\u0004C\u000f[1oA\u0001dWM\u001c1-AQDW\r\t:fiV\u0014h\u000e\t<bYV,\u0007%[:!g\"|'\u000f^3oK\u0012\u0004Co\u001c\u0011aY\u0016t\u0007\rI2iCJ\f7\r^3sg\u0002z'\u000f\t2zi\u0016\u001chF\u0003\u0011!A\u0001\u0002\u0003%\u00134!AB\fG\r\u0019\u0011jg\u0002rw\u000e\u001e\u0011ta\u0016\u001c\u0017NZ5fI2\u0002\u0003m\u001d;sA\u0002:\u0018\u000e\u001c7!E\u0016\u0004\u0003/\u00193eK\u0012\u0004Co\u001c\u0011uQ\u0016\u0004C.\u001a4uA]LG\u000f\u001b\u0011ta\u0006\u001cW\rI2iCJ\f7\r^3sg\u0002Jg\rI5uA%\u001c(\u0002\t\u0011!A\u0001\u0002\u0013\rI2iCJ\f7\r^3sAM$(/\u001b8hY\u0001\ng\u000e\u001a\u0011xSRD\u0007E_3s_N\u0004\u0013N\u001a\u0011ji\u0002J7\u000fI1!Ef$X\rI:fcV,gnY3/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0003U\n!q\f\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!Lw\u0005\f\u00116Y\u0001:shP\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001zth\u00105j\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0003.[\u0014-AEb\u0003eJ @O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001b\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!Lw\u0005\f\u00116SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011iS*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003\u0003.\u001a=)?\u001a+fjQ0)k:DW\r\u001f\u0015(C\u0006\u0014'mJ\u0015-AUJ\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00111aA\u0002\u0004\u0007M!B\u0005\nS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006\u0005[3yQ}3UKT\"`QUt\u0007.\u001a=)O\u0005\f'MY\u0014*Y\u0001*D\u0006I;oQ\u0016D\bfJ\u00192eI:\u0013&K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\n$GM\u00192\u0003\u0006\u0013%I\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\u0005A\u0014!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018%A\u001e\u0002\u0019M$(/\u001b8h?\u001a,hnY:)\u0015\u0001i\u0003'M\u001a5m]J$\b")
public final class LPadExpressionBuilder {
    public static Expression createStringPad(Expression str, Expression len, Expression pad) {
        return LPadExpressionBuilder$.MODULE$.createStringPad(str, len, pad);
    }

    public static Expression build(String funcName, Seq<Expression> expressions) {
        return LPadExpressionBuilder$.MODULE$.build(funcName, (Seq)expressions);
    }

    public static boolean supportsLambda() {
        return LPadExpressionBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return LPadExpressionBuilder$.MODULE$.rearrange(expectedSignature, providedArguments, functionName, resolver);
    }

    public static Option<FunctionSignature> functionSignature() {
        return LPadExpressionBuilder$.MODULE$.functionSignature();
    }
}

