/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.DivModLike;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.IntegralDivide$;
import org.apache.spark.sql.catalyst.expressions.NumericEvalContext;
import org.apache.spark.sql.catalyst.expressions.NumericEvalContext$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.types.PhysicalDecimalType$;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType$;
import org.apache.spark.sql.catalyst.types.PhysicalIntegralType$;
import org.apache.spark.sql.catalyst.types.PhysicalLongType$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$DecimalAsIfIntegral$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Divide `expr1` by `expr2`. It returns NULL if an operand is NULL or `expr2` is 0. The result is casted to long.", examples="\n    Examples:\n      > SELECT 3 _FUNC_ 2;\n       1\n      > SELECT INTERVAL '1-1' YEAR TO MONTH _FUNC_ INTERVAL '-1' MONTH;\n       -13\n  ", since="3.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015c\u0001B\u0015+\u0001^B\u0001\"\u0015\u0001\u0003\u0016\u0004%\tA\u0015\u0005\t-\u0002\u0011\t\u0012)A\u0005'\"Aq\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003T\u0011!I\u0006A!f\u0001\n\u0003Q\u0006\u0002\u00030\u0001\u0005#\u0005\u000b\u0011B.\t\u000b}\u0003A\u0011\u00011\t\u000b}\u0003A\u0011A3\t\u000b!\u0004A\u0011I5\t\u000b5\u0004A\u0011\t8\t\u000bU\u0004A\u0011\t<\t\u000bi\u0004A\u0011I>\t\r\u0005%\u0001\u0001\"\u0011|\u0011\u001d\tY\u0001\u0001C!\u0003\u001bAq!a\u0005\u0001\t\u0003\n)\u0002\u0003\u0004\u00024\u0001!\te\u001f\u0005\u000b\u0003k\u0001\u0001R1A\u0005\n\u0005]\u0002bBA#\u0001\u0011\u0005\u0013q\t\u0005\b\u0003\u001b\u0002A\u0011KA(\u0011%\tI\u0006AA\u0001\n\u0003\tY\u0006C\u0005\u0002d\u0001\t\n\u0011\"\u0001\u0002f!I\u00111\u0010\u0001\u0012\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003{\u0002\u0011\u0013!C\u0001\u0003\u007fB\u0011\"a!\u0001\u0003\u0003%\t%!\"\t\u0013\u0005U\u0005!!A\u0005\u0002\u0005]\u0005\"CAM\u0001\u0005\u0005I\u0011AAN\u0011%\t\t\u000bAA\u0001\n\u0003\n\u0019\u000bC\u0005\u00022\u0002\t\t\u0011\"\u0001\u00024\"I\u0011q\u0017\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0018\u0005\n\u0003{\u0003\u0011\u0011!C!\u0003\u007fCQ\"a1\u0001!\u0003\r\t\u0011!C\u0005m\u0006\u0015waBAtU!\u0005\u0011\u0011\u001e\u0004\u0007S)B\t!a;\t\r}\u000bC\u0011AA\u007f\u0011\u001d\ty0\tC\u0001\u0005\u0003A\u0011\"a@\"\u0003\u0003%\tIa\u0007\t\u0013\t\r\u0012%%A\u0005\u0002\u0005}\u0004\"\u0003B\u0013C\u0005\u0005I\u0011\u0011B\u0014\u0011%\u0011I$II\u0001\n\u0003\ty\bC\u0005\u0003<\u0005\n\t\u0011\"\u0003\u0003>\tq\u0011J\u001c;fOJ\fG\u000eR5wS\u0012,'BA\u0016-\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u00055r\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005=\u0002\u0014aA:rY*\u0011\u0011GM\u0001\u0006gB\f'o\u001b\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001ADhP#\u0011\u0005eRT\"\u0001\u0016\n\u0005mR#\u0001\u0005\"j]\u0006\u0014\u00180\u0011:ji\"lW\r^5d!\tIT(\u0003\u0002?U\tQA)\u001b<N_\u0012d\u0015n[3\u0011\u0005\u0001\u001bU\"A!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0003\u000fA\u0013x\u000eZ;diB\u0011aI\u0014\b\u0003\u000f2s!\u0001S&\u000e\u0003%S!A\u0013\u001c\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0015BA'B\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0014)\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u00055\u000b\u0015\u0001\u00027fMR,\u0012a\u0015\t\u0003sQK!!\u0016\u0016\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\fKZ\fGnQ8oi\u0016DH/F\u0001\\!\tID,\u0003\u0002^U\t\u0011b*^7fe&\u001cWI^1m\u0007>tG/\u001a=u\u00031)g/\u00197D_:$X\r\u001f;!\u0003\u0019a\u0014N\\5u}Q!\u0011MY2e!\tI\u0004\u0001C\u0003R\u000f\u0001\u00071\u000bC\u0003X\u000f\u0001\u00071\u000bC\u0004Z\u000fA\u0005\t\u0019A.\u0015\u0007\u00054w\rC\u0003R\u0011\u0001\u00071\u000bC\u0003X\u0011\u0001\u00071+A\ndQ\u0016\u001c7\u000eR5wS\u0012,wJ^3sM2|w/F\u0001k!\t\u00015.\u0003\u0002m\u0003\n9!i\\8mK\u0006t\u0017!C5oaV$H+\u001f9f+\u0005y\u0007C\u00019t\u001b\u0005\t(B\u0001:/\u0003\u0015!\u0018\u0010]3t\u0013\t!\u0018O\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001x!\t\u0001\b0\u0003\u0002zc\nAA)\u0019;b)f\u0004X-\u0001\u0004ts6\u0014w\u000e\\\u000b\u0002yB\u0019Q0a\u0001\u000f\u0005y|\bC\u0001%B\u0013\r\t\t!Q\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005\u0011)A\u0007eK\u000eLW.\u00197NKRDw\u000eZ\u0001\u0019I\u0016\u001c\u0017.\\1m)>$\u0015\r^1UsB,7i\u001c3f\u000f\u0016tGc\u0001?\u0002\u0010!1\u0011\u0011\u0003\bA\u0002q\fQ\u0002Z3dS6\fGNU3tk2$\u0018!\u0005:fgVdG\u000fR3dS6\fG\u000eV=qKRQ\u0011qCA\u000f\u0003O\tY#a\f\u0011\u0007A\fI\"C\u0002\u0002\u001cE\u00141\u0002R3dS6\fG\u000eV=qK\"9\u0011qD\bA\u0002\u0005\u0005\u0012A\u000192!\r\u0001\u00151E\u0005\u0004\u0003K\t%aA%oi\"9\u0011\u0011F\bA\u0002\u0005\u0005\u0012AA:2\u0011\u001d\tic\u0004a\u0001\u0003C\t!\u0001\u001d\u001a\t\u000f\u0005Er\u00021\u0001\u0002\"\u0005\u00111OM\u0001\fgFdw\n]3sCR|'/A\u0002eSZ,\"!!\u000f\u0011\u0013\u0001\u000bY$a\u0010\u0002@\u0005}\u0012bAA\u001f\u0003\nIa)\u001e8di&|gN\r\t\u0004\u0001\u0006\u0005\u0013bAA\"\u0003\n\u0019\u0011I\\=\u0002\u001b\u00154\u0018\r\\(qKJ\fG/[8o)\u0019\ty$!\u0013\u0002L!1\u0011K\u0005a\u0001\u0003\u007fAaa\u0016\nA\u0002\u0005}\u0012aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015\t\u0017\u0011KA+\u0011\u0019\t\u0019f\u0005a\u0001'\u00069a.Z<MK\u001a$\bBBA,'\u0001\u00071+\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000f\u0005\fi&a\u0018\u0002b!9\u0011\u000b\u0006I\u0001\u0002\u0004\u0019\u0006bB,\u0015!\u0003\u0005\ra\u0015\u0005\b3R\u0001\n\u00111\u0001\\\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u001a+\u0007M\u000bIg\u000b\u0002\u0002lA!\u0011QNA<\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014!C;oG\",7m[3e\u0015\r\t)(Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA=\u0003_\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0002*\u001a1,!\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\t\u0005\u0003\u0002\n\u0006MUBAAF\u0015\u0011\ti)a$\u0002\t1\fgn\u001a\u0006\u0003\u0003#\u000bAA[1wC&!\u0011QAAF\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t#\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u0012Q\u0014\u0005\n\u0003?S\u0012\u0011!a\u0001\u0003C\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAS!\u0019\t9+!,\u0002@5\u0011\u0011\u0011\u0016\u0006\u0004\u0003W\u000b\u0015AC2pY2,7\r^5p]&!\u0011qVAU\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007)\f)\fC\u0005\u0002 r\t\t\u00111\u0001\u0002@\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9)a/\t\u0013\u0005}U$!AA\u0002\u0005\u0005\u0012AB3rk\u0006d7\u000fF\u0002k\u0003\u0003D\u0011\"a(\u001f\u0003\u0003\u0005\r!a\u0010\u0002\u001dM,\b/\u001a:%I\u0006$\u0018\rV=qK&\u0011QO\u000f\u0015\u0014\u0001\u0005%\u0017qZAi\u0003+\f9.a7\u0002^\u0006\u0005\u00181\u001d\t\u0004s\u0005-\u0017bAAgU\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAj\u0003\u0005%Q\r\u001f9sc\u0001zf)\u0016(D?\u0002*\u0007\u0010\u001d:3A5\u0002C)\u001b<jI\u0016\u0004\u0003-\u001a=qeF\u0002\u0007EY=!A\u0016D\bO\u001d\u001aa]\u0001JE\u000f\t:fiV\u0014hn\u001d\u0011O+2c\u0005%\u001b4!C:\u0004s\u000e]3sC:$\u0007%[:!\u001dVcE\nI8sA\u0001,\u0007\u0010\u001d:3A\u0002J7\u000f\t\u0019/AQCW\r\t:fgVdG\u000fI5tA\r\f7\u000f^3eAQ|\u0007\u0005\\8oO:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u00033\f\u0011\u0011\u0003\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!g\u0001zf)\u0016(D?\u0002\u00124H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA%sE+\u0012*W\u00032\u0003s%M\u00172O\u0001JV)\u0011*!)>\u0003Sj\u0014(U\u0011\u0002zf)\u0016(D?\u0002Je\nV#S-\u0006c\u0005eJ\u00172O\u0001juJ\u0014+Iw)\u0001\u0003\u0005\t\u0011!A\u0001j\u0013g\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011q\\\u0001\u0006g9\u0002d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003K\f!\"\\1uQ~3WO\\2t\u00039Ie\u000e^3he\u0006dG)\u001b<jI\u0016\u0004\"!O\u0011\u0014\u000b\u0005\ni/a=\u0011\u0007\u0001\u000by/C\u0002\u0002r\u0006\u0013a!\u00118z%\u00164\u0007\u0003BA{\u0003wl!!a>\u000b\t\u0005e\u0018qR\u0001\u0003S>L1aTA|)\t\tI/A\u0003baBd\u0017\u0010F\u0004b\u0005\u0007\u0011)Aa\u0002\t\u000bE\u001b\u0003\u0019A*\t\u000b]\u001b\u0003\u0019A*\t\u000f\t%1\u00051\u0001\u0003\f\u0005AQM^1m\u001b>$W\r\u0005\u0003\u0003\u000e\tMabA\u001d\u0003\u0010%\u0019!\u0011\u0003\u0016\u0002\u0011\u00153\u0018\r\\'pI\u0016LAA!\u0006\u0003\u0018\t)a+\u00197vK&\u0019!\u0011D!\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u000b\bC\nu!q\u0004B\u0011\u0011\u0015\tF\u00051\u0001T\u0011\u00159F\u00051\u0001T\u0011\u001dIF\u0005%AA\u0002m\u000bq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IC!\u000e\u0011\u000b\u0001\u0013YCa\f\n\u0007\t5\u0012I\u0001\u0004PaRLwN\u001c\t\u0007\u0001\nE2kU.\n\u0007\tM\u0012I\u0001\u0004UkBdWm\r\u0005\t\u0005o1\u0013\u0011!a\u0001C\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011y\u0004\u0005\u0003\u0002\n\n\u0005\u0013\u0002\u0002B\"\u0003\u0017\u0013aa\u00142kK\u000e$\b")
public class IntegralDivide
extends BinaryArithmetic
implements DivModLike {
    private Function2<Object, Object, Object> div;
    private final Expression left;
    private final Expression right;
    private final NumericEvalContext evalContext;
    private Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    private volatile byte bitmap$0;

    public static NumericEvalContext $lessinit$greater$default$3() {
        return IntegralDivide$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, NumericEvalContext>> unapply(IntegralDivide x$0) {
        return IntegralDivide$.MODULE$.unapply(x$0);
    }

    public static NumericEvalContext apply$default$3() {
        return IntegralDivide$.MODULE$.apply$default$3();
    }

    @Override
    public /* synthetic */ DataType org$apache$spark$sql$catalyst$expressions$DivModLike$$super$dataType() {
        return super.dataType();
    }

    @Override
    public boolean nullable() {
        return DivModLike.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return DivModLike.eval$(this, input);
    }

    @Override
    public String divideByZeroErrorCode(CodegenContext ctx) {
        return DivModLike.divideByZeroErrorCode$(this, ctx);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return DivModLike.doGenCode$(this, ctx, ev);
    }

    private Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$lzycompute() {
        IntegralDivide integralDivide = this;
        synchronized (integralDivide) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero = DivModLike.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    }

    @Override
    public Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    }

    private /* synthetic */ DataType super$dataType() {
        return super.dataType();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public NumericEvalContext evalContext() {
        return this.evalContext;
    }

    @Override
    public boolean checkDivideOverflow() {
        DataType dataType = this.left().dataType();
        return LongType$.MODULE$.equals(dataType) && this.failOnError();
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{LongType$.MODULE$, DecimalType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public String symbol() {
        return "/";
    }

    @Override
    public String decimalMethod() {
        return "quot";
    }

    @Override
    public String decimalToDataTypeCodeGen(String decimalResult) {
        return decimalResult + ".toLong()";
    }

    @Override
    public DecimalType resultDecimalType(int p1, int s1, int p2, int s2) {
        int intDig = p1 - s1 + s2;
        return DecimalType$.MODULE$.bounded(intDig == 0 ? 1 : intDig, 0);
    }

    @Override
    public String sqlOperator() {
        return "div";
    }

    private Function2<Object, Object, Object> div$lzycompute() {
        IntegralDivide integralDivide = this;
        synchronized (integralDivide) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                DecimalType decimalType;
                Option option;
                Decimal$DecimalAsIfIntegral$ decimal$DecimalAsIfIntegral$;
                DataType dataType = this.left().dataType();
                if (dataType instanceof IntegralType) {
                    IntegralType integralType = (IntegralType)dataType;
                    decimal$DecimalAsIfIntegral$ = PhysicalIntegralType$.MODULE$.integral(integralType);
                } else if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int p = ((Tuple2)option.get())._1$mcI$sp();
                    int s = ((Tuple2)option.get())._2$mcI$sp();
                    decimal$DecimalAsIfIntegral$ = PhysicalDecimalType$.MODULE$.apply(p, s).asIntegral();
                } else if (dataType instanceof YearMonthIntervalType) {
                    decimal$DecimalAsIfIntegral$ = PhysicalIntegerType$.MODULE$.integral();
                } else if (dataType instanceof DayTimeIntervalType) {
                    decimal$DecimalAsIfIntegral$ = PhysicalLongType$.MODULE$.integral();
                } else {
                    throw new MatchError((Object)dataType);
                }
                Decimal$DecimalAsIfIntegral$ integral = decimal$DecimalAsIfIntegral$;
                this.div = (Function2 & Serializable)(x, y) -> {
                    Object res;
                    DecimalType decimalType;
                    Option option;
                    DataType dataType = this.super$dataType();
                    if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                        int precision = ((Tuple2)option.get())._1$mcI$sp();
                        int scale = ((Tuple2)option.get())._2$mcI$sp();
                        v0 = this.checkDecimalOverflow((Decimal)integral.quot(x, y), precision, scale);
                    } else {
                        v0 = res = integral.quot(x, y);
                    }
                    if (res == null) {
                        return null;
                    }
                    return BoxesRunTime.boxToLong((long)integral.toLong(res));
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.div;
    }

    private Function2<Object, Object, Object> div() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.div$lzycompute();
        }
        return this.div;
    }

    @Override
    public Object evalOperation(Object left, Object right) {
        return this.div().apply(left, right);
    }

    @Override
    public IntegralDivide withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public IntegralDivide copy(Expression left, Expression right, NumericEvalContext evalContext) {
        return new IntegralDivide(left, right, evalContext);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public NumericEvalContext copy$default$3() {
        return this.evalContext();
    }

    @Override
    public String productPrefix() {
        return "IntegralDivide";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.evalContext();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IntegralDivide;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "evalContext";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IntegralDivide)) return false;
        boolean bl = true;
        if (!bl) return false;
        IntegralDivide integralDivide = (IntegralDivide)x$1;
        Expression expression = this.left();
        Expression expression2 = integralDivide.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = integralDivide.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        NumericEvalContext numericEvalContext = this.evalContext();
        NumericEvalContext numericEvalContext2 = integralDivide.evalContext();
        if (numericEvalContext == null) {
            if (numericEvalContext2 != null) {
                return false;
            }
        } else if (!((Object)numericEvalContext).equals(numericEvalContext2)) return false;
        if (!integralDivide.canEqual(this)) return false;
        return true;
    }

    public IntegralDivide(Expression left, Expression right, NumericEvalContext evalContext) {
        this.left = left;
        this.right = right;
        this.evalContext = evalContext;
        DivModLike.$init$(this);
    }

    public IntegralDivide(Expression left, Expression right) {
        this(left, right, NumericEvalContext$.MODULE$.fromSQLConf(SQLConf$.MODULE$.get()));
    }
}

