/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Window;
import org.apache.sis.gui.Widget;
import org.apache.sis.gui.internal.DataStoreOpener;
import org.apache.sis.gui.internal.GUIUtilities;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.base.StoreResource;
import org.apache.sis.util.Classes;

public final class ExceptionReporter
extends Widget {
    private static final Insets MARGIN = new Insets(9.0, 3.0, 3.0, 9.0);
    private static final Insets PADDING = new Insets(9.0, 3.0, 1.0, 3.0);
    private static Alert currentlyShown;
    private Throwable exception;
    private final VBox view;
    private final Text trace;

    public ExceptionReporter(Throwable exception) {
        this.exception = exception;
        this.trace = new Text(ExceptionReporter.getStackTrace(exception));
        ScrollPane pane = new ScrollPane((Node)this.trace);
        pane.setFitToWidth(true);
        pane.setFitToHeight(true);
        pane.setPadding(MARGIN);
        Resources localized = Resources.getInstance();
        Menu sendTo = new Menu(localized.getString((short)31));
        sendTo.getItems().add((Object)localized.menu((short)32, (EventHandler<ActionEvent>)((EventHandler)this::printStackTrace)));
        ContextMenu menu = new ContextMenu(new MenuItem[]{localized.menu((short)11, (EventHandler<ActionEvent>)((EventHandler)this::copy)), sendTo});
        pane.setContextMenu(menu);
        Label header = new Label(localized.getString((short)53));
        this.view = new VBox(new Node[]{header, pane});
        VBox.setVgrow((Node)pane, (Priority)Priority.ALWAYS);
        VBox.setMargin((Node)pane, (Insets)PADDING);
        VBox.setMargin((Node)header, (Insets)PADDING);
        this.view.setPrefHeight(400.0);
    }

    public void setException(Throwable exception) {
        this.trace.setText(ExceptionReporter.getStackTrace(exception));
        this.exception = exception;
    }

    public static String getStackTrace(Throwable exception) {
        StringWriter buffer = new StringWriter();
        exception.printStackTrace(new PrintWriter(buffer));
        return buffer.toString();
    }

    @Override
    public final Region getView() {
        return this.view;
    }

    public static void show(Node owner, WorkerStateEvent event) {
        Worker worker = event.getSource();
        Throwable exception = worker.getException();
        if (worker instanceof DataStoreOpener) {
            ExceptionReporter.canNotReadFile(owner, ((DataStoreOpener)worker).getFileName(), exception);
        } else {
            ExceptionReporter.show(GUIUtilities.getWindow(owner), (short)0, (short)0, null, exception);
        }
    }

    public static void canNotReadFile(Node owner, Resource resource, Throwable exception) {
        DataStore ds;
        String name = null;
        if (resource instanceof StoreResource && (ds = ((StoreResource)resource).getOriginator()) != null) {
            name = ds.getDisplayName();
        }
        if (name == null && resource instanceof DataStore) {
            name = ((DataStore)resource).getDisplayName();
        }
        if (name == null) {
            ExceptionReporter.canNotUseResource(owner, exception);
            return;
        }
        ExceptionReporter.canNotReadFile(owner, name, exception);
    }

    public static void canNotReadFile(Node owner, String file, Throwable exception) {
        ExceptionReporter.show(GUIUtilities.getWindow(owner), (short)19, (short)6, new Object[]{file}, exception);
    }

    public static void canNotCloseFile(Node owner, String file, Throwable exception) {
        ExceptionReporter.show(GUIUtilities.getWindow(owner), (short)14, (short)2, new Object[]{file}, exception);
    }

    public static void canNotCreateCRS(Window owner, String code, Throwable exception) {
        ExceptionReporter.show(owner, (short)15, (short)3, new Object[]{code}, exception);
    }

    public static void canNotUseResource(Node owner, Throwable exception) {
        ExceptionReporter.show(GUIUtilities.getWindow(owner), (short)16, (short)16, new Object[0], exception);
    }

    private static void show(Window owner, short title, short text, Object[] arguments, Throwable exception) {
        if (exception != null) {
            String t = null;
            String h = null;
            if ((title | text) != 0) {
                Resources resources = Resources.getInstance();
                if (title != 0) {
                    t = resources.getString(title);
                }
                if (text != 0) {
                    h = resources.getString(text, arguments);
                }
            }
            ExceptionReporter.show(owner, t, h, exception);
        }
    }

    public static void show(Node owner, String title, String text, Throwable exception) {
        ExceptionReporter.show(GUIUtilities.getWindow(owner), title, text, exception);
    }

    public static void show(Window owner, String title, String text, Throwable exception) {
        Alert alert;
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> ExceptionReporter.show(owner, title, text, exception));
            return;
        }
        String message = null;
        for (Throwable e = exception; e != null && ((message = e.getLocalizedMessage()) == null || message.equalsIgnoreCase(text)); e = e.getCause()) {
        }
        if (message == null) {
            message = Classes.getShortClassName((Object)exception);
        }
        if ((alert = currentlyShown) == null) {
            alert = new Alert(Alert.AlertType.ERROR);
            alert.initOwner(owner);
            alert.setOnHidden(event -> {
                currentlyShown = null;
            });
            ExceptionReporter content = new ExceptionReporter(exception);
            DialogPane pane = alert.getDialogPane();
            pane.setExpandableContent((Node)content.getView());
            pane.setPrefWidth(650.0);
            pane.setUserData((Object)content);
        } else {
            ExceptionReporter content = (ExceptionReporter)alert.getDialogPane().getUserData();
            content.setException(exception);
        }
        if (title != null) {
            alert.setTitle(title);
        }
        if (text != null) {
            alert.setHeaderText(text);
        }
        alert.setContentText(message);
        alert.show();
        currentlyShown = alert;
    }

    public static void show(Node owner, Task<?> task) {
        ExceptionReporter.show(owner, task.getTitle(), null, task.getException());
    }

    private void copy(ActionEvent event) {
        ClipboardContent content = new ClipboardContent();
        content.putString(this.trace.getText());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private void printStackTrace(ActionEvent event) {
        this.exception.printStackTrace();
    }
}

