/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.internal.Dependencies;
import org.apache.sis.metadata.iso.legacy.DateToTemporal;
import org.apache.sis.metadata.iso.legacy.TemporalToDate;
import org.apache.sis.metadata.iso.quality.AbstractCompleteness;
import org.apache.sis.metadata.iso.quality.AbstractLogicalConsistency;
import org.apache.sis.metadata.iso.quality.AbstractMetaquality;
import org.apache.sis.metadata.iso.quality.AbstractPositionalAccuracy;
import org.apache.sis.metadata.iso.quality.AbstractTemporalQuality;
import org.apache.sis.metadata.iso.quality.AbstractThematicAccuracy;
import org.apache.sis.metadata.iso.quality.DefaultEvaluationMethod;
import org.apache.sis.metadata.iso.quality.DefaultMeasureReference;
import org.apache.sis.metadata.iso.quality.DefaultQualityMeasure;
import org.apache.sis.metadata.iso.quality.DefaultUsability;
import org.apache.sis.metadata.iso.quality.ISOMetadata;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.gco.InternationalStringAdapter;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.Completeness;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.LogicalConsistency;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.Result;
import org.opengis.metadata.quality.TemporalAccuracy;
import org.opengis.metadata.quality.ThematicAccuracy;
import org.opengis.metadata.quality.Usability;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractDQ_Element_Type", propOrder={"standaloneQualityReportDetails", "measureReference", "evaluationMethod", "namesOfMeasure", "measureIdentification", "measureDescription", "evaluationMethodType", "evaluationMethodDescription", "evaluationProcedure", "dates", "results", "derivedElement"})
@XmlRootElement(name="AbstractDQ_Element")
@XmlSeeAlso(value={AbstractCompleteness.class, AbstractLogicalConsistency.class, AbstractPositionalAccuracy.class, AbstractThematicAccuracy.class, AbstractTemporalQuality.class, DefaultUsability.class, AbstractMetaquality.class, DefaultQualityMeasure.class})
public class AbstractElement
extends ISOMetadata
implements Element {
    private static final long serialVersionUID = -406229448295586970L;
    private InternationalString standaloneQualityReportDetails;
    private DefaultMeasureReference measureReference;
    private DefaultEvaluationMethod evaluationMethod;
    private Collection<Result> results;
    private Collection<Element> derivedElements;

    public AbstractElement() {
    }

    public AbstractElement(Result result) {
        this.results = AbstractElement.singleton(result, Result.class);
    }

    public AbstractElement(Element object) {
        super(object);
        if (object != null) {
            if (object instanceof AbstractElement) {
                DefaultMeasureReference candidate;
                AbstractElement impl = (AbstractElement)object;
                this.standaloneQualityReportDetails = impl.getStandaloneQualityReportDetails();
                this.evaluationMethod = impl.getEvaluationMethod();
                this.derivedElements = AbstractElement.copyCollection(impl.getDerivedElements(), Element.class);
                this.measureReference = impl.getMeasureReference();
                if (this.measureReference == null && (candidate = new DefaultMeasureReference()).setLegacy(object)) {
                    this.measureReference = candidate;
                }
            }
            this.results = AbstractElement.copyCollection(object.getResults(), Result.class);
        }
    }

    public static AbstractElement castOrCopy(Element object) {
        if (object instanceof PositionalAccuracy) {
            return AbstractPositionalAccuracy.castOrCopy((PositionalAccuracy)object);
        }
        if (object instanceof TemporalAccuracy) {
            return AbstractTemporalQuality.castOrCopy((TemporalAccuracy)object);
        }
        if (object instanceof ThematicAccuracy) {
            return AbstractThematicAccuracy.castOrCopy((ThematicAccuracy)object);
        }
        if (object instanceof LogicalConsistency) {
            return AbstractLogicalConsistency.castOrCopy((LogicalConsistency)object);
        }
        if (object instanceof Completeness) {
            return AbstractCompleteness.castOrCopy((Completeness)object);
        }
        if (object instanceof Usability) {
            return DefaultUsability.castOrCopy((Usability)object);
        }
        if (object == null || object instanceof AbstractElement) {
            return (AbstractElement)object;
        }
        return new AbstractElement(object);
    }

    @XmlElement(name="standaloneQualityReportDetails")
    @XmlJavaTypeAdapter(value=InternationalStringAdapter.Since2014.class)
    @UML(identifier="standaloneQualityReportDetails", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public InternationalString getStandaloneQualityReportDetails() {
        return this.standaloneQualityReportDetails;
    }

    public void setStandaloneQualityReportDetails(InternationalString newValue) {
        this.checkWritePermission(this.standaloneQualityReportDetails);
        this.standaloneQualityReportDetails = newValue;
    }

    @XmlElement(name="measure", required=false)
    @UML(identifier="measure", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public DefaultMeasureReference getMeasureReference() {
        return this.measureReference;
    }

    public void setMeasureReference(DefaultMeasureReference newValues) {
        this.checkWritePermission(this.measureReference);
        this.measureReference = newValues;
    }

    private <V> V getMeasureReferenceProperty(Function<DefaultMeasureReference, V> getter) {
        DefaultMeasureReference m = this.getMeasureReference();
        return m != null && FilterByVersion.LEGACY_METADATA.accept() ? (V)getter.apply(m) : null;
    }

    private <V> void setMeasureReferenceProperty(BiConsumer<DefaultMeasureReference, V> setter, V newValue) {
        if (newValue != null) {
            if (this.measureReference == null) {
                this.measureReference = new DefaultMeasureReference();
            }
            setter.accept(this.measureReference, newValue);
        }
    }

    @Deprecated(since="1.3")
    @Dependencies(value={"getMeasureReference"})
    @XmlElement(name="nameOfMeasure", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<InternationalString> getNamesOfMeasure() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        DefaultMeasureReference m = this.getMeasureReference();
        if (m == null) {
            if (this.state() == ModifiableMetadata.State.FINAL) {
                return Collections.emptyList();
            }
            m = new DefaultMeasureReference();
            this.setMeasureReference(m);
        }
        return m.getNamesOfMeasure();
    }

    @Deprecated(since="1.3")
    public void setNamesOfMeasure(Collection<? extends InternationalString> newValues) {
        if (!Containers.isNullOrEmpty(newValues)) {
            this.setMeasureReferenceProperty(DefaultMeasureReference::setNamesOfMeasure, newValues);
        }
    }

    @Deprecated(since="1.3")
    @Dependencies(value={"getMeasureReference"})
    @XmlElement(name="measureIdentification", namespace="http://www.isotc211.org/2005/gmd")
    public Identifier getMeasureIdentification() {
        return this.getMeasureReferenceProperty(DefaultMeasureReference::getMeasureIdentification);
    }

    @Deprecated(since="1.3")
    public void setMeasureIdentification(Identifier newValue) {
        this.setMeasureReferenceProperty(DefaultMeasureReference::setMeasureIdentification, newValue);
    }

    @Deprecated(since="1.3")
    @Dependencies(value={"getMeasureReference"})
    @XmlElement(name="measureDescription", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getMeasureDescription() {
        return this.getMeasureReferenceProperty(DefaultMeasureReference::getMeasureDescription);
    }

    @Deprecated(since="1.3")
    public void setMeasureDescription(InternationalString newValue) {
        this.setMeasureReferenceProperty(DefaultMeasureReference::setMeasureDescription, newValue);
    }

    @XmlElement(name="evaluationMethod", required=false)
    @UML(identifier="evaluationMethod", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public DefaultEvaluationMethod getEvaluationMethod() {
        return this.evaluationMethod;
    }

    public void setEvaluationMethod(DefaultEvaluationMethod newValue) {
        this.checkWritePermission(this.evaluationMethod);
        this.evaluationMethod = newValue;
    }

    private <V> V getEvaluationMethodProperty(Function<DefaultEvaluationMethod, V> getter) {
        DefaultEvaluationMethod m = this.getEvaluationMethod();
        return m != null && FilterByVersion.LEGACY_METADATA.accept() ? (V)getter.apply(m) : null;
    }

    private <V> void setEvaluationMethodProperty(BiConsumer<DefaultEvaluationMethod, V> setter, V newValue) {
        if (newValue != null) {
            if (this.evaluationMethod == null) {
                this.evaluationMethod = new DefaultEvaluationMethod();
            }
            setter.accept(this.evaluationMethod, newValue);
        }
    }

    @Deprecated(since="1.3")
    @Dependencies(value={"getEvaluationMethod"})
    @XmlElement(name="evaluationMethodType", namespace="http://www.isotc211.org/2005/gmd")
    public EvaluationMethodType getEvaluationMethodType() {
        return this.getEvaluationMethodProperty(DefaultEvaluationMethod::getEvaluationMethodType);
    }

    @Deprecated(since="1.3")
    public void setEvaluationMethodType(EvaluationMethodType newValue) {
        this.setEvaluationMethodProperty(DefaultEvaluationMethod::setEvaluationMethodType, newValue);
    }

    @Deprecated(since="1.3")
    @Dependencies(value={"getEvaluationMethod"})
    @XmlElement(name="evaluationMethodDescription", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getEvaluationMethodDescription() {
        return this.getEvaluationMethodProperty(DefaultEvaluationMethod::getEvaluationMethodDescription);
    }

    @Deprecated(since="1.3")
    public void setEvaluationMethodDescription(InternationalString newValue) {
        this.setEvaluationMethodProperty(DefaultEvaluationMethod::setEvaluationMethodDescription, newValue);
    }

    @Deprecated(since="1.3")
    @Dependencies(value={"getEvaluationMethod"})
    @XmlElement(name="evaluationProcedure", namespace="http://www.isotc211.org/2005/gmd")
    public Citation getEvaluationProcedure() {
        return this.getEvaluationMethodProperty(DefaultEvaluationMethod::getEvaluationProcedure);
    }

    @Deprecated(since="1.3")
    public void setEvaluationProcedure(Citation newValue) {
        this.setEvaluationMethodProperty(DefaultEvaluationMethod::setEvaluationProcedure, newValue);
    }

    @Deprecated(since="1.3")
    @Dependencies(value={"getEvaluationMethod"})
    @XmlElement(name="dateTime", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<Date> getDates() {
        if (FilterByVersion.LEGACY_METADATA.accept()) {
            Collection<Temporal> dates;
            DefaultEvaluationMethod m = this.getEvaluationMethod();
            if (m == null) {
                if (this.state() == ModifiableMetadata.State.FINAL) {
                    return Collections.emptyList();
                }
                m = new DefaultEvaluationMethod();
                this.setEvaluationMethod(m);
            }
            if ((dates = m.getDates()) != null) {
                return new TemporalToDate(dates);
            }
        }
        return null;
    }

    @Deprecated(since="1.3")
    public void setDates(Collection<? extends Date> newValues) {
        if (!Containers.isNullOrEmpty(newValues)) {
            this.setEvaluationMethodProperty(DefaultEvaluationMethod::setDates, new DateToTemporal(newValues));
        }
    }

    @XmlElement(name="result", required=true)
    public Collection<Result> getResults() {
        this.results = this.nonNullCollection(this.results, Result.class);
        return this.results;
    }

    public void setResults(Collection<? extends Result> newValues) {
        this.results = this.writeCollection(newValues, this.results, Result.class);
    }

    @UML(identifier="derivedElement", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public Collection<Element> getDerivedElements() {
        this.derivedElements = this.nonNullCollection(this.derivedElements, Element.class);
        return this.derivedElements;
    }

    public void setDerivedElements(Collection<? extends Element> newValues) {
        this.derivedElements = this.writeCollection(newValues, this.derivedElements, Element.class);
    }

    @XmlElement(name="derivedElement")
    private Collection<Element> getDerivedElement() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getDerivedElements() : null;
    }
}

