/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.spring.boot.tracing;

import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.apache.shardingsphere.elasticjob.kernel.tracing.config.TracingConfiguration;
import org.apache.shardingsphere.elasticjob.spring.boot.tracing.TracingProperties;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={TracingProperties.class})
public class ElasticJobTracingConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(name={"elasticjob.tracing.type"}, havingValue="RDB")
    static class RDBTracingConfiguration {
        RDBTracingConfiguration() {
        }

        @Bean(value={"tracingDataSource"})
        public DataSource tracingDataSource(TracingProperties tracingProperties) {
            DataSourceProperties dataSource = tracingProperties.getDataSource();
            if (dataSource == null) {
                return null;
            }
            HikariDataSource tracingDataSource = new HikariDataSource();
            tracingDataSource.setJdbcUrl(dataSource.getUrl());
            BeanUtils.copyProperties((Object)dataSource, (Object)tracingDataSource);
            return tracingDataSource;
        }

        @Bean
        public TracingConfiguration<DataSource> tracingConfiguration(@Qualifier(value="dataSource") @Nullable DataSource dataSource, @Qualifier(value="tracingDataSource") @Nullable DataSource tracingDataSource) {
            if (dataSource == null && tracingDataSource == null) {
                throw new IllegalArgumentException("Neither dataSource nor tracingDataSource bean is required");
            }
            return new TracingConfiguration("RDB", (Object)(null == tracingDataSource ? dataSource : tracingDataSource));
        }
    }
}

