/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client;

import java.util.Map;
import org.apache.qpid.protonj2.client.impl.ClientDeliveryState;

public interface DeliveryState {
    public Type getType();

    default public boolean isAccepted() {
        return this.getType() == Type.ACCEPTED;
    }

    default public boolean isRejected() {
        return this.getType() == Type.REJECTED;
    }

    default public boolean isModified() {
        return this.getType() == Type.MODIFIED;
    }

    default public boolean isReleased() {
        return this.getType() == Type.RELEASED;
    }

    default public boolean isTransactional() {
        return this.getType() == Type.TRANSACTIONAL;
    }

    public static DeliveryState accepted() {
        return ClientDeliveryState.ClientAccepted.getInstance();
    }

    public static DeliveryState released() {
        return ClientDeliveryState.ClientReleased.getInstance();
    }

    public static DeliveryState rejected(String condition, String description) {
        return new ClientDeliveryState.ClientRejected(condition, description);
    }

    public static DeliveryState rejected(String condition, String description, Map<String, Object> info) {
        return new ClientDeliveryState.ClientRejected(condition, description, info);
    }

    public static DeliveryState modified(boolean failed, boolean undeliverable) {
        return new ClientDeliveryState.ClientModified(failed, undeliverable);
    }

    public static DeliveryState modified(boolean failed, boolean undeliverable, Map<String, Object> annotations) {
        return new ClientDeliveryState.ClientModified(failed, undeliverable, annotations);
    }

    public static enum Type {
        ACCEPTED,
        REJECTED,
        MODIFIED,
        RELEASED,
        TRANSACTIONAL;

    }
}

