/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageSize;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.freon.ContentGenerator;
import org.apache.hadoop.ozone.freon.FreonReplicationOptions;
import org.apache.hadoop.ozone.freon.StorageSizeConverter;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="ommg", aliases={"om-metadata-generator"}, description={"Create metadata operation to the OM."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class OmMetadataGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    @CommandLine.Option(names={"-v", "--volume"}, description={"Name of the volume which contains the test data. Will be created if missing."}, defaultValue="vol1")
    private String volumeName;
    @CommandLine.Option(names={"-b", "--bucket"}, description={"Name of the bucket which contains the test data. Will be created if missing."}, defaultValue="bucket1")
    private String bucketName;
    @CommandLine.Option(names={"-s", "--size"}, description={"The size in byte of a file for the Create File/Key op. You can specify the size using data units like 'GB', 'MB', 'KB', etc. Size is in base 2 binary."}, defaultValue="0", converter={StorageSizeConverter.class})
    private StorageSize dataSize;
    @CommandLine.Option(names={"--buffer"}, description={"Size of buffer used to generated the key content."}, defaultValue="4096")
    private int bufferSize;
    @CommandLine.Option(names={"--batch-size"}, description={"The number of key/file requests per LIST_KEY/LIST_STATUS request."}, defaultValue="1000")
    private int batchSize;
    @CommandLine.Option(names={"--random"}, description={"random read/write if given. This means that it is possible to read/write the same file at the same time"}, defaultValue="false")
    private boolean randomOp;
    @CommandLine.Option(names={"-o", "--operation"}, description={"The operation to perform, --ophelp Print detail"})
    private Operation operation;
    @CommandLine.Option(names={"--ops"}, description={"The operations list to perform, --ophelp Print detail"})
    private String operationsList;
    @CommandLine.Option(names={"--opsnum"}, description={"The number of threads per operations, the values sum must equal the number of threads, --ophelp Print detail"})
    private String operationsNum;
    @CommandLine.Option(names={"--ophelp"}, description={"Print operation help, or list available operation"})
    private boolean opHelp;
    @CommandLine.Option(names={"--om-service-id"}, description={"OM Service ID"})
    private String omServiceID;
    @CommandLine.Mixin
    private FreonReplicationOptions replication;
    private OzoneManagerProtocol ozoneManagerClient;
    private ThreadLocal<OmKeyArgs.Builder> omKeyArgsBuilder;
    private OzoneBucket bucket;
    private ContentGenerator contentGenerator;
    private final byte[] readBuffer = new byte[4096];
    private ReplicationConfig replicationConfig;
    private Operation[] operations;
    private boolean mixedOperation = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        if (this.opHelp || this.operation == null) {
            System.out.println(OmMetadataGenerator.getUsage());
            return null;
        }
        if (this.operation.equals((Object)Operation.MIXED)) {
            this.initMixedOperation();
            this.mixedOperation = true;
        }
        this.init();
        this.contentGenerator = new ContentGenerator(this.dataSize.toBytes(), this.bufferSize);
        this.omKeyArgsBuilder = ThreadLocal.withInitial(this::createKeyArgsBuilder);
        OzoneConfiguration conf = this.createOzoneConfiguration();
        this.replicationConfig = this.replication.fromParamsOrConfig((ConfigurationSource)conf);
        try (OzoneClient rpcClient = this.createOzoneClient(this.omServiceID, conf);){
            this.ensureVolumeAndBucketExist(rpcClient, this.volumeName, this.bucketName);
            this.ozoneManagerClient = this.createOmClient(conf, this.omServiceID);
            this.bucket = rpcClient.getObjectStore().getVolume(this.volumeName).getBucket(this.bucketName);
            this.runTests(this::applyOperation);
        }
        finally {
            if (this.ozoneManagerClient != null) {
                this.ozoneManagerClient.close();
                this.omKeyArgsBuilder.remove();
            }
        }
        return null;
    }

    private void initMixedOperation() {
        if (this.operationsList == null || this.operationsNum == null) {
            throw new IllegalArgumentException("--ops and --opsnum must be given, if --operation is MIXED");
        }
        List ops = Arrays.stream(this.operationsList.split(",")).map(Operation::valueOf).collect(Collectors.toList());
        List opsNum = Arrays.stream(this.operationsNum.split(",")).map(Integer::valueOf).collect(Collectors.toList());
        if (ops.size() != opsNum.size() || opsNum.stream().mapToInt(x -> x).sum() != this.getThreadNo()) {
            throw new IllegalArgumentException("the --opsnum values sum must equal the number of threads");
        }
        int index = 0;
        this.operations = new Operation[this.getThreadNo()];
        for (int i = 0; i < ops.size(); ++i) {
            Operation op = (Operation)((Object)ops.get(i));
            int num = (Integer)opsNum.get(i);
            for (int j = 0; j < num; ++j) {
                this.operations[index] = op;
                ++index;
            }
        }
    }

    public static String getUsage() {
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"A tool to measure the Ozone om performance", (Object)"support Operation: ", (Object)("  " + EnumSet.allOf(Operation.class).stream().map(Enum::toString).collect(Collectors.joining(", "))), (Object)"\nExample: ", (Object)"# create 25000 keys, run time 180s", (Object)"$ bin/ozone freon ommg --operation CREATE_KEY -n 25000 --duration  180s\n", (Object)"# read 25000 keys, run time 180s", (Object)"$ bin/ozone freon ommg --operation READ_KEY -n 25000 --duration 180s\n", (Object)"# 20 threads, list 1000 keys each request, and run time 180s", (Object)"$ bin/ozone freon ommg --operation LIST_KEYS -t 20 --batch-size 1000 --duration 180s\n", (Object)"# 10 threads, 1 threads list keys, 5 threads create file, 4 threads lookup file and run time 180s", (Object)"$ bin/ozone freon ommg --operation MIXED --ops CREATE_FILE,LOOKUP_FILE,LIST_STATUS --opsnum 5,4,1 -t 10 -n 1000 --duration 180s\n", (Object[])new String[]{"Note that: You must create a sufficient number of objects before executing read-related tests\n"}));
    }

    private OmKeyArgs.Builder createKeyArgsBuilder() {
        UserGroupInformation ugi = null;
        try {
            ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new OmKeyArgs.Builder().setBucketName(this.bucketName).setVolumeName(this.volumeName).setReplicationConfig(this.replicationConfig).setLocationInfoList(new ArrayList()).setAcls(OzoneAclUtil.getAclList((UserGroupInformation)ugi, (IAccessAuthorizer.ACLType)IAccessAuthorizer.ACLType.ALL, (IAccessAuthorizer.ACLType)IAccessAuthorizer.ACLType.ALL));
    }

    private String getPath(long counter) {
        return StringUtils.leftPad((String)String.valueOf(counter), (int)19, (char)'0');
    }

    @Override
    public Supplier<String> realTimeStatusSupplier() {
        HashMap maxValueRecorder = new HashMap();
        HashMap valueRecorder = new HashMap();
        HashMap instantsRecorder = new HashMap();
        return () -> {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : this.getMetrics().getTimers(MetricFilter.ALL).entrySet()) {
                String name = (String)entry.getKey();
                long maxValue = maxValueRecorder.getOrDefault(name, -1L);
                long preValue = valueRecorder.getOrDefault(name, 0L);
                Instant preInstant = instantsRecorder.getOrDefault(name, Instant.now());
                long curValue = ((Timer)entry.getValue()).getCount();
                Instant now = Instant.now();
                long duration = Duration.between(preInstant, now).getSeconds();
                long rate = (curValue - preValue) / (duration == 0L ? 1L : duration);
                maxValue = Math.max(rate, maxValue);
                maxValueRecorder.put(name, maxValue);
                valueRecorder.put(name, curValue);
                instantsRecorder.put(name, now);
                sb.append(' ').append(name).append(": rate ").append(rate).append(" max ").append(maxValue);
            }
            sb.append("  ");
            return sb.toString();
        };
    }

    private void applyOperation(long counter) throws Exception {
        long threadSeqId = this.getThreadSequenceId();
        if (this.mixedOperation) {
            this.operation = this.operations[(int)threadSeqId];
        }
        if (this.randomOp) {
            counter = ThreadLocalRandom.current().nextLong(this.getTestNo());
        }
        String keyName = this.getPath(counter);
        switch (this.operation.ordinal()) {
            case 6: {
                this.getMetrics().timer(this.operation.name()).time(() -> this.performWriteOperation(() -> this.bucket.createKey(keyName, this.dataSize.toBytes(), this.replicationConfig, Collections.emptyMap()), this.contentGenerator));
                break;
            }
            case 7: {
                this.getMetrics().timer(this.operation.name()).time(() -> this.performWriteOperation(() -> this.bucket.createStreamKey(keyName, this.dataSize.toBytes(), this.replicationConfig, Collections.emptyMap()), this.contentGenerator));
                break;
            }
            case 8: {
                OmKeyArgs keyArgs = this.omKeyArgsBuilder.get().setKeyName(keyName).build();
                this.getMetrics().timer(this.operation.name()).time(() -> this.ozoneManagerClient.lookupKey(keyArgs));
                break;
            }
            case 9: {
                OmKeyArgs keyArgs = this.omKeyArgsBuilder.get().setKeyName(keyName).build();
                this.getMetrics().timer(this.operation.name()).time(() -> this.ozoneManagerClient.getKeyInfo(keyArgs, false));
                break;
            }
            case 10: {
                OmKeyArgs keyArgs = this.omKeyArgsBuilder.get().setKeyName(keyName).setHeadOp(true).build();
                this.getMetrics().timer(this.operation.name()).time(() -> this.ozoneManagerClient.getKeyInfo(keyArgs, false));
                break;
            }
            case 11: {
                this.getMetrics().timer(this.operation.name()).time(() -> this.performReadOperation(() -> this.bucket.readKey(keyName), this.readBuffer));
                break;
            }
            case 3: {
                this.getMetrics().timer(this.operation.name()).time(() -> this.performReadOperation(() -> this.bucket.readFile(keyName), this.readBuffer));
                break;
            }
            case 0: {
                this.getMetrics().timer(this.operation.name()).time(() -> this.performWriteOperation(() -> this.bucket.createFile(keyName, this.dataSize.toBytes(), this.replicationConfig, true, false), this.contentGenerator));
                break;
            }
            case 1: {
                this.getMetrics().timer(this.operation.name()).time(() -> this.performWriteOperation(() -> this.bucket.createStreamFile(keyName, this.dataSize.toBytes(), this.replicationConfig, true, false), this.contentGenerator));
                break;
            }
            case 2: {
                OmKeyArgs keyArgs = this.omKeyArgsBuilder.get().setKeyName(keyName).build();
                this.getMetrics().timer(this.operation.name()).time(() -> this.ozoneManagerClient.lookupFile(keyArgs));
                break;
            }
            case 12: {
                String startKeyName = this.getPath(threadSeqId * (long)this.batchSize);
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    List keyInfoList = this.ozoneManagerClient.listKeys(this.volumeName, this.bucketName, startKeyName, "", this.batchSize).getKeys();
                    if (keyInfoList.size() + 1 < this.batchSize) {
                        throw new NoSuchFileException("There are not enough keys for testing you should use CREATE_KEY to create at least batch-size * threads = " + this.batchSize * this.getThreadNo());
                    }
                    return null;
                });
                break;
            }
            case 13: {
                String startKeyName = this.getPath(threadSeqId * (long)this.batchSize);
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    List keyInfoList = this.ozoneManagerClient.listKeysLight(this.volumeName, this.bucketName, startKeyName, "", this.batchSize).getKeys();
                    if (keyInfoList.size() + 1 < this.batchSize) {
                        throw new NoSuchFileException("There are not enough keys for testing you should use CREATE_KEY to create at least batch-size * threads = " + this.batchSize * this.getThreadNo());
                    }
                    return null;
                });
                break;
            }
            case 4: {
                String startKeyName = this.getPath(threadSeqId * (long)this.batchSize);
                OmKeyArgs keyArgs = this.omKeyArgsBuilder.get().setKeyName("").build();
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    List fileStatusList = this.ozoneManagerClient.listStatus(keyArgs, false, startKeyName, (long)this.batchSize);
                    if (fileStatusList.size() + 1 < this.batchSize) {
                        throw new NoSuchFileException("There are not enough files for testing you should use CREATE_FILE to create at least batch-size * threads = " + this.batchSize * this.getThreadNo());
                    }
                    return null;
                });
                break;
            }
            case 5: {
                String startKeyName = this.getPath(threadSeqId * (long)this.batchSize);
                OmKeyArgs keyArgs = this.omKeyArgsBuilder.get().setKeyName("").build();
                this.getMetrics().timer(this.operation.name()).time(() -> {
                    List fileStatusList = this.ozoneManagerClient.listStatusLight(keyArgs, false, startKeyName, (long)this.batchSize, false);
                    if (fileStatusList.size() + 1 < this.batchSize) {
                        throw new NoSuchFileException("There are not enough files for testing you should use CREATE_FILE to create at least batch-size * threads = " + this.batchSize * this.getThreadNo());
                    }
                    return null;
                });
                break;
            }
            case 14: {
                this.getMetrics().timer(this.operation.name()).time(() -> this.ozoneManagerClient.getBucketInfo(this.volumeName, this.bucketName));
                break;
            }
            case 15: {
                this.getMetrics().timer(this.operation.name()).time(() -> this.ozoneManagerClient.getVolumeInfo(this.volumeName));
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized write command type request " + (Object)((Object)this.operation));
            }
        }
    }

    private Void performWriteOperation(WriteOperation writeOp, ContentGenerator contentGen) throws IOException {
        try (OutputStream stream = writeOp.createStream();){
            contentGen.write(stream);
        }
        return null;
    }

    private Void performReadOperation(ReadOperation readOp, byte[] buffer) throws IOException {
        try (InputStream stream = readOp.createStream();){
            while (stream.read(buffer) >= 0) {
            }
            Void void_ = null;
            return void_;
        }
    }

    @Override
    public boolean allowEmptyPrefix() {
        return true;
    }

    static enum Operation {
        CREATE_FILE,
        CREATE_STREAM_FILE,
        LOOKUP_FILE,
        READ_FILE,
        LIST_STATUS,
        LIST_STATUS_LIGHT,
        CREATE_KEY,
        CREATE_STREAM_KEY,
        LOOKUP_KEY,
        GET_KEYINFO,
        HEAD_KEY,
        READ_KEY,
        LIST_KEYS,
        LIST_KEYS_LIGHT,
        INFO_BUCKET,
        INFO_VOLUME,
        MIXED;

    }

    @FunctionalInterface
    static interface WriteOperation {
        public OutputStream createStream() throws IOException;
    }

    @FunctionalInterface
    static interface ReadOperation {
        public InputStream createStream() throws IOException;
    }
}

