/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.bouncycastle.pqc.jcajce.provider.dilithium;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.ozone.shaded.org.bouncycastle.asn1.ASN1Set;
import org.apache.ozone.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.apache.ozone.shaded.org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPrivateKeyParameters;
import org.apache.ozone.shaded.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.apache.ozone.shaded.org.bouncycastle.pqc.jcajce.interfaces.DilithiumPrivateKey;
import org.apache.ozone.shaded.org.bouncycastle.pqc.jcajce.interfaces.DilithiumPublicKey;
import org.apache.ozone.shaded.org.bouncycastle.pqc.jcajce.provider.dilithium.BCDilithiumPublicKey;
import org.apache.ozone.shaded.org.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import org.apache.ozone.shaded.org.bouncycastle.pqc.jcajce.spec.DilithiumParameterSpec;
import org.apache.ozone.shaded.org.bouncycastle.util.Arrays;
import org.apache.ozone.shaded.org.bouncycastle.util.Strings;

public class BCDilithiumPrivateKey
implements DilithiumPrivateKey {
    private static final long serialVersionUID = 1L;
    private transient DilithiumPrivateKeyParameters params;
    private transient String algorithm;
    private transient byte[] encoding;
    private transient ASN1Set attributes;

    public BCDilithiumPrivateKey(DilithiumPrivateKeyParameters dilithiumPrivateKeyParameters) {
        this.init(dilithiumPrivateKeyParameters, null);
    }

    public BCDilithiumPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init((DilithiumPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo), privateKeyInfo.getAttributes());
    }

    private void init(DilithiumPrivateKeyParameters dilithiumPrivateKeyParameters, ASN1Set aSN1Set) {
        this.attributes = aSN1Set;
        this.params = dilithiumPrivateKeyParameters;
        this.algorithm = Strings.toUpperCase(dilithiumPrivateKeyParameters.getParameters().getName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCDilithiumPrivateKey) {
            BCDilithiumPrivateKey bCDilithiumPrivateKey = (BCDilithiumPrivateKey)object;
            return Arrays.areEqual(this.getEncoded(), bCDilithiumPrivateKey.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = KeyUtil.getEncodedPrivateKeyInfo(this.params, this.attributes);
        }
        return Arrays.clone(this.encoding);
    }

    @Override
    public DilithiumPublicKey getPublicKey() {
        return new BCDilithiumPublicKey(this.params.getPublicKeyParameters());
    }

    @Override
    public DilithiumParameterSpec getParameterSpec() {
        return DilithiumParameterSpec.fromName(this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    DilithiumPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

