/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.bouncycastle.asn1.x9;

import java.util.Enumeration;
import org.apache.ozone.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import org.apache.ozone.shaded.org.bouncycastle.asn1.ASN1Object;
import org.apache.ozone.shaded.org.bouncycastle.asn1.ASN1OctetString;
import org.apache.ozone.shaded.org.bouncycastle.asn1.ASN1Primitive;
import org.apache.ozone.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.apache.ozone.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.apache.ozone.shaded.org.bouncycastle.asn1.DERSequence;
import org.apache.ozone.shaded.org.bouncycastle.asn1.DERTaggedObject;
import org.apache.ozone.shaded.org.bouncycastle.asn1.x9.KeySpecificInfo;

public class OtherInfo
extends ASN1Object {
    private KeySpecificInfo keyInfo;
    private ASN1OctetString partyAInfo;
    private ASN1OctetString suppPubInfo;

    public OtherInfo(KeySpecificInfo keySpecificInfo, ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) {
        this.keyInfo = keySpecificInfo;
        this.partyAInfo = aSN1OctetString;
        this.suppPubInfo = aSN1OctetString2;
    }

    public static OtherInfo getInstance(Object object) {
        if (object instanceof OtherInfo) {
            return (OtherInfo)object;
        }
        if (object != null) {
            return new OtherInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private OtherInfo(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.keyInfo = KeySpecificInfo.getInstance(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            if (aSN1TaggedObject.hasContextTag(0)) {
                this.partyAInfo = (ASN1OctetString)aSN1TaggedObject.getExplicitBaseObject();
                continue;
            }
            if (!aSN1TaggedObject.hasContextTag(2)) continue;
            this.suppPubInfo = (ASN1OctetString)aSN1TaggedObject.getExplicitBaseObject();
        }
    }

    public KeySpecificInfo getKeyInfo() {
        return this.keyInfo;
    }

    public ASN1OctetString getPartyAInfo() {
        return this.partyAInfo;
    }

    public ASN1OctetString getSuppPubInfo() {
        return this.suppPubInfo;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(this.keyInfo);
        if (this.partyAInfo != null) {
            aSN1EncodableVector.add(new DERTaggedObject(0, this.partyAInfo));
        }
        aSN1EncodableVector.add(new DERTaggedObject(2, this.suppPubInfo));
        return new DERSequence(aSN1EncodableVector);
    }
}

