/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.trace;

import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.ozone.shaded.com.google.errorprone.annotations.MustBeClosed;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.common.Scope;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.internal.Utils;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.trace.BlankSpan;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.trace.CurrentSpanUtils;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.trace.Sampler;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.trace.Span;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.trace.SpanContext;

public abstract class SpanBuilder {
    public abstract SpanBuilder setSampler(Sampler var1);

    public abstract SpanBuilder setParentLinks(List<Span> var1);

    public abstract SpanBuilder setRecordEvents(boolean var1);

    public SpanBuilder setSpanKind(@Nullable Span.Kind spanKind) {
        return this;
    }

    public abstract Span startSpan();

    @MustBeClosed
    public final Scope startScopedSpan() {
        return CurrentSpanUtils.withSpan(this.startSpan(), true);
    }

    public final void startSpanAndRun(Runnable runnable2) {
        Span span = this.startSpan();
        CurrentSpanUtils.withSpan(span, true, runnable2).run();
    }

    public final <V> V startSpanAndCall(Callable<V> callable) throws Exception {
        Span span = this.startSpan();
        return CurrentSpanUtils.withSpan(span, true, callable).call();
    }

    static final class NoopSpanBuilder
    extends SpanBuilder {
        static NoopSpanBuilder createWithParent(String spanName, @Nullable Span parent) {
            return new NoopSpanBuilder(spanName);
        }

        static NoopSpanBuilder createWithRemoteParent(String spanName, @Nullable SpanContext remoteParentSpanContext) {
            return new NoopSpanBuilder(spanName);
        }

        @Override
        public Span startSpan() {
            return BlankSpan.INSTANCE;
        }

        @Override
        public SpanBuilder setSampler(@Nullable Sampler sampler) {
            return this;
        }

        @Override
        public SpanBuilder setParentLinks(List<Span> parentLinks) {
            return this;
        }

        @Override
        public SpanBuilder setRecordEvents(boolean recordEvents) {
            return this;
        }

        @Override
        public SpanBuilder setSpanKind(@Nullable Span.Kind spanKind) {
            return this;
        }

        private NoopSpanBuilder(String name) {
            Utils.checkNotNull(name, "name");
        }
    }
}

